/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.biopaxL3converter;

import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.sbfc.converter.GeneralConverter;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.models.BioPAXModel;
import org.sbfc.converter.models.GeneralModel;

public class BioPAX2BioPAXL3
extends GeneralConverter {
    public GeneralModel biopaxExport(BioPAXModel model) throws ConversionException, ReadModelException {
        if (model.getModel().getLevel().equals((Object)BioPAXLevel.L1) || model.getModel().getLevel().equals((Object)BioPAXLevel.L2)) {
            LevelUpgrader levelUpgrader = new LevelUpgrader();
            Model level3Model = levelUpgrader.filter(model.getModel());
            BioPAXModel bioPaxModelOut = new BioPAXModel(level3Model);
            return bioPaxModelOut;
        }
        return model;
    }

    @Override
    public GeneralModel convert(GeneralModel model) throws ConversionException, ReadModelException {
        try {
            this.inputModel = model;
            return this.biopaxExport((BioPAXModel)model);
        }
        catch (ReadModelException e) {
            throw e;
        }
        catch (ConversionException e) {
            throw e;
        }
    }

    @Override
    public String getResultExtension() {
        return "-biopaxL3.owl";
    }

    @Override
    public String getName() {
        return "BioPAX to BioPAX L3";
    }

    @Override
    public String getDescription() {
        return "Converts a model from BioPAX L1/L2 to BioPAX L3, using paxtools.";
    }

    @Override
    public String getHtmlDescription() {
        return "Converts a model from <a href=\"http://www.biopax.org\">BioPAX</a> L1/L2 to <a href=\"http://www.biopax.org\">BioPAX</a> L3, using <a href=\"http://www.biopax.org\">paxtools</a>.";
    }
}

