/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.xmlcdwrappers;

import fr.curie.cd2sbgnml.graphics.AnchorPoint;
import fr.curie.cd2sbgnml.xmlcdwrappers.AliasWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.LineWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.LogicGateWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ModelWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ModificationLinkType;
import java.awt.geom.Point2D;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sbml._2001.ns.celldesigner.BaseProduct;
import org.sbml._2001.ns.celldesigner.BaseReactant;
import org.sbml._2001.ns.celldesigner.LinkAnchor;
import org.sbml._2001.ns.celldesigner.LinkTarget;
import org.sbml._2001.ns.celldesigner.ListOfModification;
import org.sbml._2001.ns.celldesigner.Modification;
import org.sbml._2001.ns.celldesigner.ProductLink;
import org.sbml._2001.ns.celldesigner.ReactantLink;
import org.sbml.sbml.level2.version4.Reaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactantWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ReactantWrapper.class);
    private ReactantType reactantType;
    private AliasWrapper aliasW;
    private AnchorPoint anchorPoint;
    private ModificationLinkType modificationLinkType;
    private String targetLineIndex;
    private LineWrapper lineWrapper;
    private int positionIndex;
    private LogicGateWrapper logicGate;

    public ReactantWrapper(AliasWrapper aliasW, ReactantType type) {
        this.aliasW = aliasW;
        this.reactantType = type;
    }

    public ReactantWrapper(ReactantWrapper w) {
        this.reactantType = w.getReactantType();
        this.modificationLinkType = w.getModificationLinkType();
        this.aliasW = w.getAliasW();
        this.targetLineIndex = w.getTargetLineIndex();
        this.anchorPoint = w.getAnchorPoint();
        this.lineWrapper = w.getLineWrapper();
        this.logicGate = w.getLogicGate();
        this.positionIndex = w.getPositionIndex();
    }

    private ReactantWrapper(BaseReactant baseReactant, AliasWrapper aliasW) {
        this.reactantType = ReactantType.BASE_REACTANT;
        this.aliasW = aliasW;
        this.anchorPoint = baseReactant.getLinkAnchor() != null && !baseReactant.getLinkAnchor().getPosition().equals("INACTIVE") ? AnchorPoint.valueOf(baseReactant.getLinkAnchor().getPosition()) : AnchorPoint.CENTER;
    }

    private ReactantWrapper(BaseProduct baseProduct, AliasWrapper aliasW) {
        this.reactantType = ReactantType.BASE_PRODUCT;
        this.aliasW = aliasW;
        this.anchorPoint = baseProduct.getLinkAnchor() != null && !baseProduct.getLinkAnchor().getPosition().equals("INACTIVE") ? AnchorPoint.valueOf(baseProduct.getLinkAnchor().getPosition()) : AnchorPoint.CENTER;
    }

    private ReactantWrapper(ReactantLink reactantLink, AliasWrapper aliasW, int index) {
        this.reactantType = ReactantType.ADDITIONAL_REACTANT;
        this.aliasW = aliasW;
        this.positionIndex = index;
        this.targetLineIndex = reactantLink.getTargetLineIndex();
        this.anchorPoint = AnchorPoint.CENTER;
        if (reactantLink.getLinkAnchor() != null && !reactantLink.getLinkAnchor().getPosition().equals("INACTIVE")) {
            this.anchorPoint = AnchorPoint.valueOf(reactantLink.getLinkAnchor().getPosition());
        }
        this.lineWrapper = new LineWrapper(reactantLink.getConnectScheme(), reactantLink.getEditPoints(), reactantLink.getLine());
    }

    private ReactantWrapper(ProductLink productLink, AliasWrapper aliasW, int index) {
        this.reactantType = ReactantType.ADDITIONAL_PRODUCT;
        this.aliasW = aliasW;
        this.positionIndex = index;
        this.targetLineIndex = productLink.getTargetLineIndex();
        this.anchorPoint = AnchorPoint.CENTER;
        if (productLink.getLinkAnchor() != null) {
            this.anchorPoint = AnchorPoint.valueOf(productLink.getLinkAnchor().getPosition());
        }
        this.lineWrapper = new LineWrapper(productLink.getConnectScheme(), productLink.getEditPoints(), productLink.getLine());
    }

    protected ReactantWrapper(Modification modification, AliasWrapper aliasW, int index) {
        this.reactantType = ReactantType.MODIFICATION;
        this.aliasW = aliasW;
        this.positionIndex = index;
        this.targetLineIndex = modification.getTargetLineIndex();
        this.modificationLinkType = ModificationLinkType.valueOf(modification.getType());
        if (modification.getLinkTarget().size() > 0 && modification.getLinkTarget().get(0).getLinkAnchor() != null) {
            String position = modification.getLinkTarget().get(0).getLinkAnchor().getPosition();
            try {
                this.anchorPoint = AnchorPoint.valueOf(position);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Illegal linkAnchor position found: " + position + ". CENTER will be used instead");
                this.anchorPoint = AnchorPoint.CENTER;
            }
        } else {
            this.anchorPoint = AnchorPoint.CENTER;
        }
        this.lineWrapper = new LineWrapper(modification.getConnectScheme(), modification.getEditPoints(), modification.getLine());
    }

    private ReactantWrapper(Modification modification, AliasWrapper aliasW, int index, LogicGateWrapper gateRef) {
        this(modification, aliasW, index);
        this.logicGate = gateRef;
    }

    public static AbstractMap.SimpleEntry<List<ReactantWrapper>, List<LogicGateWrapper>> fromReaction(Reaction reaction, ModelWrapper modelW) {
        int i;
        ArrayList<ReactantWrapper> reactantList = new ArrayList<ReactantWrapper>();
        ArrayList logicGateWrapperList = new ArrayList();
        reaction.getAnnotation().getExtension().getBaseReactants().getBaseReactant().forEach(e -> reactantList.add(new ReactantWrapper((BaseReactant)e, modelW.getAliasWrapperFor(e.getAlias()))));
        reaction.getAnnotation().getExtension().getBaseProducts().getBaseProduct().forEach(e -> reactantList.add(new ReactantWrapper((BaseProduct)e, modelW.getAliasWrapperFor(e.getAlias()))));
        if (reaction.getAnnotation().getExtension().getListOfReactantLinks() != null) {
            i = 0;
            for (ReactantLink rlink : reaction.getAnnotation().getExtension().getListOfReactantLinks().getReactantLink()) {
                reactantList.add(new ReactantWrapper(rlink, modelW.getAliasWrapperFor(rlink.getAlias()), i));
                ++i;
            }
        }
        if (reaction.getAnnotation().getExtension().getListOfProductLinks() != null) {
            i = 0;
            for (ProductLink plink : reaction.getAnnotation().getExtension().getListOfProductLinks().getProductLink()) {
                reactantList.add(new ReactantWrapper(plink, modelW.getAliasWrapperFor(plink.getAlias()), i));
                ++i;
            }
        }
        if (reaction.getAnnotation().getExtension().getListOfModification() != null) {
            AbstractMap.SimpleEntry<List<ReactantWrapper>, List<LogicGateWrapper>> result = ReactantWrapper.fromListOfModifications(reaction.getAnnotation().getExtension().getListOfModification(), modelW);
            reactantList.addAll((Collection)result.getKey());
            logicGateWrapperList.addAll(result.getValue());
        }
        return new AbstractMap.SimpleEntry<List<ReactantWrapper>, List<LogicGateWrapper>>(reactantList, logicGateWrapperList);
    }

    public static AbstractMap.SimpleEntry<List<ReactantWrapper>, List<LogicGateWrapper>> fromListOfModifications(ListOfModification listOfModification, ModelWrapper modelW) {
        ArrayList<ReactantWrapper> reactantList = new ArrayList<ReactantWrapper>();
        ArrayList<LogicGateWrapper> logicGateWrapperList = new ArrayList<LogicGateWrapper>();
        LogicGateWrapper logicGateRef = null;
        int i = 0;
        for (Modification modif : listOfModification.getModification()) {
            logger.debug("Parsing modification " + modif.getModifiers() + " " + modif.getType());
            if (ReactantWrapper.isLogicGate(modif)) {
                logicGateRef = new LogicGateWrapper(modif, i);
                logicGateWrapperList.add(logicGateRef);
            } else if (logicGateRef != null && (modif.getTargetLineIndex() == null || modif.getTargetLineIndex().endsWith("0"))) {
                reactantList.add(new ReactantWrapper(modif, modelW.getAliasWrapperFor(modif.getAliases()), i, logicGateRef));
            } else {
                reactantList.add(new ReactantWrapper(modif, modelW.getAliasWrapperFor(modif.getAliases()), i));
            }
            ++i;
        }
        return new AbstractMap.SimpleEntry<List<ReactantWrapper>, List<LogicGateWrapper>>(reactantList, logicGateWrapperList);
    }

    public Point2D.Float getCenterPoint() {
        return this.aliasW.getCenterPoint();
    }

    public static int getProcessAnchorIndex(Modification modif) {
        if (modif.getTargetLineIndex() == null) {
            return 0;
        }
        String targetLineIndex = modif.getTargetLineIndex();
        return Integer.parseInt(targetLineIndex.split(",")[1]);
    }

    public int getProcessAnchorIndex() {
        if (this.getTargetLineIndex() == null) {
            return 0;
        }
        String targetLineIndex = this.getTargetLineIndex();
        return Integer.parseInt(targetLineIndex.split(",")[1]);
    }

    public Object getCDElement() {
        switch (this.reactantType) {
            case BASE_REACTANT: {
                BaseReactant baseReactant = new BaseReactant();
                baseReactant.setSpecies(this.getAliasW().getSpeciesW().getId());
                baseReactant.setAlias(this.getAliasW().getId());
                if (this.getAnchorPoint() != AnchorPoint.CENTER) {
                    LinkAnchor linkAnchor = new LinkAnchor();
                    linkAnchor.setPosition(this.getAnchorPoint().toString());
                    baseReactant.setLinkAnchor(linkAnchor);
                }
                return baseReactant;
            }
            case BASE_PRODUCT: {
                BaseProduct baseProduct = new BaseProduct();
                baseProduct.setSpecies(this.getAliasW().getSpeciesW().getId());
                baseProduct.setAlias(this.getAliasW().getId());
                if (this.getAnchorPoint() != AnchorPoint.CENTER) {
                    LinkAnchor linkAnchor = new LinkAnchor();
                    linkAnchor.setPosition(this.getAnchorPoint().toString());
                    baseProduct.setLinkAnchor(linkAnchor);
                }
                return baseProduct;
            }
            case ADDITIONAL_REACTANT: {
                ReactantLink reactantLink = new ReactantLink();
                reactantLink.setReactant(this.getAliasW().getSpeciesW().getId());
                reactantLink.setAlias(this.getAliasW().getId());
                if (this.getAnchorPoint() != AnchorPoint.CENTER) {
                    LinkAnchor linkAnchor = new LinkAnchor();
                    linkAnchor.setPosition(this.getAnchorPoint().toString());
                    reactantLink.setLinkAnchor(linkAnchor);
                }
                reactantLink.setTargetLineIndex(this.getTargetLineIndex());
                reactantLink.setConnectScheme(this.getLineWrapper().getCDConnectScheme());
                reactantLink.setLine(this.getLineWrapper().getCDLineType2());
                if (this.getLineWrapper().getEditPoints().size() > 0) {
                    reactantLink.setEditPoints(this.getLineWrapper().getCDEditPoints(false));
                }
                return reactantLink;
            }
            case ADDITIONAL_PRODUCT: {
                ProductLink productLink = new ProductLink();
                productLink.setProduct(this.getAliasW().getSpeciesW().getId());
                productLink.setAlias(this.getAliasW().getId());
                if (this.getAnchorPoint() != AnchorPoint.CENTER) {
                    LinkAnchor linkAnchor = new LinkAnchor();
                    linkAnchor.setPosition(this.getAnchorPoint().toString());
                    productLink.setLinkAnchor(linkAnchor);
                }
                productLink.setTargetLineIndex(this.getTargetLineIndex());
                productLink.setConnectScheme(this.getLineWrapper().getCDConnectScheme());
                productLink.setLine(this.getLineWrapper().getCDLineType2());
                if (this.getLineWrapper().getEditPoints().size() > 0) {
                    productLink.setEditPoints(this.getLineWrapper().getCDEditPoints(false));
                }
                return productLink;
            }
            case MODIFICATION: {
                return this.getAsModification();
            }
        }
        throw new RuntimeException("Reactant type was not defined properly.");
    }

    public Modification getAsModification() {
        Modification modification = new Modification();
        modification.setModifiers(this.getAliasW().getSpeciesW().getId());
        modification.setAliases(this.getAliasW().getId());
        modification.setTargetLineIndex(this.getTargetLineIndex());
        modification.setType(this.getModificationLinkType().toString());
        if (this.getAnchorPoint() != AnchorPoint.CENTER) {
            LinkTarget linkTarget = new LinkTarget();
            linkTarget.setSpecies(this.getAliasW().getSpeciesW().getId());
            linkTarget.setAlias(this.getAliasW().getId());
            LinkAnchor linkAnchor = new LinkAnchor();
            linkAnchor.setPosition(this.getAnchorPoint().toString());
            linkTarget.setLinkAnchor(linkAnchor);
            modification.getLinkTarget().add(linkTarget);
        }
        modification.setConnectScheme(this.getLineWrapper().getCDConnectScheme());
        modification.setLine(this.getLineWrapper().getCDLine());
        if (this.getLineWrapper().getEditPoints().size() > 0) {
            for (String s : this.getLineWrapper().editPointsAsStringList()) {
                modification.getEditPoints().add(s);
            }
        }
        return modification;
    }

    public static boolean isLogicGate(Modification modif) {
        return modif.getModifiers().split(",").length > 1;
    }

    public AliasWrapper getAliasW() {
        return this.aliasW;
    }

    public ReactantType getReactantType() {
        return this.reactantType;
    }

    public float getHeight() {
        return (float)this.aliasW.getBounds().getHeight();
    }

    public float getWidth() {
        return (float)this.aliasW.getBounds().getWidth();
    }

    public AnchorPoint getAnchorPoint() {
        return this.anchorPoint;
    }

    public int getPositionIndex() {
        return this.positionIndex;
    }

    public LogicGateWrapper getLogicGate() {
        return this.logicGate;
    }

    public LineWrapper getLineWrapper() {
        return this.lineWrapper;
    }

    public void setLineWrapper(LineWrapper lineWrapper) {
        this.lineWrapper = lineWrapper;
    }

    public ModificationLinkType getModificationLinkType() {
        return this.modificationLinkType;
    }

    public void setModificationLinkType(ModificationLinkType modificationLinkType) {
        this.modificationLinkType = modificationLinkType;
    }

    public String getTargetLineIndex() {
        return this.targetLineIndex;
    }

    public void setTargetLineIndex(String targetLineIndex) {
        this.targetLineIndex = targetLineIndex;
    }

    public void setReactantType(ReactantType reactantType) {
        this.reactantType = reactantType;
    }

    public void setAliasW(AliasWrapper aliasW) {
        this.aliasW = aliasW;
    }

    public void setAnchorPoint(AnchorPoint anchorPoint) {
        this.anchorPoint = anchorPoint;
    }

    public void setPositionIndex(int positionIndex) {
        this.positionIndex = positionIndex;
    }

    public void setLogicGate(LogicGateWrapper logicGate) {
        this.logicGate = logicGate;
    }

    public static enum ReactantType {
        BASE_REACTANT,
        BASE_PRODUCT,
        ADDITIONAL_REACTANT,
        ADDITIONAL_PRODUCT,
        MODIFICATION;

    }
}

