/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.xmlcdwrappers;

import fr.curie.cd2sbgnml.xmlcdwrappers.AliasInfoWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.SpeciesWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.StyleInfo;
import fr.curie.cd2sbgnml.xmlcdwrappers.Utils;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.AbstractMap;
import org.sbml._2001.ns.celldesigner.Bounds;
import org.sbml._2001.ns.celldesigner.BoxSize;
import org.sbml._2001.ns.celldesigner.BriefView;
import org.sbml._2001.ns.celldesigner.ComplexSpeciesAlias;
import org.sbml._2001.ns.celldesigner.Info;
import org.sbml._2001.ns.celldesigner.InnerPosition;
import org.sbml._2001.ns.celldesigner.ListOfComplexSpeciesAliases;
import org.sbml._2001.ns.celldesigner.Paint;
import org.sbml._2001.ns.celldesigner.SingleLine;
import org.sbml._2001.ns.celldesigner.SpeciesAlias;
import org.sbml._2001.ns.celldesigner.UsualView;
import org.sbml._2001.ns.celldesigner.View;

public class AliasWrapper {
    private AliasType aliasType;
    private Rectangle2D bounds;
    private String id;
    private String complexAlias;
    private String compartmentAlias;
    private SpeciesWrapper speciesW;
    private boolean isActive;
    private AliasInfoWrapper info;
    private StyleInfo styleInfo;
    private AliasWrapper topLevelParent;

    public AliasWrapper(String id, AliasType type, SpeciesWrapper speciesW) {
        this.id = id;
        this.aliasType = type;
        this.speciesW = speciesW;
        this.isActive = false;
    }

    public AliasWrapper(SpeciesAlias alias, SpeciesWrapper speciesW) {
        this.aliasType = AliasType.SPECIES;
        this.bounds = Utils.bounds2Rect(alias.getBounds());
        this.id = alias.getId();
        this.complexAlias = alias.getComplexSpeciesAlias();
        this.speciesW = speciesW;
        this.compartmentAlias = alias.getCompartmentAlias();
        this.isActive = alias.getActivity().equals("active");
        if (!alias.getInfo().getState().equals("empty")) {
            this.info = new AliasInfoWrapper(alias.getInfo().getAngle().floatValue(), alias.getInfo().getPrefix(), alias.getInfo().getLabel());
        }
        this.styleInfo = new StyleInfo(alias, speciesW.getId() + "_" + this.id);
    }

    public AliasWrapper(ComplexSpeciesAlias alias, SpeciesWrapper speciesW) {
        this.aliasType = AliasType.COMPLEX;
        this.bounds = Utils.bounds2Rect(alias.getBounds());
        this.id = alias.getId();
        this.speciesW = speciesW;
        ListOfComplexSpeciesAliases.ComplexSpeciesAlias a = (ListOfComplexSpeciesAliases.ComplexSpeciesAlias)alias;
        this.complexAlias = a.getComplexSpeciesAlias();
        this.compartmentAlias = alias.getCompartmentAlias();
        this.isActive = alias.getActivity().equals("active");
        if (!alias.getInfo().getState().equals("empty")) {
            this.info = new AliasInfoWrapper(alias.getInfo().getAngle().floatValue(), alias.getInfo().getPrefix(), alias.getInfo().getLabel());
        }
        this.styleInfo = new StyleInfo(alias, speciesW.getId() + "_" + this.id);
    }

    public Point2D.Float getCenterPoint() {
        return new Point2D.Float((float)this.bounds.getCenterX(), (float)this.bounds.getCenterY());
    }

    public SpeciesAlias getCDSpeciesAlias() {
        SpeciesAlias alias = new SpeciesAlias();
        alias.setId(this.getId());
        alias.setSpecies(this.getSpeciesId());
        alias.setCompartmentAlias(this.getCompartmentAlias());
        alias.setActivity("inactive");
        if (this.getComplexAlias() != null) {
            alias.setComplexSpeciesAlias(this.getComplexAlias());
        }
        alias.setBounds(this.getBoundsElement());
        alias.setView(this.getSimpleViewElement());
        AbstractMap.SimpleEntry<UsualView, BriefView> viewsEntry = this.getViewElements();
        alias.setUsualView(viewsEntry.getKey());
        alias.setBriefView(viewsEntry.getValue());
        alias.setInfo(this.getInfoElement());
        SpeciesAlias.Font font = new SpeciesAlias.Font();
        font.setSize((int)this.getStyleInfo().getFontSize());
        alias.setFont(font);
        return alias;
    }

    public ListOfComplexSpeciesAliases.ComplexSpeciesAlias getCDComplexSpeciesAlias() {
        ListOfComplexSpeciesAliases.ComplexSpeciesAlias alias = new ListOfComplexSpeciesAliases.ComplexSpeciesAlias();
        alias.setId(this.getId());
        alias.setSpecies(this.getSpeciesId());
        alias.setCompartmentAlias(this.getCompartmentAlias());
        alias.setActivity("inactive");
        if (this.getComplexAlias() != null) {
            alias.setComplexSpeciesAlias(this.getComplexAlias());
        }
        alias.setBounds(this.getBoundsElement());
        alias.setView(this.getSimpleViewElement());
        AbstractMap.SimpleEntry<UsualView, BriefView> viewsEntry = this.getViewElements();
        alias.setUsualView(viewsEntry.getKey());
        alias.setBriefView(viewsEntry.getValue());
        alias.setInfo(this.getInfoElement());
        ComplexSpeciesAlias.Font font = new ComplexSpeciesAlias.Font();
        font.setSize((int)this.getStyleInfo().getFontSize());
        alias.setFont(font);
        ComplexSpeciesAlias.BackupSize backupSize = new ComplexSpeciesAlias.BackupSize();
        alias.setBackupSize(backupSize);
        backupSize.setW(0.0);
        backupSize.setH(0.0);
        View backupView = new View();
        backupView.setState("none");
        alias.setBackupView(backupView);
        return alias;
    }

    private View getSimpleViewElement() {
        View view = new View();
        view.setState("usual");
        return view;
    }

    private Bounds getBoundsElement() {
        return Utils.rect2Bounds(this.getBounds());
    }

    private Info getInfoElement() {
        Info info = new Info();
        if (this.getInfo() != null) {
            info.setState("open");
            info.setAngle(BigDecimal.valueOf(this.getInfo().angle));
            info.setPrefix(this.getInfo().prefix);
            info.setLabel(this.getInfo().label);
        } else {
            info.setState("empty");
            info.setAngle(BigDecimal.valueOf(-1.57));
        }
        return info;
    }

    private AbstractMap.SimpleEntry<UsualView, BriefView> getViewElements() {
        InnerPosition innerPosition = new InnerPosition();
        innerPosition.setX(BigDecimal.valueOf(0L));
        innerPosition.setY(BigDecimal.valueOf(0L));
        BoxSize boxSize = new BoxSize();
        boxSize.setWidth(BigDecimal.valueOf(this.getBounds().getWidth()));
        boxSize.setHeight(BigDecimal.valueOf(this.getBounds().getHeight()));
        SingleLine singleLine = new SingleLine();
        singleLine.setWidth(BigDecimal.valueOf(this.getStyleInfo().getLineWidth()));
        Paint paint = new Paint();
        paint.setColor(this.getStyleInfo().getBgColor());
        paint.setScheme("Color");
        UsualView usualView = new UsualView();
        usualView.setBoxSize(boxSize);
        usualView.setInnerPosition(innerPosition);
        usualView.setPaint(paint);
        usualView.setSingleLine(singleLine);
        BriefView briefView = new BriefView();
        briefView.setBoxSize(boxSize);
        briefView.setInnerPosition(innerPosition);
        briefView.setPaint(paint);
        briefView.setSingleLine(singleLine);
        return new AbstractMap.SimpleEntry<UsualView, BriefView>(usualView, briefView);
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public AliasType getAliasType() {
        return this.aliasType;
    }

    public String getId() {
        return this.id;
    }

    public String getComplexAlias() {
        return this.complexAlias;
    }

    public String getCompartmentAlias() {
        return this.compartmentAlias;
    }

    public String getSpeciesId() {
        return this.speciesW.getId();
    }

    public SpeciesWrapper getSpeciesW() {
        return this.speciesW;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public AliasInfoWrapper getInfo() {
        return this.info;
    }

    public StyleInfo getStyleInfo() {
        return this.styleInfo;
    }

    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    public void setAliasType(AliasType aliasType) {
        this.aliasType = aliasType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setComplexAlias(String complexAlias) {
        this.complexAlias = complexAlias;
    }

    public void setCompartmentAlias(String compartmentAlias) {
        this.compartmentAlias = compartmentAlias;
    }

    public void setSpeciesW(SpeciesWrapper speciesW) {
        this.speciesW = speciesW;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public void setInfo(AliasInfoWrapper info) {
        this.info = info;
    }

    public void setStyleInfo(StyleInfo styleInfo) {
        this.styleInfo = styleInfo;
    }

    public AliasWrapper getTopLevelParent() {
        return this.topLevelParent;
    }

    public void setTopLevelParent(AliasWrapper topLevelParent) {
        this.topLevelParent = topLevelParent;
    }

    public static enum AliasType {
        COMPLEX,
        SPECIES;

    }
}

