/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.model;

import fr.curie.cd2sbgnml.graphics.AnchorPoint;
import fr.curie.cd2sbgnml.graphics.GeometryUtils;
import fr.curie.cd2sbgnml.graphics.Link;
import fr.curie.cd2sbgnml.model.GenericReactionModel;
import fr.curie.cd2sbgnml.model.LinkModel;
import fr.curie.cd2sbgnml.model.Process;
import fr.curie.cd2sbgnml.model.ReactantModel;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactantWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactionWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.StyleInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleReactionModel
extends GenericReactionModel {
    private static final Logger logger = LoggerFactory.getLogger(SimpleReactionModel.class);

    public SimpleReactionModel(ReactionWrapper reactionW) {
        super(reactionW);
        ReactantWrapper startR = reactionW.getBaseReactants().get(0);
        ReactantWrapper endR = reactionW.getBaseProducts().get(0);
        ReactantModel startModel = new ReactantModel(startR);
        ReactantModel endModel = new ReactantModel(endR);
        Point2D.Float baseLinkStartPoint = startModel.getAbsoluteAnchorCoordinate(startR.getAnchorPoint());
        Point2D.Float baseLinkEndPoint = endModel.getAbsoluteAnchorCoordinate(endR.getAnchorPoint());
        List<Point2D.Float> editPoints = reactionW.getLineWrapper().getEditPoints();
        AffineTransform transform = GeometryUtils.getTransformsToGlobalCoords(baseLinkStartPoint, baseLinkEndPoint);
        List<Point2D.Float> absoluteEditPoints = new ArrayList<Point2D.Float>();
        absoluteEditPoints.add(baseLinkStartPoint);
        absoluteEditPoints.addAll(GeometryUtils.convertPoints(editPoints, transform));
        absoluteEditPoints.add(baseLinkEndPoint);
        absoluteEditPoints = GeometryUtils.getNormalizedEndPoints(absoluteEditPoints, startModel.getGlyph(), endModel.getGlyph(), startModel.getAnchorPoint(), endModel.getAnchorPoint());
        if (this.hasProcess()) {
            Line2D.Float processAxis = new Line2D.Float(absoluteEditPoints.get(reactionW.getProcessSegmentIndex()), absoluteEditPoints.get(reactionW.getProcessSegmentIndex() + 1));
            String prId = "pr_" + UUID.randomUUID();
            Process process2 = new Process(GeometryUtils.getMiddleOfPolylineSegment(absoluteEditPoints, reactionW.getProcessSegmentIndex()), prId, processAxis, new StyleInfo(reactionW.getLineWrapper().getLineWidth(), reactionW.getLineWrapper().getLineColor(), prId));
            AbstractMap.SimpleEntry<List<Point2D.Float>, List<Point2D.Float>> subLinesTuple = GeometryUtils.splitPolylineAtSegment(absoluteEditPoints, reactionW.getProcessSegmentIndex());
            List<Point2D.Float> subLinesTuple1 = GeometryUtils.getNormalizedEndPoints(subLinesTuple.getKey(), startModel.getGlyph(), process2.getGlyph(), startModel.getAnchorPoint(), AnchorPoint.CENTER);
            List<Point2D.Float> subLinesTuple2 = GeometryUtils.getNormalizedEndPoints(subLinesTuple.getValue(), process2.getGlyph(), endModel.getGlyph(), AnchorPoint.CENTER, endModel.getAnchorPoint());
            Point2D.Float pIn = subLinesTuple1.get(subLinesTuple1.size() - 1);
            Point2D.Float pOut = subLinesTuple2.get(0);
            process2.setPorts(pIn, pOut);
            subLinesTuple1.set(subLinesTuple1.size() - 1, process2.getPortIn());
            subLinesTuple2.set(0, process2.getPortOut());
            String l1Id = "cons_" + UUID.randomUUID();
            LinkModel l1 = new LinkModel(startModel, process2, new Link(subLinesTuple1), l1Id, "consumption", new StyleInfo(reactionW.getLineWrapper().getLineWidth(), reactionW.getLineWrapper().getLineColor(), l1Id));
            String l2Id = "prod_" + UUID.randomUUID();
            LinkModel l2 = new LinkModel(process2, endModel, new Link(subLinesTuple2), l2Id, LinkModel.getSbgnClass(reactionW.getReactionType().toString()), new StyleInfo(reactionW.getLineWrapper().getLineWidth(), reactionW.getLineWrapper().getLineColor(), l2Id));
            if (reactionW.isReversible()) {
                l1.reverse();
            }
            this.getReactantModels().add(startModel);
            this.getReactantModels().add(endModel);
            this.getReactionNodeModels().add(process2);
            this.getLinkModels().add(l1);
            this.getLinkModels().add(l2);
            this.addModifiers(reactionW, process2);
            this.addAdditionalReactants(reactionW, process2);
            this.addAdditionalProducts(reactionW, process2);
        } else {
            String linkid = "direct_" + UUID.randomUUID();
            LinkModel l1 = new LinkModel(startModel, endModel, new Link(absoluteEditPoints), linkid, LinkModel.getSbgnClass(reactionW.getReactionType().toString()), new StyleInfo(reactionW.getLineWrapper().getLineWidth(), reactionW.getLineWrapper().getLineColor(), linkid));
            this.getReactantModels().add(startModel);
            this.getReactantModels().add(endModel);
            this.getLinkModels().add(l1);
            if (reactionW.getModifiers().size() > 0) {
                logger.error("Reaction " + reactionW.getId() + " with no process has " + reactionW.getModifiers().size() + " modifier links that were removed.");
            }
        }
    }
}

