/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.model;

import fr.curie.cd2sbgnml.graphics.CdShape;
import fr.curie.cd2sbgnml.graphics.GeometryUtils;
import fr.curie.cd2sbgnml.graphics.Glyph;
import fr.curie.cd2sbgnml.graphics.SbgnShape;
import fr.curie.cd2sbgnml.model.ReactionNodeModel;
import fr.curie.cd2sbgnml.xmlcdwrappers.StyleInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Process
extends ReactionNodeModel {
    private static final float PROCESS_SIZE = 10.0f;
    private static final float PORT_DISTANCE_RATIO = 1.0f;
    private Line2D.Float axis;

    public Process(Glyph glyph, String id, Line2D.Float axis, StyleInfo styleInfo) {
        super(glyph, id, 10.0f, 1.0f, styleInfo);
        this.axis = axis;
    }

    public Process(Point2D.Float centerCoords, String id, Line2D.Float axis, StyleInfo styleInfo) {
        super(new Glyph(centerCoords, 10.0f, 10.0f, CdShape.RECTANGLE, SbgnShape.RECTANGLE), id, 10.0f, 1.0f, styleInfo);
        this.axis = axis;
    }

    public Point2D.Float getRelativeAnchorCoords(int index) {
        float halfSize = 5.0f;
        switch (index) {
            case 0: {
                float distance = (float)this.getAxis().getP1().distance(this.getAxis().getP2()) * 0.2f;
                return new Point2D.Float(-distance, 0.0f);
            }
            case 1: {
                float distance = (float)this.getAxis().getP1().distance(this.getAxis().getP2()) * 0.2f;
                return new Point2D.Float(distance, 0.0f);
            }
            case 2: {
                return new Point2D.Float(0.0f, -halfSize);
            }
            case 3: {
                return new Point2D.Float(0.0f, halfSize);
            }
            case 4: {
                return new Point2D.Float(-halfSize, -halfSize);
            }
            case 5: {
                return new Point2D.Float(halfSize, -halfSize);
            }
            case 6: {
                return new Point2D.Float(-halfSize, halfSize);
            }
            case 7: {
                return new Point2D.Float(halfSize, halfSize);
            }
        }
        throw new IllegalArgumentException("Celldesigner index for process anchor point should be an integer from 2 to 7. Was provided: " + index);
    }

    public Point2D.Float getAbsoluteAnchorCoords(int index) {
        Point2D.Float relativeCoords = this.getRelativeAnchorCoords(index);
        if (index == 0) {
            Point2D.Float absolute = GeometryUtils.interpolationByRatio(this.getGlyph().getCenter(), (Point2D.Float)this.getAxis().getP1(), 0.2f);
            return absolute;
        }
        if (index == 1) {
            Point2D.Float absolute = GeometryUtils.interpolationByRatio(this.getGlyph().getCenter(), (Point2D.Float)this.getAxis().getP2(), 0.2f);
            return absolute;
        }
        Point2D.Double p2AtOrigin = new Point2D.Double(this.getAxis().getP2().getX() - this.getGlyph().getCenter().getX(), this.getAxis().getP2().getY() - this.getGlyph().getCenter().getY());
        double angle = GeometryUtils.angle(new Point2D.Float(1.0f, 0.0f), p2AtOrigin);
        AffineTransform t2 = new AffineTransform();
        t2.rotate(angle);
        Point2D.Float afterRotate = new Point2D.Float();
        t2.transform(relativeCoords, afterRotate);
        Point2D.Float absolute = new Point2D.Float((float)(afterRotate.getX() + this.getGlyph().getCenter().getX()), (float)(afterRotate.getY() + this.getGlyph().getCenter().getY()));
        return absolute;
    }

    public static String getSbgnClass(String reactionType) {
        switch (reactionType) {
            case "STATE_TRANSITION": {
                return "process";
            }
            case "KNOWN_TRANSITION_OMITTED": {
                return "omitted process";
            }
            case "UNKNOWN_TRANSITION": {
                return "uncertain process";
            }
            case "TRANSPORT": {
                return "process";
            }
            case "TRUNCATION": {
                return "process";
            }
            case "TRANSCRIPTION": {
                return "process";
            }
            case "TRANSLATION": {
                return "process";
            }
            case "HETERODIMER_ASSOCIATION": {
                return "process";
            }
            case "DISSOCIATION": {
                return "process";
            }
        }
        throw new IllegalArgumentException("Could not infer SBGN class from reaction type: " + reactionType);
    }

    public Line2D.Float getAxis() {
        return this.axis;
    }
}

