/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml.model;

import fr.curie.cd2sbgnml.graphics.AnchorPoint;
import fr.curie.cd2sbgnml.graphics.GeometryUtils;
import fr.curie.cd2sbgnml.graphics.Link;
import fr.curie.cd2sbgnml.model.AssocDissoc;
import fr.curie.cd2sbgnml.model.LinkModel;
import fr.curie.cd2sbgnml.model.LogicGate;
import fr.curie.cd2sbgnml.model.Process;
import fr.curie.cd2sbgnml.model.ReactantModel;
import fr.curie.cd2sbgnml.model.ReactionNodeModel;
import fr.curie.cd2sbgnml.xmlcdwrappers.LogicGateWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactantWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactionType;
import fr.curie.cd2sbgnml.xmlcdwrappers.ReactionWrapper;
import fr.curie.cd2sbgnml.xmlcdwrappers.StyleInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericReactionModel {
    private static final Logger logger = LoggerFactory.getLogger(GenericReactionModel.class);
    private List<ReactionNodeModel> reactionNodeModels = new ArrayList<ReactionNodeModel>();
    private List<ReactantModel> reactantModels = new ArrayList<ReactantModel>();
    private List<LinkModel> linkModels = new ArrayList<LinkModel>();
    private ReactionType cdReactionType;
    private boolean hasProcess;
    private String id;

    public GenericReactionModel(ReactionWrapper reactionW) {
        this.cdReactionType = reactionW.getReactionType();
        this.hasProcess = reactionW.hasProcess();
        this.id = reactionW.getId();
    }

    private HashMap<ReactantWrapper, String> addLogicGates(ReactionWrapper reactionW, Process process2) {
        HashMap<ReactantWrapper, String> reactantToLogicGateMap = new HashMap<ReactantWrapper, String>();
        for (LogicGateWrapper logicW : reactionW.getLogicGates()) {
            logger.trace("logic gate: " + logicW.getModificationType() + " " + (Object)((Object)logicW.getType()));
            Point2D.Float processAnchorPoint = process2.getAbsoluteAnchorCoords(logicW.getProcessAnchorIndex());
            List<Point2D.Float> editPoints = logicW.getLineWrapper().getEditPoints();
            logger.trace("gate edit points " + editPoints);
            Point2D.Float logicGateGlobalCoord = editPoints.get(editPoints.size() - 1);
            editPoints = editPoints.subList(0, editPoints.size() - 1);
            logger.trace("Rest of edit points: " + editPoints);
            String logicId = "logicglyph_" + UUID.randomUUID();
            LogicGate logicGate = new LogicGate(logicGateGlobalCoord, logicId, logicW.getType(), new StyleInfo(logicW.getLineWrapper().getLineWidth(), logicW.getLineWrapper().getLineColor(), logicId));
            for (ReactantWrapper reactantW : reactionW.getModifiers()) {
                if (reactantW.getLogicGate() == null || !reactantW.getLogicGate().equals(logicW)) continue;
                reactantToLogicGateMap.put(reactantW, logicId);
            }
            AffineTransform transform = GeometryUtils.getTransformsToGlobalCoords(logicGateGlobalCoord, processAnchorPoint);
            List<Point2D.Float> absoluteEditPoints = new ArrayList<Point2D.Float>();
            absoluteEditPoints.add(logicGateGlobalCoord);
            absoluteEditPoints.addAll(GeometryUtils.convertPoints(editPoints, transform));
            absoluteEditPoints.add(processAnchorPoint);
            absoluteEditPoints = GeometryUtils.getNormalizedEndPoints(absoluteEditPoints, logicGate.getGlyph(), process2.getGlyph(), AnchorPoint.E, AnchorPoint.E);
            logger.trace("FINAL logic gate edit points " + absoluteEditPoints);
            Point2D.Float pIn = logicGate.getGlyph().getCenter();
            Point2D.Float pOut = absoluteEditPoints.get(1);
            logicGate.setPorts(pIn, pOut);
            absoluteEditPoints.set(0, logicGate.getPortOut());
            String logicArcId = "logicarc_" + UUID.randomUUID();
            LinkModel logicLink = new LinkModel(logicGate, process2, new Link(absoluteEditPoints), logicArcId, LinkModel.getSbgnClass(logicW.getModificationType()), new StyleInfo(logicW.getLineWrapper().getLineWidth(), logicW.getLineWrapper().getLineColor(), logicArcId));
            this.getReactionNodeModels().add(logicGate);
            this.getLinkModels().add(logicLink);
        }
        return reactantToLogicGateMap;
    }

    public void addModifiers(ReactionWrapper reactionW, Process process2) {
        HashMap<ReactantWrapper, String> reactantToLogicGateMap = this.addLogicGates(reactionW, process2);
        HashSet<ReactionNodeModel> logicGatesToBeRemoved = new HashSet<ReactionNodeModel>();
        HashSet<LinkModel> logicLinksToBeRemoved = new HashSet<LinkModel>();
        for (ReactantWrapper reactantW : reactionW.getModifiers()) {
            String linkType;
            Point2D.Float genericNodeAnchorPoint;
            logger.trace("modifier: " + reactantW.getAliasW().getId());
            ReactantModel modifModel = new ReactantModel(reactantW);
            int modifIndex = reactantW.getPositionIndex();
            List<Point2D.Float> editPoints = reactantW.getLineWrapper().getEditPoints();
            ReactionNodeModel genericNode = null;
            LinkModel logicLink = null;
            if (reactantW.getLogicGate() != null) {
                String logicId = reactantToLogicGateMap.get(reactantW);
                for (ReactionNodeModel reactionNodeModel : this.getReactionNodeModels()) {
                    if (!reactionNodeModel.getId().equals(logicId)) continue;
                    genericNode = reactionNodeModel;
                }
                LogicGateWrapper logicGate = reactantW.getLogicGate();
                if (logicGate.getType() == LogicGateWrapper.LogicGateType.UNKNOWN) {
                    logger.error("For reaction: " + this.getId() + " a glyph with ID: " + reactantW.getAliasW().getId() + " and glyph name: " + reactantW.getAliasW().getSpeciesW().getName() + " is linked to an UNKNOWN logic gate which cannot be translated. The logic gate will be removed and the modifier will point directly to the process glyph.");
                    for (LinkModel linkModel : this.getLinkModels()) {
                        if (!linkModel.getStart().getId().equals(logicId)) continue;
                        logicLink = linkModel;
                    }
                    logicLinksToBeRemoved.add(logicLink);
                    logicGatesToBeRemoved.add(genericNode);
                    genericNode = process2;
                    genericNodeAnchorPoint = process2.getAbsoluteAnchorCoords(logicGate.getProcessAnchorIndex());
                    linkType = logicLink.getSbgnClass();
                } else {
                    genericNodeAnchorPoint = genericNode.getPortIn();
                    linkType = "logic arc";
                }
            } else {
                genericNode = process2;
                genericNodeAnchorPoint = process2.getAbsoluteAnchorCoords(reactantW.getProcessAnchorIndex());
                linkType = LinkModel.getSbgnClass(reactantW.getModificationLinkType().toString());
            }
            logger.trace("edit points: " + editPoints);
            AffineTransform transform = GeometryUtils.getTransformsToGlobalCoords(modifModel.getAbsoluteAnchorCoordinate(reactantW.getAnchorPoint()), genericNodeAnchorPoint);
            List<Point2D.Float> absoluteEditPoints = new ArrayList<Point2D.Float>();
            absoluteEditPoints.add(modifModel.getAbsoluteAnchorCoordinate(reactantW.getAnchorPoint()));
            absoluteEditPoints.addAll(GeometryUtils.convertPoints(editPoints, transform));
            absoluteEditPoints.add(genericNodeAnchorPoint);
            absoluteEditPoints = GeometryUtils.getNormalizedEndPoints(absoluteEditPoints, modifModel.getGlyph(), genericNode.getGlyph(), modifModel.getAnchorPoint(), AnchorPoint.E);
            String string = "modif_" + UUID.randomUUID();
            LinkModel modifLink = new LinkModel(modifModel, genericNode, new Link(absoluteEditPoints), string, linkType, new StyleInfo(reactantW.getLineWrapper().getLineWidth(), reactantW.getLineWrapper().getLineColor(), string));
            this.getReactantModels().add(modifModel);
            this.getLinkModels().add(modifLink);
        }
        if (logicGatesToBeRemoved.size() > 0) {
            logger.error(logicGatesToBeRemoved.size() + " logic gates were removed for reaction " + this.getId());
        }
        for (ReactionNodeModel r : logicGatesToBeRemoved) {
            this.getReactionNodeModels().remove(r);
        }
        for (LinkModel l : logicLinksToBeRemoved) {
            this.getLinkModels().remove(l);
        }
    }

    public void addAdditionalReactants(ReactionWrapper reactionW, Process process2) {
        for (ReactantWrapper reactantW : reactionW.getAdditionalReactants()) {
            ReactantModel reactantModel = new ReactantModel(reactantW);
            AffineTransform transform = GeometryUtils.getTransformsToGlobalCoords(reactantModel.getAbsoluteAnchorCoordinate(reactantW.getAnchorPoint()), process2.getAbsoluteAnchorCoords(0));
            int positionIndex = reactantW.getPositionIndex();
            logger.trace("POSITION INDEX " + positionIndex);
            List<Point2D.Float> editPoints = reactantW.getLineWrapper().getEditPoints();
            logger.trace("ADDITIONAL REACT EDIT POINTS " + editPoints);
            ArrayList<Point2D.Float> absoluteEditPoints = new ArrayList<Point2D.Float>();
            absoluteEditPoints.add(reactantModel.getAbsoluteAnchorCoordinate(reactantW.getAnchorPoint()));
            absoluteEditPoints.addAll(GeometryUtils.convertPoints(editPoints, transform));
            absoluteEditPoints.add(process2.getAbsoluteAnchorCoords(0));
            logger.trace("ABSOLUTE POINTS: " + absoluteEditPoints);
            Point2D.Float normalizedStart = GeometryUtils.normalizePoint((Point2D.Float)absoluteEditPoints.get(0), (Point2D.Float)absoluteEditPoints.get(1), reactantModel.getGlyph(), reactantModel.getAnchorPoint());
            ArrayList<Point2D.Float> normalizedEditPoints = new ArrayList<Point2D.Float>();
            normalizedEditPoints.add(normalizedStart);
            normalizedEditPoints.addAll(GeometryUtils.convertPoints(editPoints, transform));
            normalizedEditPoints.add(process2.getPortIn());
            String reactLinkId = "addreact_" + UUID.randomUUID();
            LinkModel reactLink = new LinkModel(reactantModel, process2, new Link(normalizedEditPoints), reactLinkId, "consumption", new StyleInfo(reactantW.getLineWrapper().getLineWidth(), reactantW.getLineWrapper().getLineColor(), reactLinkId));
            if (reactionW.isReversible()) {
                reactLink.reverse();
            }
            this.getReactantModels().add(reactantModel);
            this.getLinkModels().add(reactLink);
        }
    }

    public void addAdditionalProducts(ReactionWrapper reactionW, Process process2) {
        for (ReactantWrapper reactantW : reactionW.getAdditionalProducts()) {
            ReactantModel reactantModel = new ReactantModel(reactantW);
            AffineTransform transform = GeometryUtils.getTransformsToGlobalCoords(process2.getAbsoluteAnchorCoords(1), reactantModel.getAbsoluteAnchorCoordinate(reactantW.getAnchorPoint()));
            int positionIndex = reactantW.getPositionIndex();
            logger.trace("POSITION INDEX " + positionIndex);
            List<Point2D.Float> editPoints = reactantW.getLineWrapper().getEditPoints();
            logger.trace("ADDITIONAL REACT EDIT POINTS " + editPoints);
            ArrayList<Point2D.Float> absoluteEditPoints = new ArrayList<Point2D.Float>();
            absoluteEditPoints.add(process2.getAbsoluteAnchorCoords(1));
            absoluteEditPoints.addAll(GeometryUtils.convertPoints(editPoints, transform));
            absoluteEditPoints.add(reactantModel.getAbsoluteAnchorCoordinate(reactantW.getAnchorPoint()));
            logger.trace("ABSOLUTE POINTS: " + absoluteEditPoints);
            Point2D.Float normalizedEnd = GeometryUtils.normalizePoint((Point2D.Float)absoluteEditPoints.get(absoluteEditPoints.size() - 1), (Point2D.Float)absoluteEditPoints.get(absoluteEditPoints.size() - 2), reactantModel.getGlyph(), reactantModel.getAnchorPoint());
            ArrayList<Point2D.Float> normalizedEditPoints = new ArrayList<Point2D.Float>();
            normalizedEditPoints.add(process2.getPortOut());
            normalizedEditPoints.addAll(GeometryUtils.convertPoints(editPoints, transform));
            normalizedEditPoints.add(normalizedEnd);
            String reactLinkId = "addprod_" + UUID.randomUUID();
            LinkModel reactLink = new LinkModel(process2, reactantModel, new Link(normalizedEditPoints), reactLinkId, "production", new StyleInfo(reactantW.getLineWrapper().getLineWidth(), reactantW.getLineWrapper().getLineColor(), reactLinkId));
            this.getReactantModels().add(reactantModel);
            this.getLinkModels().add(reactLink);
        }
    }

    public static Point2D.Float getAbsolutePoint(Point2D.Float origin, Point2D.Float pX, Point2D.Float pY, Point2D.Float editPoint) {
        Point2D.Float absolutePoint = new Point2D.Float((float)editPoint.getX(), (float)editPoint.getY());
        AffineTransform t = GeometryUtils.getTransformsToGlobalCoords(origin, pX, pY);
        t.transform(absolutePoint, absolutePoint);
        if (Double.isNaN(absolutePoint.getX()) || Double.isNaN(absolutePoint.getY())) {
            logger.error("NaN was produced as global coords for association glyph with coords: " + editPoint + " Local coordinates will be used instead, but they may be incorrect.");
            absolutePoint = editPoint;
        }
        return absolutePoint;
    }

    public static List<Point2D.Float> getBranchPoints(ReactionWrapper reactionW, Point2D.Float origin, Point2D.Float pX, int branch) {
        ArrayList<Point2D.Float> absoluteEditPoints = new ArrayList<Point2D.Float>();
        absoluteEditPoints.add(origin);
        logger.trace("local system: " + origin + " " + pX);
        logger.trace("points for BRANCH " + branch + " " + reactionW.getEditPointsForBranch(branch));
        for (Point2D point2D : reactionW.getEditPointsForBranch(branch)) {
            Point2D.Double p = new Point2D.Double(point2D.getX(), point2D.getY());
            AffineTransform t = GeometryUtils.getTransformsToGlobalCoords(origin, pX);
            t.transform(p, p);
            logger.trace("BRANCH " + branch + " result: " + point2D + " -> " + ((Object)p).toString());
            absoluteEditPoints.add(new Point2D.Float((float)((Point2D)p).getX(), (float)((Point2D)p).getY()));
        }
        absoluteEditPoints.add(pX);
        logger.trace("BRANCH " + branch + " stack: " + absoluteEditPoints);
        return absoluteEditPoints;
    }

    public Process getProcess() {
        for (ReactionNodeModel node : this.getReactionNodeModels()) {
            if (!(node instanceof Process)) continue;
            return (Process)node;
        }
        throw new RuntimeException("Reaction has no process " + this.getId());
    }

    public AssocDissoc getAssocDissoc() {
        for (ReactionNodeModel node : this.getReactionNodeModels()) {
            if (!(node instanceof AssocDissoc)) continue;
            return (AssocDissoc)node;
        }
        throw new RuntimeException("Reaction has no association or dissociation glyph " + this.getId());
    }

    public List<ReactionNodeModel> getReactionNodeModels() {
        return this.reactionNodeModels;
    }

    public List<ReactantModel> getReactantModels() {
        return this.reactantModels;
    }

    public List<LinkModel> getLinkModels() {
        return this.linkModels;
    }

    public ReactionType getCdReactionType() {
        return this.cdReactionType;
    }

    public boolean hasProcess() {
        return this.hasProcess;
    }

    public String getId() {
        return this.id;
    }
}

