/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml;

import fr.curie.cd2sbgnml.xmlcdwrappers.StyleInfo;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sbgn.ArcClazz;
import org.sbgn.GlyphClazz;
import org.sbgn.bindings.Arc;
import org.sbgn.bindings.Bbox;
import org.sbgn.bindings.Glyph;
import org.sbgn.bindings.Map;
import org.sbgn.bindings.Port;
import org.sbgn.bindings.Sbgn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SBGNUtils {
    private static final Logger logger = LoggerFactory.getLogger(SBGNUtils.class);

    public static Rectangle2D getMapBounds(Map map) {
        if (map.getGlyph().size() == 0) {
            return new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        }
        Bbox firstBox = map.getGlyph().get(0).getBbox();
        float minX = firstBox.getX();
        float maxX = minX + firstBox.getW();
        float minY = firstBox.getY();
        float maxY = minY + firstBox.getH();
        for (Glyph glyph : map.getGlyph()) {
            Bbox b = glyph.getBbox();
            float currentX = b.getX();
            float currentMaxX = b.getX() + b.getW();
            float currentY = b.getY();
            float currentMaxY = b.getY() + b.getH();
            minX = Float.min(currentX, minX);
            maxX = Float.max(currentMaxX, maxX);
            minY = Float.min(currentY, minY);
            maxY = Float.max(currentMaxY, maxY);
        }
        int sizeX = Math.round(maxX - minX) + 200;
        int sizeY = Math.round(maxY - minY) + 200;
        float X = minX - 100.0f;
        float Y = minY - 100.0f;
        return new Rectangle2D.Float(X, Y, sizeX, sizeY);
    }

    public static java.util.Map<String, StyleInfo> mapStyleinfo(Element renderInformation) {
        HashMap<String, StyleInfo> result = new HashMap<String, StyleInfo>();
        NodeList listOfColors = renderInformation.getElementsByTagName("colorDefinition");
        HashMap<String, String> colorMap = new HashMap<String, String>();
        for (int i = 0; i < listOfColors.getLength(); ++i) {
            Element color = (Element)listOfColors.item(i);
            String colorValue = color.getAttribute("value").replaceFirst("#", "");
            if (colorValue.length() == 8) {
                String alpha = colorValue.substring(6, 8);
                colorValue = alpha + colorValue.substring(0, 6);
            } else if (colorValue.length() == 6) {
                colorValue = "ff" + colorValue;
            }
            colorMap.put(color.getAttribute("id"), colorValue);
        }
        NodeList listOfStyles = renderInformation.getElementsByTagName("style");
        for (int i = 0; i < listOfStyles.getLength(); ++i) {
            Element style = (Element)listOfStyles.item(i);
            String idListAttr = style.getAttribute("idList");
            List<String> idList = Arrays.asList(idListAttr.split(" "));
            Element g = (Element)style.getElementsByTagName("g").item(0);
            for (String refId : idList) {
                StyleInfo styleInfo = new StyleInfo(refId);
                if (g.getAttribute("fontSize") != null && !g.getAttribute("fontSize").isEmpty()) {
                    styleInfo.setFontSize(Float.parseFloat(g.getAttribute("fontSize")));
                }
                if (g.getAttribute("strokeWidth") != null) {
                    styleInfo.setLineWidth(Float.parseFloat(g.getAttribute("strokeWidth")));
                }
                if (g.getAttribute("stroke") != null) {
                    styleInfo.setLineColor((String)colorMap.get(g.getAttribute("stroke")));
                }
                if (g.getAttribute("fill") != null && !g.getAttribute("fill").isEmpty()) {
                    styleInfo.setBgColor((String)colorMap.get(g.getAttribute("fill")));
                }
                result.put(refId, styleInfo);
            }
        }
        return result;
    }

    public static String urlToUrn(String url) {
        Matcher m = Pattern.compile("http://identifiers\\.org/(\\S+):(\\S+)").matcher(url);
        if (m.matches()) {
            String db = m.group(1);
            String id = m.group(2);
            return "urn:miriam:" + db + ":" + id;
        }
        throw new IllegalArgumentException("Annotation URL: " + url + " not recognized, must be of the form: http://identifiers.org/<db>:<id>");
    }

    public static Element sanitizeRdfURNs(Element rdf) {
        Element result = (Element)rdf.cloneNode(true);
        NodeList nodeList = result.getElementsByTagName("rdf:li");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String convertedResource;
            Element e = (Element)nodeList.item(i);
            String resource = e.getAttribute("rdf:resource");
            if (resource.contains("http://identifiers.org/")) {
                convertedResource = SBGNUtils.urlToUrn(resource);
            } else if (resource.contains("urn:miriam:")) {
                convertedResource = resource;
            } else {
                logger.warn("Annotation resource: " + resource + " isn't of any known format (urn or identifier url) andmay be ignored and lost by CellDesigner");
                convertedResource = resource;
            }
            e.setAttribute("rdf:resource", convertedResource);
        }
        return result;
    }

    public static boolean hasUnitOfInfo(Glyph glyph, String regexp) {
        Pattern p = Pattern.compile(regexp, 2);
        for (Glyph subglyph : glyph.getGlyph()) {
            String info;
            Matcher m;
            if (!subglyph.getClazz().equals("unit of information") || !(m = p.matcher(info = subglyph.getLabel().getText())).find()) continue;
            return true;
        }
        return false;
    }

    public static Optional<Glyph> getUnitOfInfo(Glyph glyph, String regexp) {
        Pattern p = Pattern.compile(regexp, 2);
        for (Glyph subglyph : glyph.getGlyph()) {
            String info;
            Matcher m;
            if (!subglyph.getClazz().equals("unit of information") || !(m = p.matcher(info = subglyph.getLabel().getText())).find()) continue;
            return Optional.of(subglyph);
        }
        return Optional.empty();
    }

    public static int getMultimerFromInfo(Glyph glyph) {
        if (SBGNUtils.hasUnitOfInfo(glyph, "N\\s*:\\s*\\d+")) {
            Pattern p = Pattern.compile("N\\s*:\\s*(\\d+)", 2);
            for (Glyph subglyph : glyph.getGlyph()) {
                String info;
                Matcher m;
                if (!subglyph.getClazz().equals("unit of information") || !(m = p.matcher(info = subglyph.getLabel().getText())).find()) continue;
                return Integer.parseInt(m.group(1));
            }
        }
        return 0;
    }

    public static boolean isReactionReversible(List<Arc> arcs) {
        for (Arc arc : arcs) {
            ArcClazz clazz = ArcClazz.fromClazz(arc.getClazz());
            if (clazz != ArcClazz.CONSUMPTION) continue;
            return false;
        }
        return true;
    }

    public static List<List<Arc>> getReactantTypes(List<Arc> arcs, boolean isReversible) {
        ArrayList<List<Arc>> result = new ArrayList<List<Arc>>();
        ArrayList<Arc> products = new ArrayList<Arc>();
        ArrayList<Arc> reactants = new ArrayList<Arc>();
        ArrayList<Arc> modifiers = new ArrayList<Arc>();
        block4: for (Arc arc : arcs) {
            ArcClazz clazz = ArcClazz.fromClazz(arc.getClazz());
            switch (clazz) {
                case CONSUMPTION: {
                    reactants.add(arc);
                    continue block4;
                }
                case PRODUCTION: {
                    products.add(arc);
                    continue block4;
                }
            }
            modifiers.add(arc);
        }
        if (isReversible) {
            reactants.add((Arc)products.remove(0));
        }
        result.add(reactants);
        result.add(products);
        result.add(modifiers);
        return result;
    }

    public static List<List<Arc>> getBLGReactantTypes(List<Arc> arcs) {
        ArrayList<List<Arc>> result = new ArrayList<List<Arc>>();
        ArrayList<Arc> product = new ArrayList<Arc>();
        ArrayList<Arc> reactants = new ArrayList<Arc>();
        block3: for (Arc arc : arcs) {
            ArcClazz clazz = ArcClazz.fromClazz(arc.getClazz());
            switch (clazz) {
                case LOGIC_ARC: {
                    reactants.add(arc);
                    continue block3;
                }
            }
            product.add(arc);
        }
        if (product.size() > 1) {
            logger.error("Logic gate has more than 1 output arc, only the first arc will be considered, others arediscarded.");
        }
        result.add(reactants);
        result.add(product);
        return result;
    }

    public static boolean isReactionAssociation(Glyph process2, List<Arc> reactants, List<Arc> products) {
        return process2.getClazz().equals("association");
    }

    public static boolean isReactionDissociation(Glyph process2, List<Arc> reactants, List<Arc> products) {
        if (process2.getClazz().equals("dissociation")) {
            return true;
        }
        if (products.size() < 2) {
            return false;
        }
        return false;
    }

    public static List<Point2D.Float> getPoints(Arc arc) {
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        float startX = arc.getStart().getX();
        float startY = arc.getStart().getY();
        points.add(new Point2D.Float(startX, startY));
        for (Arc.Next n : arc.getNext()) {
            points.add(new Point2D.Float(n.getX(), n.getY()));
        }
        float endX = arc.getEnd().getX();
        float endY = arc.getEnd().getY();
        points.add(new Point2D.Float(endX, endY));
        return points;
    }

    public static void sanitizeSubGlyphs(List<Glyph> subglyphs) {
        for (Glyph g : subglyphs) {
            g.setId(g.getId().replaceAll("-", "_"));
            SBGNUtils.sanitizeSubGlyphs(g.getGlyph());
        }
    }

    public static Sbgn sanitizeIds(Sbgn sbgn) {
        for (Glyph g : sbgn.getMap().getGlyph()) {
            g.setId(g.getId().replaceAll("-", "_"));
            SBGNUtils.sanitizeSubGlyphs(g.getGlyph());
            if (g.getPort().size() <= 0) continue;
            for (Port p : g.getPort()) {
                p.setId(p.getId().replaceAll("-", "_"));
            }
        }
        for (Arc a : sbgn.getMap().getArc()) {
            a.setId(a.getId().replaceAll("-", "_"));
        }
        if (sbgn.getMap().getExtension() != null) {
            for (Element e : sbgn.getMap().getExtension().getAny()) {
                if (!e.getTagName().equals("renderInformation")) continue;
                NodeList nodeList = e.getElementsByTagName("style");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element e2 = (Element)nodeList.item(i);
                    e2.setAttribute("idList", e2.getAttribute("idList").replaceAll("-", "_"));
                }
            }
        }
        return sbgn;
    }

    public static Rectangle2D.Float getRectangleFromGlyph(Glyph g) {
        return new Rectangle2D.Float(g.getBbox().getX(), g.getBbox().getY(), g.getBbox().getW(), g.getBbox().getH());
    }

    public static boolean isLogicGate(Glyph g) {
        return GlyphClazz.fromClazz(g.getClazz()) == GlyphClazz.AND || GlyphClazz.fromClazz(g.getClazz()) == GlyphClazz.OR || GlyphClazz.fromClazz(g.getClazz()) == GlyphClazz.NOT;
    }

    public static List<Glyph> getStateVariables(Glyph g) {
        boolean i = true;
        ArrayList<Glyph> result = new ArrayList<Glyph>();
        for (Glyph subglyph : g.getGlyph()) {
            if (GlyphClazz.fromClazz(subglyph.getClazz()) != GlyphClazz.STATE_VARIABLE) continue;
            result.add(subglyph);
        }
        return result;
    }
}

