/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.exceptions.WriteModelException;
import org.sbfc.converter.models.SBGNModel;
import org.sbgn.bindings.Sbgn;

public class SBGNSBFCModel
extends SBGNModel {
    private Sbgn model;

    public SBGNSBFCModel() {
    }

    public SBGNSBFCModel(Sbgn model) {
        super(model);
        this.model = model;
    }

    public Sbgn getModel() {
        return this.model;
    }

    @Override
    public void setModelFromFile(String fileName) throws ReadModelException {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            SBGNSBFCModel.BOMskip(reader);
            String content = reader.lines().collect(Collectors.joining());
            content = content.replaceFirst("http://sbgn\\.org/libsbgn/0\\.3", "http://sbgn.org/libsbgn/0.2");
            JAXBContext context = JAXBContext.newInstance((String)"org.sbgn.bindings");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            this.model = (Sbgn)unmarshaller.unmarshal((Reader)new StringReader(content));
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void modelToFile(String fileName) throws WriteModelException {
        StringWriter sw = new StringWriter();
        try {
            Marshaller marshaller = JAXBContext.newInstance((String)"org.sbgn.bindings").createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)this.model, (Writer)sw);
            String content = sw.toString();
            PrintWriter out = new PrintWriter(fileName);
            out.println(content);
            out.close();
        }
        catch (FileNotFoundException | JAXBException e) {
            e.printStackTrace();
        }
    }

    public static void BOMskip(Reader reader) throws IOException {
        reader.mark(1);
        char[] possibleBOM = new char[1];
        reader.read(possibleBOM);
        if (possibleBOM[0] != '\ufeff' && possibleBOM[0] != '\u00ef') {
            reader.reset();
        } else if (possibleBOM[0] == '\u00ef') {
            reader.read(new char[2]);
        }
    }
}

