/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml;

import fr.curie.cd2sbgnml.xmlcdwrappers.Utils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.exceptions.WriteModelException;
import org.sbfc.converter.models.GeneralModel;
import org.sbml.sbml.level2.version4.Sbml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellDesignerSBFCModel
implements GeneralModel {
    private final Logger logger = LoggerFactory.getLogger(CellDesignerSBFCModel.class);
    private Sbml sbml;

    public CellDesignerSBFCModel() {
    }

    public CellDesignerSBFCModel(Sbml sbml) {
        this.sbml = sbml;
    }

    public Sbml getSbml() {
        return this.sbml;
    }

    @Override
    public void setModelFromFile(String s) throws ReadModelException {
        byte[] encoded = new byte[]{};
        try {
            encoded = Files.readAllBytes(Paths.get(s, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String sbmlString = new String(encoded, StandardCharsets.UTF_8);
        this.setModelFromString(sbmlString);
    }

    @Override
    public void setModelFromString(String s) throws ReadModelException {
        Pattern p2;
        Matcher m2;
        Pattern p = Pattern.compile("xmlns=\"http://www\\.sbml\\.org/sbml/level2\"");
        Matcher m = p.matcher(s);
        if (m.find()) {
            this.logger.warn("Namespace definition was messed up, it has been set to: xmlns=\"http://www.sbml.org/sbml/level2/version4\"");
            s = s.replaceFirst("xmlns=\"http://www\\.sbml\\.org/sbml/level2\"", "xmlns=\"http://www.sbml.org/sbml/level2/version4\"");
        }
        if (!(m2 = (p2 = Pattern.compile("<annotation>[\\n\\s]*<celldesigner:extension>")).matcher(s)).find()) {
            this.logger.warn("<celldesigner:extension> elements are missing, they were added automatically.");
            s = s.replaceAll("<annotation>", "<annotation><celldesigner:extension>");
            s = s.replaceAll("</annotation>", "</celldesigner:extension></annotation>");
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Sbml.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            this.sbml = (Sbml)jaxbUnmarshaller.unmarshal((Reader)new StringReader(s));
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new ReadModelException(e.getCause());
        }
    }

    @Override
    public void modelToFile(String s) throws WriteModelException {
        File file = new File(s);
        Marshaller marshaller = null;
        try {
            marshaller = JAXBContext.newInstance((Class[])new Class[]{Sbml.class}).createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new Utils.DefaultNamespacePrefixMapper());
            marshaller.marshal((Object)this.sbml, file);
        }
        catch (JAXBException e) {
            throw new WriteModelException(e.getCause());
        }
    }

    @Override
    public String modelToString() throws WriteModelException {
        return this.sbml.toString();
    }

    @Override
    public String[] getExtensions() {
        return new String[0];
    }

    @Override
    public boolean isCorrectType(File file) {
        return false;
    }

    @Override
    public String getURI() {
        return null;
    }
}

