/*
 * Decompiled with CFR 0.152.
 */
package fr.curie.cd2sbgnml;

import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import fr.curie.cd2sbgnml.Cd2SbgnmlScript;
import fr.curie.cd2sbgnml.Sbgnml2CdScript;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.Task;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;

public class App
extends Application {
    private ObjectProperty<ConvertionChoice> directionChoice = new SimpleObjectProperty((Object)ConvertionChoice.CD2SBGN);

    public void start(Stage primaryStage) {
        primaryStage.setTitle("CellDesigner \u00e2\u2021\u201e SBGN-ML");
        VBox vbox = new VBox(10.0);
        vbox.setPadding(new Insets(20.0, 20.0, 20.0, 20.0));
        vbox.setAlignment(Pos.CENTER);
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER_LEFT);
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        vbox.getChildren().add((Object)grid);
        Button cd2sbgnRadio = new Button(ConvertionChoice.CD2SBGN.toString());
        Button sbgn2cdRadio = new Button(ConvertionChoice.SBGN2CD.toString());
        final TextField inputFileText = new TextField();
        final TextField outputFileText = new TextField();
        TextField logFileText = new TextField();
        cd2sbgnRadio.getStyleClass().add((Object)"toggle");
        cd2sbgnRadio.setPrefWidth(250.0);
        cd2sbgnRadio.setPrefHeight(36.0);
        cd2sbgnRadio.setStyle("-fx-background-color: #1976d2");
        cd2sbgnRadio.setOnAction(e -> this.directionChoice.setValue((Object)ConvertionChoice.CD2SBGN));
        Animation b1select = this.buildAnimation(cd2sbgnRadio, true);
        Animation b1unselect = this.buildAnimation(cd2sbgnRadio, false);
        sbgn2cdRadio.getStyleClass().add((Object)"toggle");
        sbgn2cdRadio.setPrefWidth(250.0);
        sbgn2cdRadio.setPrefHeight(36.0);
        sbgn2cdRadio.setOnAction(e -> this.directionChoice.setValue((Object)ConvertionChoice.SBGN2CD));
        Animation b2select = this.buildAnimation(sbgn2cdRadio, true);
        Animation b2unselect = this.buildAnimation(sbgn2cdRadio, false);
        this.directionChoice.addListener((observable, oldValue, newValue) -> {
            if (newValue == ConvertionChoice.SBGN2CD) {
                b1unselect.play();
                b2select.play();
            } else {
                b1select.play();
                b2unselect.play();
            }
        });
        grid.add((Node)cd2sbgnRadio, 1, 0);
        grid.add((Node)sbgn2cdRadio, 1, 1);
        GridPane.setMargin((Node)sbgn2cdRadio, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
        Label inputFileLabel = new Label("Input File");
        inputFileLabel.getStyleClass().addAll((Object[])new String[]{"bold"});
        inputFileLabel.setPrefWidth(150.0);
        inputFileLabel.setAlignment(Pos.CENTER_RIGHT);
        grid.add((Node)inputFileLabel, 0, 2);
        grid.add((Node)inputFileText, 1, 2);
        FileChooser inputFileChooser = new FileChooser();
        Button inputFileOpenButton = GlyphsDude.createIconButton(FontAwesomeIcon.FOLDER_OPEN);
        inputFileOpenButton.getStyleClass().add((Object)"normal");
        grid.add((Node)inputFileOpenButton, 2, 2);
        inputFileOpenButton.setOnAction(e -> {
            File file = inputFileChooser.showOpenDialog((Window)primaryStage);
            if (file != null) {
                inputFileText.setText(file.getAbsolutePath());
                this.autoFillFromInputFile(file, outputFileText, logFileText);
                inputFileText.positionCaret(inputFileText.getText().length());
            }
        });
        Label outputFileLabel = new Label("Output File");
        outputFileLabel.getStyleClass().addAll((Object[])new String[]{"bold"});
        grid.add((Node)outputFileLabel, 0, 3);
        GridPane.setHalignment((Node)outputFileLabel, (HPos)HPos.RIGHT);
        grid.add((Node)outputFileText, 1, 3);
        FileChooser outputFileChooser = new FileChooser();
        Button outputFileOpenButton = GlyphsDude.createIconButton(FontAwesomeIcon.FOLDER_OPEN);
        outputFileOpenButton.getStyleClass().add((Object)"normal");
        grid.add((Node)outputFileOpenButton, 2, 3);
        outputFileOpenButton.setOnAction(e -> {
            File file = outputFileChooser.showSaveDialog((Window)primaryStage);
            if (file != null) {
                outputFileText.setText(file.getAbsolutePath());
                outputFileText.positionCaret(outputFileText.getText().length());
            }
        });
        Label logFileLabel = new Label("Log File");
        logFileLabel.getStyleClass().addAll((Object[])new String[]{"bold"});
        grid.add((Node)logFileLabel, 0, 4);
        GridPane.setHalignment((Node)logFileLabel, (HPos)HPos.RIGHT);
        grid.add((Node)logFileText, 1, 4);
        FileChooser logFileChooser = new FileChooser();
        Button logFileOpenButton = GlyphsDude.createIconButton(FontAwesomeIcon.FOLDER_OPEN);
        logFileOpenButton.getStyleClass().add((Object)"normal");
        grid.add((Node)logFileOpenButton, 2, 4);
        logFileOpenButton.setOnAction(e -> {
            File file = logFileChooser.showSaveDialog((Window)primaryStage);
            if (file != null) {
                logFileText.setText(file.getAbsolutePath());
                logFileText.positionCaret(logFileText.getText().length());
            }
        });
        Button convertButton = new Button("Convert");
        convertButton.getStyleClass().addAll((Object[])new String[]{"normal", "important"});
        grid.add((Node)convertButton, 1, 5);
        GridPane.setHalignment((Node)convertButton, (HPos)HPos.CENTER);
        GridPane.setMargin((Node)convertButton, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        final Label infoLabel = new Label();
        final ProgressIndicator progressWheel = new ProgressIndicator();
        progressWheel.setPrefHeight(20.0);
        final HBox infosBox = new HBox(new Node[]{infoLabel});
        infosBox.setAlignment(Pos.CENTER);
        grid.add((Node)infosBox, 1, 6);
        GridPane.setHalignment((Node)infosBox, (HPos)HPos.CENTER);
        convertButton.setOnAction(e -> {
            PrintStream out = null;
            try {
                out = new PrintStream(new FileOutputStream(logFileText.getText()));
            }
            catch (FileNotFoundException e1) {
                infoLabel.setText("No log file provided.");
                return;
            }
            System.setOut(out);
            System.setErr(System.out);
            if (inputFileText.getText().isEmpty()) {
                infoLabel.setText("No input provided.");
                return;
            }
            if (outputFileText.getText().isEmpty()) {
                infoLabel.setText("No output provided.");
                return;
            }
            if (this.directionChoice.get() == ConvertionChoice.CD2SBGN) {
                System.out.println("Convert button clicked, launch script");
                Task<Void> task = new Task<Void>(){

                    public Void call() {
                        Platform.runLater(() -> {
                            infoLabel.setText("");
                            infosBox.getChildren().add((Object)progressWheel);
                        });
                        try {
                            Cd2SbgnmlScript.convert(inputFileText.getText(), outputFileText.getText());
                            Platform.runLater(() -> infoLabel.setText("Done."));
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> infoLabel.setText("An exception occured, see the log."));
                        }
                        finally {
                            Platform.runLater(() -> infosBox.getChildren().remove((Object)progressWheel));
                        }
                        return null;
                    }
                };
                new Thread((Runnable)task).start();
            } else if (this.directionChoice.get() == ConvertionChoice.SBGN2CD) {
                System.out.println("Convert button clicked, launch script");
                Task<Void> task = new Task<Void>(){

                    public Void call() {
                        Platform.runLater(() -> {
                            infoLabel.setText("");
                            infosBox.getChildren().add((Object)progressWheel);
                        });
                        try {
                            Sbgnml2CdScript.convert(inputFileText.getText(), outputFileText.getText());
                            Platform.runLater(() -> infoLabel.setText("Done."));
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> infoLabel.setText("An exception occured, see the log."));
                        }
                        finally {
                            Platform.runLater(() -> infosBox.getChildren().remove((Object)progressWheel));
                        }
                        return null;
                    }
                };
                new Thread((Runnable)task).start();
            } else {
                throw new RuntimeException("That shouldn't happen.");
            }
        });
        Text issueMessage = new Text("If you encounter a problem, please open an issue on");
        issueMessage.getStyleClass().add((Object)"small");
        Hyperlink issueLink = new Hyperlink("github");
        issueLink.getStyleClass().add((Object)"small");
        issueLink.setStyle("-fx-underline: true;");
        TextFlow wholeMessage = new TextFlow(new Node[]{issueMessage, issueLink});
        wholeMessage.setPrefWidth(170.0);
        HBox footer = new HBox(new Node[]{wholeMessage});
        footer.setAlignment(Pos.BOTTOM_RIGHT);
        issueLink.setOnMouseClicked(e -> this.getHostServices().showDocument("https://github.com/royludo/cd2sbgnml/issues"));
        AnchorPane anchorPane = new AnchorPane(new Node[]{vbox, footer});
        AnchorPane.setTopAnchor((Node)vbox, (Double)20.0);
        AnchorPane.setBottomAnchor((Node)footer, (Double)0.0);
        AnchorPane.setRightAnchor((Node)footer, (Double)0.0);
        Scene scene = new Scene((Parent)anchorPane, 610.0, 400.0);
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/guiStyle.css").toExternalForm());
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    private Animation buildAnimation(final Button button, final boolean select) {
        Transition animation = new Transition(){
            Color startColor;
            Color endColor;
            {
                this.setCycleDuration(Duration.millis((double)100.0));
                this.setInterpolator(Interpolator.LINEAR);
                String normalColor = "#373737";
                String selectedColor = "#1976d2";
                if (select) {
                    this.startColor = Color.web((String)normalColor);
                    this.endColor = Color.web((String)selectedColor);
                } else {
                    this.startColor = Color.web((String)selectedColor);
                    this.endColor = Color.web((String)normalColor);
                }
            }

            protected void interpolate(double frac) {
                Color finalColor = this.startColor.interpolate(this.endColor, frac);
                button.setStyle("-fx-background-color: " + App.toRGBCode(finalColor));
            }
        };
        return animation;
    }

    private void autoFillFromInputFile(File inputFile, TextField outputField, TextField logField) {
        Path inputPath = inputFile.toPath().getParent();
        String inputName = inputFile.toPath().getFileName().toString();
        String noExt = inputName.contains(".") ? inputName.substring(0, inputName.lastIndexOf(46)) : inputName;
        String outputExt = this.directionChoice.get() == ConvertionChoice.CD2SBGN ? "sbgn" : "xml";
        Path outputFullPath = Paths.get(inputPath.toString(), noExt + "." + outputExt);
        Path logFullPath = Paths.get(inputPath.toString(), noExt + ".log");
        outputField.setText(outputFullPath.toString());
        logField.setText(logFullPath.toString());
        outputField.positionCaret(outputField.getText().length());
        logField.positionCaret(logField.getText().length());
    }

    private static String toRGBCode(Color color) {
        return String.format("#%02X%02X%02X", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }

    public class TextOutputStream
    extends OutputStream {
        TextArea textArea;

        public TextOutputStream(TextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void write(int b) throws IOException {
            this.textArea.appendText(String.valueOf((char)b));
            this.textArea.positionCaret(this.textArea.getText().length());
        }
    }

    public static enum ConvertionChoice {
        CD2SBGN,
        SBGN2CD;


        public String toString() {
            switch (this) {
                case CD2SBGN: {
                    return "CellDesigner \u00e2\u017e\u00a1 SBGN-ML";
                }
                case SBGN2CD: {
                    return "SBGN-ML \u00e2\u017e\u00a1 CellDesigner";
                }
            }
            throw new IllegalArgumentException("No valid enum was given");
        }
    }
}

