"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFile = exports.readFileAsync = exports.readdirAsync = exports.pascalize = void 0;
const fs = require("fs");
function pascalize(input) {
    return input.replace(/([a-zA-Z])([a-zA-Z]*)/g, function (_g0, g1, g2) { return g1.toUpperCase() + g2.toLowerCase(); })
        .replace(/[^a-zA-Z0-9]/g, '');
}
exports.pascalize = pascalize;
function readdirAsync(dirname) {
    return new Promise(function (resolve, reject) {
        fs.readdir(dirname, function (err, filenames) {
            if (err) {
                reject(err);
            }
            else {
                resolve(filenames);
            }
        });
    });
}
exports.readdirAsync = readdirAsync;
;
// make Promise version of fs.readFile()
function readFileAsync(filename, enc) {
    return new Promise(function (resolve, reject) {
        fs.readFile(filename, enc, function (err, data) {
            if (err) {
                reject(err);
            }
            else {
                resolve(data);
            }
        });
    });
}
exports.readFileAsync = readFileAsync;
;
// utility function, return Promise
async function getFile(filename) {
    return readFileAsync(filename, 'utf8');
}
exports.getFile = getFile;
//# sourceMappingURL=data:application/json;base64,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