"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackNotification = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const logs = require("aws-cdk-lib/aws-logs");
const aws_logs_destinations_1 = require("aws-cdk-lib/aws-logs-destinations");
const snsSubscriptions = require("aws-cdk-lib/aws-sns-subscriptions");
const constructs_1 = require("constructs");
class SlackNotification extends constructs_1.Construct {
    constructor(scope, id, snsTopic, slackConfig, recipename) {
        super(scope, id);
        this.snsTopic = snsTopic;
        if (slackConfig.slackWebhookUrl && slackConfig.channel && slackConfig.username) {
            const pipelineSlackFn = new lambda.Function(this, 'PipelineSlackFunction', {
                runtime: lambda.Runtime.PYTHON_3_8,
                handler: 'main.lambda_handler',
                code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'slack-notification')),
                environment: {
                    SLACK_WEBHOOK_URL: slackConfig.slackWebhookUrl,
                    SLACK_CHANNEL: slackConfig.channel,
                    SLACK_USERNAME: slackConfig.username,
                },
            });
            this.snsTopic.addSubscription(new snsSubscriptions.LambdaSubscription(pipelineSlackFn));
            const fn = new lambda.Function(this, 'SubFiltSlackFunction', {
                runtime: lambda.Runtime.PYTHON_3_8,
                handler: 'main.lambda_handler',
                code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'slack-notification-sub-filter')),
                environment: {
                    SLACK_WEBHOOK_URL: slackConfig.slackWebhookUrl,
                    SLACK_CHANNEL: slackConfig.channel,
                    SLACK_USERNAME: slackConfig.username,
                    RECIPE_NAME: recipename,
                },
            });
            const logGroup = new logs.LogGroup(this, `${recipename}LogGroup`, {
                logGroupName: `/aws/imagebuilder/${recipename}`,
                retention: logs.RetentionDays.ONE_DAY,
            });
            new logs.SubscriptionFilter(this, 'SlackSubFilter', {
                destination: new aws_logs_destinations_1.LambdaDestination(fn),
                filterPattern: logs.FilterPattern.allTerms('Step'),
                logGroup: logGroup,
            });
        }
    }
}
exports.SlackNotification = SlackNotification;
_a = JSII_RTTI_SYMBOL_1;
SlackNotification[_a] = { fqn: "halloumi-ami-pipelines.SlackNotification", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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