"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImageRecipeVersionBump = void 0;
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const logs = require("aws-cdk-lib/aws-logs");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class ImageRecipeVersionBump extends constructs_1.Construct {
    constructor(scope, id, recipeName) {
        super(scope, id);
        this.recipeName = recipeName;
        const fn = new lambda.SingletonFunction(this, 'ImageRecipeLatestVersion', {
            uuid: '35399eb5-3b70-49d2-bcf6-ab26006ee648',
            runtime: lambda.Runtime.PYTHON_3_8,
            handler: 'index.handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'imagerecipe-latest-version')),
            initialPolicy: [
                aws_iam_1.PolicyStatement.fromJson({
                    Sid: 'VisualEditor0',
                    Effect: 'Allow',
                    Action: [
                        'imagebuilder:ListImagePipelines',
                        'imagebuilder:ListComponents',
                        'imagebuilder:ListImageRecipes',
                    ],
                    Resource: '*',
                }),
            ],
            timeout: cdk.Duration.minutes(5),
        });
        const provider = new cr.Provider(this, 'ImageRecipeCrProvider', {
            onEventHandler: fn,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const customResource = new cdk.CustomResource(this, 'ImageRecipeLatestVersionCustom', {
            serviceToken: provider.serviceToken,
            properties: {
                RecipeName: this.recipeName,
                RefreshToken: Date.now(),
            },
        });
        this.nextVersion = customResource.getAtt('NextVersion').toString();
    }
}
exports.ImageRecipeVersionBump = ImageRecipeVersionBump;
//# sourceMappingURL=data:application/json;base64,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