"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComponentVersionBump = void 0;
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const logs = require("aws-cdk-lib/aws-logs");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class ComponentVersionBump extends constructs_1.Construct {
    constructor(scope, id, componentName) {
        super(scope, id);
        this.componentName = componentName;
        const fn = new lambda.SingletonFunction(this, 'ComponentLatestVersion', {
            uuid: '2e19301f-4792-43a6-ba35-8899ff89a708',
            runtime: lambda.Runtime.PYTHON_3_8,
            handler: 'index.handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'component-latest-version')),
            initialPolicy: [
                aws_iam_1.PolicyStatement.fromJson({
                    Sid: 'ListComponents',
                    Effect: 'Allow',
                    Action: [
                        'imagebuilder:ListComponents',
                    ],
                    Resource: '*',
                }),
            ],
            timeout: cdk.Duration.minutes(5),
        });
        const provider = new cr.Provider(this, `ComponentVersionProvider${this.componentName}`, {
            onEventHandler: fn,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const customResource = new cdk.CustomResource(this, 'ComponentLatestVersionCustom', {
            serviceToken: provider.serviceToken,
            properties: {
                ComponentName: this.componentName,
                RefreshToken: Date.now(),
            },
        });
        this.nextVersion = customResource.getAtt('NextVersion').toString();
    }
}
exports.ComponentVersionBump = ComponentVersionBump;
//# sourceMappingURL=data:application/json;base64,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