"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComponentSynchronizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const simple_git_1 = require("simple-git");
/**
 * Ensures that component dependencies are downloaded and available
 */
class ComponentSynchronizer {
    constructor() {
        this.cacheDir = 'component_cache';
    }
    async synchronize(componentDefs) {
        const git = simple_git_1.default();
        // Ensure component cache directory exists
        if (!fs.existsSync(this.cacheDir)) {
            fs.mkdirSync(this.cacheDir);
        }
        const gitDefs = componentDefs.filter((x) => x.type == 'git');
        // Pull in all the git component dependencies
        for (let componentConfig of gitDefs) {
            const destination = componentConfig.name;
            if (!fs.existsSync(path.join(this.cacheDir, destination))) {
                await git.cwd(this.cacheDir)
                    .clone(componentConfig.url, destination, {
                    '--branch': componentConfig.branch,
                })
                    .cwd('../../')
                    .catch(e => {
                    console.error(e);
                    throw new Error(e);
                });
            }
            else {
                await git.cwd(path.join(this.cacheDir, destination))
                    .fetch()
                    .checkout(componentConfig.branch)
                    .pull('origin', componentConfig.branch)
                    .cwd('../../')
                    .catch(e => {
                    console.error(e);
                    throw new Error(e);
                });
            }
        }
        return 'OK';
    }
}
exports.ComponentSynchronizer = ComponentSynchronizer;
_a = JSII_RTTI_SYMBOL_1;
ComponentSynchronizer[_a] = { fqn: "halloumi-ami-pipelines.ComponentSynchronizer", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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