
from __future__ import print_function

import boto3
import botocore
import json

import urllib3
import json

SUCCESS = "SUCCESS"
FAILED = "FAILED"

http = urllib3.PoolManager()


ib_client = boto3.client('imagebuilder')

def handler(event, context):
    print("Received event: " + json.dumps(event, indent=2))
    
    request_type = event['RequestType']
    props = event['ResourceProperties']

    component_name = props['ComponentName']

    if request_type == 'Create' or request_type == 'Update':
    
        if request_type == 'Update':
            physicalResourceId = event["PhysicalResourceId"]
        else:
            physicalResourceId = None
            
        try:
            found_component = False
            next_token = None

            while not found_component:
                
                if next_token:
                    response = ib_client.list_components(
                        owner='Self',
                        filters=[
                            {
                                'name': 'name',
                                'values': [
                                    component_name,
                                ]
                            },
                        ],
                        maxResults=25,
                        nextToken=next_token
                    )
                else:
                    response = ib_client.list_components(
                        owner='Self',
                        filters=[
                            {
                                'name': 'name',
                                'values': [
                                    component_name,
                                ]
                            },
                        ],
                        maxResults=25
                    )
                
                if 'componentVersionList' in response and len(response['componentVersionList']) > 0:
                    found_component = True
                    component_version = response['componentVersionList'][0]['version']
                    
                    print("Component version: " + component_version)
                    
                    next_version = bump(component_version)
                    return create_response({
                        'ImageRecipeArn': response['componentVersionList'][0]['arn'],
                        'Version': component_version,
                        'NextVersion': next_version
                    }, physicalResourceId)
                else:
                    if response.get('nextToken'):
                        next_token = response['nextToken']
                    else:
                        return create_response({ 'NextVersion': '1.0.0' }, physicalResourceId)
            
        except botocore.exceptions.ClientError as err:
            raise err
    elif request_type == 'Delete': return create_response({}, event["PhysicalResourceId"])

    raise Exception("Invalid request type: %s" % request_type)

def bump(version):
    split_version = version.split('.')
    return f'{split_version[0]}.{split_version[1]}.{int(split_version[2]) + 1}'

def create_response(responseData, physicalResourceId=None):

    return {
        'PhysicalResourceId' : physicalResourceId,
        'Data' : responseData
    }

