# Migrate an instance

```{warning}

Currently only supports users with registered schema modules, [contact us](https://lamin.ai/contact) if you are interested!
```

## CI-guided workflow (Postgres)

1. Create a new branch (e.g. `migration`) in your schema module repository.
2. On your `migration` branch, modify the sqlmodel code (typically located in `{package_name/_core.py}`) to reflect the desired changes of the schema.

````{admonition} Example: rename a column
Let's try to rename the `v` column to `version` in `Notebook` table of `lnschema_core`.

In the `lnschema_core/_core.py` `Notebook` class, modify line:

```{code-block} python
---
emphasize-lines: 1, 3
---
v: str = Field(default="1", primary_key=True)
to:
version: str = Field(default="1", primary_key=True)
````

3. On the command line (at the root of the repository), run `lndb migrate generate` to generate an empty script file under `{package_name}/migrations/versions/`.

````{admonition} Example: migration directory
The script will be named as `{date}-{revision}-vx_x_x.py`.

Located:

```{code-block} yaml
---
emphasize-lines: 5
---
-- lnschema_core
   |-- dev
   |-- migrations
   |   |-- versions
   |       |-- 2023-02-16-dd2b4a9499f2-vx_x_x.py
   |-- __init__.py
   |-- _core.py
````

````{admonition} Example: empty migration script
You will notice that script or `upgrade` and `downgrade` are empty.

```{code-block} python
---
emphasize-lines: 10
---
"""vX.X.X."""
from alembic import op
import sqlalchemy as sa  # noqa
import sqlmodel as sqm # noqa

revision = 'dd2b4a9499f2'
down_revision = '8280855a5064'


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
````

4. Populate `_migration` with revision in the `{package_name}/__init__.py` file:

```{admonition} Example: updated _migration with revision
`_migration = "dd2b4a9499f2"`.
```

5. Commit the changes and push the `migration` branch to remote.

6. Create a Pull Request from the `migration` branch, and inspect CI step Build output.

7. CI will fail and prints out the migration code to be added to the migration script file.

````{admonition} Example: CI output

```{code-block} python
# ### commands auto generated by Alembic - please adjust! ###
op.alter_column("notebook", column_name="v", new_column_name="version", schema="core")
# ### end Alembic commands ###
````

8. Copy the migration script to the side the `update` function in `{date}-{revision}-vx_x_x.py` file.

````{admonition} Example: modified migration script

```{code-block} python
def upgrade() -> None:
    op.alter_column("notebook", column_name="v", new_column_name="version", schema="core")
````

9. Commit & push changes.

10. Now CI should pass and you have created a successful migration! 🎉

11. Merge PR and make a release with a new version_id.

```{admonition} Example: new release
Let's make a new release called `1.0.0`:

1. Modify `__version__` in the `__init__.py` file: `__version__ = "1.0.0"`
2. Modify the migration script file name to: `2023-02-16-dd2b4a9499f2-v1_0_0.py`
3. Modify the first line of the migration script file from `"""vX.X.X."""` to `"""v1.0.0."""`
```

**Next time you load your instance, you will be asked to deploy the migration!**

```{note}

`lndb` leverages [alembic](https://alembic.sqlalchemy.org/en/latest/).
```
