# Обработка сканов машинно-читаемых документов МИС

Принцип работы приложения:

- По заданному пути производится поиск PDF файлов.
- Просматривается каждый файл PDF документа, производится поиск ШК
- Если найден ШК и он соответствует маске, то производится сборка документа по последующим страницам с таким же ШК
- Собранный документ с указанным типом подгружается в МКАБ
- Журнал выполнения сохраняется в папке logs по пути исходных документов
- Если были ошибки разбора, то файл перемещается в папку UNPROCESSED по пути исходных документов

Инструкция по генерации ШК в шаблонах документов ТМ:МИС находится на [портале технической документации](https://wiki.mnogomed.ru/man/tm-mis.html#машинно-читаемые-документы)

## Установка

Для работы приложения необходимы следующие зависимости:

- Python 3.7 и выше
- [Microsoft ODBC Driver for SQL Server](https://docs.microsoft.com/sql/connect/odbc/linux-mac/installing-the-microsoft-odbc-driver-for-sql-server)
- Заголовочные файлы ODBC (пакет `unixodbc-dev` на Debian-based дистрибутивах)
- Библиотека распознавания штрих-кодов [ZBar](http://zbar.sourceforge.net/) (пакет `libzbar0` на Debian-based дистрибутивах)
- Библиотека для рендеринга PDF-файлов [Poppler](https://poppler.freedesktop.org/) (пакет `poppler-utils` на Debian-based дистрибутивах)

Программа автоматически устанавливается в систему:

```bash
git clone https://github.com/mnogomed/mis-scan-handler
cd mis-scan-handler
python3 setup.py install
```

## Использование

Для просмотра всех ключей запуска и наименований используемых переменных окружения используйте ключ `--help`:

```bash
mis-scan-handler --help
```

Программа принимает единственный обязательный аргумент - путь, по которому будет производиться разбор отсканированных документов, например:

```bash
mis-scan-handler /var/lib/samba/public/ADULT
```

## Настройка

Настройки приложения осуществляются либо из переменных окружения, либо при помощи ключей запуска, причём приоритет имеют последние.

| Переменная окружения     | Ключ запуска           | Обязательно? | Значение по умолчанию | Описание                                                             |
| ------------------------ | ---------------------- | ------------ | --------------------- | -------------------------------------------------------------------- |
| `MHS_UNPROCESSED_FOLDER` | `--unprocessed-folder` | Нет          | `UNPROCESSED`         | Наименование папки, куда перемещаются документы с ошибками обработки |
| `MSH_CREATE_USER_ID`     | `--create-user-id`     | Нет          | `1`                   | Идентификатор пользователя, прикрепившего файл                       |
| `MSH_CREATE_USER_NAME`   | `--create-user-name`   | Нет          | `Администратор`       | ФИО пользователя, прикрепившего файл                                 |
| `MIS_DB_SERVER`          | `--mis-db-server`      | Да           |                       | Адрес сервера СУБД МИС                                               |
| `MIS_DB_PORT`            | `--mis-db-port`        | Нет          | `1433`                | Порт сервера СУБД МИС                                                |
| `MIS_DB_NAME`            | `--mis-db-name`        | Да           |                       | Наименование БД МИС                                                  |
| `MIS_DB_USERNAME`        | `--mis-db-username`    | Нет          | `sa`                  | Имя пользователя для подключения к БД МИС                            |
| `MIS_DB_PASSWORD`        | `--mis-db-password`    | Да           |                       | Пароль пользователя для подключения к БД МИС                         |
| `MIS_FILE_PATH`          | `--mis-file-path`      | Да           |                       | Путь до хранилища прикреплённых файлов МИС                           |
| `ROTATE_ANGLE`           | `--rotate-angle`       | Нет          | `5`                   | Угол поворота страницы при попытке распознавания                     |
| `ROTATE_COUNT`           | `--rotate-count`       | Нет          | `7`                   | Количество итераций попыток распознавания ШК поворотом страницы      |

При создании задания cron необходимо убедиться, что корректно определена переменная окружения `PATH`. 
Если вы определяете настройки приложения в файле `~/.profile`, то crontab может выглядеть следующим образом:
```
PATH=/bin:/usr/bin:/usr/local/bin

* * * * * . ~/.profile; mis-scan-handler /var/lib/samba/public/ADULT/__TEST
```
