/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.BitwuzlaSolverInfo;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J5\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lsolver/BitwuzlaSolverInfo;", "Lsolver/SolverInfo;", "()V", "defaultCommand", "", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "customSolverExecutable", "timeout", "Ljava/time/Duration;", "incrementalMode", "", "getDefaultConfigs", "Lsolver/SolverConfig;", "memlimitBytes", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "(Ljava/time/Duration;Ljava/lang/Long;ZLsolver/SolverConfig$LogicFeatures;)Ljava/util/List;", "getProcessTimeoutString", "getQueryTimeoutString", "preprocessCheckSatOutput", "lines", "supportsLogicFeatures", "features", "GeneralUtils"})
public final class BitwuzlaSolverInfo
extends SolverInfo {
    @NotNull
    public static final BitwuzlaSolverInfo INSTANCE = new BitwuzlaSolverInfo();

    private BitwuzlaSolverInfo() {
        super("Bitwuzla");
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return "bitwuzla";
    }

    @Override
    @NotNull
    public List<String> getProcessTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf(Intrinsics.stringPlus("--time=", timeout.toSeconds()));
    }

    @Override
    @NotNull
    public List<String> getQueryTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return this.getProcessTimeoutString(timeout);
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        if (features.getUsesDatatypes()) {
            return false;
        }
        SolverConfig.ArithmeticOperations[] arithmeticOperationsArray = new SolverConfig.ArithmeticOperations[]{SolverConfig.ArithmeticOperations.NonLinear, SolverConfig.ArithmeticOperations.LinearOnly};
        return !SetsKt.setOf(arithmeticOperationsArray).contains((Object)features.getArithmeticOperations());
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@Nullable String customSolverExecutable, @Nullable Duration timeout, boolean incrementalMode) {
        List<String> list2;
        String string2 = customSolverExecutable;
        String[] stringArray = new String[]{string2 == null ? this.getDefaultCommand() : string2, "--smt2", "--output-number-format=hex", incrementalMode ? "--incremental" : null};
        Collection collection = CollectionsKt.listOfNotNull(stringArray);
        if (timeout != null) {
            list2 = this.getQueryTimeoutString(timeout);
        } else {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection, (Iterable)list2);
    }

    @Override
    @NotNull
    public List<SolverConfig> getDefaultConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode, @NotNull SolverConfig.LogicFeatures logicFeatures) {
        List<SolverConfig> list2;
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
        if (logicFeatures.getArithmeticOperations() == SolverConfig.ArithmeticOperations.BitVector && !logicFeatures.getUsesDatatypes()) {
            boolean bl = false;
            list2 = CollectionsKt.listOf(new SolverConfig(this, timeout, memlimitBytes, incrementalMode, CollectionsKt.emptyList(), null, null, null, 224, null));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @NotNull
    public List<String> preprocessCheckSatOutput(@NotNull List<String> lines) {
        List<String> list2;
        String it;
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter(lines, "lines");
            Iterable $this$any$iv = lines;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default(it, "[bitwuzla>main] ALARM TRIGGERED: time limit ", false, 2, null)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            boolean bl3;
            block10: {
                Iterable $this$all$iv = lines;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (String)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(it, "unknown")) continue;
                        bl3 = false;
                        break block10;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                SolverInfo.Companion.getLogger().warn(preprocessCheckSatOutput.3.INSTANCE);
            }
            list2 = CollectionsKt.listOf("timeout");
        } else {
            list2 = super.preprocessCheckSatOutput(lines);
        }
        return list2;
    }
}

