/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.util.Arrays;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.random.NormalizedRandomGenerator;
import org.apache.commons.math3.random.RandomVectorGenerator;

public class UncorrelatedRandomVectorGenerator
implements RandomVectorGenerator {
    private final NormalizedRandomGenerator generator;
    private final double[] mean;
    private final double[] standardDeviation;

    public UncorrelatedRandomVectorGenerator(double[] mean2, double[] standardDeviation2, NormalizedRandomGenerator generator) {
        if (mean2.length != standardDeviation2.length) {
            throw new DimensionMismatchException(mean2.length, standardDeviation2.length);
        }
        this.mean = (double[])mean2.clone();
        this.standardDeviation = (double[])standardDeviation2.clone();
        this.generator = generator;
    }

    public UncorrelatedRandomVectorGenerator(int dimension, NormalizedRandomGenerator generator) {
        this.mean = new double[dimension];
        this.standardDeviation = new double[dimension];
        Arrays.fill(this.standardDeviation, 1.0);
        this.generator = generator;
    }

    public double[] nextVector() {
        double[] random2 = new double[this.mean.length];
        for (int i = 0; i < random2.length; ++i) {
            random2[i] = this.mean[i] + this.standardDeviation[i] * this.generator.nextNormalizedDouble();
        }
        return random2;
    }
}

