"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Plugin = exports.PluginProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const apigateway_generated_1 = require("./apigateway.generated");
Object.defineProperty(exports, "PluginProperty", { enumerable: true, get: function () { return apigateway_generated_1.RosPlugin; } });
/**
 * A ROS resource type:  `ALIYUN::ApiGateway::Plugin`
 */
class Plugin extends ros.Resource {
    /**
     * Create a new `ALIYUN::ApiGateway::Plugin`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPlugin = new apigateway_generated_1.RosPlugin(this, id, {
            pluginName: props.pluginName,
            description: props.description,
            pluginData: props.pluginData,
            pluginType: props.pluginType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPlugin;
        this.attrDescription = rosPlugin.attrDescription;
        this.attrPluginData = rosPlugin.attrPluginData;
        this.attrPluginId = rosPlugin.attrPluginId;
        this.attrPluginName = rosPlugin.attrPluginName;
        this.attrPluginType = rosPlugin.attrPluginType;
    }
}
exports.Plugin = Plugin;
//# sourceMappingURL=data:application/json;base64,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