"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LifecycleLabel = exports.renderBottlerocketUserData = exports.renderAmazonLinuxUserData = void 0;
const core_1 = require("@aws-cdk/core");
// eslint-disable-next-line max-len
function renderAmazonLinuxUserData(clusterName, autoScalingGroup, options = {}) {
    var _a;
    const stack = core_1.Stack.of(autoScalingGroup);
    // determine logical id of ASG so we can signal cloudformation
    const cfn = autoScalingGroup.node.defaultChild;
    const asgLogicalId = cfn.logicalId;
    const extraArgs = new Array();
    extraArgs.push(`--use-max-pods ${(_a = options.useMaxPods) !== null && _a !== void 0 ? _a : true}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge true');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    const lifecycleLabel = autoScalingGroup.spotPrice ? LifecycleLabel.SPOT : LifecycleLabel.ON_DEMAND;
    const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${asgLogicalId} --region ${stack.region}`,
    ];
}
exports.renderAmazonLinuxUserData = renderAmazonLinuxUserData;
function renderBottlerocketUserData(cluster) {
    return [
        '[settings.kubernetes]',
        `api-server="${cluster.clusterEndpoint}"`,
        `cluster-certificate="${cluster.clusterCertificateAuthorityData}"`,
        `cluster-name="${cluster.clusterName}"`,
    ];
}
exports.renderBottlerocketUserData = renderBottlerocketUserData;
/**
 * The lifecycle label for node selector
 */
var LifecycleLabel;
(function (LifecycleLabel) {
    /**
     * on-demand instances
     */
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    /**
     * spot instances
     */
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
//# sourceMappingURL=data:application/json;base64,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