import { Construct } from 'constructs';
import { ICluster } from './cluster';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Properties for KubernetesPatch.
 *
 * @stability stable
 */
export interface KubernetesPatchProps {
    /**
     * The cluster to apply the patch to.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @stability stable
     */
    readonly cluster: ICluster;
    /**
     * The JSON object to pass to `kubectl patch` when the resource is created/updated.
     *
     * @stability stable
     */
    readonly applyPatch: {
        [key: string]: any;
    };
    /**
     * The JSON object to pass to `kubectl patch` when the resource is removed.
     *
     * @stability stable
     */
    readonly restorePatch: {
        [key: string]: any;
    };
    /**
     * The full name of the resource to patch (e.g. `deployment/coredns`).
     *
     * @stability stable
     */
    readonly resourceName: string;
    /**
     * The kubernetes API namespace.
     *
     * @default "default"
     * @stability stable
     */
    readonly resourceNamespace?: string;
    /**
     * The patch type to pass to `kubectl patch`.
     *
     * The default type used by `kubectl patch` is "strategic".
     *
     * @default PatchType.STRATEGIC
     * @stability stable
     */
    readonly patchType?: PatchType;
}
/**
 * Values for `kubectl patch` --type argument.
 *
 * @stability stable
 */
export declare enum PatchType {
    /**
     * JSON Patch, RFC 6902.
     *
     * @stability stable
     */
    JSON = "json",
    /**
     * JSON Merge patch.
     *
     * @stability stable
     */
    MERGE = "merge",
    /**
     * Strategic merge patch.
     *
     * @stability stable
     */
    STRATEGIC = "strategic"
}
/**
 * A CloudFormation resource which applies/restores a JSON patch into a Kubernetes resource.
 *
 * @see https://kubernetes.io/docs/tasks/run-application/update-api-object-kubectl-patch/
 * @stability stable
 */
export declare class KubernetesPatch extends CoreConstruct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: KubernetesPatchProps);
}
