#!/usr/bin/env python3
# Part of code implemented from predictmz.py with approval of Andy Ohlin
import re
import numpy as np


pt = {
    'Ag': [107.0, [0.5184000000000001, 0, 0.4816]],
    'Al': [27.0, [1.0]],
    'Ar': [36.0, [0.0034000000000000002, 0, 0.00063, 0, 0, 0.996]],
    'As': [75.0, [1.0]],
    'Au': [197.0, [1.0]],
    'B': [10.0, [0.198, 0.802]],
    'Ba': [130.0, [0.0011, 0, 0.001, 0, 0, 0.0242, 0, 0, 0.0659, 0, 0, 0.0785,
                   0, 0, 0.1123, 0, 0, 0.717]],
    'Be': [9.0, [1.0]],
    'Bi': [209.0, [1.0]],
    'Br': [79.0, [0.5069, 0, 0.4931]],
    'C': [12.0, [0.989, 0.011]],
    'Ca': [40.0, [0.9695, 0, 0.0065, 0, 0.0014, 0,
                  0.02086, 0, 0, 4e-05, 0, 0, 0, 0.0019]],
    'Cd': [106.0, [0.0125, 0, 0.0089, 0, 0, 0.1249, 0, 0, 0.128, 0, 0, 0.2413,
                   0, 0, 0.1222, 0, 0, 0.2873, 0, 0, 0, 0.0749]],
    'Ce': [136.0, [0.0019, 0, 0.0025, 0, 0, 0.8848, 0, 0, 0, 0.1108]],
    'Cl': [35.0, [0.7577, 0, 0.2423]],
    'Co': [59.0, [1.0]],
    'Cr': [50.0, [0.0435, 0, 0.8379, 0, 0.095, 0, 0.0236]],
    'Cs': [133.0, [1.0]],
    'Cu': [63.0, [0.6917, 0, 0.3083]],
    'Dy': [156.0, [0.0006, 0, 0.001, 0, 0, 0.0234, 0, 0,
                   0.189, 0, 0, 0.255, 0, 0, 0.249, 0, 0, 0.282]],
    'Er': [162.0, [0.0014, 0, 0.0161, 0, 0, 0.336, 0, 0, 0.2295, 0, 0, 0.268,
                   0, 0, 0, 0.149]],
    'Eu': [151.0, [0.478, 0, 0.522]],
    'F': [19.0, [1.0]],
    'Fe': [54.0, [0.058, 0, 0.9172, 0, 0.022, 0, 0.0028]],
    'Ga': [69.0, [0.601, 0, 0.399]],
    'Gd': [152.0, [0.002, 0, 0.0218, 0, 0.148, 0, 0.2047, 0, 0.1565, 0, 0.2484,
                   0, 0, 0.2186]],
    'Ge': [70.0, [0.205, 0, 0.274, 0, 0.078, 0, 0.365, 0, 0, 0.078]],
    'H': [1.0, [0.99985, 0.00015]],
    'He': [3.0, [1e-06, 1.0]],
    'Hf': [174.0, [0.0016, 0, 0.052, 0, 0.186, 0, 0.271, 0, 0.1374, 0, 0.352]],
    'Hg': [196.0, [0.0015, 0, 0.101, 0, 0.17, 0, 0.231, 0, 0.132, 0, 0.2965, 0,
                   0, 0.068]],
    'Ho': [165.0, [1.0]],
    'I': [127.0, [1.0]],
    'In': [113.0, [0.043, 0, 0.957]],
    'Ir': [191.0, [0.373, 0, 0.627]],
    'K': [39.0, [0.932, 0.00012, 0.0673]],
    'Kr': [78.0, [0.0035, 0, 0.0225, 0, 0, 0.116, 0, 0, 0.115, 0, 0, 0.57, 0,
                  0, 0, 0.173]],
    'La': [138.0, [0.0009, 0.9991]],
    'Li': [6.0, [0.0742, 0.9258]],
    'Lu': [175.0, [0.974, 0.026]],
    'Mg': [24.0, [0.789, 0.1, 0.111]],
    'Mn': [55.0, [1.0]],
    'Mo': [92.0, [0.1484, 0, 0.0925, 0, 0.1592, 0, 0.1668, 0, 0.0955, 0,
                  0.2413, 0, 0, 0.0963]],
    'N': [14.0, [0.9963, 0.0037]],
    'Na': [23.0, [1.0]],
    'Nb': [93.0, [1.0]],
    'Nd': [142.0, [0.2713, 0.1218, 0.238, 0.083, 0.1719, 0, 0.0576, 0, 0,
                   0.0564]],
    'Ne': [20.0, [0.906, 0.0026, 0.092]],
    'Ni': [58.0, [0.6827, 0, 0.261, 0, 0.0113, 0, 0.0359, 0, 0, 0.0091]],
    'O': [16.0, [0.9976, 0.00038, 0.002]],
    'Os': [184.0, [0.0002, 0, 0.0158, 0, 0.016, 0, 0.133, 0, 0.161, 0, 0.264,
                   0, 0, 0.41]],
    'P': [31.0, [1.0]],
    'Pb': [204.0, [0.014, 0, 0.241, 0, 0.221, 0, 0.524]],
    'Pd': [102.0, [0.0102, 0, 0.1114, 0, 0.2233, 0, 0.2733, 0, 0, 0.2646, 0, 0,
                   0, 0.1172]],
    'Pr': [141.0, [1.0]],
    'Pt': [190.0, [0.0001, 0, 0.0079, 0, 0, 0.329, 0, 0, 0.338, 0, 0, 0.253, 0,
                   0, 0, 0.072]],
    'Rb': [85.0, [0.7217, 0, 0.2784]],
    'Re': [185.0, [0.374, 0, 0.626]],
    'Rh': [103.0, [1.0]],
    'Ru': [96.0, [0.0552, 0, 0.0188, 0, 0.127, 0, 0.126, 0, 0.17, 0, 0.316, 0,
                  0, 0.187]],
    'S': [32.0, [0.9502, 0.0075, 0.0421, 0, 0.0002]],
    'Sb': [121.0, [0.573, 0, 0.427]],
    'Sc': [45.0, [1.0]],
    'Se': [74.0, [0.009, 0, 0.09, 0, 0.076, 0, 0.235, 0, 0, 0.496, 0, 0, 0,
                  0.094]],
    'Si': [28.0, [0.9223, 0.0467, 0.031]],
    'Sm': [144.0, [0.031, 0, 0, 0.15, 0, 0, 0.113, 0, 0, 0.138, 0, 0, 0.074, 0,
                   0, 0, 0.267, 0, 0, 0, 0, 0.227]],
    'Sn': [112.0, [0.0097, 0, 0.0065, 0, 0.0036, 0, 0.147, 0, 0.077, 0, 0.243,
                   0, 0.086, 0, 0.324, 0, 0, 0.046, 0, 0, 0, 0.056]],
    'Sr': [84.0, [0.0056, 0, 0.0986, 0, 0.07, 0, 0.8258]],
    'Ta': [180.0, [0.00012, 0.9999]],
    'Tb': [159.0, [1.0]],
    'Te': [120.0, [0.00096, 0, 0.026, 0, 0.0091, 0, 0.0482, 0, 0.0714, 0,
                   0.1895, 0, 0, 0.3169, 0, 0, 0, 0.338]],
    'Th': [232.0, [1.0]],
    'Ti': [46.0, [0.08, 0.073, 0.738, 0.055, 0.054]],
    'Tl': [203.0, [0.2952, 0, 0.7048]],
    'Tm': [169.0, [1.0]],
    'U': [234.0, [6e-05, 0.0072, 0, 0, 0.9927]],
    'V': [50.0, [0.0025, 0.9975]],
    'W': [180.0, [0.0013, 0, 0.263, 0, 0.143, 0, 0.3067, 0, 0, 0.286]],
    'Xe': [124.0, [0.001, 0, 0.0009, 0, 0, 0.0191, 0, 0, 0.264, 0, 0, 0.041, 0,
                   0, 0.212, 0, 0, 0.269, 0, 0, 0, 0.104, 0, 0, 0, 0, 0.089]],
    'Y': [89.0, [1.0]],
    'Yb': [168.0, [0.0013, 0, 0.0305, 0, 0.143, 0, 0.219, 0, 0.1612, 0, 0.318,
                   0, 0, 0.127]],
    'Zn': [64.0, [0.486, 0, 0.279, 0, 0.041, 0, 0.188, 0, 0, 0.006]],
    'Zr': [90.0, [0.5145, 0.1127, 0.1717, 0, 0.1733, 0, 0, 0.0278]],
}


def formulaExpander(formula):
    while len(re.findall("\(\w*\)", formula)) > 0:
        parenthetical = re.findall("\(\w*\)[0-9]+", formula)
        for i in parenthetical:
            p = re.findall("[0-9]+", str(re.findall("\)[0-9]+", i)))
            j = re.findall("[A-Z][a-z]*[0-9]*", i)
            for n in range(0, len(j)):
                numero = re.findall("[0-9]+", j[n])
                if len(numero) != 0:
                    for k in numero:
                        nu = re.sub(k, str(int(int(k)*int(p[0]))), j[n])
                else:
                    nu = re.sub(j[n], j[n]+p[0], j[n])
                j[n] = nu
            newphrase = ""
            for m in j:
                newphrase += str(m)
            formula = formula.replace(i, newphrase)
        if (len((re.findall("\(\w*\)[0-9]+", formula))) == 0) and (
                len(re.findall("\(\w*\)", formula)) != 0):
            formula = formula.replace('(', '')
            formula = formula.replace(')', '')
    lopoff = re.findall('[A-Z][a-z]*0', formula)
    if lopoff != []:
        formula = formula.replace(lopoff[0], '')
    formula = re.findall(r'([A-Z][a-z]*)([0-9]*)', formula)
    return formula


def predict(text):
    rawform = formulaExpander(text)
    form = []
    for element in rawform:
        if element[0] in pt.keys():
            if element[1] != "":
                form += ([element[0]] * int(element[1]))
            else:
                form += ([element[0]])
        else:
            # TODO: Solve how to proceed
            print("warning, element {} does not exist".format(element[0]))
    pattern = [1]
    smass = 0
    for atom in form:
        pattern = np.convolve(pattern, pt[atom][1])
        smass += pt[atom][0]
    pattern = pattern/np.amax(pattern)
    return smass, pattern
