import java.awt
import java.io
import java.lang
import javax.xml.transform.stream
import jpype.protocol
import bioformats_jar._ome.xml.model
import bioformats_jar._ome.xml.model.enums
import org.w3c.dom
import org.w3c.dom.ls
import typing



class OmeValidator:
    JAXP_SCHEMA_LANGUAGE: typing.ClassVar[java.lang.String] = ...
    W3C_XML_SCHEMA: typing.ClassVar[java.lang.String] = ...
    JAXP_SCHEMA_SOURCE: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def isValidFile(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], file2: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> bool: ...
    @typing.overload
    def isValidFile(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], streamSourceArray: typing.List[javax.xml.transform.stream.StreamSource]) -> bool: ...
    @typing.overload
    def parseFile(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> org.w3c.dom.Document: ...
    @typing.overload
    def parseFile(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], file2: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> org.w3c.dom.Document: ...
    def parseFileWithStreamArray(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], streamSourceArray: typing.List[javax.xml.transform.stream.StreamSource]) -> org.w3c.dom.Document: ...
    def parseFileWithStreamArrayToSdtErr(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], streamSourceArray: typing.List[javax.xml.transform.stream.StreamSource]) -> org.w3c.dom.Document: ...
    @typing.overload
    def validateFile(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], file2: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    def validateFile(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], streamSourceArray: typing.List[javax.xml.transform.stream.StreamSource]) -> None: ...
    def validateFileToStdError(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], streamSourceArray: typing.List[javax.xml.transform.stream.StreamSource]) -> None: ...

class SchemaResolver(org.w3c.dom.ls.LSResourceResolver):
    def __init__(self): ...
    def resolveResource(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], string4: typing.Union[java.lang.String, str], string5: typing.Union[java.lang.String, str]) -> org.w3c.dom.ls.LSInput: ...

class XMLMockObjects:
    DEFAULT_COLOR: typing.ClassVar[java.awt.Color] = ...
    LIGHTSOURCE_POWER: typing.ClassVar[float] = ...
    COMPONENT_MODEL: typing.ClassVar[java.lang.String] = ...
    COMPONENT_MANUFACTURER: typing.ClassVar[java.lang.String] = ...
    COMPONENT_SERIAL_NUMBER: typing.ClassVar[java.lang.String] = ...
    COMPONENT_LOT_NUMBER: typing.ClassVar[java.lang.String] = ...
    LASER_TYPE: typing.ClassVar[bioformats_jar._ome.xml.model.enums.LaserType] = ...
    ARC_TYPE: typing.ClassVar[bioformats_jar._ome.xml.model.enums.ArcType] = ...
    FILAMENT_TYPE: typing.ClassVar[bioformats_jar._ome.xml.model.enums.FilamentType] = ...
    DETECTOR_TYPE: typing.ClassVar[bioformats_jar._ome.xml.model.enums.DetectorType] = ...
    CORRECTION: typing.ClassVar[bioformats_jar._ome.xml.model.enums.Correction] = ...
    IMMERSION: typing.ClassVar[bioformats_jar._ome.xml.model.enums.Immersion] = ...
    FILTER_TYPE: typing.ClassVar[bioformats_jar._ome.xml.model.enums.FilterType] = ...
    MICROSCOPE_TYPE: typing.ClassVar[bioformats_jar._ome.xml.model.enums.MicroscopeType] = ...
    EXPERIMENT_TYPE: typing.ClassVar[bioformats_jar._ome.xml.model.enums.ExperimentType] = ...
    MICROBEAM_MANIPULATION_TYPE: typing.ClassVar[bioformats_jar._ome.xml.model.enums.MicrobeamManipulationType] = ...
    BINNING: typing.ClassVar[bioformats_jar._ome.xml.model.enums.Binning] = ...
    MEDIUM: typing.ClassVar[bioformats_jar._ome.xml.model.enums.Medium] = ...
    LASER_MEDIUM: typing.ClassVar[bioformats_jar._ome.xml.model.enums.LaserMedium] = ...
    SIZE_X: typing.ClassVar[int] = ...
    SIZE_Y: typing.ClassVar[int] = ...
    SIZE_Z: typing.ClassVar[int] = ...
    SIZE_C: typing.ClassVar[int] = ...
    SIZE_T: typing.ClassVar[int] = ...
    BYTES_PER_PIXEL: typing.ClassVar[int] = ...
    ROWS: typing.ClassVar[int] = ...
    COLUMNS: typing.ClassVar[int] = ...
    FIELDS: typing.ClassVar[int] = ...
    LIGHT_SOURCES: typing.ClassVar[typing.List[java.lang.String]] = ...
    SHAPES: typing.ClassVar[typing.List[java.lang.String]] = ...
    ANNOTATIONS: typing.ClassVar[typing.List[java.lang.String]] = ...
    ROW_NAMING_CONVENTION: typing.ClassVar[bioformats_jar._ome.xml.model.enums.NamingConvention] = ...
    COLUMN_NAMING_CONVENTION: typing.ClassVar[bioformats_jar._ome.xml.model.enums.NamingConvention] = ...
    DIMENSION_ORDER: typing.ClassVar[bioformats_jar._ome.xml.model.enums.DimensionOrder] = ...
    PIXEL_TYPE: typing.ClassVar[bioformats_jar._ome.xml.model.enums.PixelType] = ...
    NUMBER_OF_DECTECTORS: typing.ClassVar[int] = ...
    NUMBER_OF_OBJECTIVES: typing.ClassVar[int] = ...
    NUMBER_OF_FILTERS: typing.ClassVar[int] = ...
    NUMBER_OF_DICHROICS: typing.ClassVar[int] = ...
    POINTS: typing.ClassVar[java.lang.String] = ...
    TIME: typing.ClassVar[java.lang.String] = ...
    CUT_IN: typing.ClassVar[float] = ...
    CUT_OUT: typing.ClassVar[float] = ...
    def __init__(self): ...
    def createAnnotatedImage(self) -> bioformats_jar._ome.xml.model.OME: ...
    def createAnnotation(self, string: typing.Union[java.lang.String, str], oMEModelObject: bioformats_jar._ome.xml.model.OMEModelObject, int: int) -> bioformats_jar._ome.xml.model.Annotation: ...
    def createBasicPlate(self, int: int) -> bioformats_jar._ome.xml.model.Plate: ...
    def createBasicPlateWithReagent(self) -> bioformats_jar._ome.xml.model.OME: ...
    def createBinData(self, int: int, int2: int, int3: int) -> bioformats_jar._ome.xml.model.BinData: ...
    def createBinaryFile(self) -> bioformats_jar._ome.xml.model.BinaryFile: ...
    def createChannel(self, int: int) -> bioformats_jar._ome.xml.model.Channel: ...
    def createDataset(self, int: int) -> bioformats_jar._ome.xml.model.Dataset: ...
    def createDetector(self, int: int) -> bioformats_jar._ome.xml.model.Detector: ...
    def createDetectorSettings(self, int: int) -> bioformats_jar._ome.xml.model.DetectorSettings: ...
    def createDichroic(self, int: int) -> bioformats_jar._ome.xml.model.Dichroic: ...
    def createExperiment(self, int: int) -> bioformats_jar._ome.xml.model.Experiment: ...
    def createExperimentWithMicrobeam(self, int: int) -> bioformats_jar._ome.xml.model.Experiment: ...
    def createExperimenter(self, int: int) -> bioformats_jar._ome.xml.model.Experimenter: ...
    def createFilter(self, int: int, double: float, double2: float) -> bioformats_jar._ome.xml.model.Filter: ...
    def createFilterSet(self, int: int) -> bioformats_jar._ome.xml.model.FilterSet: ...
    def createFullPopulatedPlate(self, int: int) -> bioformats_jar._ome.xml.model.OME: ...
    @typing.overload
    def createImage(self, int: int) -> bioformats_jar._ome.xml.model.Image: ...
    @typing.overload
    def createImage(self, int: int, boolean: bool) -> bioformats_jar._ome.xml.model.Image: ...
    @typing.overload
    def createImage(self) -> bioformats_jar._ome.xml.model.OME: ...
    @typing.overload
    def createImage(self, boolean: bool) -> bioformats_jar._ome.xml.model.OME: ...
    def createImageEnvironment(self) -> bioformats_jar._ome.xml.model.ImagingEnvironment: ...
    def createImageWithAcquisitionData(self) -> bioformats_jar._ome.xml.model.OME: ...
    def createImageWithAnnotatedAcquisitionData(self) -> bioformats_jar._ome.xml.model.OME: ...
    def createImageWithExperiment(self, int: int, boolean: bool, experiment: bioformats_jar._ome.xml.model.Experiment) -> bioformats_jar._ome.xml.model.Image: ...
    def createImageWithROI(self) -> bioformats_jar._ome.xml.model.OME: ...
    def createInstrument(self, boolean: bool) -> bioformats_jar._ome.xml.model.Instrument: ...
    def createLightPath(self) -> bioformats_jar._ome.xml.model.LightPath: ...
    def createLightSource(self, string: typing.Union[java.lang.String, str], int: int) -> bioformats_jar._ome.xml.model.LightSource: ...
    def createLightSourceSettings(self, int: int) -> bioformats_jar._ome.xml.model.LightSourceSettings: ...
    def createMicrobeamManipulation(self, int: int) -> bioformats_jar._ome.xml.model.MicrobeamManipulation: ...
    def createMicroscope(self) -> bioformats_jar._ome.xml.model.Microscope: ...
    def createObjective(self, int: int) -> bioformats_jar._ome.xml.model.Objective: ...
    def createObjectiveSettings(self, int: int) -> bioformats_jar._ome.xml.model.ObjectiveSettings: ...
    def createPlane(self, int: int, int2: int, int3: int) -> bioformats_jar._ome.xml.model.Plane: ...
    @typing.overload
    def createPlate(self, int: int, int2: int, int3: int) -> bioformats_jar._ome.xml.model.Plate: ...
    @typing.overload
    def createPlate(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> bioformats_jar._ome.xml.model.Plate: ...
    @typing.overload
    def createPlate(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, boolean: bool) -> bioformats_jar._ome.xml.model.Plate: ...
    @typing.overload
    def createPlate(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int) -> bioformats_jar._ome.xml.model.Plate: ...
    @typing.overload
    def createPlate(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, boolean: bool) -> bioformats_jar._ome.xml.model.Plate: ...
    @typing.overload
    def createPopulatedPlate(self, int: int) -> bioformats_jar._ome.xml.model.OME: ...
    @typing.overload
    def createPopulatedPlate(self, int: int, int2: int) -> bioformats_jar._ome.xml.model.OME: ...
    @typing.overload
    def createPopulatedPlate(self, int: int, int2: int, int3: int, int4: int, int5: int) -> bioformats_jar._ome.xml.model.OME: ...
    @typing.overload
    def createPopulatedPlate(self, int: int, int2: int, int3: int, int4: int, int5: int, boolean: bool) -> bioformats_jar._ome.xml.model.OME: ...
    @typing.overload
    def createPopulatedScreen(self) -> bioformats_jar._ome.xml.model.OME: ...
    @typing.overload
    def createPopulatedScreen(self, int: int, int2: int, int3: int, int4: int, int5: int) -> bioformats_jar._ome.xml.model.OME: ...
    @typing.overload
    def createPopulatedScreen(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> bioformats_jar._ome.xml.model.OME: ...
    @typing.overload
    def createPopulatedScreen(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, boolean: bool) -> bioformats_jar._ome.xml.model.OME: ...
    def createProject(self, int: int) -> bioformats_jar._ome.xml.model.Project: ...
    def createROI(self, int: int, int2: int, int3: int, int4: int) -> bioformats_jar._ome.xml.model.ROI: ...
    def createReagent(self, int: int) -> bioformats_jar._ome.xml.model.Reagent: ...
    def createScreen(self, int: int) -> bioformats_jar._ome.xml.model.Screen: ...
    def createShape(self, int: int, string: typing.Union[java.lang.String, str], int2: int, int3: int, int4: int) -> bioformats_jar._ome.xml.model.Shape: ...
    def createStageLabel(self) -> bioformats_jar._ome.xml.model.StageLabel: ...
    def getRoot(self) -> bioformats_jar._ome.xml.model.OME: ...

class XMLWriter:
    ID_ATTRIBUTE: typing.ClassVar[java.lang.String] = ...
    NAME_ATTRIBUTE: typing.ClassVar[java.lang.String] = ...
    DIMENSION_ORDER_ATTRIBUTE: typing.ClassVar[java.lang.String] = ...
    PIXELS_TYPE_ATTRIBUTE: typing.ClassVar[java.lang.String] = ...
    SIZE_C_ATTRIBUTE: typing.ClassVar[java.lang.String] = ...
    SIZE_T_ATTRIBUTE: typing.ClassVar[java.lang.String] = ...
    SIZE_Z_ATTRIBUTE: typing.ClassVar[java.lang.String] = ...
    SIZE_X_ATTRIBUTE: typing.ClassVar[java.lang.String] = ...
    SIZE_Y_ATTRIBUTE: typing.ClassVar[java.lang.String] = ...
    COMPRESSION_ATTRIBUTE: typing.ClassVar[java.lang.String] = ...
    BIG_ENDIAN_ATTRIBUTE: typing.ClassVar[java.lang.String] = ...
    LENGTH_ATTRIBUTE: typing.ClassVar[java.lang.String] = ...
    OME_TAG: typing.ClassVar[java.lang.String] = ...
    IMAGE_TAG: typing.ClassVar[java.lang.String] = ...
    PIXELS_TAG: typing.ClassVar[java.lang.String] = ...
    BIN_DATA_TAG: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    @typing.overload
    def writeFile(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], oME: bioformats_jar._ome.xml.model.OME) -> None: ...
    @typing.overload
    def writeFile(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], oME: bioformats_jar._ome.xml.model.OME, boolean: bool) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("ome.specification")``.

    OmeValidator: typing.Type[OmeValidator]
    SchemaResolver: typing.Type[SchemaResolver]
    XMLMockObjects: typing.Type[XMLMockObjects]
    XMLWriter: typing.Type[XMLWriter]
