import java.io
import java.util
import bioformats_jar._loci
import bioformats_jar._loci.common
import bioformats_jar._loci.poi.poifs.filesystem
import bioformats_jar._loci.poi.poifs.property
import typing



class BlockAllocationTableReader:
    def __init__(self, int: int, intArray: typing.List[int], int3: int, int4: int, blockList: 'BlockList', int5: int): ...

class BlockList:
    def fetchBlocks(self, int: int) -> typing.List['ListManagedBlock']: ...
    def remove(self, int: int) -> 'ListManagedBlock': ...
    def setBAT(self, blockAllocationTableReader: BlockAllocationTableReader) -> None: ...
    def zap(self, int: int) -> None: ...

class BlockWritable:
    def writeBlocks(self, outputStream: java.io.OutputStream) -> None: ...

class HeaderBlockConstants:
    _signature: typing.ClassVar[int] = ...
    _bat_array_offset: typing.ClassVar[int] = ...
    _signature_offset: typing.ClassVar[int] = ...
    _bat_count_offset: typing.ClassVar[int] = ...
    _property_start_offset: typing.ClassVar[int] = ...
    _sbat_start_offset: typing.ClassVar[int] = ...
    _sbat_block_count_offset: typing.ClassVar[int] = ...
    _xbat_start_offset: typing.ClassVar[int] = ...
    _xbat_count_offset: typing.ClassVar[int] = ...

class ListManagedBlock:
    def getData(self) -> typing.List[int]: ...

class SmallBlockTableReader:
    def __init__(self): ...
    @staticmethod
    def getSmallDocumentBlocks(rawDataBlockList: 'RawDataBlockList', rootProperty: bioformats_jar._loci.poi.poifs.property.RootProperty, int: int) -> BlockList: ...

class BlockAllocationTableWriter(BlockWritable, bioformats_jar._loci.poi.poifs.filesystem.BATManaged):
    def __init__(self): ...
    def allocateSpace(self, int: int) -> int: ...
    def countBlocks(self) -> int: ...
    def createBlocks(self, int: int) -> int: ...
    def getStartBlock(self) -> int: ...
    def setStartBlock(self, int: int) -> None: ...
    def writeBlocks(self, outputStream: java.io.OutputStream) -> None: ...

class HeaderBlockReader(HeaderBlockConstants):
    def __init__(self, inputStream: java.io.InputStream, int: int): ...
    def getBATArray(self) -> typing.List[int]: ...
    def getBATCount(self) -> int: ...
    def getPropertyStart(self) -> int: ...
    def getSBATStart(self) -> int: ...
    def getXBATCount(self) -> int: ...
    def getXBATIndex(self) -> int: ...

class RawDataBlock(ListManagedBlock):
    def __init__(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, int: int, long: int): ...
    def eof(self) -> bool: ...
    def getBlockSize(self) -> int: ...
    def getData(self) -> typing.List[int]: ...
    def getLength(self) -> int: ...
    def getOffset(self) -> int: ...

class SmallBlockTableWriter(BlockWritable, bioformats_jar._loci.poi.poifs.filesystem.BATManaged):
    def __init__(self, list: java.util.List, rootProperty: bioformats_jar._loci.poi.poifs.property.RootProperty): ...
    def countBlocks(self) -> int: ...
    def getSBAT(self) -> BlockAllocationTableWriter: ...
    def getSBATBlockCount(self) -> int: ...
    def setStartBlock(self, int: int) -> None: ...
    def writeBlocks(self, outputStream: java.io.OutputStream) -> None: ...

class SmallDocumentBlock(BlockWritable, ListManagedBlock):
    @staticmethod
    def calcSize(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def convert(byteArray: typing.List[int], int: int) -> typing.List['SmallDocumentBlock']: ...
    @typing.overload
    @staticmethod
    def convert(blockWritableArray: typing.List[BlockWritable], int: int) -> typing.List['SmallDocumentBlock']: ...
    @staticmethod
    def extract(listManagedBlockArray: typing.List[ListManagedBlock], int: int) -> java.util.List: ...
    @staticmethod
    def fill(list: java.util.List, int: int) -> int: ...
    def getBigBlockSize(self) -> int: ...
    def getData(self) -> typing.List[int]: ...
    @staticmethod
    def read(blockWritableArray: typing.List[BlockWritable], byteArray: typing.List[int], int: int) -> None: ...
    def writeBlocks(self, outputStream: java.io.OutputStream) -> None: ...

class BATBlock(loci.poi.poifs.storage.BigBlock):
    @staticmethod
    def calculateStorageRequirements(int: int, int2: int) -> int: ...
    @staticmethod
    def calculateXBATStorageRequirements(int: int, int2: int) -> int: ...
    @staticmethod
    def createBATBlocks(intArray: typing.List[int], int2: int) -> typing.List['BATBlock']: ...
    @staticmethod
    def createXBATBlocks(intArray: typing.List[int], int2: int, int3: int) -> typing.List['BATBlock']: ...
    @staticmethod
    def entriesPerBlock(int: int) -> int: ...
    @staticmethod
    def entriesPerXBATBlock(int: int) -> int: ...
    def getBigBlockSize(self) -> int: ...
    @staticmethod
    def getXBATChainOffset(int: int) -> int: ...

class DocumentBlock(loci.poi.poifs.storage.BigBlock):
    @typing.overload
    def __init__(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, int: int): ...
    @typing.overload
    def __init__(self, rawDataBlock: RawDataBlock, int: int): ...
    @staticmethod
    def convert(long: int, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, int: int, int2: int, int3: int) -> typing.List['DocumentBlock']: ...
    def getBigBlockSize(self) -> int: ...
    @staticmethod
    def getFillByte() -> int: ...
    def partiallyRead(self) -> bool: ...
    @staticmethod
    def read(documentBlockArray: typing.List['DocumentBlock'], byteArray: typing.List[int], int: int, int2: int, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> None: ...
    def size(self) -> int: ...

class HeaderBlockWriter(loci.poi.poifs.storage.BigBlock, HeaderBlockConstants):
    def __init__(self, int: int): ...
    def getBigBlockSize(self) -> int: ...
    def setBATBlocks(self, int: int, int2: int, int3: int) -> typing.List[BATBlock]: ...
    def setPropertyStart(self, int: int) -> None: ...
    def setSBATBlockCount(self, int: int) -> None: ...
    def setSBATStart(self, int: int) -> None: ...

class PropertyBlock(loci.poi.poifs.storage.BigBlock):
    @staticmethod
    def createPropertyBlockArray(list: java.util.List, int: int) -> typing.List[BlockWritable]: ...
    def getBigBlockSize(self) -> int: ...

class RawDataBlockList(loci.poi.poifs.storage.BlockListImpl):
    def __init__(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, int: int): ...
    def getBigBlockSize(self) -> int: ...
    def getBlocks(self) -> typing.List[ListManagedBlock]: ...

class SmallDocumentBlockList(loci.poi.poifs.storage.BlockListImpl):
    def __init__(self, list: java.util.List): ...
    def getBlocks(self) -> typing.List[ListManagedBlock]: ...

class BigBlock: ...

class BlockListImpl: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.poi.poifs.storage")``.

    BATBlock: typing.Type[BATBlock]
    BigBlock: typing.Type[BigBlock]
    BlockAllocationTableReader: typing.Type[BlockAllocationTableReader]
    BlockAllocationTableWriter: typing.Type[BlockAllocationTableWriter]
    BlockList: typing.Type[BlockList]
    BlockListImpl: typing.Type[BlockListImpl]
    BlockWritable: typing.Type[BlockWritable]
    DocumentBlock: typing.Type[DocumentBlock]
    HeaderBlockConstants: typing.Type[HeaderBlockConstants]
    HeaderBlockReader: typing.Type[HeaderBlockReader]
    HeaderBlockWriter: typing.Type[HeaderBlockWriter]
    ListManagedBlock: typing.Type[ListManagedBlock]
    PropertyBlock: typing.Type[PropertyBlock]
    RawDataBlock: typing.Type[RawDataBlock]
    RawDataBlockList: typing.Type[RawDataBlockList]
    SmallBlockTableReader: typing.Type[SmallBlockTableReader]
    SmallBlockTableWriter: typing.Type[SmallBlockTableWriter]
    SmallDocumentBlock: typing.Type[SmallDocumentBlock]
    SmallDocumentBlockList: typing.Type[SmallDocumentBlockList]
