import java.io
import java.lang
import java.util
import bioformats_jar._loci.common
import bioformats_jar._loci.poi.hpsf.wellknown
import bioformats_jar._loci.poi.poifs.filesystem
import typing



class ClassID:
    LENGTH: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getBytes(self) -> typing.List[int]: ...
    def hashCode(self) -> int: ...
    def length(self) -> int: ...
    def read(self, byteArray: typing.List[int], int: int) -> typing.List[int]: ...
    def setBytes(self, byteArray: typing.List[int]) -> None: ...
    def toString(self) -> java.lang.String: ...
    def write(self, byteArray: typing.List[int], int: int) -> None: ...

class Constants:
    CP_037: typing.ClassVar[int] = ...
    CP_SJIS: typing.ClassVar[int] = ...
    CP_GBK: typing.ClassVar[int] = ...
    CP_MS949: typing.ClassVar[int] = ...
    CP_UTF16: typing.ClassVar[int] = ...
    CP_UTF16_BE: typing.ClassVar[int] = ...
    CP_WINDOWS_1250: typing.ClassVar[int] = ...
    CP_WINDOWS_1251: typing.ClassVar[int] = ...
    CP_WINDOWS_1252: typing.ClassVar[int] = ...
    CP_WINDOWS_1253: typing.ClassVar[int] = ...
    CP_WINDOWS_1254: typing.ClassVar[int] = ...
    CP_WINDOWS_1255: typing.ClassVar[int] = ...
    CP_WINDOWS_1256: typing.ClassVar[int] = ...
    CP_WINDOWS_1257: typing.ClassVar[int] = ...
    CP_WINDOWS_1258: typing.ClassVar[int] = ...
    CP_JOHAB: typing.ClassVar[int] = ...
    CP_MAC_ROMAN: typing.ClassVar[int] = ...
    CP_MAC_JAPAN: typing.ClassVar[int] = ...
    CP_MAC_CHINESE_TRADITIONAL: typing.ClassVar[int] = ...
    CP_MAC_KOREAN: typing.ClassVar[int] = ...
    CP_MAC_ARABIC: typing.ClassVar[int] = ...
    CP_MAC_HEBREW: typing.ClassVar[int] = ...
    CP_MAC_GREEK: typing.ClassVar[int] = ...
    CP_MAC_CYRILLIC: typing.ClassVar[int] = ...
    CP_MAC_CHINESE_SIMPLE: typing.ClassVar[int] = ...
    CP_MAC_ROMANIA: typing.ClassVar[int] = ...
    CP_MAC_UKRAINE: typing.ClassVar[int] = ...
    CP_MAC_THAI: typing.ClassVar[int] = ...
    CP_MAC_CENTRAL_EUROPE: typing.ClassVar[int] = ...
    CP_MAC_ICELAND: typing.ClassVar[int] = ...
    CP_MAC_TURKISH: typing.ClassVar[int] = ...
    CP_MAC_CROATIAN: typing.ClassVar[int] = ...
    CP_US_ACSII: typing.ClassVar[int] = ...
    CP_KOI8_R: typing.ClassVar[int] = ...
    CP_ISO_8859_1: typing.ClassVar[int] = ...
    CP_ISO_8859_2: typing.ClassVar[int] = ...
    CP_ISO_8859_3: typing.ClassVar[int] = ...
    CP_ISO_8859_4: typing.ClassVar[int] = ...
    CP_ISO_8859_5: typing.ClassVar[int] = ...
    CP_ISO_8859_6: typing.ClassVar[int] = ...
    CP_ISO_8859_7: typing.ClassVar[int] = ...
    CP_ISO_8859_8: typing.ClassVar[int] = ...
    CP_ISO_8859_9: typing.ClassVar[int] = ...
    CP_ISO_2022_JP1: typing.ClassVar[int] = ...
    CP_ISO_2022_JP2: typing.ClassVar[int] = ...
    CP_ISO_2022_JP3: typing.ClassVar[int] = ...
    CP_ISO_2022_KR: typing.ClassVar[int] = ...
    CP_EUC_JP: typing.ClassVar[int] = ...
    CP_EUC_KR: typing.ClassVar[int] = ...
    CP_GB2312: typing.ClassVar[int] = ...
    CP_GB18030: typing.ClassVar[int] = ...
    CP_US_ASCII2: typing.ClassVar[int] = ...
    CP_UTF8: typing.ClassVar[int] = ...
    CP_UNICODE: typing.ClassVar[int] = ...
    def __init__(self): ...

class CustomProperties(java.util.HashMap):
    def __init__(self): ...
    @typing.overload
    def get(self, object: typing.Any) -> typing.Any: ...
    @typing.overload
    def get(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def getCodepage(self) -> int: ...
    def isPure(self) -> bool: ...
    @typing.overload
    def put(self, object: typing.Any, object2: typing.Any) -> typing.Any: ...
    @typing.overload
    def put(self, string: typing.Union[java.lang.String, str], boolean: bool) -> typing.Any: ...
    @typing.overload
    def put(self, string: typing.Union[java.lang.String, str], double: float) -> typing.Any: ...
    @typing.overload
    def put(self, string: typing.Union[java.lang.String, str], integer: int) -> typing.Any: ...
    @typing.overload
    def put(self, string: typing.Union[java.lang.String, str], long: int) -> typing.Any: ...
    @typing.overload
    def put(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> typing.Any: ...
    @typing.overload
    def put(self, string: typing.Union[java.lang.String, str], date: java.util.Date) -> typing.Any: ...
    @typing.overload
    def remove(self, object: typing.Any, object2: typing.Any) -> bool: ...
    @typing.overload
    def remove(self, object: typing.Any) -> typing.Any: ...
    @typing.overload
    def remove(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def setCodepage(self, int: int) -> None: ...
    def setPure(self, boolean: bool) -> None: ...

class HPSFException(java.lang.Exception):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...
    def getReason(self) -> java.lang.Throwable: ...

class HPSFRuntimeException(java.lang.RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...
    def getReason(self) -> java.lang.Throwable: ...
    @typing.overload
    def printStackTrace(self) -> None: ...
    @typing.overload
    def printStackTrace(self, printStream: java.io.PrintStream) -> None: ...
    @typing.overload
    def printStackTrace(self, printWriter: java.io.PrintWriter) -> None: ...

class Property:
    @typing.overload
    def __init__(self, long: int, byteArray: typing.List[int], long2: int, int: int, int2: int): ...
    @typing.overload
    def __init__(self, long: int, long2: int, object: typing.Any): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getID(self) -> int: ...
    def getType(self) -> int: ...
    def getValue(self) -> typing.Any: ...
    def hashCode(self) -> int: ...
    def toString(self) -> java.lang.String: ...

class PropertySet:
    OS_WIN16: typing.ClassVar[int] = ...
    OS_MACINTOSH: typing.ClassVar[int] = ...
    OS_WIN32: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int]): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int, int2: int): ...
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getByteOrder(self) -> int: ...
    def getClassID(self) -> ClassID: ...
    def getFirstSection(self) -> 'Section': ...
    def getFormat(self) -> int: ...
    def getOSVersion(self) -> int: ...
    def getProperties(self) -> typing.List[Property]: ...
    def getSectionCount(self) -> int: ...
    def getSections(self) -> java.util.List: ...
    def getSingleSection(self) -> 'Section': ...
    def hashCode(self) -> int: ...
    def isDocumentSummaryInformation(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isPropertySetStream(byteArray: typing.List[int], int: int, int2: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isPropertySetStream(inputStream: java.io.InputStream) -> bool: ...
    def isSummaryInformation(self) -> bool: ...
    def toString(self) -> java.lang.String: ...
    def wasNull(self) -> bool: ...

class PropertySetFactory:
    def __init__(self): ...
    @staticmethod
    def create(inputStream: java.io.InputStream) -> PropertySet: ...
    @staticmethod
    def newDocumentSummaryInformation() -> 'DocumentSummaryInformation': ...
    @staticmethod
    def newSummaryInformation() -> 'SummaryInformation': ...

class Section:
    def __init__(self, byteArray: typing.List[int], int: int): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getCodepage(self) -> int: ...
    def getDictionary(self) -> java.util.Map: ...
    def getFormatID(self) -> ClassID: ...
    def getOffset(self) -> int: ...
    def getPIDString(self, long: int) -> java.lang.String: ...
    def getProperties(self) -> typing.List[Property]: ...
    def getProperty(self, long: int) -> typing.Any: ...
    def getPropertyCount(self) -> int: ...
    def getSize(self) -> int: ...
    def hashCode(self) -> int: ...
    def toString(self) -> java.lang.String: ...
    def wasNull(self) -> bool: ...

class Thumbnail:
    OFFSET_CFTAG: typing.ClassVar[int] = ...
    OFFSET_CF: typing.ClassVar[int] = ...
    OFFSET_WMFDATA: typing.ClassVar[int] = ...
    CFTAG_WINDOWS: typing.ClassVar[int] = ...
    CFTAG_MACINTOSH: typing.ClassVar[int] = ...
    CFTAG_FMTID: typing.ClassVar[int] = ...
    CFTAG_NODATA: typing.ClassVar[int] = ...
    CF_METAFILEPICT: typing.ClassVar[int] = ...
    CF_DIB: typing.ClassVar[int] = ...
    CF_ENHMETAFILE: typing.ClassVar[int] = ...
    CF_BITMAP: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int]): ...
    def getClipboardFormat(self) -> int: ...
    def getClipboardFormatTag(self) -> int: ...
    def getThumbnail(self) -> typing.List[int]: ...
    def getThumbnailAsWMF(self) -> typing.List[int]: ...
    def setThumbnail(self, byteArray: typing.List[int]) -> None: ...

class TypeWriter:
    def __init__(self): ...
    @typing.overload
    @staticmethod
    def writeToStream(outputStream: java.io.OutputStream, double: float) -> int: ...
    @typing.overload
    @staticmethod
    def writeToStream(outputStream: java.io.OutputStream, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def writeToStream(outputStream: java.io.OutputStream, classID: ClassID) -> int: ...
    @typing.overload
    @staticmethod
    def writeToStream(outputStream: java.io.OutputStream, long: int) -> int: ...
    @typing.overload
    @staticmethod
    def writeToStream(outputStream: java.io.OutputStream, short: int) -> int: ...
    @typing.overload
    @staticmethod
    def writeToStream(outputStream: java.io.OutputStream, propertyArray: typing.List[Property], int: int) -> None: ...
    @staticmethod
    def writeUIntToStream(outputStream: java.io.OutputStream, long: int) -> int: ...
    @staticmethod
    def writeUShortToStream(outputStream: java.io.OutputStream, int: int) -> None: ...

class Util:
    EPOCH_DIFF: typing.ClassVar[int] = ...
    def __init__(self): ...
    @staticmethod
    def cat(byteArray: typing.List[typing.List[int]]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def copy(byteArray: typing.List[int], int: int, int2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def copy(byteArray: typing.List[int], int: int, int2: int, byteArray2: typing.List[int], int3: int) -> None: ...
    @staticmethod
    def dateToFileTime(date: java.util.Date) -> int: ...
    @staticmethod
    def equal(byteArray: typing.List[int], byteArray2: typing.List[int]) -> bool: ...
    @typing.overload
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    @staticmethod
    def equals(objectArray: typing.List[typing.Any], objectArray2: typing.List[typing.Any]) -> bool: ...
    @typing.overload
    @staticmethod
    def equals(collection: typing.Union[java.util.Collection, typing.Sequence], collection2: typing.Union[java.util.Collection, typing.Sequence]) -> bool: ...
    @typing.overload
    @staticmethod
    def filetimeToDate(int: int, int2: int) -> java.util.Date: ...
    @typing.overload
    @staticmethod
    def filetimeToDate(long: int) -> java.util.Date: ...
    @typing.overload
    @staticmethod
    def pad4(byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def pad4(charArray: typing.List[str]) -> typing.List[str]: ...
    @typing.overload
    @staticmethod
    def pad4(string: typing.Union[java.lang.String, str]) -> typing.List[str]: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def toString(throwable: java.lang.Throwable) -> java.lang.String: ...

class Variant:
    VT_EMPTY: typing.ClassVar[int] = ...
    VT_NULL: typing.ClassVar[int] = ...
    VT_I2: typing.ClassVar[int] = ...
    VT_I4: typing.ClassVar[int] = ...
    VT_R4: typing.ClassVar[int] = ...
    VT_R8: typing.ClassVar[int] = ...
    VT_CY: typing.ClassVar[int] = ...
    VT_DATE: typing.ClassVar[int] = ...
    VT_BSTR: typing.ClassVar[int] = ...
    VT_DISPATCH: typing.ClassVar[int] = ...
    VT_ERROR: typing.ClassVar[int] = ...
    VT_BOOL: typing.ClassVar[int] = ...
    VT_VARIANT: typing.ClassVar[int] = ...
    VT_UNKNOWN: typing.ClassVar[int] = ...
    VT_DECIMAL: typing.ClassVar[int] = ...
    VT_I1: typing.ClassVar[int] = ...
    VT_UI1: typing.ClassVar[int] = ...
    VT_UI2: typing.ClassVar[int] = ...
    VT_UI4: typing.ClassVar[int] = ...
    VT_I8: typing.ClassVar[int] = ...
    VT_UI8: typing.ClassVar[int] = ...
    VT_INT: typing.ClassVar[int] = ...
    VT_UINT: typing.ClassVar[int] = ...
    VT_VOID: typing.ClassVar[int] = ...
    VT_HRESULT: typing.ClassVar[int] = ...
    VT_PTR: typing.ClassVar[int] = ...
    VT_SAFEARRAY: typing.ClassVar[int] = ...
    VT_CARRAY: typing.ClassVar[int] = ...
    VT_USERDEFINED: typing.ClassVar[int] = ...
    VT_LPSTR: typing.ClassVar[int] = ...
    VT_LPWSTR: typing.ClassVar[int] = ...
    VT_FILETIME: typing.ClassVar[int] = ...
    VT_BLOB: typing.ClassVar[int] = ...
    VT_STREAM: typing.ClassVar[int] = ...
    VT_STORAGE: typing.ClassVar[int] = ...
    VT_STREAMED_OBJECT: typing.ClassVar[int] = ...
    VT_STORED_OBJECT: typing.ClassVar[int] = ...
    VT_BLOB_OBJECT: typing.ClassVar[int] = ...
    VT_CF: typing.ClassVar[int] = ...
    VT_CLSID: typing.ClassVar[int] = ...
    VT_VECTOR: typing.ClassVar[int] = ...
    VT_ARRAY: typing.ClassVar[int] = ...
    VT_BYREF: typing.ClassVar[int] = ...
    VT_RESERVED: typing.ClassVar[int] = ...
    VT_ILLEGAL: typing.ClassVar[int] = ...
    VT_ILLEGALMASKED: typing.ClassVar[int] = ...
    VT_TYPEMASK: typing.ClassVar[int] = ...
    LENGTH_UNKNOWN: typing.ClassVar[int] = ...
    LENGTH_VARIABLE: typing.ClassVar[int] = ...
    LENGTH_0: typing.ClassVar[int] = ...
    LENGTH_2: typing.ClassVar[int] = ...
    LENGTH_4: typing.ClassVar[int] = ...
    LENGTH_8: typing.ClassVar[int] = ...
    def __init__(self): ...
    @staticmethod
    def getVariantLength(long: int) -> int: ...
    @staticmethod
    def getVariantName(long: int) -> java.lang.String: ...

class IllegalPropertySetDataException(HPSFRuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class MarkUnsupportedException(HPSFException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class MissingSectionException(HPSFRuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class MutableProperty(Property):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, property: Property): ...
    def setID(self, long: int) -> None: ...
    def setType(self, long: int) -> None: ...
    def setValue(self, object: typing.Any) -> None: ...
    def write(self, outputStream: java.io.OutputStream, int: int) -> int: ...

class MutablePropertySet(PropertySet):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, propertySet: PropertySet): ...
    def addSection(self, section: Section) -> None: ...
    def clearSections(self) -> None: ...
    def setByteOrder(self, int: int) -> None: ...
    def setClassID(self, classID: ClassID) -> None: ...
    def setFormat(self, int: int) -> None: ...
    def setOSVersion(self, int: int) -> None: ...
    def toInputStream(self) -> bioformats_jar._loci.common.RandomAccessInputStream: ...
    @typing.overload
    def write(self, outputStream: java.io.OutputStream) -> None: ...
    @typing.overload
    def write(self, directoryEntry: bioformats_jar._loci.poi.poifs.filesystem.DirectoryEntry, string: typing.Union[java.lang.String, str]) -> None: ...

class MutableSection(Section):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, section: Section): ...
    def clear(self) -> None: ...
    def getProperties(self) -> typing.List[Property]: ...
    def getProperty(self, long: int) -> typing.Any: ...
    def getPropertyCount(self) -> int: ...
    def getSize(self) -> int: ...
    def removeProperty(self, long: int) -> None: ...
    def setCodepage(self, int: int) -> None: ...
    def setDictionary(self, map: typing.Union[java.util.Map, typing.Mapping]) -> None: ...
    @typing.overload
    def setFormatID(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def setFormatID(self, classID: ClassID) -> None: ...
    def setProperties(self, propertyArray: typing.List[Property]) -> None: ...
    @typing.overload
    def setProperty(self, int: int, boolean: bool) -> None: ...
    @typing.overload
    def setProperty(self, int: int, int2: int) -> None: ...
    @typing.overload
    def setProperty(self, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def setProperty(self, int: int, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setProperty(self, int: int, long: int) -> None: ...
    @typing.overload
    def setProperty(self, int: int, long: int, object: typing.Any) -> None: ...
    @typing.overload
    def setProperty(self, property: Property) -> None: ...
    def write(self, outputStream: java.io.OutputStream) -> int: ...

class NoFormatIDException(HPSFRuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class NoPropertySetStreamException(HPSFException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class NoSingleSectionException(HPSFRuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class UnexpectedPropertySetTypeException(HPSFException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class VariantSupport(Variant):
    def __init__(self): ...
    @staticmethod
    def codepageToEncoding(int: int) -> java.lang.String: ...
    @staticmethod
    def isLogUnsupportedTypes() -> bool: ...
    @staticmethod
    def read(byteArray: typing.List[int], int: int, int2: int, long: int, int3: int) -> typing.Any: ...
    @staticmethod
    def setLogUnsupportedTypes(boolean: bool) -> None: ...
    @staticmethod
    def write(outputStream: java.io.OutputStream, long: int, object: typing.Any, int: int) -> int: ...

class VariantTypeException(HPSFException):
    def __init__(self, long: int, object: typing.Any, string: typing.Union[java.lang.String, str]): ...
    def getValue(self) -> typing.Any: ...
    def getVariantType(self) -> int: ...

class CustomProperty(MutableProperty):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, property: Property): ...
    @typing.overload
    def __init__(self, property: Property, string: typing.Union[java.lang.String, str]): ...
    def equalsContents(self, object: typing.Any) -> bool: ...
    def getName(self) -> java.lang.String: ...
    def hashCode(self) -> int: ...
    def setName(self, string: typing.Union[java.lang.String, str]) -> None: ...

class IllegalVariantTypeException(VariantTypeException):
    @typing.overload
    def __init__(self, long: int, object: typing.Any): ...
    @typing.overload
    def __init__(self, long: int, object: typing.Any, string: typing.Union[java.lang.String, str]): ...

class SpecialPropertySet(MutablePropertySet):
    @typing.overload
    def __init__(self, mutablePropertySet: MutablePropertySet): ...
    @typing.overload
    def __init__(self, propertySet: PropertySet): ...
    def addSection(self, section: Section) -> None: ...
    def clearSections(self) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getByteOrder(self) -> int: ...
    def getClassID(self) -> ClassID: ...
    def getFirstSection(self) -> Section: ...
    def getFormat(self) -> int: ...
    def getOSVersion(self) -> int: ...
    def getProperties(self) -> typing.List[Property]: ...
    def getSectionCount(self) -> int: ...
    def getSections(self) -> java.util.List: ...
    def hashCode(self) -> int: ...
    def isDocumentSummaryInformation(self) -> bool: ...
    def isSummaryInformation(self) -> bool: ...
    def setByteOrder(self, int: int) -> None: ...
    def setClassID(self, classID: ClassID) -> None: ...
    def setFormat(self, int: int) -> None: ...
    def setOSVersion(self, int: int) -> None: ...
    def toInputStream(self) -> bioformats_jar._loci.common.RandomAccessInputStream: ...
    def toString(self) -> java.lang.String: ...
    def wasNull(self) -> bool: ...
    @typing.overload
    def write(self, outputStream: java.io.OutputStream) -> None: ...
    @typing.overload
    def write(self, directoryEntry: bioformats_jar._loci.poi.poifs.filesystem.DirectoryEntry, string: typing.Union[java.lang.String, str]) -> None: ...

class UnsupportedVariantTypeException(VariantTypeException):
    def __init__(self, long: int, object: typing.Any): ...

class DocumentSummaryInformation(SpecialPropertySet):
    DEFAULT_STREAM_NAME: typing.ClassVar[java.lang.String] = ...
    def __init__(self, propertySet: PropertySet): ...
    def getByteCount(self) -> int: ...
    def getCategory(self) -> java.lang.String: ...
    def getCompany(self) -> java.lang.String: ...
    def getCustomProperties(self) -> CustomProperties: ...
    def getDocparts(self) -> typing.List[int]: ...
    def getHeadingPair(self) -> typing.List[int]: ...
    def getHiddenCount(self) -> int: ...
    def getLineCount(self) -> int: ...
    def getLinksDirty(self) -> bool: ...
    def getMMClipCount(self) -> int: ...
    def getManager(self) -> java.lang.String: ...
    def getNoteCount(self) -> int: ...
    def getParCount(self) -> int: ...
    def getPresentationFormat(self) -> java.lang.String: ...
    def getScale(self) -> bool: ...
    def getSlideCount(self) -> int: ...
    def removeByteCount(self) -> None: ...
    def removeCategory(self) -> None: ...
    def removeCompany(self) -> None: ...
    def removeCustomProperties(self) -> None: ...
    def removeDocparts(self) -> None: ...
    def removeHeadingPair(self) -> None: ...
    def removeHiddenCount(self) -> None: ...
    def removeLineCount(self) -> None: ...
    def removeLinksDirty(self) -> None: ...
    def removeMMClipCount(self) -> None: ...
    def removeManager(self) -> None: ...
    def removeNoteCount(self) -> None: ...
    def removeParCount(self) -> None: ...
    def removePresentationFormat(self) -> None: ...
    def removeScale(self) -> None: ...
    def removeSlideCount(self) -> None: ...
    def setByteCount(self, int: int) -> None: ...
    def setCategory(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setCompany(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setCustomProperties(self, customProperties: CustomProperties) -> None: ...
    def setDocparts(self, byteArray: typing.List[int]) -> None: ...
    def setHeadingPair(self, byteArray: typing.List[int]) -> None: ...
    def setHiddenCount(self, int: int) -> None: ...
    def setLineCount(self, int: int) -> None: ...
    def setLinksDirty(self, boolean: bool) -> None: ...
    def setMMClipCount(self, int: int) -> None: ...
    def setManager(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setNoteCount(self, int: int) -> None: ...
    def setParCount(self, int: int) -> None: ...
    def setPresentationFormat(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setScale(self, boolean: bool) -> None: ...
    def setSlideCount(self, int: int) -> None: ...

class ReadingNotSupportedException(UnsupportedVariantTypeException):
    def __init__(self, long: int, object: typing.Any): ...

class SummaryInformation(SpecialPropertySet):
    DEFAULT_STREAM_NAME: typing.ClassVar[java.lang.String] = ...
    def __init__(self, propertySet: PropertySet): ...
    def getApplicationName(self) -> java.lang.String: ...
    def getAuthor(self) -> java.lang.String: ...
    def getCharCount(self) -> int: ...
    def getComments(self) -> java.lang.String: ...
    def getCreateDateTime(self) -> java.util.Date: ...
    def getEditTime(self) -> int: ...
    def getKeywords(self) -> java.lang.String: ...
    def getLastAuthor(self) -> java.lang.String: ...
    def getLastPrinted(self) -> java.util.Date: ...
    def getLastSaveDateTime(self) -> java.util.Date: ...
    def getPageCount(self) -> int: ...
    def getRevNumber(self) -> java.lang.String: ...
    def getSecurity(self) -> int: ...
    def getSubject(self) -> java.lang.String: ...
    def getTemplate(self) -> java.lang.String: ...
    def getThumbnail(self) -> typing.List[int]: ...
    def getTitle(self) -> java.lang.String: ...
    def getWordCount(self) -> int: ...
    def removeApplicationName(self) -> None: ...
    def removeAuthor(self) -> None: ...
    def removeCharCount(self) -> None: ...
    def removeComments(self) -> None: ...
    def removeCreateDateTime(self) -> None: ...
    def removeEditTime(self) -> None: ...
    def removeKeywords(self) -> None: ...
    def removeLastAuthor(self) -> None: ...
    def removeLastPrinted(self) -> None: ...
    def removeLastSaveDateTime(self) -> None: ...
    def removePageCount(self) -> None: ...
    def removeRevNumber(self) -> None: ...
    def removeSecurity(self) -> None: ...
    def removeSubject(self) -> None: ...
    def removeTemplate(self) -> None: ...
    def removeThumbnail(self) -> None: ...
    def removeTitle(self) -> None: ...
    def removeWordCount(self) -> None: ...
    def setApplicationName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setAuthor(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setCharCount(self, int: int) -> None: ...
    def setComments(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setCreateDateTime(self, date: java.util.Date) -> None: ...
    def setEditTime(self, long: int) -> None: ...
    def setKeywords(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLastAuthor(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLastPrinted(self, date: java.util.Date) -> None: ...
    def setLastSaveDateTime(self, date: java.util.Date) -> None: ...
    def setPageCount(self, int: int) -> None: ...
    def setRevNumber(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setSecurity(self, int: int) -> None: ...
    def setSubject(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTemplate(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setThumbnail(self, byteArray: typing.List[int]) -> None: ...
    def setTitle(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setWordCount(self, int: int) -> None: ...

class WritingNotSupportedException(UnsupportedVariantTypeException):
    def __init__(self, long: int, object: typing.Any): ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.poi.hpsf")``.

    ClassID: typing.Type[ClassID]
    Constants: typing.Type[Constants]
    CustomProperties: typing.Type[CustomProperties]
    CustomProperty: typing.Type[CustomProperty]
    DocumentSummaryInformation: typing.Type[DocumentSummaryInformation]
    HPSFException: typing.Type[HPSFException]
    HPSFRuntimeException: typing.Type[HPSFRuntimeException]
    IllegalPropertySetDataException: typing.Type[IllegalPropertySetDataException]
    IllegalVariantTypeException: typing.Type[IllegalVariantTypeException]
    MarkUnsupportedException: typing.Type[MarkUnsupportedException]
    MissingSectionException: typing.Type[MissingSectionException]
    MutableProperty: typing.Type[MutableProperty]
    MutablePropertySet: typing.Type[MutablePropertySet]
    MutableSection: typing.Type[MutableSection]
    NoFormatIDException: typing.Type[NoFormatIDException]
    NoPropertySetStreamException: typing.Type[NoPropertySetStreamException]
    NoSingleSectionException: typing.Type[NoSingleSectionException]
    Property: typing.Type[Property]
    PropertySet: typing.Type[PropertySet]
    PropertySetFactory: typing.Type[PropertySetFactory]
    ReadingNotSupportedException: typing.Type[ReadingNotSupportedException]
    Section: typing.Type[Section]
    SpecialPropertySet: typing.Type[SpecialPropertySet]
    SummaryInformation: typing.Type[SummaryInformation]
    Thumbnail: typing.Type[Thumbnail]
    TypeWriter: typing.Type[TypeWriter]
    UnexpectedPropertySetTypeException: typing.Type[UnexpectedPropertySetTypeException]
    UnsupportedVariantTypeException: typing.Type[UnsupportedVariantTypeException]
    Util: typing.Type[Util]
    Variant: typing.Type[Variant]
    VariantSupport: typing.Type[VariantSupport]
    VariantTypeException: typing.Type[VariantTypeException]
    WritingNotSupportedException: typing.Type[WritingNotSupportedException]
    wellknown: bioformats_jar._loci.poi.hpsf.wellknown.__module_protocol__
