import java.io
import java.lang
import java.util
import bioformats_jar._loci.common
import bioformats_jar._loci.common.enumeration
import bioformats_jar._loci.formats.codec
import typing



class IFD(java.util.HashMap[int, typing.Any]):
    LITTLE_ENDIAN: typing.ClassVar[int] = ...
    BIG_TIFF: typing.ClassVar[int] = ...
    REUSE: typing.ClassVar[int] = ...
    NEW_SUBFILE_TYPE: typing.ClassVar[int] = ...
    SUBFILE_TYPE: typing.ClassVar[int] = ...
    IMAGE_WIDTH: typing.ClassVar[int] = ...
    IMAGE_LENGTH: typing.ClassVar[int] = ...
    BITS_PER_SAMPLE: typing.ClassVar[int] = ...
    COMPRESSION: typing.ClassVar[int] = ...
    PHOTOMETRIC_INTERPRETATION: typing.ClassVar[int] = ...
    THRESHHOLDING: typing.ClassVar[int] = ...
    CELL_WIDTH: typing.ClassVar[int] = ...
    CELL_LENGTH: typing.ClassVar[int] = ...
    FILL_ORDER: typing.ClassVar[int] = ...
    DOCUMENT_NAME: typing.ClassVar[int] = ...
    IMAGE_DESCRIPTION: typing.ClassVar[int] = ...
    MAKE: typing.ClassVar[int] = ...
    MODEL: typing.ClassVar[int] = ...
    STRIP_OFFSETS: typing.ClassVar[int] = ...
    ORIENTATION: typing.ClassVar[int] = ...
    SAMPLES_PER_PIXEL: typing.ClassVar[int] = ...
    ROWS_PER_STRIP: typing.ClassVar[int] = ...
    STRIP_BYTE_COUNTS: typing.ClassVar[int] = ...
    MIN_SAMPLE_VALUE: typing.ClassVar[int] = ...
    MAX_SAMPLE_VALUE: typing.ClassVar[int] = ...
    X_RESOLUTION: typing.ClassVar[int] = ...
    Y_RESOLUTION: typing.ClassVar[int] = ...
    PLANAR_CONFIGURATION: typing.ClassVar[int] = ...
    PAGE_NAME: typing.ClassVar[int] = ...
    X_POSITION: typing.ClassVar[int] = ...
    Y_POSITION: typing.ClassVar[int] = ...
    FREE_OFFSETS: typing.ClassVar[int] = ...
    FREE_BYTE_COUNTS: typing.ClassVar[int] = ...
    GRAY_RESPONSE_UNIT: typing.ClassVar[int] = ...
    GRAY_RESPONSE_CURVE: typing.ClassVar[int] = ...
    T4_OPTIONS: typing.ClassVar[int] = ...
    T6_OPTIONS: typing.ClassVar[int] = ...
    RESOLUTION_UNIT: typing.ClassVar[int] = ...
    PAGE_NUMBER: typing.ClassVar[int] = ...
    TRANSFER_FUNCTION: typing.ClassVar[int] = ...
    SOFTWARE: typing.ClassVar[int] = ...
    DATE_TIME: typing.ClassVar[int] = ...
    ARTIST: typing.ClassVar[int] = ...
    HOST_COMPUTER: typing.ClassVar[int] = ...
    PREDICTOR: typing.ClassVar[int] = ...
    WHITE_POINT: typing.ClassVar[int] = ...
    PRIMARY_CHROMATICITIES: typing.ClassVar[int] = ...
    COLOR_MAP: typing.ClassVar[int] = ...
    HALFTONE_HINTS: typing.ClassVar[int] = ...
    TILE_WIDTH: typing.ClassVar[int] = ...
    TILE_LENGTH: typing.ClassVar[int] = ...
    TILE_OFFSETS: typing.ClassVar[int] = ...
    TILE_BYTE_COUNTS: typing.ClassVar[int] = ...
    SUB_IFD: typing.ClassVar[int] = ...
    INK_SET: typing.ClassVar[int] = ...
    INK_NAMES: typing.ClassVar[int] = ...
    NUMBER_OF_INKS: typing.ClassVar[int] = ...
    DOT_RANGE: typing.ClassVar[int] = ...
    TARGET_PRINTER: typing.ClassVar[int] = ...
    EXTRA_SAMPLES: typing.ClassVar[int] = ...
    SAMPLE_FORMAT: typing.ClassVar[int] = ...
    S_MIN_SAMPLE_VALUE: typing.ClassVar[int] = ...
    S_MAX_SAMPLE_VALUE: typing.ClassVar[int] = ...
    TRANSFER_RANGE: typing.ClassVar[int] = ...
    JPEG_TABLES: typing.ClassVar[int] = ...
    JPEG_PROC: typing.ClassVar[int] = ...
    JPEG_INTERCHANGE_FORMAT: typing.ClassVar[int] = ...
    JPEG_INTERCHANGE_FORMAT_LENGTH: typing.ClassVar[int] = ...
    JPEG_RESTART_INTERVAL: typing.ClassVar[int] = ...
    JPEG_LOSSLESS_PREDICTORS: typing.ClassVar[int] = ...
    JPEG_POINT_TRANSFORMS: typing.ClassVar[int] = ...
    JPEG_Q_TABLES: typing.ClassVar[int] = ...
    JPEG_DC_TABLES: typing.ClassVar[int] = ...
    JPEG_AC_TABLES: typing.ClassVar[int] = ...
    Y_CB_CR_COEFFICIENTS: typing.ClassVar[int] = ...
    Y_CB_CR_SUB_SAMPLING: typing.ClassVar[int] = ...
    Y_CB_CR_POSITIONING: typing.ClassVar[int] = ...
    REFERENCE_BLACK_WHITE: typing.ClassVar[int] = ...
    COPYRIGHT: typing.ClassVar[int] = ...
    EXIF: typing.ClassVar[int] = ...
    EXPOSURE_TIME: typing.ClassVar[int] = ...
    F_NUMBER: typing.ClassVar[int] = ...
    EXPOSURE_PROGRAM: typing.ClassVar[int] = ...
    SPECTRAL_SENSITIVITY: typing.ClassVar[int] = ...
    ISO_SPEED_RATINGS: typing.ClassVar[int] = ...
    OECF: typing.ClassVar[int] = ...
    EXIF_VERSION: typing.ClassVar[int] = ...
    DATE_TIME_ORIGINAL: typing.ClassVar[int] = ...
    DATE_TIME_DIGITIZED: typing.ClassVar[int] = ...
    COMPONENTS_CONFIGURATION: typing.ClassVar[int] = ...
    COMPRESSED_BITS_PER_PIXEL: typing.ClassVar[int] = ...
    SHUTTER_SPEED_VALUE: typing.ClassVar[int] = ...
    APERTURE_VALUE: typing.ClassVar[int] = ...
    BRIGHTNESS_VALUE: typing.ClassVar[int] = ...
    EXPOSURE_BIAS_VALUE: typing.ClassVar[int] = ...
    MAX_APERTURE_VALUE: typing.ClassVar[int] = ...
    SUBJECT_DISTANCE: typing.ClassVar[int] = ...
    METERING_MODE: typing.ClassVar[int] = ...
    LIGHT_SOURCE: typing.ClassVar[int] = ...
    FLASH: typing.ClassVar[int] = ...
    FOCAL_LENGTH: typing.ClassVar[int] = ...
    MAKER_NOTE: typing.ClassVar[int] = ...
    USER_COMMENT: typing.ClassVar[int] = ...
    SUB_SEC_TIME: typing.ClassVar[int] = ...
    SUB_SEC_TIME_ORIGINAL: typing.ClassVar[int] = ...
    SUB_SEC_TIME_DIGITIZED: typing.ClassVar[int] = ...
    FLASH_PIX_VERSION: typing.ClassVar[int] = ...
    COLOR_SPACE: typing.ClassVar[int] = ...
    PIXEL_X_DIMENSION: typing.ClassVar[int] = ...
    PIXEL_Y_DIMENSION: typing.ClassVar[int] = ...
    RELATED_SOUND_FILE: typing.ClassVar[int] = ...
    FLASH_ENERGY: typing.ClassVar[int] = ...
    SPATIAL_FREQUENCY_RESPONSE: typing.ClassVar[int] = ...
    FOCAL_PLANE_X_RESOLUTION: typing.ClassVar[int] = ...
    FOCAL_PLANE_Y_RESOLUTION: typing.ClassVar[int] = ...
    FOCAL_PLANE_RESOLUTION_UNIT: typing.ClassVar[int] = ...
    SUBJECT_LOCATION: typing.ClassVar[int] = ...
    EXPOSURE_INDEX: typing.ClassVar[int] = ...
    SENSING_METHOD: typing.ClassVar[int] = ...
    FILE_SOURCE: typing.ClassVar[int] = ...
    SCENE_TYPE: typing.ClassVar[int] = ...
    CFA_PATTERN: typing.ClassVar[int] = ...
    CUSTOM_RENDERED: typing.ClassVar[int] = ...
    EXPOSURE_MODE: typing.ClassVar[int] = ...
    WHITE_BALANCE: typing.ClassVar[int] = ...
    DIGITAL_ZOOM_RATIO: typing.ClassVar[int] = ...
    FOCAL_LENGTH_35MM_FILM: typing.ClassVar[int] = ...
    SCENE_CAPTURE_TYPE: typing.ClassVar[int] = ...
    GAIN_CONTROL: typing.ClassVar[int] = ...
    CONTRAST: typing.ClassVar[int] = ...
    SATURATION: typing.ClassVar[int] = ...
    SHARPNESS: typing.ClassVar[int] = ...
    SUBJECT_DISTANCE_RANGE: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iFD: 'IFD'): ...
    def getBitsPerSample(self) -> typing.List[int]: ...
    def getBytesPerSample(self) -> typing.List[int]: ...
    def getComment(self) -> java.lang.String: ...
    def getCompression(self) -> 'TiffCompression': ...
    @staticmethod
    def getFieldName(int: int) -> java.lang.String: ...
    def getIFDIntArray(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def getIFDIntValue(self, int: int) -> int: ...
    @typing.overload
    def getIFDIntValue(self, int: int, int2: int) -> int: ...
    def getIFDLongArray(self, int: int) -> typing.List[int]: ...
    def getIFDLongValue(self, int: int, long: int) -> int: ...
    def getIFDRationalValue(self, int: int) -> 'TiffRational': ...
    def getIFDShortArray(self, int: int) -> typing.List[int]: ...
    def getIFDStringValue(self, int: int) -> java.lang.String: ...
    @staticmethod
    def getIFDTagName(int: int) -> java.lang.String: ...
    def getIFDTextValue(self, int: int) -> java.lang.String: ...
    @typing.overload
    def getIFDValue(self, int: int) -> typing.Any: ...
    @typing.overload
    def getIFDValue(self, int: int, class_: typing.Type) -> typing.Any: ...
    def getImageLength(self) -> int: ...
    def getImageWidth(self) -> int: ...
    def getOnDemandStripOffsets(self) -> 'OnDemandLongArray': ...
    def getPhotometricInterpretation(self) -> 'PhotoInterp': ...
    def getPixelType(self) -> int: ...
    def getPlanarConfiguration(self) -> int: ...
    def getResolutionMultiplier(self) -> int: ...
    def getRowsPerStrip(self) -> typing.List[int]: ...
    def getSamplesPerPixel(self) -> int: ...
    def getStripByteCounts(self) -> typing.List[int]: ...
    def getStripOffsets(self) -> typing.List[int]: ...
    def getTileLength(self) -> int: ...
    def getTileWidth(self) -> int: ...
    def getTilesPerColumn(self) -> int: ...
    def getTilesPerRow(self) -> int: ...
    def getXResolution(self) -> float: ...
    def getYResolution(self) -> float: ...
    def isBigTiff(self) -> bool: ...
    def isLittleEndian(self) -> bool: ...
    def isTiled(self) -> bool: ...
    def printIFD(self) -> None: ...
    @typing.overload
    def putIFDValue(self, int: int, int2: int) -> None: ...
    @typing.overload
    def putIFDValue(self, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def putIFDValue(self, int: int, long: int) -> None: ...
    @typing.overload
    def putIFDValue(self, int: int, short: int) -> None: ...

class IFDList(java.util.ArrayList[IFD]):
    def __init__(self): ...

class IFDType(java.lang.Enum['IFDType'], bioformats_jar._loci.common.enumeration.CodedEnum):
    BYTE: typing.ClassVar['IFDType'] = ...
    ASCII: typing.ClassVar['IFDType'] = ...
    SHORT: typing.ClassVar['IFDType'] = ...
    LONG: typing.ClassVar['IFDType'] = ...
    RATIONAL: typing.ClassVar['IFDType'] = ...
    SBYTE: typing.ClassVar['IFDType'] = ...
    UNDEFINED: typing.ClassVar['IFDType'] = ...
    SSHORT: typing.ClassVar['IFDType'] = ...
    SLONG: typing.ClassVar['IFDType'] = ...
    SRATIONAL: typing.ClassVar['IFDType'] = ...
    FLOAT: typing.ClassVar['IFDType'] = ...
    DOUBLE: typing.ClassVar['IFDType'] = ...
    IFD: typing.ClassVar['IFDType'] = ...
    LONG8: typing.ClassVar['IFDType'] = ...
    SLONG8: typing.ClassVar['IFDType'] = ...
    IFD8: typing.ClassVar['IFDType'] = ...
    @staticmethod
    def get(int: int) -> 'IFDType': ...
    def getBytesPerElement(self) -> int: ...
    def getCode(self) -> int: ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'IFDType': ...
    @staticmethod
    def values() -> typing.List['IFDType']: ...

class OnDemandLongArray:
    def __init__(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream): ...
    def close(self) -> None: ...
    def get(self, int: int) -> int: ...
    def getStream(self) -> bioformats_jar._loci.common.RandomAccessInputStream: ...
    def setSize(self, int: int) -> None: ...
    def setStream(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> None: ...
    def size(self) -> int: ...
    def toArray(self) -> typing.List[int]: ...

class PhotoInterp(java.lang.Enum['PhotoInterp'], bioformats_jar._loci.common.enumeration.CodedEnum):
    WHITE_IS_ZERO: typing.ClassVar['PhotoInterp'] = ...
    BLACK_IS_ZERO: typing.ClassVar['PhotoInterp'] = ...
    RGB: typing.ClassVar['PhotoInterp'] = ...
    RGB_PALETTE: typing.ClassVar['PhotoInterp'] = ...
    TRANSPARENCY_MASK: typing.ClassVar['PhotoInterp'] = ...
    CMYK: typing.ClassVar['PhotoInterp'] = ...
    Y_CB_CR: typing.ClassVar['PhotoInterp'] = ...
    CIE_LAB: typing.ClassVar['PhotoInterp'] = ...
    CFA_ARRAY: typing.ClassVar['PhotoInterp'] = ...
    LUMA_RED: typing.ClassVar[float] = ...
    LUMA_GREEN: typing.ClassVar[float] = ...
    LUMA_BLUE: typing.ClassVar[float] = ...
    @staticmethod
    def get(int: int) -> 'PhotoInterp': ...
    def getCode(self) -> int: ...
    def getMetadataType(self) -> java.lang.String: ...
    def getName(self) -> java.lang.String: ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'PhotoInterp': ...
    @staticmethod
    def values() -> typing.List['PhotoInterp']: ...

class TiffCompression(java.lang.Enum['TiffCompression'], bioformats_jar._loci.common.enumeration.CodedEnum):
    DEFAULT_UNCOMPRESSED: typing.ClassVar['TiffCompression'] = ...
    UNCOMPRESSED: typing.ClassVar['TiffCompression'] = ...
    CCITT_1D: typing.ClassVar['TiffCompression'] = ...
    GROUP_3_FAX: typing.ClassVar['TiffCompression'] = ...
    GROUP_4_FAX: typing.ClassVar['TiffCompression'] = ...
    LZW: typing.ClassVar['TiffCompression'] = ...
    OLD_JPEG: typing.ClassVar['TiffCompression'] = ...
    JPEG: typing.ClassVar['TiffCompression'] = ...
    PACK_BITS: typing.ClassVar['TiffCompression'] = ...
    PROPRIETARY_DEFLATE: typing.ClassVar['TiffCompression'] = ...
    DEFLATE: typing.ClassVar['TiffCompression'] = ...
    THUNDERSCAN: typing.ClassVar['TiffCompression'] = ...
    JPEG_2000: typing.ClassVar['TiffCompression'] = ...
    JPEG_2000_LOSSY: typing.ClassVar['TiffCompression'] = ...
    ALT_JPEG2000: typing.ClassVar['TiffCompression'] = ...
    ALT_JPEG: typing.ClassVar['TiffCompression'] = ...
    OLYMPUS_JPEG2000: typing.ClassVar['TiffCompression'] = ...
    NIKON: typing.ClassVar['TiffCompression'] = ...
    LURAWAVE: typing.ClassVar['TiffCompression'] = ...
    JPEGXR: typing.ClassVar['TiffCompression'] = ...
    def compress(self, byteArray: typing.List[int], codecOptions: bioformats_jar._loci.formats.codec.CodecOptions) -> typing.List[int]: ...
    def decompress(self, byteArray: typing.List[int], codecOptions: bioformats_jar._loci.formats.codec.CodecOptions) -> typing.List[int]: ...
    @staticmethod
    def difference(byteArray: typing.List[int], iFD: IFD) -> None: ...
    @staticmethod
    def get(int: int) -> 'TiffCompression': ...
    def getCode(self) -> int: ...
    def getCodecName(self) -> java.lang.String: ...
    @typing.overload
    def getCompressionCodecOptions(self, iFD: IFD) -> bioformats_jar._loci.formats.codec.CodecOptions: ...
    @typing.overload
    def getCompressionCodecOptions(self, iFD: IFD, codecOptions: bioformats_jar._loci.formats.codec.CodecOptions) -> bioformats_jar._loci.formats.codec.CodecOptions: ...
    @staticmethod
    def undifference(byteArray: typing.List[int], iFD: IFD) -> None: ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'TiffCompression': ...
    @staticmethod
    def values() -> typing.List['TiffCompression']: ...

class TiffConstants:
    BYTES_PER_ENTRY: typing.ClassVar[int] = ...
    BIG_TIFF_BYTES_PER_ENTRY: typing.ClassVar[int] = ...
    MAGIC_NUMBER: typing.ClassVar[int] = ...
    BIG_TIFF_MAGIC_NUMBER: typing.ClassVar[int] = ...
    LITTLE: typing.ClassVar[int] = ...
    BIG: typing.ClassVar[int] = ...

class TiffIFDEntry(java.lang.Comparable[typing.Any]):
    def __init__(self, int: int, iFDType: IFDType, int2: int, long: int): ...
    def compareTo(self, object: typing.Any) -> int: ...
    def getTag(self) -> int: ...
    def getType(self) -> IFDType: ...
    def getValueCount(self) -> int: ...
    def getValueOffset(self) -> int: ...
    def toString(self) -> java.lang.String: ...

class TiffParser(java.io.Closeable):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream): ...
    def checkHeader(self) -> bool: ...
    def close(self) -> None: ...
    def fillInIFD(self, iFD: IFD) -> None: ...
    def getCodecOptions(self) -> bioformats_jar._loci.formats.codec.CodecOptions: ...
    def getColorMap(self, iFD: IFD) -> typing.List[int]: ...
    def getComment(self) -> java.lang.String: ...
    def getExifIFDs(self) -> IFDList: ...
    def getFirstIFD(self) -> IFD: ...
    def getFirstIFDEntry(self, int: int) -> TiffIFDEntry: ...
    def getFirstOffset(self) -> int: ...
    def getIFD(self, long: int) -> IFD: ...
    def getIFDOffsets(self) -> typing.List[int]: ...
    def getIFDValue(self, tiffIFDEntry: TiffIFDEntry) -> typing.Any: ...
    def getIFDs(self) -> IFDList: ...
    def getMainIFDs(self) -> IFDList: ...
    def getNonThumbnailIFDs(self) -> IFDList: ...
    @typing.overload
    def getSamples(self, iFD: IFD, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def getSamples(self, iFD: IFD, byteArray: typing.List[int], int: int, int2: int, long: int, long2: int) -> typing.List[int]: ...
    @typing.overload
    def getSamples(self, iFD: IFD, byteArray: typing.List[int], int: int, int2: int, long: int, long2: int, int3: int, int4: int) -> typing.List[int]: ...
    def getStream(self) -> bioformats_jar._loci.common.RandomAccessInputStream: ...
    def getSubIFDs(self, iFD: IFD) -> IFDList: ...
    def getThumbnailIFDs(self) -> IFDList: ...
    def getTile(self, iFD: IFD, byteArray: typing.List[int], int: int, int2: int) -> typing.List[int]: ...
    def isBigTiff(self) -> bool: ...
    def isValidHeader(self) -> bool: ...
    def setAssumeEqualStrips(self, boolean: bool) -> None: ...
    def setCodecOptions(self, codecOptions: bioformats_jar._loci.formats.codec.CodecOptions) -> None: ...
    def setDoCaching(self, boolean: bool) -> None: ...
    def setUse64BitOffsets(self, boolean: bool) -> None: ...
    def setYCbCrCorrection(self, boolean: bool) -> None: ...
    @staticmethod
    def unpackBytes(byteArray: typing.List[int], int: int, byteArray2: typing.List[int], iFD: IFD) -> None: ...

class TiffRational(java.lang.Number, java.lang.Comparable['TiffRational']):
    def __init__(self, long: int, long2: int): ...
    def byteValue(self) -> int: ...
    def compareTo(self, tiffRational: 'TiffRational') -> int: ...
    def doubleValue(self) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    def floatValue(self) -> float: ...
    def getDenominator(self) -> int: ...
    def getNumerator(self) -> int: ...
    def hashCode(self) -> int: ...
    def intValue(self) -> int: ...
    def longValue(self) -> int: ...
    def reduce(self) -> None: ...
    def shortValue(self) -> int: ...
    def toString(self) -> java.lang.String: ...

class TiffSaver(java.io.Closeable):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, randomAccessOutputStream: bioformats_jar._loci.common.RandomAccessOutputStream, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, randomAccessOutputStream: bioformats_jar._loci.common.RandomAccessOutputStream, byteArrayHandle: bioformats_jar._loci.common.ByteArrayHandle): ...
    def close(self) -> None: ...
    def getStream(self) -> bioformats_jar._loci.common.RandomAccessOutputStream: ...
    def isBigTiff(self) -> bool: ...
    def isLittleEndian(self) -> bool: ...
    def overwriteComment(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, object: typing.Any) -> None: ...
    def overwriteIFDOffset(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, long: int, long2: int) -> None: ...
    @typing.overload
    def overwriteIFDValue(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, int: int, int2: int, object: typing.Any) -> None: ...
    @typing.overload
    def overwriteIFDValue(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, long: int, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def overwriteIFDValue(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, long: int, int: int, object: typing.Any, boolean: bool) -> None: ...
    def overwriteLastIFDOffset(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> None: ...
    def setBigTiff(self, boolean: bool) -> None: ...
    def setCodecOptions(self, codecOptions: bioformats_jar._loci.formats.codec.CodecOptions) -> None: ...
    def setLittleEndian(self, boolean: bool) -> None: ...
    def setWritingSequentially(self, boolean: bool) -> None: ...
    def writeHeader(self) -> None: ...
    def writeIFD(self, iFD: IFD, long: int) -> None: ...
    def writeIFDValue(self, randomAccessOutputStream: bioformats_jar._loci.common.RandomAccessOutputStream, long: int, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def writeImage(self, byteArray: typing.List[int], iFD: IFD, int: int, int2: int, boolean: bool) -> None: ...
    @typing.overload
    def writeImage(self, byteArray: typing.List[int], iFD: IFD, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, boolean: bool) -> None: ...
    @typing.overload
    def writeImage(self, byteArray: typing.List[int], iFD: IFD, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, boolean: bool, integer: int, boolean2: bool) -> None: ...
    @typing.overload
    def writeImage(self, byteArray: typing.List[typing.List[int]], iFDList: IFDList, int: int) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.formats.tiff")``.

    IFD: typing.Type[IFD]
    IFDList: typing.Type[IFDList]
    IFDType: typing.Type[IFDType]
    OnDemandLongArray: typing.Type[OnDemandLongArray]
    PhotoInterp: typing.Type[PhotoInterp]
    TiffCompression: typing.Type[TiffCompression]
    TiffConstants: typing.Type[TiffConstants]
    TiffIFDEntry: typing.Type[TiffIFDEntry]
    TiffParser: typing.Type[TiffParser]
    TiffRational: typing.Type[TiffRational]
    TiffSaver: typing.Type[TiffSaver]
