import java.lang
import java.util
import bioformats_jar._loci.formats
import typing



class CacheEvent:
    SOURCE_CHANGED: typing.ClassVar[int] = ...
    STRATEGY_CHANGED: typing.ClassVar[int] = ...
    POSITION_CHANGED: typing.ClassVar[int] = ...
    PRIORITIES_CHANGED: typing.ClassVar[int] = ...
    ORDER_CHANGED: typing.ClassVar[int] = ...
    RANGE_CHANGED: typing.ClassVar[int] = ...
    OBJECT_LOADED: typing.ClassVar[int] = ...
    OBJECT_DROPPED: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, object: typing.Any, int: int): ...
    @typing.overload
    def __init__(self, object: typing.Any, int: int, int2: int): ...
    def getIndex(self) -> int: ...
    def getSource(self) -> typing.Any: ...
    def getType(self) -> int: ...
    def toString(self) -> java.lang.String: ...

class CacheException(loci.formats.FormatException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class CacheListener:
    def cacheUpdated(self, cacheEvent: CacheEvent) -> None: ...

class CacheReporter:
    def addCacheListener(self, cacheListener: CacheListener) -> None: ...
    def getCacheListeners(self) -> typing.List[CacheListener]: ...
    def removeCacheListener(self, cacheListener: CacheListener) -> None: ...

class CacheUpdater(java.lang.Thread):
    def __init__(self, cache: 'Cache'): ...
    def quit(self) -> None: ...
    def run(self) -> None: ...

class ICacheSource:
    def getObject(self, int: int) -> typing.Any: ...
    def getObjectCount(self) -> int: ...

class Cache(CacheReporter):
    def __init__(self, iCacheStrategy: 'ICacheStrategy', iCacheSource: ICacheSource, boolean: bool): ...
    def addCacheListener(self, cacheListener: CacheListener) -> None: ...
    def getCacheListeners(self) -> typing.List[CacheListener]: ...
    def getCurrentPos(self) -> typing.List[int]: ...
    def getObject(self, intArray: typing.List[int]) -> typing.Any: ...
    def getSource(self) -> ICacheSource: ...
    def getStrategy(self) -> 'ICacheStrategy': ...
    @typing.overload
    def isInCache(self, int: int) -> bool: ...
    @typing.overload
    def isInCache(self, intArray: typing.List[int]) -> bool: ...
    @typing.overload
    def recache(self) -> None: ...
    @typing.overload
    def recache(self, int: int) -> None: ...
    def removeCacheListener(self, cacheListener: CacheListener) -> None: ...
    def reset(self) -> None: ...
    def setCurrentPos(self, intArray: typing.List[int]) -> None: ...
    def setSource(self, iCacheSource: ICacheSource) -> None: ...
    def setStrategy(self, iCacheStrategy: 'ICacheStrategy') -> None: ...

class CacheSource(ICacheSource):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, iFormatReader: bioformats_jar._loci.formats.IFormatReader): ...
    def getObject(self, int: int) -> typing.Any: ...
    def getObjectCount(self) -> int: ...

class ICacheStrategy(CacheReporter):
    MIN_PRIORITY: typing.ClassVar[int] = ...
    LOW_PRIORITY: typing.ClassVar[int] = ...
    NORMAL_PRIORITY: typing.ClassVar[int] = ...
    HIGH_PRIORITY: typing.ClassVar[int] = ...
    MAX_PRIORITY: typing.ClassVar[int] = ...
    CENTERED_ORDER: typing.ClassVar[int] = ...
    FORWARD_ORDER: typing.ClassVar[int] = ...
    BACKWARD_ORDER: typing.ClassVar[int] = ...
    def getLengths(self) -> typing.List[int]: ...
    def getLoadList(self, intArray: typing.List[int]) -> typing.List[typing.List[int]]: ...
    def getOrder(self) -> typing.List[int]: ...
    def getPriorities(self) -> typing.List[int]: ...
    def getRange(self) -> typing.List[int]: ...
    def setOrder(self, int: int, int2: int) -> None: ...
    def setPriority(self, int: int, int2: int) -> None: ...
    def setRange(self, int: int, int2: int) -> None: ...

class ByteArraySource(CacheSource):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, iFormatReader: bioformats_jar._loci.formats.IFormatReader): ...
    def getObject(self, int: int) -> typing.Any: ...

class CacheStrategy(CacheReporter, java.util.Comparator, ICacheStrategy):
    DEFAULT_RANGE: typing.ClassVar[int] = ...
    def __init__(self, intArray: typing.List[int]): ...
    def addCacheListener(self, cacheListener: CacheListener) -> None: ...
    def compare(self, object: typing.Any, object2: typing.Any) -> int: ...
    def distance(self, int: int, int2: int) -> int: ...
    def getCacheListeners(self) -> typing.List[CacheListener]: ...
    def getLengths(self) -> typing.List[int]: ...
    def getLoadList(self, intArray: typing.List[int]) -> typing.List[typing.List[int]]: ...
    def getOrder(self) -> typing.List[int]: ...
    def getPriorities(self) -> typing.List[int]: ...
    def getRange(self) -> typing.List[int]: ...
    def removeCacheListener(self, cacheListener: CacheListener) -> None: ...
    def setOrder(self, int: int, int2: int) -> None: ...
    def setPriority(self, int: int, int2: int) -> None: ...
    def setRange(self, int: int, int2: int) -> None: ...

class CrosshairStrategy(CacheStrategy):
    def __init__(self, intArray: typing.List[int]): ...

class RectangleStrategy(CacheStrategy):
    def __init__(self, intArray: typing.List[int]): ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.formats.cache")``.

    ByteArraySource: typing.Type[ByteArraySource]
    Cache: typing.Type[Cache]
    CacheEvent: typing.Type[CacheEvent]
    CacheException: typing.Type[CacheException]
    CacheListener: typing.Type[CacheListener]
    CacheReporter: typing.Type[CacheReporter]
    CacheSource: typing.Type[CacheSource]
    CacheStrategy: typing.Type[CacheStrategy]
    CacheUpdater: typing.Type[CacheUpdater]
    CrosshairStrategy: typing.Type[CrosshairStrategy]
    ICacheSource: typing.Type[ICacheSource]
    ICacheStrategy: typing.Type[ICacheStrategy]
    RectangleStrategy: typing.Type[RectangleStrategy]
