import java.io
import java.lang
import typing



class DependencyException(java.lang.Exception):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], class_: typing.Type['Service']): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], class_: typing.Type['Service'], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...
    def getFailureClass(self) -> typing.Type['Service']: ...
    def toString(self) -> java.lang.String: ...

class S3ClientStat:
    def length(self) -> int: ...

class Service: ...

class ServiceException(java.lang.Exception):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class ServiceFactory:
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    _getInstance__T = typing.TypeVar('_getInstance__T', bound=Service)  # <T>
    def getInstance(self, class_: typing.Type[_getInstance__T]) -> _getInstance__T: ...

class AbstractService(Service):
    def __init__(self): ...

class S3ClientService(Service):
    def bucketExists(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def getObject(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], long: int) -> java.io.InputStream: ...
    @typing.overload
    def getObject(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> None: ...
    def initialize(self, string: typing.Union[java.lang.String, str], int: int, string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], string4: typing.Union[java.lang.String, str], string5: typing.Union[java.lang.String, str]) -> None: ...
    def statObject(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> S3ClientStat: ...

class S3ClientServiceException(ServiceException):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class S3ClientServiceImpl(AbstractService, S3ClientService):
    def __init__(self): ...
    def bucketExists(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def getObject(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], long: int) -> java.io.InputStream: ...
    @typing.overload
    def getObject(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> None: ...
    def initialize(self, string: typing.Union[java.lang.String, str], int: int, string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], string4: typing.Union[java.lang.String, str], string5: typing.Union[java.lang.String, str]) -> None: ...
    def statObject(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> S3ClientStat: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.common.services")``.

    AbstractService: typing.Type[AbstractService]
    DependencyException: typing.Type[DependencyException]
    S3ClientService: typing.Type[S3ClientService]
    S3ClientServiceException: typing.Type[S3ClientServiceException]
    S3ClientServiceImpl: typing.Type[S3ClientServiceImpl]
    S3ClientStat: typing.Type[S3ClientStat]
    Service: typing.Type[Service]
    ServiceException: typing.Type[ServiceException]
    ServiceFactory: typing.Type[ServiceFactory]
