/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.ZlibCodec;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.MDBService;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;

public class CellomicsReader
extends FormatReader {
    public static final int C01_MAGIC_BYTES = 16;
    private static final Pattern PATTERN_O = Pattern.compile("(.*)_(\\p{Alpha}\\d{2})(f\\d{2,3})?(o\\d+)?[^_]+$");
    private static final Pattern PATTERN_D = Pattern.compile("(.*)_(\\p{Alpha}\\d{2})(f\\d{2,3})?(d\\d+)?[^_]+$");
    private Pattern cellomicsPattern;
    private ArrayList<ChannelFile> files = new ArrayList();
    private ArrayList<String> metadataFiles = new ArrayList();

    public CellomicsReader() {
        super("Cellomics C01", new String[]{"c01", "dib"});
        this.domains = new String[]{"Light Microscopy", "High-Content Screening (HCS)"};
        this.datasetDescription = "One or more .c01 files";
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == 16;
    }

    @Override
    public String[] getDomains() {
        FormatTools.assertId(this.currentId, true, 1);
        return new String[]{"High-Content Screening (HCS)"};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int[] zct = this.getZCTCoords(no);
        ChannelFile file2 = this.lookupFile(this.getSeries(), zct[1]);
        if (file2 != null && file2.filename != null) {
            LOGGER.trace("series {} #{} reading from {}", this.getSeries(), no, file2.filename);
            try (RandomAccessInputStream s2 = this.getDecompressedStream(file2.filename);){
                int planeSize = FormatTools.getPlaneSize(this);
                s2.seek(52 + zct[0] * planeSize);
                this.readPlane(s2, x, y, w, h2, buf);
            }
        } else {
            Arrays.fill(buf, (byte)0);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.files.clear();
            this.cellomicsPattern = null;
            this.metadataFiles.clear();
        }
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return this.metadataFiles.toArray(new String[this.metadataFiles.size()]);
        }
        ArrayList<String> seriesFiles = new ArrayList<String>();
        for (int c = 0; c < this.getSizeC(); ++c) {
            ChannelFile f = this.lookupFile(this.getSeries(), c);
            if (f == null || f.filename == null) continue;
            seriesFiles.add(f.filename);
        }
        seriesFiles.addAll(this.metadataFiles);
        return seriesFiles.toArray(new String[seriesFiles.size()]);
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return this.metadataFiles.toArray(new String[this.metadataFiles.size()]);
        }
        ArrayList<String> allFiles = new ArrayList<String>();
        for (ChannelFile f : this.files) {
            allFiles.add(f.filename);
        }
        allFiles.addAll(this.metadataFiles);
        return allFiles.toArray(new String[allFiles.size()]);
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        Time[] exposureTimes;
        String[] channelNames;
        Color[] channelColors;
        int pixelHeight;
        int pixelWidth;
        short nBits;
        short nPlanes;
        int y;
        int x;
        ArrayList<Integer> uniqueChannels;
        ArrayList<Integer> uniqueFields;
        int wellColumns;
        int wellRows;
        String plateName;
        block47: {
            super.initFile(id);
            Location baseFile = new Location(id).getAbsoluteFile();
            Location parent = baseFile.getParentFile();
            ArrayList<String> pixelFiles = new ArrayList<String>();
            plateName = this.getPlateName(baseFile.getName());
            String mdbFile = null;
            if (plateName != null && this.isGroupFiles()) {
                String[] list;
                for (String f : list = parent.list()) {
                    boolean hasPlateName = plateName.equals(this.getPlateName(f));
                    Location loc = new Location(parent, f);
                    if (hasPlateName && (CellomicsReader.checkSuffix(f, "c01") || CellomicsReader.checkSuffix(f, "dib"))) {
                        if (f.startsWith(".") && loc.isHidden() || this.getChannel(f) < 0) continue;
                        pixelFiles.add(loc.getAbsolutePath());
                        continue;
                    }
                    if (!hasPlateName) continue;
                    this.metadataFiles.add(loc.getAbsolutePath());
                    if (!CellomicsReader.checkSuffix(f, "mdb")) continue;
                    mdbFile = loc.getAbsolutePath();
                }
            } else {
                pixelFiles.add(id);
            }
            String[] filenames = pixelFiles.toArray(new String[pixelFiles.size()]);
            Arrays.sort(filenames, new Comparator<String>(){

                @Override
                public int compare(String f1, String f2) {
                    int wellRow1 = CellomicsReader.this.getWellRow(f1);
                    int wellCol1 = CellomicsReader.this.getWellColumn(f1);
                    int field1 = CellomicsReader.this.getField(f1);
                    int channel1 = CellomicsReader.this.getChannel(f1);
                    int wellRow2 = CellomicsReader.this.getWellRow(f2);
                    int wellCol2 = CellomicsReader.this.getWellColumn(f2);
                    int field2 = CellomicsReader.this.getField(f2);
                    int channel2 = CellomicsReader.this.getChannel(f2);
                    if (wellRow1 < wellRow2) {
                        return -1;
                    }
                    if (wellRow1 > wellRow2) {
                        return 1;
                    }
                    if (wellCol1 < wellCol2) {
                        return -1;
                    }
                    if (wellCol1 > wellCol2) {
                        return 1;
                    }
                    if (field1 < field2) {
                        return -1;
                    }
                    if (field1 > field2) {
                        return 1;
                    }
                    return channel1 - channel2;
                }
            });
            wellRows = 0;
            wellColumns = 0;
            int fields = 0;
            ArrayList<Integer> uniqueRows = new ArrayList<Integer>();
            ArrayList<Integer> uniqueCols = new ArrayList<Integer>();
            uniqueFields = new ArrayList<Integer>();
            uniqueChannels = new ArrayList<Integer>();
            for (String f : filenames) {
                int wellRow = this.getWellRow(f);
                int wellCol = this.getWellColumn(f);
                int field = this.getField(f);
                int channel = this.getChannel(f);
                if (!uniqueRows.contains(wellRow)) {
                    uniqueRows.add(wellRow);
                }
                if (!uniqueCols.contains(wellCol)) {
                    uniqueCols.add(wellCol);
                }
                if (!uniqueFields.contains(field)) {
                    uniqueFields.add(field);
                }
                if (!uniqueChannels.contains(channel)) {
                    uniqueChannels.add(channel);
                }
                this.files.add(new ChannelFile(f, wellRow, wellCol, field, channel));
                wellRows = Math.max(wellRows, wellRow);
                wellColumns = Math.max(wellColumns, wellCol);
            }
            fields = uniqueFields.size();
            for (int file2 = 0; file2 < this.files.size(); ++file2) {
                ChannelFile f = this.files.get(file2);
                f.series = file2 / uniqueChannels.size();
                f.channel = uniqueChannels.indexOf(f.channel);
            }
            this.core.clear();
            int seriesCount = this.files.size();
            if (uniqueChannels.size() > 0) {
                seriesCount /= uniqueChannels.size();
            }
            for (int i = 0; i < seriesCount; ++i) {
                this.core.add(new CoreMetadata());
            }
            this.in = this.getDecompressedStream(id);
            LOGGER.info("Reading header data");
            this.in.order(true);
            this.in.skipBytes(4);
            x = this.in.readInt();
            y = this.in.readInt();
            nPlanes = this.in.readShort();
            nBits = this.in.readShort();
            int compression = this.in.readInt();
            if ((long)(x * y * nPlanes * (nBits / 8) + 52) > this.in.length()) {
                throw new UnsupportedCompressionException("Compressed pixel data is not yet supported.");
            }
            this.in.skipBytes(4);
            pixelWidth = 0;
            pixelHeight = 0;
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                pixelWidth = this.in.readInt();
                pixelHeight = this.in.readInt();
                int colorUsed = this.in.readInt();
                int colorImportant = this.in.readInt();
                LOGGER.info("Populating metadata hashtable");
                this.addGlobalMeta("Image width", x);
                this.addGlobalMeta("Image height", y);
                this.addGlobalMeta("Number of planes", (int)nPlanes);
                this.addGlobalMeta("Bits per pixel", (int)nBits);
                this.addGlobalMeta("Compression", compression);
                this.addGlobalMeta("Pixels per meter (X)", pixelWidth);
                this.addGlobalMeta("Pixels per meter (Y)", pixelHeight);
                this.addGlobalMeta("Color used", colorUsed);
                this.addGlobalMeta("Color important", colorImportant);
            }
            channelColors = new Color[uniqueChannels.size()];
            channelNames = new String[uniqueChannels.size()];
            exposureTimes = new Time[uniqueChannels.size()];
            if (mdbFile != null) {
                try (MDBService mdb = null;){
                    ServiceFactory factory = new ServiceFactory();
                    mdb = factory.getInstance(MDBService.class);
                    mdb.initialize(mdbFile);
                    Vector<String[]> table = mdb.parseTable("asnProtocolChannel");
                    if (table == null) break block47;
                    Object[] header = table.get(0);
                    int nameColumn = DataTools.indexOf(header, "Name");
                    int exposureTimeColumn = DataTools.indexOf(header, "ExposureTime");
                    int colorColumn = DataTools.indexOf(header, "CompositeColor");
                    for (int r = 1; r < table.size(); ++r) {
                        String[] row = table.get(r);
                        if (nameColumn >= 0) {
                            channelNames[r - 1] = row[nameColumn];
                        }
                        if (colorColumn >= 0) {
                            try {
                                int color = Integer.parseInt(row[colorColumn]);
                                int blue = color >> 16 & 0xFF;
                                int green = color >> 8 & 0xFF;
                                int red = color & 0xFF;
                                channelColors[r - 1] = new Color(red, green, blue, 255);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.debug("Could not parse channel color " + row[colorColumn], e);
                            }
                        }
                        if (exposureTimeColumn < 0) continue;
                        try {
                            double exposure = DataTools.parseDouble(row[exposureTimeColumn]);
                            exposureTimes[r - 1] = FormatTools.getTime(exposure, null);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse exposure time " + row[exposureTimeColumn], e);
                        }
                    }
                }
            }
        }
        LOGGER.info("Populating core metadata");
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            ms.sizeX = x;
            ms.sizeY = y;
            ms.sizeZ = nPlanes;
            ms.sizeT = 1;
            ms.sizeC = uniqueChannels.size();
            ms.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
            ms.littleEndian = true;
            ms.dimensionOrder = "XYCZT";
            ms.pixelType = FormatTools.pixelTypeFromBytes(nBits / 8, false, false);
        }
        LOGGER.info("Populating metadata store");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        store.setPlateID(MetadataTools.createLSID("Plate", 0), 0);
        store.setPlateName(plateName, 0);
        store.setPlateRowNamingConvention(NamingConvention.LETTER, 0);
        store.setPlateColumnNamingConvention(NamingConvention.NUMBER, 0);
        int realRows = wellRows + 1;
        int realCols = wellColumns + 1;
        if (this.getSeriesCount() == 1) {
            realRows = 1;
            realCols = 1;
        } else if (realRows <= 8 && realCols <= 12) {
            realRows = 8;
            realCols = 12;
        } else {
            realRows = 16;
            realCols = 24;
        }
        store.setPlateRows(new PositiveInteger(realRows), 0);
        store.setPlateColumns(new PositiveInteger(realCols), 0);
        for (int row = 0; row < realRows; ++row) {
            for (int col = 0; col < realCols; ++col) {
                int well = row * realCols + col;
                if (this.getSeriesCount() == 1) {
                    row = this.files.get((int)0).row;
                    col = this.files.get((int)0).col;
                }
                store.setWellID(MetadataTools.createLSID("Well", 0, well), 0, well);
                store.setWellRow(new NonNegativeInteger(row), 0, well);
                store.setWellColumn(new NonNegativeInteger(col), 0, well);
            }
        }
        int image = 0;
        for (int s2 = 0; s2 < this.getSeriesCount(); ++s2) {
            ChannelFile file3 = null;
            for (int c = 0; file3 == null && c < this.getEffectiveSizeC(); ++c) {
                file3 = this.lookupFile(s2, c);
            }
            int row = file3.row;
            int col = file3.col;
            int field = file3.field;
            int fieldIndex = uniqueFields.indexOf(field);
            store.setImageName(String.format("Well %s%02d, Field #%02d", new String(Character.toChars(row + 65)), col + 1, field), image);
            if (this.getSeriesCount() == 1) {
                row = 0;
                col = 0;
            }
            String imageID = MetadataTools.createLSID("Image", image);
            store.setImageID(imageID, image);
            if (row < realRows && col < realCols) {
                int wellIndex = row * realCols + col;
                String wellSampleID = MetadataTools.createLSID("WellSample", 0, wellIndex, fieldIndex);
                store.setWellSampleID(wellSampleID, 0, wellIndex, fieldIndex);
                store.setWellSampleIndex(new NonNegativeInteger(image), 0, wellIndex, fieldIndex);
                store.setWellSampleImageRef(imageID, 0, wellIndex, fieldIndex);
            }
            ++image;
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            double width = pixelWidth == 0 ? 0.0 : 1000000.0 / (double)pixelWidth;
            double height = pixelHeight == 0 ? 0.0 : 1000000.0 / (double)pixelHeight;
            Length sizeX = FormatTools.getPhysicalSizeX(width);
            Length sizeY = FormatTools.getPhysicalSizeY(height);
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                if (sizeX != null) {
                    store.setPixelsPhysicalSizeX(sizeX, i);
                }
                if (sizeY != null) {
                    store.setPixelsPhysicalSizeY(sizeY, i);
                }
                for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                    if (channelNames[c] != null) {
                        store.setChannelName(channelNames[c], i, c);
                    }
                    if (channelColors[c] == null) continue;
                    store.setChannelColor(channelColors[c], i, c);
                }
                for (int p = 0; p < this.getImageCount(); ++p) {
                    int[] zct = this.getZCTCoords(p);
                    if (exposureTimes[zct[1]] == null) continue;
                    store.setPlaneExposureTime(exposureTimes[zct[1]], i, p);
                }
            }
        }
    }

    private Matcher matchFilename(String filename) {
        String name = new Location(filename).getName();
        if (this.cellomicsPattern == null) {
            Matcher m3 = PATTERN_O.matcher(name);
            if (m3.matches() && m3.group(4) != null) {
                this.cellomicsPattern = PATTERN_O;
                return m3;
            }
            this.cellomicsPattern = PATTERN_D;
        }
        return this.cellomicsPattern.matcher(name);
    }

    private String getPlateName(String filename) {
        Matcher m3 = this.matchFilename(filename);
        if (m3.matches()) {
            return m3.group(1);
        }
        if (CellomicsReader.checkSuffix(filename, this.suffixes)) {
            return null;
        }
        int lastDot = filename.lastIndexOf(".");
        if (lastDot < 0) {
            lastDot = filename.length();
        }
        return filename.substring(0, lastDot);
    }

    private String getWellName(String filename) {
        Matcher m3 = this.matchFilename(filename);
        if (m3.matches()) {
            return m3.group(2);
        }
        return null;
    }

    private int getWellRow(String filename) {
        String wellName = this.getWellName(filename);
        if (wellName == null || wellName.length() < 1) {
            return 0;
        }
        int ord = wellName.toUpperCase().charAt(0) - 65;
        if (ord < 0 || ord >= 26) {
            return 0;
        }
        return ord;
    }

    private int getWellColumn(String filename) {
        String wellName = this.getWellName(filename);
        if (wellName == null || wellName.length() <= 2) {
            return 0;
        }
        if (!Character.isDigit(wellName.charAt(1))) {
            return 0;
        }
        if (!Character.isDigit(wellName.charAt(2))) {
            return 0;
        }
        return Integer.parseInt(wellName.substring(1, 3)) - 1;
    }

    private int getField(String filename) {
        Matcher m3 = this.matchFilename(filename);
        if (m3.matches() && m3.group(3) != null) {
            return Integer.parseInt(m3.group(3).substring(1));
        }
        return 0;
    }

    private int getChannel(String filename) {
        Matcher m3 = this.matchFilename(filename);
        if (m3.matches() && m3.group(4) != null) {
            return Integer.parseInt(m3.group(4).substring(1));
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessInputStream getDecompressedStream(String filename) throws FormatException, IOException {
        RandomAccessInputStream s2 = new RandomAccessInputStream(filename);
        if (CellomicsReader.checkSuffix(filename, "c01")) {
            LOGGER.info("Decompressing file");
            try {
                s2.seek(4L);
                ZlibCodec codec = new ZlibCodec();
                byte[] file2 = codec.decompress(s2, null);
                RandomAccessInputStream randomAccessInputStream = new RandomAccessInputStream(file2);
                return randomAccessInputStream;
            }
            finally {
                s2.close();
            }
        }
        return s2;
    }

    private ChannelFile lookupFile(int seriesIndex, int channel) {
        for (ChannelFile f : this.files) {
            if (f.series != seriesIndex || f.channel != channel) continue;
            return f;
        }
        return null;
    }

    class ChannelFile {
        public String filename;
        public int row;
        public int col;
        public int field;
        public int channel;
        public int series;

        public ChannelFile(String filename, int row, int col, int field, int channel) {
            this.filename = filename;
            this.row = row;
            this.col = col;
            this.field = field;
            this.channel = channel;
        }
    }
}

