/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.MissingLibraryException;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;
import loci.formats.services.JPEGXRService;

public class JPEGXRCodec
extends BaseCodec {
    private JPEGXRService service;

    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new UnsupportedCompressionException("JPEG-XR compression not supported");
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        byte[] buf = new byte[(int)in.length()];
        in.read(buf);
        return this.decompress(buf, options);
    }

    @Override
    public byte[] decompress(byte[] buf, CodecOptions options) throws FormatException {
        this.initialize();
        int bpp = options.bitsPerSample / 8;
        int pixels = options.width * options.height;
        byte[] uncompressed = this.service.decompress(buf);
        int channels = uncompressed.length / (pixels * bpp);
        if (channels == 1 || options.interleaved) {
            return uncompressed;
        }
        byte[] deinterleaved = new byte[uncompressed.length];
        for (int p = 0; p < pixels; ++p) {
            for (int c = 0; c < channels; ++c) {
                for (int b = 0; b < bpp; ++b) {
                    int bb = options.littleEndian ? b : bpp - b - 1;
                    int src = bpp * (p * channels + c) + b;
                    int dest = bpp * (c * pixels + p) + bb;
                    deinterleaved[dest] = uncompressed[src];
                }
            }
        }
        return deinterleaved;
    }

    private void initialize() throws FormatException {
        if (this.service != null) {
            return;
        }
        try {
            ServiceFactory factory = new ServiceFactory();
            this.service = factory.getInstance(JPEGXRService.class);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException("JPEG-XR library not available", e);
        }
    }
}

