import { DockerImageAssetLocation, DockerImageAssetSource, FileAssetLocation, FileAssetSource, ISynthesisSession, Stack, StackSynthesizer } from 'aws-cdk-lib';
export * from './aspect';
/**
 * Configuration properties for BootstraplessStackSynthesizer
 */
export interface BootstraplessStackSynthesizerProps {
    /**
     * Name of the S3 bucket to hold file assets
     *
     * You must supply this if you have given a non-standard name to the staging bucket.
     *
     * The placeholders `${AWS::AccountId}` and `${AWS::Region}` will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     *
     * @required if you have file assets
     * @default - process.env.BSS_FILE_ASSET_BUCKET_NAME
     */
    readonly fileAssetBucketName?: string;
    /**
     * Name of the ECR repository to hold Docker Image assets
     *
     * You must supply this if you have given a non-standard name to the ECR repository.
     *
     * The placeholders `${AWS::AccountId}` and `${AWS::Region}` will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     *
     * @required if you have docker image assets
     * @default - process.env.BSS_IMAGE_ASSET_REPOSITORY_NAME
     */
    readonly imageAssetRepositoryName?: string;
    /**
     * The role to use to publish file assets to the S3 bucket in this environment
     *
     * You must supply this if you have given a non-standard name to the publishing role.
     *
     * The placeholders `${AWS::AccountId}` and `${AWS::Region}` will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     *
     * @default - process.env.BSS_FILE_ASSET_PUBLISHING_ROLE_ARN
     */
    readonly fileAssetPublishingRoleArn?: string;
    /**
     * The role to use to publish image assets to the ECR repository in this environment
     *
     * You must supply this if you have given a non-standard name to the publishing role.
     *
     * The placeholders `${AWS::AccountId}` and `${AWS::Region}` will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     *
     * @default - process.env.BSS_IMAGE_ASSET_PUBLISHING_ROLE_ARN
     */
    readonly imageAssetPublishingRoleArn?: string;
    /**
     * Object key prefix to use while storing S3 Assets
     *
     * @default - process.env.BSS_FILE_ASSET_PREFIX
     */
    readonly fileAssetPrefix?: string;
    /**
     * The regions set of file assets to be published only when `fileAssetBucketName` contains `${AWS::Region}`
     *
     * For examples:
     * `['us-east-1', 'us-west-1']`
     *
     * @default - process.env.BSS_FILE_ASSET_REGION_SET // comma delimited list
     */
    readonly fileAssetRegionSet?: string[];
    /**
     * Override the name of the S3 bucket to hold Cloudformation template
     *
     * @default - process.env.BSS_TEMPLATE_BUCKET_NAME
     */
    readonly templateBucketName?: string;
    /**
     * Override the tag of the Docker Image assets
     *
     * @default - process.env.BSS_IMAGE_ASSET_TAG_PREFIX
     */
    readonly imageAssetTagPrefix?: string;
    /**
     * Override the ECR repository region of the Docker Image assets
     *
     * For examples:
     * `['us-east-1', 'us-west-1']`
     *
     * @default - process.env.BSS_IMAGE_ASSET_REGION_SET // comma delimited list
     */
    readonly imageAssetRegionSet?: string[];
    /**
     * Override the ECR repository account id of the Docker Image assets
     *
     * @default - process.env.BSS_IMAGE_ASSET_ACCOUNT_ID
     */
    readonly imageAssetAccountId?: string;
}
/**
 * A Bootstrapless stack synthesizer that is designated to generate templates
 * that can be directly used by Cloudformation
 */
export declare class BootstraplessStackSynthesizer extends StackSynthesizer {
    private _stack?;
    private bucketName?;
    private repositoryName?;
    private fileAssetPublishingRoleArn?;
    private imageAssetPublishingRoleArn?;
    private fileAssetPrefix?;
    private fileAssetRegionSet?;
    private templateBucketName?;
    private imageAssetTagPrefix?;
    private imageAssetRegionSet?;
    private imageAssetAccountId?;
    private readonly files;
    private readonly dockerImages;
    constructor(props?: BootstraplessStackSynthesizerProps);
    bind(stack: Stack): void;
    addFileAsset(asset: FileAssetSource): FileAssetLocation;
    private _addFileAsset;
    addDockerImageAsset(asset: DockerImageAssetSource): DockerImageAssetLocation;
    /**
     * Dumps current manifest into JSON format
     */
    dumps(): string;
    /**
     * Synthesize the associated stack to the session
     */
    synthesize(session: ISynthesisSession): void;
    protected get stack(): Stack | undefined;
    /**
     * Add the stack's template as one of the manifest assets
     *
     * This will make it get uploaded to S3 automatically by S3-assets. Return
     * the manifest URL.
     *
     * (We can't return the location returned from `addFileAsset`, as that
     * contains CloudFormation intrinsics which can't go into the manifest).
     */
    private addStackTemplateToAssetManifest;
    /**
     * Write an asset manifest to the Cloud Assembly, return the artifact IDs written
     */
    private writeAssetManifest;
    private get manifestEnvName();
}
