from typing import List

from ...representations import abstract_representation
from .abstract_operators import AbstractMutationOperator, AbstractMutator


class SplitAndSwap(AbstractMutationOperator):
    def __call__(self, representation: abstract_representation.RoadRepresentation, test):
        half = len(test) // 2
        return test[half:] + test[:half]


class ReverseTest(AbstractMutationOperator):
    def __call__(self, representation: abstract_representation.RoadRepresentation, test):
        return test[::-1]


class FlipSign(AbstractMutationOperator):
    def __call__(self, representation: abstract_representation.RoadRepresentation, test):
        return list(map(lambda x: x * -1.0, test))


class KappaFlipSign(AbstractMutationOperator):
    def __call__(self, representation: abstract_representation.RoadRepresentation, test):
        return list(map(lambda x: (x[0] * -1.0, x[1]), test))


class Exploiter(AbstractMutator):
    def __init__(self, operators: List[AbstractMutationOperator] = None):
        operators = operators or [  # default exploiters
            ReverseTest(),
            SplitAndSwap(),
            FlipSign(),
        ]
        super().__init__(operators)
