# Explanation of Configuration File

Explanation of config options:

| Field                       | Description                                                                                                                                                                                                                                     |
|-----------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `general/publish_interval`  | integer number from 1 and above. Tells how often send measurements. Keep in mind that if measurements from sensors come less often than this number connectivity sends last data                                                                |
| `general/db_path`           | path to the database (.db) file                                                                                                                                                                                                                 |
| `comstation/enable`         | true/false. Enabling/disabling the station                                                                                                                                                                                                      |
| `comstation/port`           | valid path to com port, for example `/dev/ttyUSB0`. It is where a sensor is connected to                                                                                                                                                        |
| `comstation/work_period`    | integer from 0 to 1800. For SDS011 sensor 0 means continuous work. Recommended period is 300 seconds                                                                                                                                            |
| `comstation/geo`            | `lat,lon` a string with two floats separated by a comma. It represents latitude and longitude of a sensor                                                                                                                                       |
| `comstation/public_key`     | Ed25519 verifying key in hex format. If not provided connectivity generates a new one                                                                                                                                                           |
| `httpstation/enable`        | true/false. Enabling/disabling the station                                                                                                                                                                                                      |
| `httpstation/port`          | what port listen to                                                                                                                                                                                                                             |
| `mqttstation/enable`        | true/false. Enabling/disabling the station                                                                                                                                                                                                      |
| `mqttstation/host`          | the hostname or IP address of the remote broker                                                                                                                                                                                                 |
| `mqttstation/port`          | the network port of the server host to connect to                                                                                                                                                                                               |
| `luftdaten/enable`          | true/false. Whether or not publish data to [Luftdaten](https://devices.sensor.community/). Don't forget to register the sensor's mac address on the site                                                                                        |
| `robonomics/enable`         | true/false. Whether or not publish data to IPFS topic according to Robonomics communication protocol                                                                                                                                            |
| `robonomics/ipfs_proveder`  | an endpoint for IPFS daemon. By default it's `/ip4/127.0.0.1/tcp/5001/http` that means local daemon. The endpoint must by in multiaddr format. For example for [Infura.io](https://infura.io/) it would be `/dns/ipfs.infura.io/tcp/5001/https` |
| `robonomics/ipfs_topic`     | IPFS topic's name. If you want to use [DApp](https://sensors.robonomics.network) provided by Robonomics team leave it untouched                                                                                                                 |
| `datalog/enable`            | true/false. Enable/Disable saving log to [Robonomics Parachain](https://polkadot.js.org/apps/?rpc=wss%3A%2F%2Fkusama.rpc.robonomics.network%2F#/explorer)                                                                                       |
| `datalog/suri`              | a private key from robonomics parachain account                                                                                                                                                                                                 |
| `datalog/dump_interval`     | specify a period of time for collecting log in seconds                                                                                                                                                                                          |
| `datalog/temporal_username` | set username to upload files to [Temporal.Cloud](https://temporal.cloud/) (Optional)                                                                                                                                                            |
| `detalog/temporal_password` | set password to upload files to [Temporal.Cloud](https://temporal.cloud/) (Optional)                                                                                                                                                            |
| `datalog/pinata_api`        | your personal [pinata](https://docs.pinata.cloud#connecting-to-the-api) api key                                                                                                                                                                 |
| `datalog/pinata_secret`     | your personal [pinata](https://docs.pinata.cloud#connecting-to-the-api) secret api key                                                                                                                                                          |
| `dev/sentry`                | for development purpose. If you have a [Sentry.io](https://sentry.io/) account you can put sentry's credentials in here                                                                                                                         |
| `frontier/enable`           | true/false. Whether or not publish telemetry to [Robonomics Parachain](https://polkadot.js.org/apps/?rpc=wss%3A%2F%2Fkusama.rpc.robonomics.network%2F#/explorer)                                                                                |
| `frontier/suri`             | a private key from robonomics parachain account                                                                                                                                                                                                 |
| `trackagro/enable`          | true/false. Enabling/disabling the station from [TrackAgro](https://tmeteo.docs.apiary.io/#)                                                                                                                                                    |
| `trackagro/token`           | authorization token for [TrackAgro](https://tmeteo.docs.apiary.io/#)                                                                                                                                                                            |