"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tm = require("../lib/index");
const tmDefaults = require("../lib/userpool-detaults");
const cdk = require("aws-cdk-lib");
const assertions_1 = require("aws-cdk-lib/assertions");
//#import { StringAttribute } from "aws-cdk-lib/aws-cognito";
describe("ProcessorStack", () => {
    test("synthesizes the way we expect", () => {
        const app = new cdk.App();
        // Since the ProcessorStack consumes resources from a separate stack
        // (cross-stack references), we create a stack for our SNS topics to live
        // in here. These topics can then be passed to the ProcessorStack later,
        // creating a cross-stack reference.
        const userpoolStack = new cdk.Stack(app, "UpStack");
        let defaultArgs = { ...tmDefaults.DefaultUserPoolProps(), ...{ signInCaseSensitive: true } };
        let defaultClient = tmDefaults.DefaultUserPoolClientProps();
        const userpoolclient = new tm.TmUserPoolClient(userpoolStack, "UserPool", defaultArgs, defaultClient);
        cdk.Tags.of(userpoolclient).add('key', 'value');
        // Prepare the stack for assertions.
        const template = assertions_1.Template.fromStack(userpoolStack);
        console.log(template);
        console.log(JSON.stringify(template));
        template.resourceCountIs("AWS::Cognito::UserPool", 1);
        template.resourceCountIs("AWS::Cognito::UserPoolClient", 1);
    });
});
//# sourceMappingURL=data:application/json;base64,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