"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TmUserPoolClient = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cognito = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
/*
export function DefaultUserPoolProps(): cognito.UserPoolProps {

  const defaultUserPoolProps: cognito.UserPoolProps = {
    signInCaseSensitive: false,
    selfSignUpEnabled: true,
    passwordPolicy: {
        minLength:12,
        requireDigits:true,
        requireLowercase:true,
        requireUppercase:true,
    },
    signInAliases: {
        email:true,
        phone:false,
        username:false,
        preferredUsername:false,
    },
  };

  return defaultUserPoolProps;
}*/
class TmUserPoolClient extends constructs_1.Construct {
    constructor(scope, id, userPoolProps, userPoolClientProps = {}) {
        super(scope, id);
        this.userPool = new cognito.UserPool(this, `${id}-userpool`, userPoolProps);
        let lUserPoolClientProps = {
            userPool: this.userPool,
            ...userPoolClientProps
        };
        //
        this.userPoolClient = new cognito.UserPoolClient(this, "UserPoolClient", lUserPoolClientProps);
        const describeCognitoUserPoolClient = new aws_cdk_lib_1.custom_resources.AwsCustomResource(this, 'DescribeCognitoUserPoolClient', {
            resourceType: 'Custom::DescribeCognitoUserPoolClient',
            onCreate: {
                service: 'CognitoIdentityServiceProvider',
                action: 'describeUserPoolClient',
                parameters: {
                    UserPoolId: this.userPool.userPoolId,
                    ClientId: this.userPoolClient.userPoolClientId,
                },
                physicalResourceId: aws_cdk_lib_1.custom_resources.PhysicalResourceId.of(this.userPoolClient.userPoolClientId),
            },
            // TODO: can we restrict this policy more?
            policy: aws_cdk_lib_1.custom_resources.AwsCustomResourcePolicy.fromSdkCalls({
                resources: aws_cdk_lib_1.custom_resources.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
        const userPoolClientSecret = describeCognitoUserPoolClient.getResponseField('UserPoolClient.ClientSecret');
        new aws_cdk_lib_1.CfnOutput(this, "CognitoUserPoolId", { value: this.userPool.userPoolId, exportName: 'CognitoUserPoolId' });
        new aws_cdk_lib_1.CfnOutput(this, "CognitoUserPoolClientId", { value: this.userPoolClient.userPoolClientId, exportName: 'CognitoUserPoolClientId' });
        new aws_cdk_lib_1.CfnOutput(this, "CognitoUserPoolClientSecret", { value: userPoolClientSecret, exportName: 'CognitoUserPoolClientSecret' });
    }
}
exports.TmUserPoolClient = TmUserPoolClient;
_a = JSII_RTTI_SYMBOL_1;
TmUserPoolClient[_a] = { fqn: "@toumoro-cdk/cognito.TmUserPoolClient", version: "1.0.1" };
//# sourceMappingURL=data:application/json;base64,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