# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AnalysisDataSetReference',
    'AnalysisDateTimeParameter',
    'AnalysisDecimalParameter',
    'AnalysisError',
    'AnalysisIntegerParameter',
    'AnalysisParameters',
    'AnalysisResourcePermission',
    'AnalysisSheet',
    'AnalysisSourceEntity',
    'AnalysisSourceTemplate',
    'AnalysisStringParameter',
    'AnalysisTag',
    'DashboardAdHocFilteringOption',
    'DashboardDataSetReference',
    'DashboardDateTimeParameter',
    'DashboardDecimalParameter',
    'DashboardError',
    'DashboardExportToCSVOption',
    'DashboardIntegerParameter',
    'DashboardParameters',
    'DashboardPublishOptions',
    'DashboardResourcePermission',
    'DashboardSheet',
    'DashboardSheetControlsOption',
    'DashboardSourceEntity',
    'DashboardSourceTemplate',
    'DashboardStringParameter',
    'DashboardTag',
    'DashboardVersion',
    'DataSetColumnGroup',
    'DataSetColumnLevelPermissionRule',
    'DataSetFieldFolderMap',
    'DataSetGeoSpatialColumnGroup',
    'DataSetIngestionWaitPolicy',
    'DataSetLogicalTableMap',
    'DataSetOutputColumn',
    'DataSetPhysicalTableMap',
    'DataSetResourcePermission',
    'DataSetRowLevelPermissionDataSet',
    'DataSetTag',
    'DataSourceAmazonElasticsearchParameters',
    'DataSourceAmazonOpenSearchParameters',
    'DataSourceAthenaParameters',
    'DataSourceAuroraParameters',
    'DataSourceAuroraPostgreSqlParameters',
    'DataSourceCredentialPair',
    'DataSourceCredentials',
    'DataSourceErrorInfo',
    'DataSourceManifestFileLocation',
    'DataSourceMariaDbParameters',
    'DataSourceMySqlParameters',
    'DataSourceOracleParameters',
    'DataSourceParameters',
    'DataSourcePostgreSqlParameters',
    'DataSourcePrestoParameters',
    'DataSourceRdsParameters',
    'DataSourceRedshiftParameters',
    'DataSourceResourcePermission',
    'DataSourceS3Parameters',
    'DataSourceSnowflakeParameters',
    'DataSourceSparkParameters',
    'DataSourceSqlServerParameters',
    'DataSourceSslProperties',
    'DataSourceTag',
    'DataSourceTeradataParameters',
    'DataSourceVpcConnectionProperties',
    'TemplateColumnGroupColumnSchema',
    'TemplateColumnGroupSchema',
    'TemplateColumnSchema',
    'TemplateDataSetConfiguration',
    'TemplateDataSetReference',
    'TemplateDataSetSchema',
    'TemplateError',
    'TemplateResourcePermission',
    'TemplateSheet',
    'TemplateSourceAnalysis',
    'TemplateSourceEntity',
    'TemplateSourceTemplate',
    'TemplateTag',
    'TemplateVersion',
    'ThemeBorderStyle',
    'ThemeConfiguration',
    'ThemeDataColorPalette',
    'ThemeError',
    'ThemeFont',
    'ThemeGutterStyle',
    'ThemeMarginStyle',
    'ThemeResourcePermission',
    'ThemeSheetStyle',
    'ThemeTag',
    'ThemeTileLayoutStyle',
    'ThemeTileStyle',
    'ThemeTypography',
    'ThemeUIColorPalette',
    'ThemeVersion',
]

@pulumi.output_type
class AnalysisDataSetReference(dict):
    """
    <p>Dataset reference.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSetArn":
            suggest = "data_set_arn"
        elif key == "dataSetPlaceholder":
            suggest = "data_set_placeholder"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalysisDataSetReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalysisDataSetReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalysisDataSetReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_set_arn: str,
                 data_set_placeholder: str):
        """
        <p>Dataset reference.</p>
        :param str data_set_arn: <p>Dataset Amazon Resource Name (ARN).</p>
        :param str data_set_placeholder: <p>Dataset placeholder.</p>
        """
        pulumi.set(__self__, "data_set_arn", data_set_arn)
        pulumi.set(__self__, "data_set_placeholder", data_set_placeholder)

    @property
    @pulumi.getter(name="dataSetArn")
    def data_set_arn(self) -> str:
        """
        <p>Dataset Amazon Resource Name (ARN).</p>
        """
        return pulumi.get(self, "data_set_arn")

    @property
    @pulumi.getter(name="dataSetPlaceholder")
    def data_set_placeholder(self) -> str:
        """
        <p>Dataset placeholder.</p>
        """
        return pulumi.get(self, "data_set_placeholder")


@pulumi.output_type
class AnalysisDateTimeParameter(dict):
    """
    <p>A date-time parameter.</p>
    """
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        <p>A date-time parameter.</p>
        :param str name: <p>A display name for the date-time parameter.</p>
        :param Sequence[str] values: <p>The values for the date-time parameter.</p>
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        <p>A display name for the date-time parameter.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        <p>The values for the date-time parameter.</p>
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class AnalysisDecimalParameter(dict):
    """
    <p>A decimal parameter.</p>
    """
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[float]):
        """
        <p>A decimal parameter.</p>
        :param str name: <p>A display name for the decimal parameter.</p>
        :param Sequence[float] values: <p>The values for the decimal parameter.</p>
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        <p>A display name for the decimal parameter.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[float]:
        """
        <p>The values for the decimal parameter.</p>
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class AnalysisError(dict):
    """
    <p>A metadata error structure for an analysis.</p>
    """
    def __init__(__self__, *,
                 message: Optional[str] = None,
                 type: Optional['AnalysisErrorType'] = None):
        """
        <p>A metadata error structure for an analysis.</p>
        :param str message: <p>The message associated with the analysis error.</p>
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        <p>The message associated with the analysis error.</p>
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def type(self) -> Optional['AnalysisErrorType']:
        return pulumi.get(self, "type")


@pulumi.output_type
class AnalysisIntegerParameter(dict):
    """
    <p>An integer parameter.</p>
    """
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[float]):
        """
        <p>An integer parameter.</p>
        :param str name: <p>The name of the integer parameter.</p>
        :param Sequence[float] values: <p>The values for the integer parameter.</p>
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        <p>The name of the integer parameter.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[float]:
        """
        <p>The values for the integer parameter.</p>
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class AnalysisParameters(dict):
    """
    <p>A list of QuickSight parameters and the list's override values.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateTimeParameters":
            suggest = "date_time_parameters"
        elif key == "decimalParameters":
            suggest = "decimal_parameters"
        elif key == "integerParameters":
            suggest = "integer_parameters"
        elif key == "stringParameters":
            suggest = "string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalysisParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalysisParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalysisParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_time_parameters: Optional[Sequence['outputs.AnalysisDateTimeParameter']] = None,
                 decimal_parameters: Optional[Sequence['outputs.AnalysisDecimalParameter']] = None,
                 integer_parameters: Optional[Sequence['outputs.AnalysisIntegerParameter']] = None,
                 string_parameters: Optional[Sequence['outputs.AnalysisStringParameter']] = None):
        """
        <p>A list of QuickSight parameters and the list's override values.</p>
        :param Sequence['AnalysisDateTimeParameter'] date_time_parameters: <p>Date-time parameters.</p>
        :param Sequence['AnalysisDecimalParameter'] decimal_parameters: <p>Decimal parameters.</p>
        :param Sequence['AnalysisIntegerParameter'] integer_parameters: <p>Integer parameters.</p>
        :param Sequence['AnalysisStringParameter'] string_parameters: <p>String parameters.</p>
        """
        if date_time_parameters is not None:
            pulumi.set(__self__, "date_time_parameters", date_time_parameters)
        if decimal_parameters is not None:
            pulumi.set(__self__, "decimal_parameters", decimal_parameters)
        if integer_parameters is not None:
            pulumi.set(__self__, "integer_parameters", integer_parameters)
        if string_parameters is not None:
            pulumi.set(__self__, "string_parameters", string_parameters)

    @property
    @pulumi.getter(name="dateTimeParameters")
    def date_time_parameters(self) -> Optional[Sequence['outputs.AnalysisDateTimeParameter']]:
        """
        <p>Date-time parameters.</p>
        """
        return pulumi.get(self, "date_time_parameters")

    @property
    @pulumi.getter(name="decimalParameters")
    def decimal_parameters(self) -> Optional[Sequence['outputs.AnalysisDecimalParameter']]:
        """
        <p>Decimal parameters.</p>
        """
        return pulumi.get(self, "decimal_parameters")

    @property
    @pulumi.getter(name="integerParameters")
    def integer_parameters(self) -> Optional[Sequence['outputs.AnalysisIntegerParameter']]:
        """
        <p>Integer parameters.</p>
        """
        return pulumi.get(self, "integer_parameters")

    @property
    @pulumi.getter(name="stringParameters")
    def string_parameters(self) -> Optional[Sequence['outputs.AnalysisStringParameter']]:
        """
        <p>String parameters.</p>
        """
        return pulumi.get(self, "string_parameters")


@pulumi.output_type
class AnalysisResourcePermission(dict):
    """
    <p>Permission for the resource.</p>
    """
    def __init__(__self__, *,
                 actions: Sequence[str],
                 principal: str):
        """
        <p>Permission for the resource.</p>
        :param Sequence[str] actions: <p>The IAM action to grant or revoke permissions on.</p>
        :param str principal: <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
                           following:</p>
                       <ul>
                           <li>
                               <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
                           </li>
                           <li>
                               <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
                           </li>
                           <li>
                               <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
                                   ARN. Use this option only to share resources (templates) across AWS accounts.
                                   (This is less common.) </p>
                           </li>
                        </ul>
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[str]:
        """
        <p>The IAM action to grant or revoke permissions on.</p>
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
                    following:</p>
                <ul>
                    <li>
                        <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
                    </li>
                    <li>
                        <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
                    </li>
                    <li>
                        <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
                            ARN. Use this option only to share resources (templates) across AWS accounts.
                            (This is less common.) </p>
                    </li>
                 </ul>
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class AnalysisSheet(dict):
    """
    <p>A <i>sheet</i>, which is an object that contains a set of visuals that
                are viewed together on one page in the Amazon QuickSight console. Every analysis and dashboard
                contains at least one sheet. Each sheet contains at least one visualization widget, for
                example a chart, pivot table, or narrative insight. Sheets can be associated with other
                components, such as controls, filters, and so on.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sheetId":
            suggest = "sheet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalysisSheet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalysisSheet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalysisSheet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 sheet_id: Optional[str] = None):
        """
        <p>A <i>sheet</i>, which is an object that contains a set of visuals that
                    are viewed together on one page in the Amazon QuickSight console. Every analysis and dashboard
                    contains at least one sheet. Each sheet contains at least one visualization widget, for
                    example a chart, pivot table, or narrative insight. Sheets can be associated with other
                    components, such as controls, filters, and so on.</p>
        :param str name: <p>The name of a sheet. This name is displayed on the sheet's tab in the QuickSight
                           console.</p>
        :param str sheet_id: <p>The unique identifier associated with a sheet.</p>
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sheet_id is not None:
            pulumi.set(__self__, "sheet_id", sheet_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        <p>The name of a sheet. This name is displayed on the sheet's tab in the QuickSight
                    console.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sheetId")
    def sheet_id(self) -> Optional[str]:
        """
        <p>The unique identifier associated with a sheet.</p>
        """
        return pulumi.get(self, "sheet_id")


@pulumi.output_type
class AnalysisSourceEntity(dict):
    """
    <p>The source entity of an analysis.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceTemplate":
            suggest = "source_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalysisSourceEntity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalysisSourceEntity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalysisSourceEntity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_template: Optional['outputs.AnalysisSourceTemplate'] = None):
        """
        <p>The source entity of an analysis.</p>
        """
        if source_template is not None:
            pulumi.set(__self__, "source_template", source_template)

    @property
    @pulumi.getter(name="sourceTemplate")
    def source_template(self) -> Optional['outputs.AnalysisSourceTemplate']:
        return pulumi.get(self, "source_template")


@pulumi.output_type
class AnalysisSourceTemplate(dict):
    """
    <p>The source template of an analysis.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSetReferences":
            suggest = "data_set_references"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalysisSourceTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalysisSourceTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalysisSourceTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: str,
                 data_set_references: Sequence['outputs.AnalysisDataSetReference']):
        """
        <p>The source template of an analysis.</p>
        :param str arn: <p>The Amazon Resource Name (ARN) of the source template of an analysis.</p>
        :param Sequence['AnalysisDataSetReference'] data_set_references: <p>The dataset references of the source template of an analysis.</p>
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "data_set_references", data_set_references)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        <p>The Amazon Resource Name (ARN) of the source template of an analysis.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataSetReferences")
    def data_set_references(self) -> Sequence['outputs.AnalysisDataSetReference']:
        """
        <p>The dataset references of the source template of an analysis.</p>
        """
        return pulumi.get(self, "data_set_references")


@pulumi.output_type
class AnalysisStringParameter(dict):
    """
    <p>A string parameter.</p>
    """
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        <p>A string parameter.</p>
        :param str name: <p>A display name for a string parameter.</p>
        :param Sequence[str] values: <p>The values of a string parameter.</p>
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        <p>A display name for a string parameter.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        <p>The values of a string parameter.</p>
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class AnalysisTag(dict):
    """
    <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
                resource.</p>
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
                    resource.</p>
        :param str key: <p>Tag key.</p>
        :param str value: <p>Tag value.</p>
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        <p>Tag key.</p>
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        <p>Tag value.</p>
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DashboardAdHocFilteringOption(dict):
    """
    <p>Ad hoc (one-time) filtering option.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityStatus":
            suggest = "availability_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardAdHocFilteringOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardAdHocFilteringOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardAdHocFilteringOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_status: Optional['DashboardBehavior'] = None):
        """
        <p>Ad hoc (one-time) filtering option.</p>
        """
        if availability_status is not None:
            pulumi.set(__self__, "availability_status", availability_status)

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> Optional['DashboardBehavior']:
        return pulumi.get(self, "availability_status")


@pulumi.output_type
class DashboardDataSetReference(dict):
    """
    <p>Dataset reference.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSetArn":
            suggest = "data_set_arn"
        elif key == "dataSetPlaceholder":
            suggest = "data_set_placeholder"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardDataSetReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardDataSetReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardDataSetReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_set_arn: str,
                 data_set_placeholder: str):
        """
        <p>Dataset reference.</p>
        :param str data_set_arn: <p>Dataset Amazon Resource Name (ARN).</p>
        :param str data_set_placeholder: <p>Dataset placeholder.</p>
        """
        pulumi.set(__self__, "data_set_arn", data_set_arn)
        pulumi.set(__self__, "data_set_placeholder", data_set_placeholder)

    @property
    @pulumi.getter(name="dataSetArn")
    def data_set_arn(self) -> str:
        """
        <p>Dataset Amazon Resource Name (ARN).</p>
        """
        return pulumi.get(self, "data_set_arn")

    @property
    @pulumi.getter(name="dataSetPlaceholder")
    def data_set_placeholder(self) -> str:
        """
        <p>Dataset placeholder.</p>
        """
        return pulumi.get(self, "data_set_placeholder")


@pulumi.output_type
class DashboardDateTimeParameter(dict):
    """
    <p>A date-time parameter.</p>
    """
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        <p>A date-time parameter.</p>
        :param str name: <p>A display name for the date-time parameter.</p>
        :param Sequence[str] values: <p>The values for the date-time parameter.</p>
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        <p>A display name for the date-time parameter.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        <p>The values for the date-time parameter.</p>
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DashboardDecimalParameter(dict):
    """
    <p>A decimal parameter.</p>
    """
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[float]):
        """
        <p>A decimal parameter.</p>
        :param str name: <p>A display name for the decimal parameter.</p>
        :param Sequence[float] values: <p>The values for the decimal parameter.</p>
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        <p>A display name for the decimal parameter.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[float]:
        """
        <p>The values for the decimal parameter.</p>
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DashboardError(dict):
    """
    <p>Dashboard error.</p>
    """
    def __init__(__self__, *,
                 message: Optional[str] = None,
                 type: Optional['DashboardErrorType'] = None):
        """
        <p>Dashboard error.</p>
        :param str message: <p>Message.</p>
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        <p>Message.</p>
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def type(self) -> Optional['DashboardErrorType']:
        return pulumi.get(self, "type")


@pulumi.output_type
class DashboardExportToCSVOption(dict):
    """
    <p>Export to .csv option.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityStatus":
            suggest = "availability_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardExportToCSVOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardExportToCSVOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardExportToCSVOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_status: Optional['DashboardBehavior'] = None):
        """
        <p>Export to .csv option.</p>
        """
        if availability_status is not None:
            pulumi.set(__self__, "availability_status", availability_status)

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> Optional['DashboardBehavior']:
        return pulumi.get(self, "availability_status")


@pulumi.output_type
class DashboardIntegerParameter(dict):
    """
    <p>An integer parameter.</p>
    """
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[float]):
        """
        <p>An integer parameter.</p>
        :param str name: <p>The name of the integer parameter.</p>
        :param Sequence[float] values: <p>The values for the integer parameter.</p>
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        <p>The name of the integer parameter.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[float]:
        """
        <p>The values for the integer parameter.</p>
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DashboardParameters(dict):
    """
    <p>A list of QuickSight parameters and the list's override values.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateTimeParameters":
            suggest = "date_time_parameters"
        elif key == "decimalParameters":
            suggest = "decimal_parameters"
        elif key == "integerParameters":
            suggest = "integer_parameters"
        elif key == "stringParameters":
            suggest = "string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_time_parameters: Optional[Sequence['outputs.DashboardDateTimeParameter']] = None,
                 decimal_parameters: Optional[Sequence['outputs.DashboardDecimalParameter']] = None,
                 integer_parameters: Optional[Sequence['outputs.DashboardIntegerParameter']] = None,
                 string_parameters: Optional[Sequence['outputs.DashboardStringParameter']] = None):
        """
        <p>A list of QuickSight parameters and the list's override values.</p>
        :param Sequence['DashboardDateTimeParameter'] date_time_parameters: <p>Date-time parameters.</p>
        :param Sequence['DashboardDecimalParameter'] decimal_parameters: <p>Decimal parameters.</p>
        :param Sequence['DashboardIntegerParameter'] integer_parameters: <p>Integer parameters.</p>
        :param Sequence['DashboardStringParameter'] string_parameters: <p>String parameters.</p>
        """
        if date_time_parameters is not None:
            pulumi.set(__self__, "date_time_parameters", date_time_parameters)
        if decimal_parameters is not None:
            pulumi.set(__self__, "decimal_parameters", decimal_parameters)
        if integer_parameters is not None:
            pulumi.set(__self__, "integer_parameters", integer_parameters)
        if string_parameters is not None:
            pulumi.set(__self__, "string_parameters", string_parameters)

    @property
    @pulumi.getter(name="dateTimeParameters")
    def date_time_parameters(self) -> Optional[Sequence['outputs.DashboardDateTimeParameter']]:
        """
        <p>Date-time parameters.</p>
        """
        return pulumi.get(self, "date_time_parameters")

    @property
    @pulumi.getter(name="decimalParameters")
    def decimal_parameters(self) -> Optional[Sequence['outputs.DashboardDecimalParameter']]:
        """
        <p>Decimal parameters.</p>
        """
        return pulumi.get(self, "decimal_parameters")

    @property
    @pulumi.getter(name="integerParameters")
    def integer_parameters(self) -> Optional[Sequence['outputs.DashboardIntegerParameter']]:
        """
        <p>Integer parameters.</p>
        """
        return pulumi.get(self, "integer_parameters")

    @property
    @pulumi.getter(name="stringParameters")
    def string_parameters(self) -> Optional[Sequence['outputs.DashboardStringParameter']]:
        """
        <p>String parameters.</p>
        """
        return pulumi.get(self, "string_parameters")


@pulumi.output_type
class DashboardPublishOptions(dict):
    """
    <p>Dashboard publish options.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adHocFilteringOption":
            suggest = "ad_hoc_filtering_option"
        elif key == "exportToCSVOption":
            suggest = "export_to_csv_option"
        elif key == "sheetControlsOption":
            suggest = "sheet_controls_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardPublishOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardPublishOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardPublishOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_hoc_filtering_option: Optional['outputs.DashboardAdHocFilteringOption'] = None,
                 export_to_csv_option: Optional['outputs.DashboardExportToCSVOption'] = None,
                 sheet_controls_option: Optional['outputs.DashboardSheetControlsOption'] = None):
        """
        <p>Dashboard publish options.</p>
        """
        if ad_hoc_filtering_option is not None:
            pulumi.set(__self__, "ad_hoc_filtering_option", ad_hoc_filtering_option)
        if export_to_csv_option is not None:
            pulumi.set(__self__, "export_to_csv_option", export_to_csv_option)
        if sheet_controls_option is not None:
            pulumi.set(__self__, "sheet_controls_option", sheet_controls_option)

    @property
    @pulumi.getter(name="adHocFilteringOption")
    def ad_hoc_filtering_option(self) -> Optional['outputs.DashboardAdHocFilteringOption']:
        return pulumi.get(self, "ad_hoc_filtering_option")

    @property
    @pulumi.getter(name="exportToCSVOption")
    def export_to_csv_option(self) -> Optional['outputs.DashboardExportToCSVOption']:
        return pulumi.get(self, "export_to_csv_option")

    @property
    @pulumi.getter(name="sheetControlsOption")
    def sheet_controls_option(self) -> Optional['outputs.DashboardSheetControlsOption']:
        return pulumi.get(self, "sheet_controls_option")


@pulumi.output_type
class DashboardResourcePermission(dict):
    """
    <p>Permission for the resource.</p>
    """
    def __init__(__self__, *,
                 actions: Sequence[str],
                 principal: str):
        """
        <p>Permission for the resource.</p>
        :param Sequence[str] actions: <p>The IAM action to grant or revoke permissions on.</p>
        :param str principal: <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
                           following:</p>
                       <ul>
                           <li>
                               <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
                           </li>
                           <li>
                               <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
                           </li>
                           <li>
                               <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
                                   ARN. Use this option only to share resources (templates) across AWS accounts.
                                   (This is less common.) </p>
                           </li>
                        </ul>
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[str]:
        """
        <p>The IAM action to grant or revoke permissions on.</p>
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
                    following:</p>
                <ul>
                    <li>
                        <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
                    </li>
                    <li>
                        <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
                    </li>
                    <li>
                        <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
                            ARN. Use this option only to share resources (templates) across AWS accounts.
                            (This is less common.) </p>
                    </li>
                 </ul>
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class DashboardSheet(dict):
    """
    <p>A <i>sheet</i>, which is an object that contains a set of visuals that
                are viewed together on one page in the Amazon QuickSight console. Every analysis and dashboard
                contains at least one sheet. Each sheet contains at least one visualization widget, for
                example a chart, pivot table, or narrative insight. Sheets can be associated with other
                components, such as controls, filters, and so on.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sheetId":
            suggest = "sheet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSheet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSheet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSheet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 sheet_id: Optional[str] = None):
        """
        <p>A <i>sheet</i>, which is an object that contains a set of visuals that
                    are viewed together on one page in the Amazon QuickSight console. Every analysis and dashboard
                    contains at least one sheet. Each sheet contains at least one visualization widget, for
                    example a chart, pivot table, or narrative insight. Sheets can be associated with other
                    components, such as controls, filters, and so on.</p>
        :param str name: <p>The name of a sheet. This name is displayed on the sheet's tab in the QuickSight
                           console.</p>
        :param str sheet_id: <p>The unique identifier associated with a sheet.</p>
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sheet_id is not None:
            pulumi.set(__self__, "sheet_id", sheet_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        <p>The name of a sheet. This name is displayed on the sheet's tab in the QuickSight
                    console.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sheetId")
    def sheet_id(self) -> Optional[str]:
        """
        <p>The unique identifier associated with a sheet.</p>
        """
        return pulumi.get(self, "sheet_id")


@pulumi.output_type
class DashboardSheetControlsOption(dict):
    """
    <p>Sheet controls option.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "visibilityState":
            suggest = "visibility_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSheetControlsOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSheetControlsOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSheetControlsOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 visibility_state: Optional['DashboardUIState'] = None):
        """
        <p>Sheet controls option.</p>
        """
        if visibility_state is not None:
            pulumi.set(__self__, "visibility_state", visibility_state)

    @property
    @pulumi.getter(name="visibilityState")
    def visibility_state(self) -> Optional['DashboardUIState']:
        return pulumi.get(self, "visibility_state")


@pulumi.output_type
class DashboardSourceEntity(dict):
    """
    <p>Dashboard source entity.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceTemplate":
            suggest = "source_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSourceEntity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSourceEntity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSourceEntity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_template: Optional['outputs.DashboardSourceTemplate'] = None):
        """
        <p>Dashboard source entity.</p>
        """
        if source_template is not None:
            pulumi.set(__self__, "source_template", source_template)

    @property
    @pulumi.getter(name="sourceTemplate")
    def source_template(self) -> Optional['outputs.DashboardSourceTemplate']:
        return pulumi.get(self, "source_template")


@pulumi.output_type
class DashboardSourceTemplate(dict):
    """
    <p>Dashboard source template.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSetReferences":
            suggest = "data_set_references"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSourceTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSourceTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSourceTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: str,
                 data_set_references: Sequence['outputs.DashboardDataSetReference']):
        """
        <p>Dashboard source template.</p>
        :param str arn: <p>The Amazon Resource Name (ARN) of the resource.</p>
        :param Sequence['DashboardDataSetReference'] data_set_references: <p>Dataset references.</p>
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "data_set_references", data_set_references)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        <p>The Amazon Resource Name (ARN) of the resource.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataSetReferences")
    def data_set_references(self) -> Sequence['outputs.DashboardDataSetReference']:
        """
        <p>Dataset references.</p>
        """
        return pulumi.get(self, "data_set_references")


@pulumi.output_type
class DashboardStringParameter(dict):
    """
    <p>A string parameter.</p>
    """
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        <p>A string parameter.</p>
        :param str name: <p>A display name for a string parameter.</p>
        :param Sequence[str] values: <p>The values of a string parameter.</p>
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        <p>A display name for a string parameter.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        <p>The values of a string parameter.</p>
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DashboardTag(dict):
    """
    <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
                resource.</p>
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
                    resource.</p>
        :param str key: <p>Tag key.</p>
        :param str value: <p>Tag value.</p>
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        <p>Tag key.</p>
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        <p>Tag value.</p>
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DashboardVersion(dict):
    """
    <p>Dashboard version.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTime":
            suggest = "created_time"
        elif key == "dataSetArns":
            suggest = "data_set_arns"
        elif key == "sourceEntityArn":
            suggest = "source_entity_arn"
        elif key == "themeArn":
            suggest = "theme_arn"
        elif key == "versionNumber":
            suggest = "version_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: Optional[str] = None,
                 created_time: Optional[str] = None,
                 data_set_arns: Optional[Sequence[str]] = None,
                 description: Optional[str] = None,
                 errors: Optional[Sequence['outputs.DashboardError']] = None,
                 sheets: Optional[Sequence['outputs.DashboardSheet']] = None,
                 source_entity_arn: Optional[str] = None,
                 status: Optional['DashboardResourceStatus'] = None,
                 theme_arn: Optional[str] = None,
                 version_number: Optional[float] = None):
        """
        <p>Dashboard version.</p>
        :param str arn: <p>The Amazon Resource Name (ARN) of the resource.</p>
        :param str created_time: <p>The time that this dashboard version was created.</p>
        :param Sequence[str] data_set_arns: <p>The Amazon Resource Numbers (ARNs) for the datasets that are associated with this
                           version of the dashboard.</p>
        :param str description: <p>Description.</p>
        :param Sequence['DashboardError'] errors: <p>Errors associated with this dashboard version.</p>
        :param Sequence['DashboardSheet'] sheets: <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
        :param str source_entity_arn: <p>Source entity ARN.</p>
        :param str theme_arn: <p>The ARN of the theme associated with a version of the dashboard.</p>
        :param float version_number: <p>Version number for this version of the dashboard.</p>
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if data_set_arns is not None:
            pulumi.set(__self__, "data_set_arns", data_set_arns)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if sheets is not None:
            pulumi.set(__self__, "sheets", sheets)
        if source_entity_arn is not None:
            pulumi.set(__self__, "source_entity_arn", source_entity_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if theme_arn is not None:
            pulumi.set(__self__, "theme_arn", theme_arn)
        if version_number is not None:
            pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        <p>The Amazon Resource Name (ARN) of the resource.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[str]:
        """
        <p>The time that this dashboard version was created.</p>
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="dataSetArns")
    def data_set_arns(self) -> Optional[Sequence[str]]:
        """
        <p>The Amazon Resource Numbers (ARNs) for the datasets that are associated with this
                    version of the dashboard.</p>
        """
        return pulumi.get(self, "data_set_arns")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        <p>Description.</p>
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.DashboardError']]:
        """
        <p>Errors associated with this dashboard version.</p>
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def sheets(self) -> Optional[Sequence['outputs.DashboardSheet']]:
        """
        <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
        """
        return pulumi.get(self, "sheets")

    @property
    @pulumi.getter(name="sourceEntityArn")
    def source_entity_arn(self) -> Optional[str]:
        """
        <p>Source entity ARN.</p>
        """
        return pulumi.get(self, "source_entity_arn")

    @property
    @pulumi.getter
    def status(self) -> Optional['DashboardResourceStatus']:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="themeArn")
    def theme_arn(self) -> Optional[str]:
        """
        <p>The ARN of the theme associated with a version of the dashboard.</p>
        """
        return pulumi.get(self, "theme_arn")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> Optional[float]:
        """
        <p>Version number for this version of the dashboard.</p>
        """
        return pulumi.get(self, "version_number")


@pulumi.output_type
class DataSetColumnGroup(dict):
    """
    <p>Groupings of columns that work together in certain Amazon QuickSight features. This is
                a variant type structure. For this structure to be valid, only one of the attributes can
                be non-null.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "geoSpatialColumnGroup":
            suggest = "geo_spatial_column_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSetColumnGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSetColumnGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSetColumnGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 geo_spatial_column_group: Optional['outputs.DataSetGeoSpatialColumnGroup'] = None):
        """
        <p>Groupings of columns that work together in certain Amazon QuickSight features. This is
                    a variant type structure. For this structure to be valid, only one of the attributes can
                    be non-null.</p>
        """
        if geo_spatial_column_group is not None:
            pulumi.set(__self__, "geo_spatial_column_group", geo_spatial_column_group)

    @property
    @pulumi.getter(name="geoSpatialColumnGroup")
    def geo_spatial_column_group(self) -> Optional['outputs.DataSetGeoSpatialColumnGroup']:
        return pulumi.get(self, "geo_spatial_column_group")


@pulumi.output_type
class DataSetColumnLevelPermissionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnNames":
            suggest = "column_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSetColumnLevelPermissionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSetColumnLevelPermissionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSetColumnLevelPermissionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_names: Optional[Sequence[str]] = None,
                 principals: Optional[Sequence[str]] = None):
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter
    def principals(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "principals")


@pulumi.output_type
class DataSetFieldFolderMap(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DataSetGeoSpatialColumnGroup(dict):
    """
    <p>Geospatial column group that denotes a hierarchy.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryCode":
            suggest = "country_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSetGeoSpatialColumnGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSetGeoSpatialColumnGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSetGeoSpatialColumnGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 columns: Sequence[str],
                 name: str,
                 country_code: Optional['DataSetGeoSpatialCountryCode'] = None):
        """
        <p>Geospatial column group that denotes a hierarchy.</p>
        :param Sequence[str] columns: <p>Columns in this hierarchy.</p>
        :param str name: <p>A display name for the hierarchy.</p>
        """
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "name", name)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)

    @property
    @pulumi.getter
    def columns(self) -> Sequence[str]:
        """
        <p>Columns in this hierarchy.</p>
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        <p>A display name for the hierarchy.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional['DataSetGeoSpatialCountryCode']:
        return pulumi.get(self, "country_code")


@pulumi.output_type
class DataSetIngestionWaitPolicy(dict):
    """
    <p>Wait policy to use when creating/updating dataset. Default is to wait for SPICE ingestion to finish with timeout of 36 hours.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingestionWaitTimeInHours":
            suggest = "ingestion_wait_time_in_hours"
        elif key == "waitForSpiceIngestion":
            suggest = "wait_for_spice_ingestion"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSetIngestionWaitPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSetIngestionWaitPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSetIngestionWaitPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingestion_wait_time_in_hours: Optional[float] = None,
                 wait_for_spice_ingestion: Optional[bool] = None):
        """
        <p>Wait policy to use when creating/updating dataset. Default is to wait for SPICE ingestion to finish with timeout of 36 hours.</p>
        :param float ingestion_wait_time_in_hours: <p>The maximum time (in hours) to wait for Ingestion to complete. Default timeout is 36 hours.
                Applicable only when DataSetImportMode mode is set to SPICE and WaitForSpiceIngestion is set to true.</p>
        :param bool wait_for_spice_ingestion: <p>Wait for SPICE ingestion to finish to mark dataset creation/update successful. Default (true).
                 Applicable only when DataSetImportMode mode is set to SPICE.</p>
        """
        if ingestion_wait_time_in_hours is not None:
            pulumi.set(__self__, "ingestion_wait_time_in_hours", ingestion_wait_time_in_hours)
        if wait_for_spice_ingestion is not None:
            pulumi.set(__self__, "wait_for_spice_ingestion", wait_for_spice_ingestion)

    @property
    @pulumi.getter(name="ingestionWaitTimeInHours")
    def ingestion_wait_time_in_hours(self) -> Optional[float]:
        """
        <p>The maximum time (in hours) to wait for Ingestion to complete. Default timeout is 36 hours.
         Applicable only when DataSetImportMode mode is set to SPICE and WaitForSpiceIngestion is set to true.</p>
        """
        return pulumi.get(self, "ingestion_wait_time_in_hours")

    @property
    @pulumi.getter(name="waitForSpiceIngestion")
    def wait_for_spice_ingestion(self) -> Optional[bool]:
        """
        <p>Wait for SPICE ingestion to finish to mark dataset creation/update successful. Default (true).
          Applicable only when DataSetImportMode mode is set to SPICE.</p>
        """
        return pulumi.get(self, "wait_for_spice_ingestion")


@pulumi.output_type
class DataSetLogicalTableMap(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DataSetOutputColumn(dict):
    """
    <p>Output column.</p>
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional['DataSetColumnDataType'] = None):
        """
        <p>Output column.</p>
        :param str description: <p>A description for a column.</p>
        :param str name: <p>A display name for the dataset.</p>
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        <p>A description for a column.</p>
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        <p>A display name for the dataset.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional['DataSetColumnDataType']:
        return pulumi.get(self, "type")


@pulumi.output_type
class DataSetPhysicalTableMap(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DataSetResourcePermission(dict):
    """
    <p>Permission for the resource.</p>
    """
    def __init__(__self__, *,
                 actions: Sequence[str],
                 principal: str):
        """
        <p>Permission for the resource.</p>
        :param Sequence[str] actions: <p>The IAM action to grant or revoke permissions on.</p>
        :param str principal: <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
                           following:</p>
                       <ul>
                           <li>
                               <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
                           </li>
                           <li>
                               <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
                           </li>
                           <li>
                               <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
                                   ARN. Use this option only to share resources (templates) across AWS accounts.
                                   (This is less common.) </p>
                           </li>
                        </ul>
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[str]:
        """
        <p>The IAM action to grant or revoke permissions on.</p>
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
                    following:</p>
                <ul>
                    <li>
                        <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
                    </li>
                    <li>
                        <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
                    </li>
                    <li>
                        <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
                            ARN. Use this option only to share resources (templates) across AWS accounts.
                            (This is less common.) </p>
                    </li>
                 </ul>
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class DataSetRowLevelPermissionDataSet(dict):
    """
    <p>The row-level security configuration for the dataset.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permissionPolicy":
            suggest = "permission_policy"
        elif key == "formatVersion":
            suggest = "format_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSetRowLevelPermissionDataSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSetRowLevelPermissionDataSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSetRowLevelPermissionDataSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: str,
                 permission_policy: 'DataSetRowLevelPermissionPolicy',
                 format_version: Optional['DataSetRowLevelPermissionFormatVersion'] = None,
                 namespace: Optional[str] = None):
        """
        <p>The row-level security configuration for the dataset.</p>
        :param str arn: <p>The Amazon Resource Name (ARN) of the permission dataset.</p>
        :param str namespace: <p>The namespace associated with the row-level permissions dataset.</p>
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "permission_policy", permission_policy)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        <p>The Amazon Resource Name (ARN) of the permission dataset.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="permissionPolicy")
    def permission_policy(self) -> 'DataSetRowLevelPermissionPolicy':
        return pulumi.get(self, "permission_policy")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional['DataSetRowLevelPermissionFormatVersion']:
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        <p>The namespace associated with the row-level permissions dataset.</p>
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class DataSetTag(dict):
    """
    <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
                resource.</p>
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
                    resource.</p>
        :param str key: <p>Tag key.</p>
        :param str value: <p>Tag value.</p>
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        <p>Tag key.</p>
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        <p>Tag value.</p>
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DataSourceAmazonElasticsearchParameters(dict):
    """
    <p>Amazon Elasticsearch Service parameters.</p>
    """
    def __init__(__self__, *,
                 domain: str):
        """
        <p>Amazon Elasticsearch Service parameters.</p>
        :param str domain: <p>The Amazon Elasticsearch Service domain.</p>
        """
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        <p>The Amazon Elasticsearch Service domain.</p>
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class DataSourceAmazonOpenSearchParameters(dict):
    """
    <p>Amazon OpenSearch Service parameters.</p>
    """
    def __init__(__self__, *,
                 domain: str):
        """
        <p>Amazon OpenSearch Service parameters.</p>
        :param str domain: <p>The Amazon OpenSearch Service domain.</p>
        """
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        <p>The Amazon OpenSearch Service domain.</p>
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class DataSourceAthenaParameters(dict):
    """
    <p>Amazon Athena parameters.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workGroup":
            suggest = "work_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceAthenaParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceAthenaParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceAthenaParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 work_group: Optional[str] = None):
        """
        <p>Amazon Athena parameters.</p>
        :param str work_group: <p>The workgroup that Amazon Athena uses.</p>
        """
        if work_group is not None:
            pulumi.set(__self__, "work_group", work_group)

    @property
    @pulumi.getter(name="workGroup")
    def work_group(self) -> Optional[str]:
        """
        <p>The workgroup that Amazon Athena uses.</p>
        """
        return pulumi.get(self, "work_group")


@pulumi.output_type
class DataSourceAuroraParameters(dict):
    """
    <p>Amazon Aurora parameters.</p>
    """
    def __init__(__self__, *,
                 database: str,
                 host: str,
                 port: float):
        """
        <p>Amazon Aurora parameters.</p>
        :param str database: <p>Database.</p>
        :param str host: <p>Host.</p>
        :param float port: <p>Port.</p>
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        <p>Database.</p>
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        <p>Host.</p>
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        <p>Port.</p>
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DataSourceAuroraPostgreSqlParameters(dict):
    """
    <p>Amazon Aurora with PostgreSQL compatibility parameters.</p>
    """
    def __init__(__self__, *,
                 database: str,
                 host: str,
                 port: float):
        """
        <p>Amazon Aurora with PostgreSQL compatibility parameters.</p>
        :param str database: <p>Database.</p>
        :param str host: <p>Host.</p>
        :param float port: <p>Port.</p>
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        <p>Database.</p>
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        <p>Host.</p>
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        <p>Port.</p>
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DataSourceCredentialPair(dict):
    """
    <p>The combination of user name and password that are used as credentials.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alternateDataSourceParameters":
            suggest = "alternate_data_source_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCredentialPair. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCredentialPair.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCredentialPair.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 username: str,
                 alternate_data_source_parameters: Optional[Sequence['outputs.DataSourceParameters']] = None):
        """
        <p>The combination of user name and password that are used as credentials.</p>
        :param str password: <p>Password.</p>
        :param str username: <p>User name.</p>
        :param Sequence['DataSourceParameters'] alternate_data_source_parameters: <p>A set of alternate data source parameters that you want to share for these
                           credentials. The credentials are applied in tandem with the data source parameters when
                           you copy a data source by using a create or update request. The API operation compares
                           the <code>DataSourceParameters</code> structure that's in the request with the
                           structures in the <code>AlternateDataSourceParameters</code> allow list. If the
                           structures are an exact match, the request is allowed to use the new data source with
                           the existing credentials. If the <code>AlternateDataSourceParameters</code> list is
                           null, the <code>DataSourceParameters</code> originally used with these
                               <code>Credentials</code> is automatically allowed.</p>
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if alternate_data_source_parameters is not None:
            pulumi.set(__self__, "alternate_data_source_parameters", alternate_data_source_parameters)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        <p>Password.</p>
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        <p>User name.</p>
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="alternateDataSourceParameters")
    def alternate_data_source_parameters(self) -> Optional[Sequence['outputs.DataSourceParameters']]:
        """
        <p>A set of alternate data source parameters that you want to share for these
                    credentials. The credentials are applied in tandem with the data source parameters when
                    you copy a data source by using a create or update request. The API operation compares
                    the <code>DataSourceParameters</code> structure that's in the request with the
                    structures in the <code>AlternateDataSourceParameters</code> allow list. If the
                    structures are an exact match, the request is allowed to use the new data source with
                    the existing credentials. If the <code>AlternateDataSourceParameters</code> list is
                    null, the <code>DataSourceParameters</code> originally used with these
                        <code>Credentials</code> is automatically allowed.</p>
        """
        return pulumi.get(self, "alternate_data_source_parameters")


@pulumi.output_type
class DataSourceCredentials(dict):
    """
    <p>Data source credentials. This is a variant type structure. For this structure to be
                valid, only one of the attributes can be non-null.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copySourceArn":
            suggest = "copy_source_arn"
        elif key == "credentialPair":
            suggest = "credential_pair"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_source_arn: Optional[str] = None,
                 credential_pair: Optional['outputs.DataSourceCredentialPair'] = None):
        """
        <p>Data source credentials. This is a variant type structure. For this structure to be
                    valid, only one of the attributes can be non-null.</p>
        :param str copy_source_arn: <p>The Amazon Resource Name (ARN) of a data source that has the credential pair that you
                           want to use. When <code>CopySourceArn</code> is not null, the credential pair from the
                           data source in the ARN is used as the credentials for the
                           <code>DataSourceCredentials</code> structure.</p>
        """
        if copy_source_arn is not None:
            pulumi.set(__self__, "copy_source_arn", copy_source_arn)
        if credential_pair is not None:
            pulumi.set(__self__, "credential_pair", credential_pair)

    @property
    @pulumi.getter(name="copySourceArn")
    def copy_source_arn(self) -> Optional[str]:
        """
        <p>The Amazon Resource Name (ARN) of a data source that has the credential pair that you
                    want to use. When <code>CopySourceArn</code> is not null, the credential pair from the
                    data source in the ARN is used as the credentials for the
                    <code>DataSourceCredentials</code> structure.</p>
        """
        return pulumi.get(self, "copy_source_arn")

    @property
    @pulumi.getter(name="credentialPair")
    def credential_pair(self) -> Optional['outputs.DataSourceCredentialPair']:
        return pulumi.get(self, "credential_pair")


@pulumi.output_type
class DataSourceErrorInfo(dict):
    """
    <p>Error information for the data source creation or update.</p>
    """
    def __init__(__self__, *,
                 message: Optional[str] = None,
                 type: Optional['DataSourceErrorInfoType'] = None):
        """
        <p>Error information for the data source creation or update.</p>
        :param str message: <p>Error message.</p>
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        <p>Error message.</p>
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def type(self) -> Optional['DataSourceErrorInfoType']:
        return pulumi.get(self, "type")


@pulumi.output_type
class DataSourceManifestFileLocation(dict):
    """
    <p>Amazon S3 manifest file location.</p>
    """
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        """
        <p>Amazon S3 manifest file location.</p>
        :param str bucket: <p>Amazon S3 bucket.</p>
        :param str key: <p>Amazon S3 key that identifies an object.</p>
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        <p>Amazon S3 bucket.</p>
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        <p>Amazon S3 key that identifies an object.</p>
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class DataSourceMariaDbParameters(dict):
    """
    <p>MariaDB parameters.</p>
    """
    def __init__(__self__, *,
                 database: str,
                 host: str,
                 port: float):
        """
        <p>MariaDB parameters.</p>
        :param str database: <p>Database.</p>
        :param str host: <p>Host.</p>
        :param float port: <p>Port.</p>
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        <p>Database.</p>
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        <p>Host.</p>
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        <p>Port.</p>
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DataSourceMySqlParameters(dict):
    """
    <p>MySQL parameters.</p>
    """
    def __init__(__self__, *,
                 database: str,
                 host: str,
                 port: float):
        """
        <p>MySQL parameters.</p>
        :param str database: <p>Database.</p>
        :param str host: <p>Host.</p>
        :param float port: <p>Port.</p>
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        <p>Database.</p>
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        <p>Host.</p>
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        <p>Port.</p>
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DataSourceOracleParameters(dict):
    def __init__(__self__, *,
                 database: str,
                 host: str,
                 port: float):
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> str:
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def host(self) -> str:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> float:
        return pulumi.get(self, "port")


@pulumi.output_type
class DataSourceParameters(dict):
    """
    <p>The parameters that Amazon QuickSight uses to connect to your underlying data source.
                This is a variant type structure. For this structure to be valid, only one of the
                attributes can be non-null.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amazonElasticsearchParameters":
            suggest = "amazon_elasticsearch_parameters"
        elif key == "amazonOpenSearchParameters":
            suggest = "amazon_open_search_parameters"
        elif key == "athenaParameters":
            suggest = "athena_parameters"
        elif key == "auroraParameters":
            suggest = "aurora_parameters"
        elif key == "auroraPostgreSqlParameters":
            suggest = "aurora_postgre_sql_parameters"
        elif key == "mariaDbParameters":
            suggest = "maria_db_parameters"
        elif key == "mySqlParameters":
            suggest = "my_sql_parameters"
        elif key == "oracleParameters":
            suggest = "oracle_parameters"
        elif key == "postgreSqlParameters":
            suggest = "postgre_sql_parameters"
        elif key == "prestoParameters":
            suggest = "presto_parameters"
        elif key == "rdsParameters":
            suggest = "rds_parameters"
        elif key == "redshiftParameters":
            suggest = "redshift_parameters"
        elif key == "s3Parameters":
            suggest = "s3_parameters"
        elif key == "snowflakeParameters":
            suggest = "snowflake_parameters"
        elif key == "sparkParameters":
            suggest = "spark_parameters"
        elif key == "sqlServerParameters":
            suggest = "sql_server_parameters"
        elif key == "teradataParameters":
            suggest = "teradata_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 amazon_elasticsearch_parameters: Optional['outputs.DataSourceAmazonElasticsearchParameters'] = None,
                 amazon_open_search_parameters: Optional['outputs.DataSourceAmazonOpenSearchParameters'] = None,
                 athena_parameters: Optional['outputs.DataSourceAthenaParameters'] = None,
                 aurora_parameters: Optional['outputs.DataSourceAuroraParameters'] = None,
                 aurora_postgre_sql_parameters: Optional['outputs.DataSourceAuroraPostgreSqlParameters'] = None,
                 maria_db_parameters: Optional['outputs.DataSourceMariaDbParameters'] = None,
                 my_sql_parameters: Optional['outputs.DataSourceMySqlParameters'] = None,
                 oracle_parameters: Optional['outputs.DataSourceOracleParameters'] = None,
                 postgre_sql_parameters: Optional['outputs.DataSourcePostgreSqlParameters'] = None,
                 presto_parameters: Optional['outputs.DataSourcePrestoParameters'] = None,
                 rds_parameters: Optional['outputs.DataSourceRdsParameters'] = None,
                 redshift_parameters: Optional['outputs.DataSourceRedshiftParameters'] = None,
                 s3_parameters: Optional['outputs.DataSourceS3Parameters'] = None,
                 snowflake_parameters: Optional['outputs.DataSourceSnowflakeParameters'] = None,
                 spark_parameters: Optional['outputs.DataSourceSparkParameters'] = None,
                 sql_server_parameters: Optional['outputs.DataSourceSqlServerParameters'] = None,
                 teradata_parameters: Optional['outputs.DataSourceTeradataParameters'] = None):
        """
        <p>The parameters that Amazon QuickSight uses to connect to your underlying data source.
                    This is a variant type structure. For this structure to be valid, only one of the
                    attributes can be non-null.</p>
        """
        if amazon_elasticsearch_parameters is not None:
            pulumi.set(__self__, "amazon_elasticsearch_parameters", amazon_elasticsearch_parameters)
        if amazon_open_search_parameters is not None:
            pulumi.set(__self__, "amazon_open_search_parameters", amazon_open_search_parameters)
        if athena_parameters is not None:
            pulumi.set(__self__, "athena_parameters", athena_parameters)
        if aurora_parameters is not None:
            pulumi.set(__self__, "aurora_parameters", aurora_parameters)
        if aurora_postgre_sql_parameters is not None:
            pulumi.set(__self__, "aurora_postgre_sql_parameters", aurora_postgre_sql_parameters)
        if maria_db_parameters is not None:
            pulumi.set(__self__, "maria_db_parameters", maria_db_parameters)
        if my_sql_parameters is not None:
            pulumi.set(__self__, "my_sql_parameters", my_sql_parameters)
        if oracle_parameters is not None:
            pulumi.set(__self__, "oracle_parameters", oracle_parameters)
        if postgre_sql_parameters is not None:
            pulumi.set(__self__, "postgre_sql_parameters", postgre_sql_parameters)
        if presto_parameters is not None:
            pulumi.set(__self__, "presto_parameters", presto_parameters)
        if rds_parameters is not None:
            pulumi.set(__self__, "rds_parameters", rds_parameters)
        if redshift_parameters is not None:
            pulumi.set(__self__, "redshift_parameters", redshift_parameters)
        if s3_parameters is not None:
            pulumi.set(__self__, "s3_parameters", s3_parameters)
        if snowflake_parameters is not None:
            pulumi.set(__self__, "snowflake_parameters", snowflake_parameters)
        if spark_parameters is not None:
            pulumi.set(__self__, "spark_parameters", spark_parameters)
        if sql_server_parameters is not None:
            pulumi.set(__self__, "sql_server_parameters", sql_server_parameters)
        if teradata_parameters is not None:
            pulumi.set(__self__, "teradata_parameters", teradata_parameters)

    @property
    @pulumi.getter(name="amazonElasticsearchParameters")
    def amazon_elasticsearch_parameters(self) -> Optional['outputs.DataSourceAmazonElasticsearchParameters']:
        return pulumi.get(self, "amazon_elasticsearch_parameters")

    @property
    @pulumi.getter(name="amazonOpenSearchParameters")
    def amazon_open_search_parameters(self) -> Optional['outputs.DataSourceAmazonOpenSearchParameters']:
        return pulumi.get(self, "amazon_open_search_parameters")

    @property
    @pulumi.getter(name="athenaParameters")
    def athena_parameters(self) -> Optional['outputs.DataSourceAthenaParameters']:
        return pulumi.get(self, "athena_parameters")

    @property
    @pulumi.getter(name="auroraParameters")
    def aurora_parameters(self) -> Optional['outputs.DataSourceAuroraParameters']:
        return pulumi.get(self, "aurora_parameters")

    @property
    @pulumi.getter(name="auroraPostgreSqlParameters")
    def aurora_postgre_sql_parameters(self) -> Optional['outputs.DataSourceAuroraPostgreSqlParameters']:
        return pulumi.get(self, "aurora_postgre_sql_parameters")

    @property
    @pulumi.getter(name="mariaDbParameters")
    def maria_db_parameters(self) -> Optional['outputs.DataSourceMariaDbParameters']:
        return pulumi.get(self, "maria_db_parameters")

    @property
    @pulumi.getter(name="mySqlParameters")
    def my_sql_parameters(self) -> Optional['outputs.DataSourceMySqlParameters']:
        return pulumi.get(self, "my_sql_parameters")

    @property
    @pulumi.getter(name="oracleParameters")
    def oracle_parameters(self) -> Optional['outputs.DataSourceOracleParameters']:
        return pulumi.get(self, "oracle_parameters")

    @property
    @pulumi.getter(name="postgreSqlParameters")
    def postgre_sql_parameters(self) -> Optional['outputs.DataSourcePostgreSqlParameters']:
        return pulumi.get(self, "postgre_sql_parameters")

    @property
    @pulumi.getter(name="prestoParameters")
    def presto_parameters(self) -> Optional['outputs.DataSourcePrestoParameters']:
        return pulumi.get(self, "presto_parameters")

    @property
    @pulumi.getter(name="rdsParameters")
    def rds_parameters(self) -> Optional['outputs.DataSourceRdsParameters']:
        return pulumi.get(self, "rds_parameters")

    @property
    @pulumi.getter(name="redshiftParameters")
    def redshift_parameters(self) -> Optional['outputs.DataSourceRedshiftParameters']:
        return pulumi.get(self, "redshift_parameters")

    @property
    @pulumi.getter(name="s3Parameters")
    def s3_parameters(self) -> Optional['outputs.DataSourceS3Parameters']:
        return pulumi.get(self, "s3_parameters")

    @property
    @pulumi.getter(name="snowflakeParameters")
    def snowflake_parameters(self) -> Optional['outputs.DataSourceSnowflakeParameters']:
        return pulumi.get(self, "snowflake_parameters")

    @property
    @pulumi.getter(name="sparkParameters")
    def spark_parameters(self) -> Optional['outputs.DataSourceSparkParameters']:
        return pulumi.get(self, "spark_parameters")

    @property
    @pulumi.getter(name="sqlServerParameters")
    def sql_server_parameters(self) -> Optional['outputs.DataSourceSqlServerParameters']:
        return pulumi.get(self, "sql_server_parameters")

    @property
    @pulumi.getter(name="teradataParameters")
    def teradata_parameters(self) -> Optional['outputs.DataSourceTeradataParameters']:
        return pulumi.get(self, "teradata_parameters")


@pulumi.output_type
class DataSourcePostgreSqlParameters(dict):
    """
    <p>PostgreSQL parameters.</p>
    """
    def __init__(__self__, *,
                 database: str,
                 host: str,
                 port: float):
        """
        <p>PostgreSQL parameters.</p>
        :param str database: <p>Database.</p>
        :param str host: <p>Host.</p>
        :param float port: <p>Port.</p>
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        <p>Database.</p>
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        <p>Host.</p>
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        <p>Port.</p>
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DataSourcePrestoParameters(dict):
    """
    <p>Presto parameters.</p>
    """
    def __init__(__self__, *,
                 catalog: str,
                 host: str,
                 port: float):
        """
        <p>Presto parameters.</p>
        :param str catalog: <p>Catalog.</p>
        :param str host: <p>Host.</p>
        :param float port: <p>Port.</p>
        """
        pulumi.set(__self__, "catalog", catalog)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def catalog(self) -> str:
        """
        <p>Catalog.</p>
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        <p>Host.</p>
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        <p>Port.</p>
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DataSourceRdsParameters(dict):
    """
    <p>Amazon RDS parameters.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRdsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRdsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRdsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: str,
                 instance_id: str):
        """
        <p>Amazon RDS parameters.</p>
        :param str database: <p>Database.</p>
        :param str instance_id: <p>Instance ID.</p>
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        <p>Database.</p>
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        <p>Instance ID.</p>
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class DataSourceRedshiftParameters(dict):
    """
    <p>Amazon Redshift parameters. The <code>ClusterId</code> field can be blank if
                <code>Host</code> and <code>Port</code> are both set. The <code>Host</code> and
                <code>Port</code> fields can be blank if the <code>ClusterId</code> field is set.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRedshiftParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRedshiftParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRedshiftParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: str,
                 cluster_id: Optional[str] = None,
                 host: Optional[str] = None,
                 port: Optional[float] = None):
        """
        <p>Amazon Redshift parameters. The <code>ClusterId</code> field can be blank if
                    <code>Host</code> and <code>Port</code> are both set. The <code>Host</code> and
                    <code>Port</code> fields can be blank if the <code>ClusterId</code> field is set.</p>
        :param str database: <p>Database.</p>
        :param str cluster_id: <p>Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are
                           provided.</p>
        :param str host: <p>Host. This field can be blank if <code>ClusterId</code> is provided.</p>
        :param float port: <p>Port. This field can be blank if the <code>ClusterId</code> is provided.</p>
        """
        pulumi.set(__self__, "database", database)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        <p>Database.</p>
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        """
        <p>Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are
                    provided.</p>
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        <p>Host. This field can be blank if <code>ClusterId</code> is provided.</p>
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        <p>Port. This field can be blank if the <code>ClusterId</code> is provided.</p>
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DataSourceResourcePermission(dict):
    """
    <p>Permission for the resource.</p>
    """
    def __init__(__self__, *,
                 actions: Sequence[str],
                 principal: str):
        """
        <p>Permission for the resource.</p>
        :param Sequence[str] actions: <p>The IAM action to grant or revoke permissions on.</p>
        :param str principal: <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
                           following:</p>
                       <ul>
                           <li>
                               <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
                           </li>
                           <li>
                               <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
                           </li>
                           <li>
                               <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
                                   ARN. Use this option only to share resources (templates) across AWS accounts.
                                   (This is less common.) </p>
                           </li>
                        </ul>
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[str]:
        """
        <p>The IAM action to grant or revoke permissions on.</p>
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
                    following:</p>
                <ul>
                    <li>
                        <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
                    </li>
                    <li>
                        <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
                    </li>
                    <li>
                        <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
                            ARN. Use this option only to share resources (templates) across AWS accounts.
                            (This is less common.) </p>
                    </li>
                 </ul>
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class DataSourceS3Parameters(dict):
    """
    <p>S3 parameters.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestFileLocation":
            suggest = "manifest_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceS3Parameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceS3Parameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceS3Parameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_file_location: 'outputs.DataSourceManifestFileLocation'):
        """
        <p>S3 parameters.</p>
        """
        pulumi.set(__self__, "manifest_file_location", manifest_file_location)

    @property
    @pulumi.getter(name="manifestFileLocation")
    def manifest_file_location(self) -> 'outputs.DataSourceManifestFileLocation':
        return pulumi.get(self, "manifest_file_location")


@pulumi.output_type
class DataSourceSnowflakeParameters(dict):
    """
    <p>Snowflake parameters.</p>
    """
    def __init__(__self__, *,
                 database: str,
                 host: str,
                 warehouse: str):
        """
        <p>Snowflake parameters.</p>
        :param str database: <p>Database.</p>
        :param str host: <p>Host.</p>
        :param str warehouse: <p>Warehouse.</p>
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "warehouse", warehouse)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        <p>Database.</p>
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        <p>Host.</p>
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def warehouse(self) -> str:
        """
        <p>Warehouse.</p>
        """
        return pulumi.get(self, "warehouse")


@pulumi.output_type
class DataSourceSparkParameters(dict):
    """
    <p>Spark parameters.</p>
    """
    def __init__(__self__, *,
                 host: str,
                 port: float):
        """
        <p>Spark parameters.</p>
        :param str host: <p>Host.</p>
        :param float port: <p>Port.</p>
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        <p>Host.</p>
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        <p>Port.</p>
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DataSourceSqlServerParameters(dict):
    """
    <p>SQL Server parameters.</p>
    """
    def __init__(__self__, *,
                 database: str,
                 host: str,
                 port: float):
        """
        <p>SQL Server parameters.</p>
        :param str database: <p>Database.</p>
        :param str host: <p>Host.</p>
        :param float port: <p>Port.</p>
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        <p>Database.</p>
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        <p>Host.</p>
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        <p>Port.</p>
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DataSourceSslProperties(dict):
    """
    <p>Secure Socket Layer (SSL) properties that apply when QuickSight connects to your
                underlying data source.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableSsl":
            suggest = "disable_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceSslProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceSslProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceSslProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_ssl: Optional[bool] = None):
        """
        <p>Secure Socket Layer (SSL) properties that apply when QuickSight connects to your
                    underlying data source.</p>
        :param bool disable_ssl: <p>A Boolean option to control whether SSL should be disabled.</p>
        """
        if disable_ssl is not None:
            pulumi.set(__self__, "disable_ssl", disable_ssl)

    @property
    @pulumi.getter(name="disableSsl")
    def disable_ssl(self) -> Optional[bool]:
        """
        <p>A Boolean option to control whether SSL should be disabled.</p>
        """
        return pulumi.get(self, "disable_ssl")


@pulumi.output_type
class DataSourceTag(dict):
    """
    <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
                resource.</p>
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
                    resource.</p>
        :param str key: <p>Tag key.</p>
        :param str value: <p>Tag value.</p>
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        <p>Tag key.</p>
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        <p>Tag value.</p>
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DataSourceTeradataParameters(dict):
    """
    <p>Teradata parameters.</p>
    """
    def __init__(__self__, *,
                 database: str,
                 host: str,
                 port: float):
        """
        <p>Teradata parameters.</p>
        :param str database: <p>Database.</p>
        :param str host: <p>Host.</p>
        :param float port: <p>Port.</p>
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        <p>Database.</p>
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        <p>Host.</p>
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        <p>Port.</p>
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DataSourceVpcConnectionProperties(dict):
    """
    <p>VPC connection properties.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcConnectionArn":
            suggest = "vpc_connection_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceVpcConnectionProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceVpcConnectionProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceVpcConnectionProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_connection_arn: str):
        """
        <p>VPC connection properties.</p>
        :param str vpc_connection_arn: <p>The Amazon Resource Name (ARN) for the VPC connection.</p>
        """
        pulumi.set(__self__, "vpc_connection_arn", vpc_connection_arn)

    @property
    @pulumi.getter(name="vpcConnectionArn")
    def vpc_connection_arn(self) -> str:
        """
        <p>The Amazon Resource Name (ARN) for the VPC connection.</p>
        """
        return pulumi.get(self, "vpc_connection_arn")


@pulumi.output_type
class TemplateColumnGroupColumnSchema(dict):
    """
    <p>A structure describing the name, data type, and geographic role of the columns.</p>
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        <p>A structure describing the name, data type, and geographic role of the columns.</p>
        :param str name: <p>The name of the column group's column schema.</p>
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        <p>The name of the column group's column schema.</p>
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class TemplateColumnGroupSchema(dict):
    """
    <p>The column group schema.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnGroupColumnSchemaList":
            suggest = "column_group_column_schema_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateColumnGroupSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateColumnGroupSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateColumnGroupSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_group_column_schema_list: Optional[Sequence['outputs.TemplateColumnGroupColumnSchema']] = None,
                 name: Optional[str] = None):
        """
        <p>The column group schema.</p>
        :param Sequence['TemplateColumnGroupColumnSchema'] column_group_column_schema_list: <p>A structure containing the list of schemas for column group columns.</p>
        :param str name: <p>The name of the column group schema.</p>
        """
        if column_group_column_schema_list is not None:
            pulumi.set(__self__, "column_group_column_schema_list", column_group_column_schema_list)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="columnGroupColumnSchemaList")
    def column_group_column_schema_list(self) -> Optional[Sequence['outputs.TemplateColumnGroupColumnSchema']]:
        """
        <p>A structure containing the list of schemas for column group columns.</p>
        """
        return pulumi.get(self, "column_group_column_schema_list")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        <p>The name of the column group schema.</p>
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class TemplateColumnSchema(dict):
    """
    <p>The column schema.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "geographicRole":
            suggest = "geographic_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateColumnSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateColumnSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateColumnSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: Optional[str] = None,
                 geographic_role: Optional[str] = None,
                 name: Optional[str] = None):
        """
        <p>The column schema.</p>
        :param str data_type: <p>The data type of the column schema.</p>
        :param str geographic_role: <p>The geographic role of the column schema.</p>
        :param str name: <p>The name of the column schema.</p>
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if geographic_role is not None:
            pulumi.set(__self__, "geographic_role", geographic_role)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        <p>The data type of the column schema.</p>
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="geographicRole")
    def geographic_role(self) -> Optional[str]:
        """
        <p>The geographic role of the column schema.</p>
        """
        return pulumi.get(self, "geographic_role")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        <p>The name of the column schema.</p>
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class TemplateDataSetConfiguration(dict):
    """
    <p>Dataset configuration.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnGroupSchemaList":
            suggest = "column_group_schema_list"
        elif key == "dataSetSchema":
            suggest = "data_set_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateDataSetConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateDataSetConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateDataSetConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_group_schema_list: Optional[Sequence['outputs.TemplateColumnGroupSchema']] = None,
                 data_set_schema: Optional['outputs.TemplateDataSetSchema'] = None,
                 placeholder: Optional[str] = None):
        """
        <p>Dataset configuration.</p>
        :param Sequence['TemplateColumnGroupSchema'] column_group_schema_list: <p>A structure containing the list of column group schemas.</p>
        :param str placeholder: <p>Placeholder.</p>
        """
        if column_group_schema_list is not None:
            pulumi.set(__self__, "column_group_schema_list", column_group_schema_list)
        if data_set_schema is not None:
            pulumi.set(__self__, "data_set_schema", data_set_schema)
        if placeholder is not None:
            pulumi.set(__self__, "placeholder", placeholder)

    @property
    @pulumi.getter(name="columnGroupSchemaList")
    def column_group_schema_list(self) -> Optional[Sequence['outputs.TemplateColumnGroupSchema']]:
        """
        <p>A structure containing the list of column group schemas.</p>
        """
        return pulumi.get(self, "column_group_schema_list")

    @property
    @pulumi.getter(name="dataSetSchema")
    def data_set_schema(self) -> Optional['outputs.TemplateDataSetSchema']:
        return pulumi.get(self, "data_set_schema")

    @property
    @pulumi.getter
    def placeholder(self) -> Optional[str]:
        """
        <p>Placeholder.</p>
        """
        return pulumi.get(self, "placeholder")


@pulumi.output_type
class TemplateDataSetReference(dict):
    """
    <p>Dataset reference.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSetArn":
            suggest = "data_set_arn"
        elif key == "dataSetPlaceholder":
            suggest = "data_set_placeholder"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateDataSetReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateDataSetReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateDataSetReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_set_arn: str,
                 data_set_placeholder: str):
        """
        <p>Dataset reference.</p>
        :param str data_set_arn: <p>Dataset Amazon Resource Name (ARN).</p>
        :param str data_set_placeholder: <p>Dataset placeholder.</p>
        """
        pulumi.set(__self__, "data_set_arn", data_set_arn)
        pulumi.set(__self__, "data_set_placeholder", data_set_placeholder)

    @property
    @pulumi.getter(name="dataSetArn")
    def data_set_arn(self) -> str:
        """
        <p>Dataset Amazon Resource Name (ARN).</p>
        """
        return pulumi.get(self, "data_set_arn")

    @property
    @pulumi.getter(name="dataSetPlaceholder")
    def data_set_placeholder(self) -> str:
        """
        <p>Dataset placeholder.</p>
        """
        return pulumi.get(self, "data_set_placeholder")


@pulumi.output_type
class TemplateDataSetSchema(dict):
    """
    <p>Dataset schema.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnSchemaList":
            suggest = "column_schema_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateDataSetSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateDataSetSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateDataSetSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_schema_list: Optional[Sequence['outputs.TemplateColumnSchema']] = None):
        """
        <p>Dataset schema.</p>
        :param Sequence['TemplateColumnSchema'] column_schema_list: <p>A structure containing the list of column schemas.</p>
        """
        if column_schema_list is not None:
            pulumi.set(__self__, "column_schema_list", column_schema_list)

    @property
    @pulumi.getter(name="columnSchemaList")
    def column_schema_list(self) -> Optional[Sequence['outputs.TemplateColumnSchema']]:
        """
        <p>A structure containing the list of column schemas.</p>
        """
        return pulumi.get(self, "column_schema_list")


@pulumi.output_type
class TemplateError(dict):
    """
    <p>List of errors that occurred when the template version creation failed.</p>
    """
    def __init__(__self__, *,
                 message: Optional[str] = None,
                 type: Optional['TemplateErrorType'] = None):
        """
        <p>List of errors that occurred when the template version creation failed.</p>
        :param str message: <p>Description of the error type.</p>
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        <p>Description of the error type.</p>
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def type(self) -> Optional['TemplateErrorType']:
        return pulumi.get(self, "type")


@pulumi.output_type
class TemplateResourcePermission(dict):
    """
    <p>Permission for the resource.</p>
    """
    def __init__(__self__, *,
                 actions: Sequence[str],
                 principal: str):
        """
        <p>Permission for the resource.</p>
        :param Sequence[str] actions: <p>The IAM action to grant or revoke permissions on.</p>
        :param str principal: <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
                           following:</p>
                       <ul>
                           <li>
                               <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
                           </li>
                           <li>
                               <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
                           </li>
                           <li>
                               <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
                                   ARN. Use this option only to share resources (templates) across AWS accounts.
                                   (This is less common.) </p>
                           </li>
                        </ul>
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[str]:
        """
        <p>The IAM action to grant or revoke permissions on.</p>
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
                    following:</p>
                <ul>
                    <li>
                        <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
                    </li>
                    <li>
                        <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
                    </li>
                    <li>
                        <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
                            ARN. Use this option only to share resources (templates) across AWS accounts.
                            (This is less common.) </p>
                    </li>
                 </ul>
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class TemplateSheet(dict):
    """
    <p>A <i>sheet</i>, which is an object that contains a set of visuals that
                are viewed together on one page in the Amazon QuickSight console. Every analysis and dashboard
                contains at least one sheet. Each sheet contains at least one visualization widget, for
                example a chart, pivot table, or narrative insight. Sheets can be associated with other
                components, such as controls, filters, and so on.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sheetId":
            suggest = "sheet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateSheet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateSheet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateSheet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 sheet_id: Optional[str] = None):
        """
        <p>A <i>sheet</i>, which is an object that contains a set of visuals that
                    are viewed together on one page in the Amazon QuickSight console. Every analysis and dashboard
                    contains at least one sheet. Each sheet contains at least one visualization widget, for
                    example a chart, pivot table, or narrative insight. Sheets can be associated with other
                    components, such as controls, filters, and so on.</p>
        :param str name: <p>The name of a sheet. This name is displayed on the sheet's tab in the QuickSight
                           console.</p>
        :param str sheet_id: <p>The unique identifier associated with a sheet.</p>
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sheet_id is not None:
            pulumi.set(__self__, "sheet_id", sheet_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        <p>The name of a sheet. This name is displayed on the sheet's tab in the QuickSight
                    console.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sheetId")
    def sheet_id(self) -> Optional[str]:
        """
        <p>The unique identifier associated with a sheet.</p>
        """
        return pulumi.get(self, "sheet_id")


@pulumi.output_type
class TemplateSourceAnalysis(dict):
    """
    <p>The source analysis of the template.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSetReferences":
            suggest = "data_set_references"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateSourceAnalysis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateSourceAnalysis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateSourceAnalysis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: str,
                 data_set_references: Sequence['outputs.TemplateDataSetReference']):
        """
        <p>The source analysis of the template.</p>
        :param str arn: <p>The Amazon Resource Name (ARN) of the resource.</p>
        :param Sequence['TemplateDataSetReference'] data_set_references: <p>A structure containing information about the dataset references used as placeholders
                           in the template.</p>
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "data_set_references", data_set_references)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        <p>The Amazon Resource Name (ARN) of the resource.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataSetReferences")
    def data_set_references(self) -> Sequence['outputs.TemplateDataSetReference']:
        """
        <p>A structure containing information about the dataset references used as placeholders
                    in the template.</p>
        """
        return pulumi.get(self, "data_set_references")


@pulumi.output_type
class TemplateSourceEntity(dict):
    """
    <p>The source entity of the template.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceAnalysis":
            suggest = "source_analysis"
        elif key == "sourceTemplate":
            suggest = "source_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateSourceEntity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateSourceEntity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateSourceEntity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_analysis: Optional['outputs.TemplateSourceAnalysis'] = None,
                 source_template: Optional['outputs.TemplateSourceTemplate'] = None):
        """
        <p>The source entity of the template.</p>
        """
        if source_analysis is not None:
            pulumi.set(__self__, "source_analysis", source_analysis)
        if source_template is not None:
            pulumi.set(__self__, "source_template", source_template)

    @property
    @pulumi.getter(name="sourceAnalysis")
    def source_analysis(self) -> Optional['outputs.TemplateSourceAnalysis']:
        return pulumi.get(self, "source_analysis")

    @property
    @pulumi.getter(name="sourceTemplate")
    def source_template(self) -> Optional['outputs.TemplateSourceTemplate']:
        return pulumi.get(self, "source_template")


@pulumi.output_type
class TemplateSourceTemplate(dict):
    """
    <p>The source template of the template.</p>
    """
    def __init__(__self__, *,
                 arn: str):
        """
        <p>The source template of the template.</p>
        :param str arn: <p>The Amazon Resource Name (ARN) of the resource.</p>
        """
        pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        <p>The Amazon Resource Name (ARN) of the resource.</p>
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class TemplateTag(dict):
    """
    <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
                resource.</p>
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
                    resource.</p>
        :param str key: <p>Tag key.</p>
        :param str value: <p>Tag value.</p>
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        <p>Tag key.</p>
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        <p>Tag value.</p>
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TemplateVersion(dict):
    """
    <p>A version of a template.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTime":
            suggest = "created_time"
        elif key == "dataSetConfigurations":
            suggest = "data_set_configurations"
        elif key == "sourceEntityArn":
            suggest = "source_entity_arn"
        elif key == "themeArn":
            suggest = "theme_arn"
        elif key == "versionNumber":
            suggest = "version_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_time: Optional[str] = None,
                 data_set_configurations: Optional[Sequence['outputs.TemplateDataSetConfiguration']] = None,
                 description: Optional[str] = None,
                 errors: Optional[Sequence['outputs.TemplateError']] = None,
                 sheets: Optional[Sequence['outputs.TemplateSheet']] = None,
                 source_entity_arn: Optional[str] = None,
                 status: Optional['TemplateResourceStatus'] = None,
                 theme_arn: Optional[str] = None,
                 version_number: Optional[float] = None):
        """
        <p>A version of a template.</p>
        :param str created_time: <p>The time that this template version was created.</p>
        :param Sequence['TemplateDataSetConfiguration'] data_set_configurations: <p>Schema of the dataset identified by the placeholder. Any dashboard created from this
                           template should be bound to new datasets matching the same schema described through this
                           API operation.</p>
        :param str description: <p>The description of the template.</p>
        :param Sequence['TemplateError'] errors: <p>Errors associated with this template version.</p>
        :param Sequence['TemplateSheet'] sheets: <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
        :param str source_entity_arn: <p>The Amazon Resource Name (ARN) of an analysis or template that was used to create this
                           template.</p>
        :param str theme_arn: <p>The ARN of the theme associated with this version of the template.</p>
        :param float version_number: <p>The version number of the template version.</p>
        """
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if data_set_configurations is not None:
            pulumi.set(__self__, "data_set_configurations", data_set_configurations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if sheets is not None:
            pulumi.set(__self__, "sheets", sheets)
        if source_entity_arn is not None:
            pulumi.set(__self__, "source_entity_arn", source_entity_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if theme_arn is not None:
            pulumi.set(__self__, "theme_arn", theme_arn)
        if version_number is not None:
            pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[str]:
        """
        <p>The time that this template version was created.</p>
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="dataSetConfigurations")
    def data_set_configurations(self) -> Optional[Sequence['outputs.TemplateDataSetConfiguration']]:
        """
        <p>Schema of the dataset identified by the placeholder. Any dashboard created from this
                    template should be bound to new datasets matching the same schema described through this
                    API operation.</p>
        """
        return pulumi.get(self, "data_set_configurations")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        <p>The description of the template.</p>
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.TemplateError']]:
        """
        <p>Errors associated with this template version.</p>
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def sheets(self) -> Optional[Sequence['outputs.TemplateSheet']]:
        """
        <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
        """
        return pulumi.get(self, "sheets")

    @property
    @pulumi.getter(name="sourceEntityArn")
    def source_entity_arn(self) -> Optional[str]:
        """
        <p>The Amazon Resource Name (ARN) of an analysis or template that was used to create this
                    template.</p>
        """
        return pulumi.get(self, "source_entity_arn")

    @property
    @pulumi.getter
    def status(self) -> Optional['TemplateResourceStatus']:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="themeArn")
    def theme_arn(self) -> Optional[str]:
        """
        <p>The ARN of the theme associated with this version of the template.</p>
        """
        return pulumi.get(self, "theme_arn")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> Optional[float]:
        """
        <p>The version number of the template version.</p>
        """
        return pulumi.get(self, "version_number")


@pulumi.output_type
class ThemeBorderStyle(dict):
    """
    <p>The display options for tile borders for visuals.</p>
    """
    def __init__(__self__, *,
                 show: Optional[bool] = None):
        """
        <p>The display options for tile borders for visuals.</p>
        :param bool show: <p>The option to enable display of borders for visuals.</p>
        """
        if show is not None:
            pulumi.set(__self__, "show", show)

    @property
    @pulumi.getter
    def show(self) -> Optional[bool]:
        """
        <p>The option to enable display of borders for visuals.</p>
        """
        return pulumi.get(self, "show")


@pulumi.output_type
class ThemeConfiguration(dict):
    """
    <p>The theme configuration. This configuration contains all of the display properties for
                a theme.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataColorPalette":
            suggest = "data_color_palette"
        elif key == "uIColorPalette":
            suggest = "u_i_color_palette"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThemeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThemeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThemeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_color_palette: Optional['outputs.ThemeDataColorPalette'] = None,
                 sheet: Optional['outputs.ThemeSheetStyle'] = None,
                 typography: Optional['outputs.ThemeTypography'] = None,
                 u_i_color_palette: Optional['outputs.ThemeUIColorPalette'] = None):
        """
        <p>The theme configuration. This configuration contains all of the display properties for
                    a theme.</p>
        """
        if data_color_palette is not None:
            pulumi.set(__self__, "data_color_palette", data_color_palette)
        if sheet is not None:
            pulumi.set(__self__, "sheet", sheet)
        if typography is not None:
            pulumi.set(__self__, "typography", typography)
        if u_i_color_palette is not None:
            pulumi.set(__self__, "u_i_color_palette", u_i_color_palette)

    @property
    @pulumi.getter(name="dataColorPalette")
    def data_color_palette(self) -> Optional['outputs.ThemeDataColorPalette']:
        return pulumi.get(self, "data_color_palette")

    @property
    @pulumi.getter
    def sheet(self) -> Optional['outputs.ThemeSheetStyle']:
        return pulumi.get(self, "sheet")

    @property
    @pulumi.getter
    def typography(self) -> Optional['outputs.ThemeTypography']:
        return pulumi.get(self, "typography")

    @property
    @pulumi.getter(name="uIColorPalette")
    def u_i_color_palette(self) -> Optional['outputs.ThemeUIColorPalette']:
        return pulumi.get(self, "u_i_color_palette")


@pulumi.output_type
class ThemeDataColorPalette(dict):
    """
    <p>The theme colors that are used for data colors in charts. The colors description is a
                hexadecimal color code that consists of six alphanumerical characters, prefixed with
                    <code>#</code>, for example #37BFF5. </p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emptyFillColor":
            suggest = "empty_fill_color"
        elif key == "minMaxGradient":
            suggest = "min_max_gradient"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThemeDataColorPalette. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThemeDataColorPalette.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThemeDataColorPalette.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 colors: Optional[Sequence[str]] = None,
                 empty_fill_color: Optional[str] = None,
                 min_max_gradient: Optional[Sequence[str]] = None):
        """
        <p>The theme colors that are used for data colors in charts. The colors description is a
                    hexadecimal color code that consists of six alphanumerical characters, prefixed with
                        <code>#</code>, for example #37BFF5. </p>
        :param Sequence[str] colors: <p>The hexadecimal codes for the colors.</p>
        :param str empty_fill_color: <p>The hexadecimal code of a color that applies to charts where a lack of data is
                           highlighted.</p>
        :param Sequence[str] min_max_gradient: <p>The minimum and maximum hexadecimal codes that describe a color gradient. </p>
        """
        if colors is not None:
            pulumi.set(__self__, "colors", colors)
        if empty_fill_color is not None:
            pulumi.set(__self__, "empty_fill_color", empty_fill_color)
        if min_max_gradient is not None:
            pulumi.set(__self__, "min_max_gradient", min_max_gradient)

    @property
    @pulumi.getter
    def colors(self) -> Optional[Sequence[str]]:
        """
        <p>The hexadecimal codes for the colors.</p>
        """
        return pulumi.get(self, "colors")

    @property
    @pulumi.getter(name="emptyFillColor")
    def empty_fill_color(self) -> Optional[str]:
        """
        <p>The hexadecimal code of a color that applies to charts where a lack of data is
                    highlighted.</p>
        """
        return pulumi.get(self, "empty_fill_color")

    @property
    @pulumi.getter(name="minMaxGradient")
    def min_max_gradient(self) -> Optional[Sequence[str]]:
        """
        <p>The minimum and maximum hexadecimal codes that describe a color gradient. </p>
        """
        return pulumi.get(self, "min_max_gradient")


@pulumi.output_type
class ThemeError(dict):
    """
    <p>Theme error.</p>
    """
    def __init__(__self__, *,
                 message: Optional[str] = None,
                 type: Optional['ThemeErrorType'] = None):
        """
        <p>Theme error.</p>
        :param str message: <p>The error message.</p>
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        <p>The error message.</p>
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def type(self) -> Optional['ThemeErrorType']:
        return pulumi.get(self, "type")


@pulumi.output_type
class ThemeFont(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fontFamily":
            suggest = "font_family"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThemeFont. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThemeFont.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThemeFont.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 font_family: Optional[str] = None):
        if font_family is not None:
            pulumi.set(__self__, "font_family", font_family)

    @property
    @pulumi.getter(name="fontFamily")
    def font_family(self) -> Optional[str]:
        return pulumi.get(self, "font_family")


@pulumi.output_type
class ThemeGutterStyle(dict):
    """
    <p>The display options for gutter spacing between tiles on a sheet.</p>
    """
    def __init__(__self__, *,
                 show: Optional[bool] = None):
        """
        <p>The display options for gutter spacing between tiles on a sheet.</p>
        :param bool show: <p>This Boolean value controls whether to display a gutter space between sheet tiles.
                       </p>
        """
        if show is not None:
            pulumi.set(__self__, "show", show)

    @property
    @pulumi.getter
    def show(self) -> Optional[bool]:
        """
        <p>This Boolean value controls whether to display a gutter space between sheet tiles.
                </p>
        """
        return pulumi.get(self, "show")


@pulumi.output_type
class ThemeMarginStyle(dict):
    """
    <p>The display options for margins around the outside edge of sheets.</p>
    """
    def __init__(__self__, *,
                 show: Optional[bool] = None):
        """
        <p>The display options for margins around the outside edge of sheets.</p>
        :param bool show: <p>This Boolean value controls whether to display sheet margins.</p>
        """
        if show is not None:
            pulumi.set(__self__, "show", show)

    @property
    @pulumi.getter
    def show(self) -> Optional[bool]:
        """
        <p>This Boolean value controls whether to display sheet margins.</p>
        """
        return pulumi.get(self, "show")


@pulumi.output_type
class ThemeResourcePermission(dict):
    """
    <p>Permission for the resource.</p>
    """
    def __init__(__self__, *,
                 actions: Sequence[str],
                 principal: str):
        """
        <p>Permission for the resource.</p>
        :param Sequence[str] actions: <p>The IAM action to grant or revoke permissions on.</p>
        :param str principal: <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
                           following:</p>
                       <ul>
                           <li>
                               <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
                           </li>
                           <li>
                               <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
                           </li>
                           <li>
                               <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
                                   ARN. Use this option only to share resources (templates) across AWS accounts.
                                   (This is less common.) </p>
                           </li>
                        </ul>
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[str]:
        """
        <p>The IAM action to grant or revoke permissions on.</p>
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
                    following:</p>
                <ul>
                    <li>
                        <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
                    </li>
                    <li>
                        <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
                    </li>
                    <li>
                        <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight
                            ARN. Use this option only to share resources (templates) across AWS accounts.
                            (This is less common.) </p>
                    </li>
                 </ul>
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class ThemeSheetStyle(dict):
    """
    <p>The theme display options for sheets. </p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tileLayout":
            suggest = "tile_layout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThemeSheetStyle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThemeSheetStyle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThemeSheetStyle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tile: Optional['outputs.ThemeTileStyle'] = None,
                 tile_layout: Optional['outputs.ThemeTileLayoutStyle'] = None):
        """
        <p>The theme display options for sheets. </p>
        """
        if tile is not None:
            pulumi.set(__self__, "tile", tile)
        if tile_layout is not None:
            pulumi.set(__self__, "tile_layout", tile_layout)

    @property
    @pulumi.getter
    def tile(self) -> Optional['outputs.ThemeTileStyle']:
        return pulumi.get(self, "tile")

    @property
    @pulumi.getter(name="tileLayout")
    def tile_layout(self) -> Optional['outputs.ThemeTileLayoutStyle']:
        return pulumi.get(self, "tile_layout")


@pulumi.output_type
class ThemeTag(dict):
    """
    <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
                resource.</p>
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
                    resource.</p>
        :param str key: <p>Tag key.</p>
        :param str value: <p>Tag value.</p>
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        <p>Tag key.</p>
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        <p>Tag value.</p>
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ThemeTileLayoutStyle(dict):
    """
    <p>The display options for the layout of tiles on a sheet.</p>
    """
    def __init__(__self__, *,
                 gutter: Optional['outputs.ThemeGutterStyle'] = None,
                 margin: Optional['outputs.ThemeMarginStyle'] = None):
        """
        <p>The display options for the layout of tiles on a sheet.</p>
        """
        if gutter is not None:
            pulumi.set(__self__, "gutter", gutter)
        if margin is not None:
            pulumi.set(__self__, "margin", margin)

    @property
    @pulumi.getter
    def gutter(self) -> Optional['outputs.ThemeGutterStyle']:
        return pulumi.get(self, "gutter")

    @property
    @pulumi.getter
    def margin(self) -> Optional['outputs.ThemeMarginStyle']:
        return pulumi.get(self, "margin")


@pulumi.output_type
class ThemeTileStyle(dict):
    """
    <p>Display options related to tiles on a sheet.</p>
    """
    def __init__(__self__, *,
                 border: Optional['outputs.ThemeBorderStyle'] = None):
        """
        <p>Display options related to tiles on a sheet.</p>
        """
        if border is not None:
            pulumi.set(__self__, "border", border)

    @property
    @pulumi.getter
    def border(self) -> Optional['outputs.ThemeBorderStyle']:
        return pulumi.get(self, "border")


@pulumi.output_type
class ThemeTypography(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fontFamilies":
            suggest = "font_families"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThemeTypography. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThemeTypography.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThemeTypography.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 font_families: Optional[Sequence['outputs.ThemeFont']] = None):
        if font_families is not None:
            pulumi.set(__self__, "font_families", font_families)

    @property
    @pulumi.getter(name="fontFamilies")
    def font_families(self) -> Optional[Sequence['outputs.ThemeFont']]:
        return pulumi.get(self, "font_families")


@pulumi.output_type
class ThemeUIColorPalette(dict):
    """
    <p>The theme colors that apply to UI and to charts, excluding data colors. The colors
                description is a hexadecimal color code that consists of six alphanumerical characters,
                prefixed with <code>#</code>, for example #37BFF5. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon QuickSight</a> in the <i>Amazon QuickSight User
                    Guide.</i>
            </p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accentForeground":
            suggest = "accent_foreground"
        elif key == "dangerForeground":
            suggest = "danger_foreground"
        elif key == "dimensionForeground":
            suggest = "dimension_foreground"
        elif key == "measureForeground":
            suggest = "measure_foreground"
        elif key == "primaryBackground":
            suggest = "primary_background"
        elif key == "primaryForeground":
            suggest = "primary_foreground"
        elif key == "secondaryBackground":
            suggest = "secondary_background"
        elif key == "secondaryForeground":
            suggest = "secondary_foreground"
        elif key == "successForeground":
            suggest = "success_foreground"
        elif key == "warningForeground":
            suggest = "warning_foreground"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThemeUIColorPalette. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThemeUIColorPalette.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThemeUIColorPalette.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accent: Optional[str] = None,
                 accent_foreground: Optional[str] = None,
                 danger: Optional[str] = None,
                 danger_foreground: Optional[str] = None,
                 dimension: Optional[str] = None,
                 dimension_foreground: Optional[str] = None,
                 measure: Optional[str] = None,
                 measure_foreground: Optional[str] = None,
                 primary_background: Optional[str] = None,
                 primary_foreground: Optional[str] = None,
                 secondary_background: Optional[str] = None,
                 secondary_foreground: Optional[str] = None,
                 success: Optional[str] = None,
                 success_foreground: Optional[str] = None,
                 warning: Optional[str] = None,
                 warning_foreground: Optional[str] = None):
        """
        <p>The theme colors that apply to UI and to charts, excluding data colors. The colors
                    description is a hexadecimal color code that consists of six alphanumerical characters,
                    prefixed with <code>#</code>, for example #37BFF5. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon QuickSight</a> in the <i>Amazon QuickSight User
                        Guide.</i>
                </p>
        :param str accent: <p>This color is that applies to selected states and buttons.</p>
        :param str accent_foreground: <p>The foreground color that applies to any text or other elements that appear over the
                           accent color.</p>
        :param str danger: <p>The color that applies to error messages.</p>
        :param str danger_foreground: <p>The foreground color that applies to any text or other elements that appear over the
                           error color.</p>
        :param str dimension: <p>The color that applies to the names of fields that are identified as
                           dimensions.</p>
        :param str dimension_foreground: <p>The foreground color that applies to any text or other elements that appear over the
                           dimension color.</p>
        :param str measure: <p>The color that applies to the names of fields that are identified as measures.</p>
        :param str measure_foreground: <p>The foreground color that applies to any text or other elements that appear over the
                           measure color.</p>
        :param str primary_background: <p>The background color that applies to visuals and other high emphasis UI.</p>
        :param str primary_foreground: <p>The color of text and other foreground elements that appear over the primary
                           background regions, such as grid lines, borders, table banding, icons, and so on.</p>
        :param str secondary_background: <p>The background color that applies to the sheet background and sheet controls.</p>
        :param str secondary_foreground: <p>The foreground color that applies to any sheet title, sheet control text, or UI that
                           appears over the secondary background.</p>
        :param str success: <p>The color that applies to success messages, for example the check mark for a
                           successful download.</p>
        :param str success_foreground: <p>The foreground color that applies to any text or other elements that appear over the
                           success color.</p>
        :param str warning: <p>This color that applies to warning and informational messages.</p>
        :param str warning_foreground: <p>The foreground color that applies to any text or other elements that appear over the
                           warning color.</p>
        """
        if accent is not None:
            pulumi.set(__self__, "accent", accent)
        if accent_foreground is not None:
            pulumi.set(__self__, "accent_foreground", accent_foreground)
        if danger is not None:
            pulumi.set(__self__, "danger", danger)
        if danger_foreground is not None:
            pulumi.set(__self__, "danger_foreground", danger_foreground)
        if dimension is not None:
            pulumi.set(__self__, "dimension", dimension)
        if dimension_foreground is not None:
            pulumi.set(__self__, "dimension_foreground", dimension_foreground)
        if measure is not None:
            pulumi.set(__self__, "measure", measure)
        if measure_foreground is not None:
            pulumi.set(__self__, "measure_foreground", measure_foreground)
        if primary_background is not None:
            pulumi.set(__self__, "primary_background", primary_background)
        if primary_foreground is not None:
            pulumi.set(__self__, "primary_foreground", primary_foreground)
        if secondary_background is not None:
            pulumi.set(__self__, "secondary_background", secondary_background)
        if secondary_foreground is not None:
            pulumi.set(__self__, "secondary_foreground", secondary_foreground)
        if success is not None:
            pulumi.set(__self__, "success", success)
        if success_foreground is not None:
            pulumi.set(__self__, "success_foreground", success_foreground)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)
        if warning_foreground is not None:
            pulumi.set(__self__, "warning_foreground", warning_foreground)

    @property
    @pulumi.getter
    def accent(self) -> Optional[str]:
        """
        <p>This color is that applies to selected states and buttons.</p>
        """
        return pulumi.get(self, "accent")

    @property
    @pulumi.getter(name="accentForeground")
    def accent_foreground(self) -> Optional[str]:
        """
        <p>The foreground color that applies to any text or other elements that appear over the
                    accent color.</p>
        """
        return pulumi.get(self, "accent_foreground")

    @property
    @pulumi.getter
    def danger(self) -> Optional[str]:
        """
        <p>The color that applies to error messages.</p>
        """
        return pulumi.get(self, "danger")

    @property
    @pulumi.getter(name="dangerForeground")
    def danger_foreground(self) -> Optional[str]:
        """
        <p>The foreground color that applies to any text or other elements that appear over the
                    error color.</p>
        """
        return pulumi.get(self, "danger_foreground")

    @property
    @pulumi.getter
    def dimension(self) -> Optional[str]:
        """
        <p>The color that applies to the names of fields that are identified as
                    dimensions.</p>
        """
        return pulumi.get(self, "dimension")

    @property
    @pulumi.getter(name="dimensionForeground")
    def dimension_foreground(self) -> Optional[str]:
        """
        <p>The foreground color that applies to any text or other elements that appear over the
                    dimension color.</p>
        """
        return pulumi.get(self, "dimension_foreground")

    @property
    @pulumi.getter
    def measure(self) -> Optional[str]:
        """
        <p>The color that applies to the names of fields that are identified as measures.</p>
        """
        return pulumi.get(self, "measure")

    @property
    @pulumi.getter(name="measureForeground")
    def measure_foreground(self) -> Optional[str]:
        """
        <p>The foreground color that applies to any text or other elements that appear over the
                    measure color.</p>
        """
        return pulumi.get(self, "measure_foreground")

    @property
    @pulumi.getter(name="primaryBackground")
    def primary_background(self) -> Optional[str]:
        """
        <p>The background color that applies to visuals and other high emphasis UI.</p>
        """
        return pulumi.get(self, "primary_background")

    @property
    @pulumi.getter(name="primaryForeground")
    def primary_foreground(self) -> Optional[str]:
        """
        <p>The color of text and other foreground elements that appear over the primary
                    background regions, such as grid lines, borders, table banding, icons, and so on.</p>
        """
        return pulumi.get(self, "primary_foreground")

    @property
    @pulumi.getter(name="secondaryBackground")
    def secondary_background(self) -> Optional[str]:
        """
        <p>The background color that applies to the sheet background and sheet controls.</p>
        """
        return pulumi.get(self, "secondary_background")

    @property
    @pulumi.getter(name="secondaryForeground")
    def secondary_foreground(self) -> Optional[str]:
        """
        <p>The foreground color that applies to any sheet title, sheet control text, or UI that
                    appears over the secondary background.</p>
        """
        return pulumi.get(self, "secondary_foreground")

    @property
    @pulumi.getter
    def success(self) -> Optional[str]:
        """
        <p>The color that applies to success messages, for example the check mark for a
                    successful download.</p>
        """
        return pulumi.get(self, "success")

    @property
    @pulumi.getter(name="successForeground")
    def success_foreground(self) -> Optional[str]:
        """
        <p>The foreground color that applies to any text or other elements that appear over the
                    success color.</p>
        """
        return pulumi.get(self, "success_foreground")

    @property
    @pulumi.getter
    def warning(self) -> Optional[str]:
        """
        <p>This color that applies to warning and informational messages.</p>
        """
        return pulumi.get(self, "warning")

    @property
    @pulumi.getter(name="warningForeground")
    def warning_foreground(self) -> Optional[str]:
        """
        <p>The foreground color that applies to any text or other elements that appear over the
                    warning color.</p>
        """
        return pulumi.get(self, "warning_foreground")


@pulumi.output_type
class ThemeVersion(dict):
    """
    <p>A version of a theme.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseThemeId":
            suggest = "base_theme_id"
        elif key == "createdTime":
            suggest = "created_time"
        elif key == "versionNumber":
            suggest = "version_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThemeVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThemeVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThemeVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: Optional[str] = None,
                 base_theme_id: Optional[str] = None,
                 configuration: Optional['outputs.ThemeConfiguration'] = None,
                 created_time: Optional[str] = None,
                 description: Optional[str] = None,
                 errors: Optional[Sequence['outputs.ThemeError']] = None,
                 status: Optional['ThemeResourceStatus'] = None,
                 version_number: Optional[float] = None):
        """
        <p>A version of a theme.</p>
        :param str arn: <p>The Amazon Resource Name (ARN) of the resource.</p>
        :param str base_theme_id: <p>The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All
                           themes initially inherit from a default QuickSight theme.</p>
        :param str created_time: <p>The date and time that this theme version was created.</p>
        :param str description: <p>The description of the theme.</p>
        :param Sequence['ThemeError'] errors: <p>Errors associated with the theme.</p>
        :param float version_number: <p>The version number of the theme.</p>
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if base_theme_id is not None:
            pulumi.set(__self__, "base_theme_id", base_theme_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version_number is not None:
            pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        <p>The Amazon Resource Name (ARN) of the resource.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="baseThemeId")
    def base_theme_id(self) -> Optional[str]:
        """
        <p>The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All
                    themes initially inherit from a default QuickSight theme.</p>
        """
        return pulumi.get(self, "base_theme_id")

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.ThemeConfiguration']:
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[str]:
        """
        <p>The date and time that this theme version was created.</p>
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        <p>The description of the theme.</p>
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.ThemeError']]:
        """
        <p>Errors associated with the theme.</p>
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def status(self) -> Optional['ThemeResourceStatus']:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> Optional[float]:
        """
        <p>The version number of the theme.</p>
        """
        return pulumi.get(self, "version_number")


