"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.RuntimeFamily = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * All known Lambda runtime families.
 */
var RuntimeFamily;
(function (RuntimeFamily) {
    /**
     * All Lambda runtimes that depend on Node.js.
     */
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    /**
     * All lambda runtimes that depend on Python.
     */
    RuntimeFamily[RuntimeFamily["PYTHON"] = 1] = "PYTHON";
    /**
     * Any future runtime family.
     */
    RuntimeFamily[RuntimeFamily["OTHER"] = 2] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Runtime options for a canary
 */
class Runtime {
    /**
      * @param name The name of the runtime version
      * @param family The Lambda runtime family
      */
    constructor(name, family) {
        this.name = name;
        this.family = family;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_synthetics_alpha_RuntimeFamily(family);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Runtime);
            }
            throw error;
        }
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "@aws-cdk/aws-synthetics-alpha.Runtime", version: "2.58.0-alpha.0" };
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-1.0` includes the following:
 *
 * - Synthetics library 1.0
 * - Synthetics handler code 1.0
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 1.14.0
 * - The Chromium version that matches Puppeteer-core 1.14.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-1.0
 */
Runtime.SYNTHETICS_1_0 = new Runtime('syn-1.0', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-2.0` includes the following:
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 3.3.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.0
 */
Runtime.SYNTHETICS_NODEJS_2_0 = new Runtime('syn-nodejs-2.0', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-2.1` includes the following:
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 3.3.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.1
 */
Runtime.SYNTHETICS_NODEJS_2_1 = new Runtime('syn-nodejs-2.1', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-2.2` includes the following:
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 3.3.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.2
 */
Runtime.SYNTHETICS_NODEJS_2_2 = new Runtime('syn-nodejs-2.2', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.0` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.0
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_0 = new Runtime('syn-nodejs-puppeteer-3.0', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.1` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.1
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_1 = new Runtime('syn-nodejs-puppeteer-3.1', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.2` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.2
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_2 = new Runtime('syn-nodejs-puppeteer-3.2', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.3` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.3
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_3 = new Runtime('syn-nodejs-puppeteer-3.3', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.4` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.4
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_4 = new Runtime('syn-nodejs-puppeteer-3.4', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.5` includes the following:
 * - Lambda runtime Node.js 14.x
 * - Puppeteer-core version 10.1.0
 * - Chromium version 92.0.4512
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.5
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_5 = new Runtime('syn-nodejs-puppeteer-3.5', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.6` includes the following:
 * - Lambda runtime Node.js 14.x
 * - Puppeteer-core version 10.1.0
 * - Chromium version 92.0.4512
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.6
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_6 = new Runtime('syn-nodejs-puppeteer-3.6', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.7` includes the following:
 * - Lambda runtime Node.js 14.x
 * - Puppeteer-core version 10.1.0
 * - Chromium version 92.0.4512
 *
 * New Features:
 * - **Logging enhancement**: The canary will upload logs to Amazon S3 even if it times out or crashes.
 * - **Lambda layer size reduced**: The size of the Lambda layer used for canaries is reduced by 34%.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.7
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_7 = new Runtime('syn-nodejs-puppeteer-3.7', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.8` includes the following:
 * - Lambda runtime Node.js 14.x
 * - Puppeteer-core version 10.1.0
 * - Chromium version 92.0.4512
 *
 * New Features:
 * - **Profile cleanup**: Chromium profiles are now cleaned up after each canary run.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.8
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_8 = new Runtime('syn-nodejs-puppeteer-3.8', RuntimeFamily.NODEJS);
/**
 * `syn-python-selenium-1.0` includes the following:
 * - Lambda runtime Python 3.8
 * - Selenium version 3.141.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html
 */
Runtime.SYNTHETICS_PYTHON_SELENIUM_1_0 = new Runtime('syn-python-selenium-1.0', RuntimeFamily.PYTHON);
//# sourceMappingURL=data:application/json;base64,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