"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SendToQueue = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const resource_arn_suffix_1 = require("../resource-arn-suffix");
/**
 * A StepFunctions Task to send messages to SQS queue.
 *
 * A Function can be used directly as a Resource, but this class mirrors
 * integration with other AWS services via a specific class instance.
 *
 * @deprecated Use `SqsSendMessage`
 */
class SendToQueue {
    constructor(queue, props) {
        this.queue = queue;
        this.props = props;
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions-tasks.SendToQueue", "Use `SqsSendMessage`");
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_SendToQueueProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.integrationPattern = props.integrationPattern || sfn.ServiceIntegrationPattern.FIRE_AND_FORGET;
        const supportedPatterns = [
            sfn.ServiceIntegrationPattern.FIRE_AND_FORGET,
            sfn.ServiceIntegrationPattern.WAIT_FOR_TASK_TOKEN,
        ];
        if (!supportedPatterns.includes(this.integrationPattern)) {
            throw new Error(`Invalid Service Integration Pattern: ${this.integrationPattern} is not supported to call SQS.`);
        }
        if (props.integrationPattern === sfn.ServiceIntegrationPattern.WAIT_FOR_TASK_TOKEN) {
            if (!sfn.FieldUtils.containsTaskToken(props.messageBody)) {
                throw new Error('Task Token is missing in messageBody (pass JsonPath.taskToken somewhere in messageBody)');
            }
        }
    }
    bind(_task) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions-tasks.SendToQueue#bind", "Use `SqsSendMessage`");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            resourceArn: resource_arn_suffix_1.getResourceArn('sqs', 'sendMessage', this.integrationPattern),
            policyStatements: [new iam.PolicyStatement({
                    actions: ['sqs:SendMessage'],
                    resources: [this.queue.queueArn],
                })],
            parameters: {
                QueueUrl: this.queue.queueUrl,
                MessageBody: this.props.messageBody.value,
                DelaySeconds: this.props.delay && this.props.delay.toSeconds(),
                MessageDeduplicationId: this.props.messageDeduplicationId,
                MessageGroupId: this.props.messageGroupId,
            },
        };
    }
}
exports.SendToQueue = SendToQueue;
_a = JSII_RTTI_SYMBOL_1;
SendToQueue[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.SendToQueue", version: "1.153.0" };
//# sourceMappingURL=data:application/json;base64,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