"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallApiGatewayRestApiEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const base_1 = require("./base");
/**
 * Call REST API endpoint as a Task
 *
 * Be aware that the header values must be arrays. When passing the Task Token
 * in the headers field `WAIT_FOR_TASK_TOKEN` integration, use
 * `JsonPath.array()` to wrap the token in an array:
 *
 * ```ts
 * import * as apigateway from '@aws-cdk/aws-apigateway';
 * declare const api: apigateway.RestApi;
 *
 * new tasks.CallApiGatewayRestApiEndpoint(this, 'Endpoint', {
 *   api,
 *   stageName: 'Stage',
 *   method: tasks.HttpMethod.PUT,
 *   integrationPattern: sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
 *   headers: sfn.TaskInput.fromObject({
 *     TaskToken: sfn.JsonPath.array(sfn.JsonPath.taskToken),
 *   }),
 * });
 * ```
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 */
class CallApiGatewayRestApiEndpoint extends base_1.CallApiGatewayEndpointBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_CallApiGatewayRestApiEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.apiEndpoint = this.getApiEndpoint();
        this.arnForExecuteApi = props.api.arnForExecuteApi(props.method, props.apiPath, props.stageName);
        this.stageName = props.stageName;
        this.taskPolicies = this.createPolicyStatements();
    }
    getApiEndpoint() {
        const apiStack = cdk.Stack.of(this.props.api);
        return `${this.props.api.restApiId}.execute-api.${apiStack.region}.${apiStack.urlSuffix}`;
    }
}
exports.CallApiGatewayRestApiEndpoint = CallApiGatewayRestApiEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CallApiGatewayRestApiEndpoint[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.CallApiGatewayRestApiEndpoint", version: "1.153.0" };
//# sourceMappingURL=data:application/json;base64,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