"""Physical constants used in pytmosph3r.
"""
import astropy.units as u

AMU = 1.660538921e-27 # 1e-3/AMU = N_A = 6.022141290116741e+23
KBOLTZ = 1.380648813e-23
G = 6.67384e-11
RSOL = u.Rsun.to(u.m) # 6.957e8
RJUP = u.Rjup.to(u.m) # 71492000 in astropy
RGP = 8.31446
PI = 3.14159265359
MSOL = u.Msun.to(u.kg) #equal to 1.9884099e+30
MJUP = 1.898e27
AU = 1.49597871e+11
PLANCK = 6.62606957e-34
SPDLIGT = 299792458
