import * as eks from '@aws-cdk/aws-eks';
import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * (experimental) Properties for calling a EKS endpoint with EksCall.
 *
 * @experimental
 */
export interface EksCallProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The EKS cluster.
     *
     * @experimental
     */
    readonly cluster: eks.ICluster;
    /**
     * (experimental) HTTP method ("GET", "POST", "PUT", ...) part of HTTP request.
     *
     * @experimental
     */
    readonly httpMethod: HttpMethods;
    /**
     * (experimental) HTTP path of the Kubernetes REST API operation For example: /api/v1/namespaces/default/pods.
     *
     * @experimental
     */
    readonly httpPath: string;
    /**
     * (experimental) Query Parameters part of HTTP request.
     *
     * @default - no query parameters
     * @experimental
     */
    readonly queryParameters?: {
        [key: string]: string[];
    };
    /**
     * (experimental) Request body part of HTTP request.
     *
     * @default - No request body
     * @experimental
     */
    readonly requestBody?: sfn.TaskInput;
}
/**
 * (experimental) Call a EKS endpoint as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-eks.html
 * @experimental
 */
export declare class EksCall extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * (experimental) No policies are required due to eks:call is an Http service integration and does not call and EKS API directly.
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-eks.html#connect-eks-permissions
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    private readonly clusterEndpoint;
    private readonly clusterCertificateAuthorityData;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EksCallProps);
    /**
     * Provides the EKS Call service integration task configuration
     * @internal
     */
    protected _renderTask(): any;
}
/**
 * Method type of a EKS call.
 *
 * @stability stable
 */
export declare enum HttpMethods {
    /**
     * Retrieve data from a server at the specified resource.
     *
     * @stability stable
     */
    GET = "GET",
    /**
     * Send data to the API endpoint to create or update a resource.
     *
     * @stability stable
     */
    POST = "POST",
    /**
     * Send data to the API endpoint to update or create a resource.
     *
     * @stability stable
     */
    PUT = "PUT",
    /**
     * Delete the resource at the specified endpoint.
     *
     * @stability stable
     */
    DELETE = "DELETE",
    /**
     * Apply partial modifications to the resource.
     *
     * @stability stable
     */
    PATCH = "PATCH",
    /**
     * Retrieve data from a server at the specified resource without the response body.
     *
     * @stability stable
     */
    HEAD = "HEAD"
}
