"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncryptionOption = exports.AthenaStartQueryExecution = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * (experimental) Start an Athena Query as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html
 * @experimental
 */
class AthenaStartQueryExecution extends sfn.TaskStateBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        this.integrationPattern = (_b = props.integrationPattern) !== null && _b !== void 0 ? _b : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, AthenaStartQueryExecution.SUPPORTED_INTEGRATION_PATTERNS);
        this.taskPolicies = this.createPolicyStatements();
    }
    createPolicyStatements() {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
        const policyStatements = [
            new iam.PolicyStatement({
                resources: [
                    cdk.Stack.of(this).formatArn({
                        service: 'athena',
                        resource: 'datacatalog',
                        resourceName: (_c = (_b = this.props.queryExecutionContext) === null || _b === void 0 ? void 0 : _b.catalogName) !== null && _c !== void 0 ? _c : 'AwsDataCatalog',
                    }),
                    cdk.Stack.of(this).formatArn({
                        service: 'athena',
                        resource: 'workgroup',
                        resourceName: (_d = this.props.workGroup) !== null && _d !== void 0 ? _d : 'primary',
                    }),
                ],
                actions: ['athena:getDataCatalog', 'athena:startQueryExecution', 'athena:getQueryExecution'],
            }),
        ];
        policyStatements.push(new iam.PolicyStatement({
            actions: ['s3:CreateBucket',
                's3:ListBucket',
                's3:GetBucketLocation',
                's3:GetObject'],
            resources: ['*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['s3:AbortMultipartUpload',
                's3:ListBucketMultipartUploads',
                's3:ListMultipartUploadParts',
                's3:PutObject'],
            resources: [((_f = (_e = this.props.resultConfiguration) === null || _e === void 0 ? void 0 : _e.outputLocation) === null || _f === void 0 ? void 0 : _f.bucketName) ? `arn:aws:s3:::${(_h = (_g = this.props.resultConfiguration) === null || _g === void 0 ? void 0 : _g.outputLocation) === null || _h === void 0 ? void 0 : _h.bucketName}/${(_k = (_j = this.props.resultConfiguration) === null || _j === void 0 ? void 0 : _j.outputLocation) === null || _k === void 0 ? void 0 : _k.objectKey}/*` : '*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['lakeformation:GetDataAccess'],
            resources: ['*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['glue:BatchCreatePartition',
                'glue:BatchDeletePartition',
                'glue:BatchDeleteTable',
                'glue:BatchGetPartition',
                'glue:CreateDatabase',
                'glue:CreatePartition',
                'glue:CreateTable',
                'glue:DeleteDatabase',
                'glue:DeletePartition',
                'glue:DeleteTable',
                'glue:GetDatabase',
                'glue:GetDatabases',
                'glue:GetPartition',
                'glue:GetPartitions',
                'glue:GetTable',
                'glue:GetTables',
                'glue:UpdateDatabase',
                'glue:UpdatePartition',
                'glue:UpdateTable'],
            resources: [
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'catalog',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'database',
                    resourceName: (_m = (_l = this.props.queryExecutionContext) === null || _l === void 0 ? void 0 : _l.databaseName) !== null && _m !== void 0 ? _m : 'default',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'table',
                    resourceName: ((_p = (_o = this.props.queryExecutionContext) === null || _o === void 0 ? void 0 : _o.databaseName) !== null && _p !== void 0 ? _p : 'default') + '/*',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'userDefinedFunction',
                    resourceName: ((_r = (_q = this.props.queryExecutionContext) === null || _q === void 0 ? void 0 : _q.databaseName) !== null && _r !== void 0 ? _r : 'default') + '/*',
                }),
            ],
        }));
        return policyStatements;
    }
    renderEncryption() {
        var _b;
        const encryptionConfiguration = ((_b = this.props.resultConfiguration) === null || _b === void 0 ? void 0 : _b.encryptionConfiguration) !== undefined
            ? {
                EncryptionOption: this.props.resultConfiguration.encryptionConfiguration.encryptionOption,
                KmsKey: this.props.resultConfiguration.encryptionConfiguration.encryptionKey,
            }
            : undefined;
        return encryptionConfiguration;
    }
    /**
     * Provides the Athena start query execution service integration task configuration
     */
    /**
     * @internal
     */
    _renderTask() {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k;
        if ((_b = this.props.resultConfiguration) === null || _b === void 0 ? void 0 : _b.outputLocation) {
            return {
                Resource: task_utils_1.integrationResourceArn('athena', 'startQueryExecution', this.integrationPattern),
                Parameters: sfn.FieldUtils.renderObject({
                    QueryString: this.props.queryString,
                    ClientRequestToken: this.props.clientRequestToken,
                    QueryExecutionContext: {
                        Catalog: (_c = this.props.queryExecutionContext) === null || _c === void 0 ? void 0 : _c.catalogName,
                        Database: (_d = this.props.queryExecutionContext) === null || _d === void 0 ? void 0 : _d.databaseName,
                    },
                    ResultConfiguration: {
                        EncryptionConfiguration: this.renderEncryption(),
                        OutputLocation: `s3://${(_f = (_e = this.props.resultConfiguration) === null || _e === void 0 ? void 0 : _e.outputLocation) === null || _f === void 0 ? void 0 : _f.bucketName}/${(_h = (_g = this.props.resultConfiguration) === null || _g === void 0 ? void 0 : _g.outputLocation) === null || _h === void 0 ? void 0 : _h.objectKey}/`,
                    },
                    WorkGroup: this.props.workGroup,
                }),
            };
        }
        else {
            return {
                Resource: task_utils_1.integrationResourceArn('athena', 'startQueryExecution', this.integrationPattern),
                Parameters: sfn.FieldUtils.renderObject({
                    QueryString: this.props.queryString,
                    ClientRequestToken: this.props.clientRequestToken,
                    QueryExecutionContext: {
                        Catalog: (_j = this.props.queryExecutionContext) === null || _j === void 0 ? void 0 : _j.catalogName,
                        Database: (_k = this.props.queryExecutionContext) === null || _k === void 0 ? void 0 : _k.databaseName,
                    },
                    ResultConfiguration: {
                        EncryptionConfiguration: this.renderEncryption(),
                    },
                    WorkGroup: this.props.workGroup,
                }),
            };
        }
    }
}
exports.AthenaStartQueryExecution = AthenaStartQueryExecution;
_a = JSII_RTTI_SYMBOL_1;
AthenaStartQueryExecution[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.AthenaStartQueryExecution", version: "1.97.0" };
AthenaStartQueryExecution.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.RUN_JOB,
];
/**
 * (experimental) Encryption Options of the S3 bucket.
 *
 * @see https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption
 * @experimental
 */
var EncryptionOption;
(function (EncryptionOption) {
    EncryptionOption["S3_MANAGED"] = "SSE_S3";
    EncryptionOption["KMS"] = "SSE_KMS";
    EncryptionOption["CLIENT_SIDE_KMS"] = "CSE_KMS";
})(EncryptionOption = exports.EncryptionOption || (exports.EncryptionOption = {}));
//# sourceMappingURL=data:application/json;base64,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