"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Deployment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// import { AutoScalingGroup, IAutoScalingGroup } from '@aws-cdk/aws-autoscaling';
const aws_codedeploy_1 = require("@aws-cdk/aws-codedeploy");
// import { Role } from '@aws-cdk/aws-iam';
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class Deployment extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const app = this.getApp(props.applicationProps);
        const dg = new aws_codedeploy_1.CfnDeploymentGroup(this, props.deploymentGroupName, {
            deploymentGroupName: props.deploymentGroupName,
            applicationName: props.applicationProps.applicationName,
            serviceRoleArn: props.roleArn,
            autoScalingGroups: props.asgNames,
            deploymentConfigName: props.deploymentConfigName,
        });
        dg.node.addDependency(app);
    }
    getApp(props) {
        if (props.type == 'existing') {
            const app = aws_codedeploy_1.ServerApplication.fromServerApplicationName(this, props.applicationName, props.applicationName);
            return app;
        }
        else {
            const app = new aws_codedeploy_1.ServerApplication(this, props.applicationName, {
                applicationName: props.applicationName,
            });
            return app;
        }
    }
}
exports.Deployment = Deployment;
_a = JSII_RTTI_SYMBOL_1;
Deployment[_a] = { fqn: "@smallcase/aws-cdk-microservice.Deployment", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVwbG95bWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9jb25zdHJ1Y3RzL2RlcGxveW1lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxrRkFBa0Y7QUFDbEYsNERBQWdGO0FBQ2hGLDJDQUEyQztBQUMzQyxxQ0FBcUM7Ozs7QUFnQnJDLE1BQWEsVUFBVyxTQUFRLEdBQUcsQ0FBQyxTQUFTOzs7O0lBQzNDLFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBc0I7UUFDbEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBRWhELE1BQU0sRUFBRSxHQUFHLElBQUksbUNBQWtCLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxtQkFBbUIsRUFBRTtZQUNqRSxtQkFBbUIsRUFBRSxLQUFLLENBQUMsbUJBQW1CO1lBQzlDLGVBQWUsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsZUFBZTtZQUN2RCxjQUFjLEVBQUUsS0FBSyxDQUFDLE9BQU87WUFDN0IsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDakMsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLG9CQUFvQjtTQUNqRCxDQUFDLENBQUM7UUFDSCxFQUFFLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUM3QixDQUFDO0lBRU8sTUFBTSxDQUFDLEtBQXVCO1FBQ3BDLElBQUksS0FBSyxDQUFDLElBQUksSUFBSSxVQUFVLEVBQUU7WUFDNUIsTUFBTSxHQUFHLEdBQUcsa0NBQWlCLENBQUMseUJBQXlCLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWUsQ0FBQyxDQUFDO1lBQzVHLE9BQU8sR0FBRyxDQUFDO1NBQ1o7YUFBTTtZQUNMLE1BQU0sR0FBRyxHQUFHLElBQUksa0NBQWlCLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxlQUFlLEVBQUU7Z0JBQzdELGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTthQUN2QyxDQUFDLENBQUM7WUFDSCxPQUFPLEdBQUcsQ0FBQztTQUNaO0lBQ0gsQ0FBQzs7QUExQkgsZ0NBMkJDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gaW1wb3J0IHsgQXV0b1NjYWxpbmdHcm91cCwgSUF1dG9TY2FsaW5nR3JvdXAgfSBmcm9tICdAYXdzLWNkay9hd3MtYXV0b3NjYWxpbmcnO1xuaW1wb3J0IHsgQ2ZuRGVwbG95bWVudEdyb3VwLCBTZXJ2ZXJBcHBsaWNhdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1jb2RlZGVwbG95Jztcbi8vIGltcG9ydCB7IFJvbGUgfSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuZXhwb3J0IGludGVyZmFjZSBBcHBsaWNhdGlvblByb3BzIHtcbiAgcmVhZG9ubHkgYXBwbGljYXRpb25OYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJlc291cmNlVHlwZTogc3RyaW5nO1xuICByZWFkb25seSB0eXBlOiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIERlcGxveW1lbnRQcm9wcyB7XG4gIHJlYWRvbmx5IGFwcGxpY2F0aW9uUHJvcHM6IEFwcGxpY2F0aW9uUHJvcHM7XG4gIHJlYWRvbmx5IGRlcGxveW1lbnRHcm91cE5hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgYXNnTmFtZXM6IHN0cmluZ1tdO1xuICByZWFkb25seSByb2xlQXJuOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlcGxveW1lbnRDb25maWdOYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHRnTmFtZTogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgRGVwbG95bWVudCBleHRlbmRzIGNkay5Db25zdHJ1Y3Qge1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IERlcGxveW1lbnRQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBhcHAgPSB0aGlzLmdldEFwcChwcm9wcy5hcHBsaWNhdGlvblByb3BzKTtcblxuICAgIGNvbnN0IGRnID0gbmV3IENmbkRlcGxveW1lbnRHcm91cCh0aGlzLCBwcm9wcy5kZXBsb3ltZW50R3JvdXBOYW1lLCB7XG4gICAgICBkZXBsb3ltZW50R3JvdXBOYW1lOiBwcm9wcy5kZXBsb3ltZW50R3JvdXBOYW1lLFxuICAgICAgYXBwbGljYXRpb25OYW1lOiBwcm9wcy5hcHBsaWNhdGlvblByb3BzLmFwcGxpY2F0aW9uTmFtZSxcbiAgICAgIHNlcnZpY2VSb2xlQXJuOiBwcm9wcy5yb2xlQXJuLFxuICAgICAgYXV0b1NjYWxpbmdHcm91cHM6IHByb3BzLmFzZ05hbWVzLFxuICAgICAgZGVwbG95bWVudENvbmZpZ05hbWU6IHByb3BzLmRlcGxveW1lbnRDb25maWdOYW1lLFxuICAgIH0pO1xuICAgIGRnLm5vZGUuYWRkRGVwZW5kZW5jeShhcHApO1xuICB9XG5cbiAgcHJpdmF0ZSBnZXRBcHAocHJvcHM6IEFwcGxpY2F0aW9uUHJvcHMpIHtcbiAgICBpZiAocHJvcHMudHlwZSA9PSAnZXhpc3RpbmcnKSB7XG4gICAgICBjb25zdCBhcHAgPSBTZXJ2ZXJBcHBsaWNhdGlvbi5mcm9tU2VydmVyQXBwbGljYXRpb25OYW1lKHRoaXMsIHByb3BzLmFwcGxpY2F0aW9uTmFtZSwgcHJvcHMuYXBwbGljYXRpb25OYW1lKTtcbiAgICAgIHJldHVybiBhcHA7XG4gICAgfSBlbHNlIHtcbiAgICAgIGNvbnN0IGFwcCA9IG5ldyBTZXJ2ZXJBcHBsaWNhdGlvbih0aGlzLCBwcm9wcy5hcHBsaWNhdGlvbk5hbWUsIHtcbiAgICAgICAgYXBwbGljYXRpb25OYW1lOiBwcm9wcy5hcHBsaWNhdGlvbk5hbWUsXG4gICAgICB9KTtcbiAgICAgIHJldHVybiBhcHA7XG4gICAgfVxuICB9XG59Il19