# Changelog

## [v5.0.0-alpha](https://github.com/boutproject/BOUT-dev/tree/next)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.3.2...next)

### Breaking changes

- `BoutMesh::GlobalNy` now counts points from all y-boundaries. Previously it
  only counted points from the boundaries at the upper and lower edges of the
  logical grid, even if there was another boundary in the grid.
  [\#1829](https://github.com/boutproject/BOUT-dev/pull/1829)
- `invert_laplace` free function removed
  [\#1834](https://github.com/boutproject/BOUT-dev/pull/1834)
- Most factories and `create` methods standardised. Run
  `bin/bout-v5-factory-upgrader.py` on your physics models to update
  them [\#1842](https://github.com/boutproject/BOUT-dev/pull/1842)
  [\#2087](https://github.com/boutproject/BOUT-dev/pull/2087)
- We now use [fmt](https://fmt.dev) for all our string formatting,
  instead of the printf-style formatting. This affects calls to
  `Output`, `BoutException`/`ParseException`, `DataFile`,
  `OptionsReader`, and `MsgStack`/`TRACE`. Run
  `bin/bout-v5-format-upgrader.py` on your physics models to update
  them. [\#1847](https://github.com/boutproject/BOUT-dev/pull/1847)
- The option `laplacexy:y_bndry_dirichlet` has been deprecated. Use
  `laplacexy:y_bndry=dirichlet` instead.
  [\#1789](https://github.com/boutproject/BOUT-dev/pull/1789)
- The variable `BOUT_VERSION`, and the macros `REVISION`,
  `BOUT_VERSION_STRING` and `BOUT_VERSION_DOUBLE` have been replaced
  with `constexpr` variables in the `bout::version`
  namespace. `REVISION` is found in `include/bout/revision.hxx`, while
  the rest are in `include/bout/version.hxx`. Both files are generated
  at configure time. Run `bin/bout-v5-macro-upgrader.py` to
  update. [\#1920](https://github.com/boutproject/BOUT-dev/pull/1920)
- The `MUMPS` Laplacian inversion wrapper has been removed. It is still possible
  to use `MUMPS` for Laplacian inversions through the `PETSc`
  wrapper. [\#2018](https://github.com/boutproject/BOUT-dev/pull/2018)
- The `using namespace bout::globals` statement has been removed from
  `physics_model.hxx`, and `PhysicsModel` has gained public `mesh` and
  `dump` members. Custom `main`s, free functions and legacy models
  will need to be updated to either use `bout::globals::mesh` or
  `Field::getMesh()` in free
  functions. [\#2042](https://github.com/boutproject/BOUT-dev/pull/2042)
- The `LaplaceShoot` Laplacian implementation was removed. There are
  very few cases, if any, where this implementation actually
  works. [\#2177](https://github.com/boutproject/BOUT-dev/pull/2177)
- `PhysicsModel` expects the options `datadir` and `dump_format` to
  have been set; this is only a problem if you don't call
  `BoutInitialise`. [\#2062](https://github.com/boutproject/BOUT-dev/pull/2062)
- `dz` is now a `Field2D`, and `Coordinates::zlength()` also returns a
  `Field2D`. In most cases, wrapping these in a call to `getUniform`
  in order to get a `BoutReal` will do the correct thing. If checks
  are enabled, `getUniform` will throw an exception if its argument is
  not uniform (that is, that all values are identical).
  [\#2025](https://github.com/boutproject/BOUT-dev/pull/2025)
- The parallel boundaries `BNDRY_PAR_FWD` and `BNDRY_PAR_BKWD` have
  been expanded to distinguish between the inner and outer boundaries
  in x; the enums have been replaced with `BNDRY_PAR_*_XIN`, and
  `BNDRY_PAR_*_XOUT` for both `FWD` and
  `BKWD`. [\#2025](https://github.com/boutproject/BOUT-dev/pull/2025)
- Support for reading/writing HDF5 files has been removed ahead of completely
  refactoring the I/O
- Support for reading/writing HDF5 files has been removed ahead of
  completely refactoring the I/O
  systems. [\#2208](https://github.com/boutproject/BOUT-dev/pull/2208)
- Removed the Karniadakis time solver. Other choices for split-operator schemes
  are: `splitrk` (built-in), `imexbdf2` (requires PETSc), and `arkode` (requires
  SUNDIALS) [\#2241](https://github.com/boutproject/BOUT-dev/pull/2241)
- Conversion of Option to bool is now stricter.  Previously, only tested
  (case-insensitively) if first character was 'n', 'f', '0', 'y', 't', or '1'.
  Now only allow (still case-insensitively but checking full strings) 'n',
  'no', 'f', 'false', '0', 'y', 'yes', 't', 'true', or '1'.
  [\#2282](https://github.com/boutproject/BOUT-dev/pull/2282)
- Having any unused options remaining after the first call to the physics model
  `rhs` is now an error. Set `input:error_on_unused_options = false` for old
  behaviour [\#2210](https://github.com/boutproject/BOUT-dev/pull/2210)
- Input options are now case sensitive. Run `bin/bout-v5-input-file-upgrader.py`
  to automatically fix the most common library options
  [\#2210](https://github.com/boutproject/BOUT-dev/pull/2210)
- Input options are now required to be either a section or a value, and not
  both. This requires renaming the `restart` section to
  `restart_files`. `bin/bout-v5-input-file-upgrader.py` can automatically make
  this change. [\#2277](https://github.com/boutproject/BOUT-dev/pull/2277)
- `Options` are now only implicitly-castable to types stored in the internal
  variant. Other types now require a call to `Options::as<T>()`
  [\#2341](https://github.com/boutproject/BOUT-dev/pull/2341)
- The Laplacian inversion solver `LaplacePDD` (`"pdd"`) has been
  removed. This implementation had some quite significant drawbacks
  that made it not terribly useful in practice
  [\#3566](https://github.com/boutproject/BOUT-dev/pull/3566)
- `DataFile` and `bout::globals::dump` have been removed in favour of
  `OptionsNetCDF`. Uses of `SAVE_ONCE/REPEAT` inside `PhysicsModel` code will
  still work for the time being; outside of `PhysicsModel` methods, these macros
  will need to be manually replaced. See **FIXME: DOCS TO BE WRITTEN** for more
  details. [\#2209](https://github.com/boutproject/BOUT-dev/pull/2209)


## v4 known bugs


  See [\#2154](https://github.com/boutproject/BOUT-dev/pull/2154).

## [v4.4.1](https://github.com/boutproject/BOUT-dev/tree/v4.4.1) (2021-12-15)

[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.4.0...v4.4.1)

**Merged pull requests:**

- Back-port beuler/snes improvements to master [\#2459](https://github.com/boutproject/BOUT-dev/pull/2459) ([bendudson](https://github.com/users/bendudson))
- Update "Running BOUT++" documentation [\#2475](https://github.com/boutproject/BOUT-dev/pull/2475) ([ZedThree](https://github.com/users/ZedThree))
- Raise more descriptive error if converting Option fails [\#2474](https://github.com/boutproject/BOUT-dev/pull/2474) ([ZedThree](https://github.com/users/ZedThree))
- Print correct CMake build directory in configure message [\#2473](https://github.com/boutproject/BOUT-dev/pull/2473) ([ZedThree](https://github.com/users/ZedThree))
- CMake: Fix using the build directory directly [\#2464](https://github.com/boutproject/BOUT-dev/pull/2464) ([ZedThree](https://github.com/users/ZedThree))
- Add `bout::utils::` prefix to `visit` [\#2463](https://github.com/boutproject/BOUT-dev/pull/2463) ([ZedThree](https://github.com/users/ZedThree))
- Fix SUNDIALS download git tag [\#2462](https://github.com/boutproject/BOUT-dev/pull/2462) ([ZedThree](https://github.com/users/ZedThree))
- Fix permission of shared objects [\#2433](https://github.com/boutproject/BOUT-dev/pull/2433) ([dschwoerer](https://github.com/users/dschwoerer))
- Fix BOUT_OVERRIDE_DEFAULT_OPTION() [\#2417](https://github.com/boutproject/BOUT-dev/pull/2417) ([johnomotani](https://github.com/users/johnomotani))
- Ensure MPI is initialised before writing [\#2409](https://github.com/boutproject/BOUT-dev/pull/2409) ([dschwoerer](https://github.com/users/dschwoerer))
- Remove `<optional>` include from uuid (v4.4.1) [\#2407](https://github.com/boutproject/BOUT-dev/pull/2407) ([ZedThree](https://github.com/users/ZedThree))
- Fix make install [\#2401](https://github.com/boutproject/BOUT-dev/pull/2401) ([dschwoerer](https://github.com/users/dschwoerer))
- Fix soname [\#2400](https://github.com/boutproject/BOUT-dev/pull/2400) ([dschwoerer](https://github.com/users/dschwoerer))

## [v4.4.0](https://github.com/boutproject/BOUT-dev/tree/v4.4.0) (2021-07-30)

[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.3.3...v4.4.4)

**Merged pull requests:**

- Add ability to use FieldPerp in Options (v.4.4) [\#2395](https://github.com/boutproject/BOUT-dev/pull/2395) ([ZedThree](https://github.com/users/ZedThree))
- Fix some HDF5 related issues and add Mesh::getLocal{X,Y,Z}Index (v4.4) [\#2394](https://github.com/boutproject/BOUT-dev/pull/2394) ([ZedThree](https://github.com/users/ZedThree))
- Add Mesh::getRegion<T> for use in generic code (v4.4) [\#2393](https://github.com/boutproject/BOUT-dev/pull/2393) ([ZedThree](https://github.com/users/ZedThree))
- Adding an adaptive, arbitrary order, Adams-Bashforth solver (v4.4) [\#2392](https://github.com/boutproject/BOUT-dev/pull/2392) ([ZedThree](https://github.com/users/ZedThree))
- Allow PETSc options to be passed from BOUT.inp (v4.4) [\#2391](https://github.com/boutproject/BOUT-dev/pull/2391) ([ZedThree](https://github.com/users/ZedThree))
- Add new contributors [\#2386](https://github.com/boutproject/BOUT-dev/pull/2386) ([dschwoerer](https://github.com/users/dschwoerer))
- Update locale [\#2385](https://github.com/boutproject/BOUT-dev/pull/2385) ([dschwoerer](https://github.com/users/dschwoerer))
- Fix RTD [\#2384](https://github.com/boutproject/BOUT-dev/pull/2384) ([dschwoerer](https://github.com/users/dschwoerer))
- Rename `max_nonlinear_it` to `max_nonlinear_iterations` [\#2339](https://github.com/boutproject/BOUT-dev/pull/2339) ([johnomotani](https://github.com/users/johnomotani))
- CVODE constraints and max_noinlinear_iterations options (4.4) [\#2304](https://github.com/boutproject/BOUT-dev/pull/2304) ([johnomotani](https://github.com/users/johnomotani))
- Fix some Solvers not always using user preconditioner/Jacobian (v4.4) [\#2284](https://github.com/boutproject/BOUT-dev/pull/2284) ([ZedThree](https://github.com/users/ZedThree))
- Fix formatting strings for pre-fmt in beuler solver [\#2278](https://github.com/boutproject/BOUT-dev/pull/2278) ([bendudson](https://github.com/users/bendudson))
- Backport of Backward Euler solver to v4.4 [\#2265](https://github.com/boutproject/BOUT-dev/pull/2265) ([bendudson](https://github.com/users/bendudson))
- Fix use of uninitialised value in Delp2 (4.4) [\#2263](https://github.com/boutproject/BOUT-dev/pull/2263) ([johnomotani](https://github.com/users/johnomotani))
- Save provenance tracking info from grid file (4.4) [\#2231](https://github.com/boutproject/BOUT-dev/pull/2231) ([johnomotani](https://github.com/users/johnomotani))
- Generate random run ID, track restarts (4.4) [\#2224](https://github.com/boutproject/BOUT-dev/pull/2224) ([johnomotani](https://github.com/users/johnomotani))
- Generate report for Timers (4.4) [\#2216](https://github.com/boutproject/BOUT-dev/pull/2216) ([johnomotani](https://github.com/users/johnomotani))
- Replace boutdata and boututils directories with submodules (v4.4) [\#2198](https://github.com/boutproject/BOUT-dev/pull/2198) ([johnomotani](https://github.com/users/johnomotani))
- Use bout_type="string" for strings in H5Format (4.4) [\#2194](https://github.com/boutproject/BOUT-dev/pull/2194) ([johnomotani](https://github.com/users/johnomotani))
- Write descriptions for std::vector<int> and std::string variables [\#2191](https://github.com/boutproject/BOUT-dev/pull/2191) ([johnomotani](https://github.com/users/johnomotani))
- Fix reading of char* in Ncxx4 (4.4) [\#2189](https://github.com/boutproject/BOUT-dev/pull/2189) ([johnomotani](https://github.com/users/johnomotani))
- Merge master into v4.4.0-alpha [\#2174](https://github.com/boutproject/BOUT-dev/pull/2174) ([ZedThree](https://github.com/users/ZedThree))
- I/O for std::vector<int> and std::string (4.4) [\#2155](https://github.com/boutproject/BOUT-dev/pull/2155) ([johnomotani](https://github.com/users/johnomotani))
- Check DataFile grid sizes match those in existing mesh (v4.4) [\#2148](https://github.com/boutproject/BOUT-dev/pull/2148) ([johnomotani](https://github.com/users/johnomotani))
- Call checkData() before returning result in Laplace inversions (v4.4) [\#2134](https://github.com/boutproject/BOUT-dev/pull/2134) ([johnomotani](https://github.com/users/johnomotani))
- Allow setting FFTW_EXHAUSTIVE (v4.4) [\#2132](https://github.com/boutproject/BOUT-dev/pull/2132) ([johnomotani](https://github.com/users/johnomotani))
- Make example relocatable [\#2127](https://github.com/boutproject/BOUT-dev/pull/2127) ([dschwoerer](https://github.com/users/dschwoerer))
- Merge master into v4.4.0-alpha [\#2121](https://github.com/boutproject/BOUT-dev/pull/2121) ([ZedThree](https://github.com/users/ZedThree))
- Handle FieldPerps in Datafile::varAdded() and Datafile::varPtr() (v4.4.0) [\#2094](https://github.com/boutproject/BOUT-dev/pull/2094) ([johnomotani](https://github.com/users/johnomotani))
- Staggered grids in InvertPar (v4.4.0) [\#2088](https://github.com/boutproject/BOUT-dev/pull/2088) ([johnomotani](https://github.com/users/johnomotani))
- Allow descriptions of output variables; save some diagnostics for solvers (v4.4) [\#2086](https://github.com/boutproject/BOUT-dev/pull/2086) ([johnomotani](https://github.com/users/johnomotani))
- Correct Grad2_par2 implementation in InvertParCR (v4.4.0) [\#2077](https://github.com/boutproject/BOUT-dev/pull/2077) ([johnomotani](https://github.com/users/johnomotani))
- Enable staggered versions of SplitFluxDerivativeType (4.4) [\#2059](https://github.com/boutproject/BOUT-dev/pull/2059) ([johnomotani](https://github.com/users/johnomotani))
- Merge master into v4.4.0-alpha [\#1998](https://github.com/boutproject/BOUT-dev/pull/1998) ([ZedThree](https://github.com/users/ZedThree))
- LaplaceXY: finite difference option (v4.4) [\#1924](https://github.com/boutproject/BOUT-dev/pull/1924) ([johnomotani](https://github.com/users/johnomotani))
- Backport of Laplace performance test [\#1910](https://github.com/boutproject/BOUT-dev/pull/1910) ([JosephThomasParker](https://github.com/users/JosephThomasParker))
- Macro for creating enum classes (v4.4) [\#1895](https://github.com/boutproject/BOUT-dev/pull/1895) ([johnomotani](https://github.com/users/johnomotani))
- Implement toFieldAligned and fromFieldAligned for Vector3D (v4.4) [\#1878](https://github.com/boutproject/BOUT-dev/pull/1878) ([johnomotani](https://github.com/users/johnomotani))
- Remove 3-element list indexers for collect() [\#1862](https://github.com/boutproject/BOUT-dev/pull/1862) ([johnomotani](https://github.com/users/johnomotani))
- Allow user to override library option defaults (v4.4) [\#1849](https://github.com/boutproject/BOUT-dev/pull/1849) ([johnomotani](https://github.com/users/johnomotani))

The following were backported from v5.0.0 in [\#2389](https://github.com/boutproject/BOUT-dev/pull/2389):

- Add remaining integrated tests to CMake build [\#1833](https://github.com/boutproject/BOUT-dev/pull/1833) ([ZedThree](https://github.com/users/ZedThree))
- Fixes for Windows [\#1874](https://github.com/boutproject/BOUT-dev/pull/1874) ([ZedThree](https://github.com/users/ZedThree))
- CMake: fix FindSlepc for non-make generators [\#1881](https://github.com/boutproject/BOUT-dev/pull/1881) ([ZedThree](https://github.com/users/ZedThree))
- CMake: enable using external mpark.variant [\#1900](https://github.com/boutproject/BOUT-dev/pull/1900) ([ZedThree](https://github.com/users/ZedThree))
- Cmake fixes [\#1909](https://github.com/boutproject/BOUT-dev/pull/1909) ([dschwoerer](https://github.com/users/dschwoerer))
- CMake: find package fixes [\#1912](https://github.com/boutproject/BOUT-dev/pull/1912) ([ZedThree](https://github.com/users/ZedThree))
- Fix runtest for non-make generators [\#1952](https://github.com/boutproject/BOUT-dev/pull/1952) ([ZedThree](https://github.com/users/ZedThree))
- CMake: Generate Field arithmetic operators [\#2119](https://github.com/boutproject/BOUT-dev/pull/2119) ([dschwoerer](https://github.com/users/dschwoerer))
- CMake: Add option to download and build netCDF C++ API [\#2138](https://github.com/boutproject/BOUT-dev/pull/2138) ([ZedThree](https://github.com/users/ZedThree))
- Fix CMake config file following change to netCDF cmake module [\#2162](https://github.com/boutproject/BOUT-dev/pull/2162) ([ZedThree](https://github.com/users/ZedThree))
- Make input Options case sensitive and error on unused Options [\#2210](https://github.com/boutproject/BOUT-dev/pull/2210) ([ZedThree](https://github.com/users/ZedThree))
- Next CMake fixes [\#2275](https://github.com/boutproject/BOUT-dev/pull/2275) ([bendudson](https://github.com/users/bendudson))
- Add MMS tests to CMake build [\#2286](https://github.com/boutproject/BOUT-dev/pull/2286) ([ZedThree](https://github.com/users/ZedThree))
- CMake: Build documentation [\#2300](https://github.com/boutproject/BOUT-dev/pull/2300) ([ZedThree](https://github.com/users/ZedThree))
- Fix for FindPETSc not being reentrant if pkg-config used (next) [\#2318](https://github.com/boutproject/BOUT-dev/pull/2318) ([ZedThree](https://github.com/users/ZedThree))
- CMake: Fix a few minor issues, generate `bout-config` [\#2328](https://github.com/boutproject/BOUT-dev/pull/2328) ([ZedThree](https://github.com/users/ZedThree))
- CMake: Add option to download SUNDIALS at configure time [\#2331](https://github.com/boutproject/BOUT-dev/pull/2331) ([ZedThree](https://github.com/users/ZedThree))
- CMake rename PACKAGE_TESTS to BOUT_TESTS [\#2347](https://github.com/boutproject/BOUT-dev/pull/2347) ([bendudson](https://github.com/users/bendudson))
- CMake: Add SOVERSION; fix FindSUNDIALS [\#2358](https://github.com/boutproject/BOUT-dev/pull/2358) ([dschwoerer](https://github.com/users/dschwoerer))
- Faster recompile [\#2294](https://github.com/boutproject/BOUT-dev/pull/2294) ([dschwoerer](https://github.com/users/dschwoerer))

## [v4.3.3](https://github.com/boutproject/BOUT-dev/tree/v4.3.2) (2021-07-28)

[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.3.2...master)

**Merged pull requests:**

- Fix documentation for examples/wave-slab [\#2369](https://github.com/boutproject/BOUT-dev/pull/2369) ([ZedThree](https://github.com/users/ZedThree))
- Make include optional [\#2360](https://github.com/boutproject/BOUT-dev/pull/2360) ([dschwoerer](https://github.com/users/dschwoerer))
- Fix ReadTheDocs (master) [\#2319](https://github.com/boutproject/BOUT-dev/pull/2319) ([ZedThree](https://github.com/users/ZedThree))
- Fix for FindPETSc not being reentrant if pkg-config used [\#2317](https://github.com/boutproject/BOUT-dev/pull/2317) ([ZedThree](https://github.com/users/ZedThree))
- Add missing snb.cxx to CMakeLists.txt [\#2315](https://github.com/boutproject/BOUT-dev/pull/2315) ([bendudson](https://github.com/users/bendudson))
- Add notes on installing SUNDIALS [\#2311](https://github.com/boutproject/BOUT-dev/pull/2311) ([bendudson](https://github.com/users/bendudson))
- Make blob2d example self contained [\#2288](https://github.com/boutproject/BOUT-dev/pull/2288) ([dschwoerer](https://github.com/users/dschwoerer))
- Fix some Solvers not always using user preconditioner/Jacobian [\#2283](https://github.com/boutproject/BOUT-dev/pull/2283) ([ZedThree](https://github.com/users/ZedThree))
- Bump jinja2 from 2.10.1 to 2.11.3 [\#2266](https://github.com/boutproject/BOUT-dev/pull/2266) ([dependabot[bot]](https://github.com/users/dependabot%5Bbot%5D))
- Fix use of uninitialised value in Delp2 [\#2262](https://github.com/boutproject/BOUT-dev/pull/2262) ([johnomotani](https://github.com/users/johnomotani))
- Add requirements to boutcore/print test [\#2175](https://github.com/boutproject/BOUT-dev/pull/2175) ([ZedThree](https://github.com/users/ZedThree))
- Update docs on supported PETSc versions [\#2171](https://github.com/boutproject/BOUT-dev/pull/2171) ([johnomotani](https://github.com/users/johnomotani))
- Convert Travis to Github Actions (master) [\#2170](https://github.com/boutproject/BOUT-dev/pull/2170) ([ZedThree](https://github.com/users/ZedThree))
- Boutcore improvements [\#2166](https://github.com/boutproject/BOUT-dev/pull/2166) ([dschwoerer](https://github.com/users/dschwoerer))
- Fix shiftOutput (master) [\#2158](https://github.com/boutproject/BOUT-dev/pull/2158) ([johnomotani](https://github.com/users/johnomotani))
- Fix test-restart-io and FieldPerp writes [\#2154](https://github.com/boutproject/BOUT-dev/pull/2154) ([johnomotani](https://github.com/users/johnomotani))
- Ignore more test data [\#2125](https://github.com/boutproject/BOUT-dev/pull/2125) ([dschwoerer](https://github.com/users/dschwoerer))
- Fix links to open-mpi.org and lam-mpi.org [\#2122](https://github.com/boutproject/BOUT-dev/pull/2122) ([tobyjamez](https://github.com/users/tobyjamez))

## [v4.3.2](https://github.com/boutproject/BOUT-dev/tree/v4.3.2) (2020-10-19)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.3.1...v4.3.2)

**Merged pull requests:**

- Make output nicer + add info about timeout'ed tests [\#2120](https://github.com/boutproject/BOUT-dev/pull/2120) ([dschwoerer](https://github.com/dschwoerer))
- Add timeout to tests [\#2118](https://github.com/boutproject/BOUT-dev/pull/2118) ([ZedThree](https://github.com/ZedThree))
- Fix reading/writing `std::string` attributes when using HDF5 [\#2116](https://github.com/boutproject/BOUT-dev/pull/2116) ([ZedThree](https://github.com/ZedThree))
- Rename death tests according to gtest recommendations [\#2115](https://github.com/boutproject/BOUT-dev/pull/2115) ([ZedThree](https://github.com/ZedThree))
- Update breathe for readthedocs [\#2114](https://github.com/boutproject/BOUT-dev/pull/2114) ([ZedThree](https://github.com/ZedThree))
- Fix `Div_par` when using more than one y guard cell [\#2113](https://github.com/boutproject/BOUT-dev/pull/2113) ([ZedThree](https://github.com/ZedThree))
- Update documentation on processor splitting and advanced installation [\#2109](https://github.com/boutproject/BOUT-dev/pull/2109) ([ZedThree](https://github.com/ZedThree))
- Soname v4.3.2 [\#2108](https://github.com/boutproject/BOUT-dev/pull/2108) ([dschwoerer](https://github.com/dschwoerer))
- Add configure option to use system mpark.variant [\#2107](https://github.com/boutproject/BOUT-dev/pull/2107) ([dschwoerer](https://github.com/dschwoerer))
- CI: Turn off patch coverage check [\#2103](https://github.com/boutproject/BOUT-dev/pull/2103) ([ZedThree](https://github.com/ZedThree))
- Make examples relocatable [\#2100](https://github.com/boutproject/BOUT-dev/pull/2100) ([dschwoerer](https://github.com/dschwoerer))
- Handle FieldPerps in `Datafile::varAdded()` and `Datafile::varPtr()` [\#2093](https://github.com/boutproject/BOUT-dev/pull/2093) ([johnomotani](https://github.com/johnomotani))
- Correct `Grad2_par2` implementation in `InvertParCR` [\#2076](https://github.com/boutproject/BOUT-dev/pull/2076) ([johnomotani](https://github.com/johnomotani))
- Enable staggered versions of `SplitFluxDerivativeType` [\#2058](https://github.com/boutproject/BOUT-dev/pull/2058) ([johnomotani](https://github.com/johnomotani))
- Fixes for `tokamak-2fluid` example [\#2043](https://github.com/boutproject/BOUT-dev/pull/2043) ([johnomotani](https://github.com/johnomotani))
- Add location checks to `Div_par_K_Grad_par` [\#2039](https://github.com/boutproject/BOUT-dev/pull/2039) ([bshanahan](https://github.com/bshanahan))
- Add clang-format bot command for pull requests [\#2032](https://github.com/boutproject/BOUT-dev/pull/2032) ([ZedThree](https://github.com/ZedThree))
- Update the staggered grids section of the manual [\#2029](https://github.com/boutproject/BOUT-dev/pull/2029) ([johnomotani](https://github.com/johnomotani))
- Make dz in boutcore a property [\#2024](https://github.com/boutproject/BOUT-dev/pull/2024) ([dschwoerer](https://github.com/dschwoerer))
- Prevent deadlock in downloading mpark [\#2017](https://github.com/boutproject/BOUT-dev/pull/2017) ([dschwoerer](https://github.com/dschwoerer))

## [v4.3.1](https://github.com/boutproject/BOUT-dev/tree/v4.3.1) (2020-03-27)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.3.0...v4.3.1)

**Merged pull requests:**

- Fix examples/make-script [\#1995](https://github.com/boutproject/BOUT-dev/pull/1995) ([ZedThree](https://github.com/ZedThree))
- Travis: Update pinned pip packages [\#1994](https://github.com/boutproject/BOUT-dev/pull/1994) ([ZedThree](https://github.com/ZedThree))
- Remove unused VERSIONS file [\#1993](https://github.com/boutproject/BOUT-dev/pull/1993) ([ZedThree](https://github.com/ZedThree))
- Minor Travis fixes and job names (master) [\#1990](https://github.com/boutproject/BOUT-dev/pull/1990) ([ZedThree](https://github.com/ZedThree))
- conditionally add -Og for non-gcc [\#1987](https://github.com/boutproject/BOUT-dev/pull/1987) ([dschwoerer](https://github.com/dschwoerer))
- fix test-laplace-petsc3d [\#1985](https://github.com/boutproject/BOUT-dev/pull/1985) ([dschwoerer](https://github.com/dschwoerer))
- Use '==' to compare to literals in Python [\#1980](https://github.com/boutproject/BOUT-dev/pull/1980) ([ZedThree](https://github.com/ZedThree))
- Read staggered J and Bxy from grid if present (master) [\#1975](https://github.com/boutproject/BOUT-dev/pull/1975) ([johnomotani](https://github.com/johnomotani))
- Remove reference to deleted test in documentation [\#1973](https://github.com/boutproject/BOUT-dev/pull/1973) ([ZedThree](https://github.com/ZedThree))
- Remove -Og from debug flags [\#1972](https://github.com/boutproject/BOUT-dev/pull/1972) ([ZedThree](https://github.com/ZedThree))
- Fix documented requirements [\#1971](https://github.com/boutproject/BOUT-dev/pull/1971) ([ZedThree](https://github.com/ZedThree))
- Compat make.config for make 4.3 [\#1970](https://github.com/boutproject/BOUT-dev/pull/1970) ([dschwoerer](https://github.com/dschwoerer))
- Install make.config with header files [\#1969](https://github.com/boutproject/BOUT-dev/pull/1969) ([dschwoerer](https://github.com/dschwoerer))
- Translations 4.3.1 [\#1968](https://github.com/boutproject/BOUT-dev/pull/1968) ([dschwoerer](https://github.com/dschwoerer))
- Fix collect when given similar name [\#1966](https://github.com/boutproject/BOUT-dev/pull/1966) ([bendudson](https://github.com/bendudson))
- Fix deprecated initialisation and boundary options [\#1956](https://github.com/boutproject/BOUT-dev/pull/1956) ([ZedThree](https://github.com/ZedThree))
- make README.md readabile [\#1953](https://github.com/boutproject/BOUT-dev/pull/1953) ([dschwoerer](https://github.com/dschwoerer))
- Fix lapd\_drift input files [\#1950](https://github.com/boutproject/BOUT-dev/pull/1950) ([bendudson](https://github.com/bendudson))
- Remove FieldData::setBoundary [\#1949](https://github.com/boutproject/BOUT-dev/pull/1949) ([bendudson](https://github.com/bendudson))
- Fixes for staggering in lapd-drift example (master) [\#1928](https://github.com/boutproject/BOUT-dev/pull/1928) ([johnomotani](https://github.com/johnomotani))
- Fix segfaults from PvodeSolver (master) [\#1927](https://github.com/boutproject/BOUT-dev/pull/1927) ([johnomotani](https://github.com/johnomotani))
- pkg-config petsc (master) [\#1913](https://github.com/boutproject/BOUT-dev/pull/1913) ([dschwoerer](https://github.com/dschwoerer))
- Fix hypnotoad [\#1911](https://github.com/boutproject/BOUT-dev/pull/1911) ([johnomotani](https://github.com/johnomotani))
- complete instructions for archlinux [\#1892](https://github.com/boutproject/BOUT-dev/pull/1892) ([dschwoerer](https://github.com/dschwoerer))
- Petsc interface generalisation [\#1889](https://github.com/boutproject/BOUT-dev/pull/1889) ([cmacmackin](https://github.com/cmacmackin))
- fix citation [\#1888](https://github.com/boutproject/BOUT-dev/pull/1888) ([dschwoerer](https://github.com/dschwoerer))
- If variable is added to Datafile twice, do not write twice [\#1876](https://github.com/boutproject/BOUT-dev/pull/1876) ([johnomotani](https://github.com/johnomotani))
- Fix loss of restart files caused by crash during initialisation [\#1875](https://github.com/boutproject/BOUT-dev/pull/1875) ([johnomotani](https://github.com/johnomotani))
- Do not include if is released [\#1871](https://github.com/boutproject/BOUT-dev/pull/1871) ([dschwoerer](https://github.com/dschwoerer))
- Easier instructions for Fedora [\#1870](https://github.com/boutproject/BOUT-dev/pull/1870) ([dschwoerer](https://github.com/dschwoerer))
- Basic lock for mpark.variant [\#1869](https://github.com/boutproject/BOUT-dev/pull/1869) ([dschwoerer](https://github.com/dschwoerer))
- Add BOUT\_REVISION (git hash of compiled version) to dump files [\#1867](https://github.com/boutproject/BOUT-dev/pull/1867) ([johnomotani](https://github.com/johnomotani))
- Mesh requires Option to stay around. [\#1860](https://github.com/boutproject/BOUT-dev/pull/1860) ([dschwoerer](https://github.com/dschwoerer))
- Try to prevent race condition while building. [\#1856](https://github.com/boutproject/BOUT-dev/pull/1856) ([dschwoerer](https://github.com/dschwoerer))
- Address needs to be aligned [\#1855](https://github.com/boutproject/BOUT-dev/pull/1855) ([dschwoerer](https://github.com/dschwoerer))
- set OMPI\_MCA\_rmaps\_base\_oversubscribe=yes for tests [\#1854](https://github.com/boutproject/BOUT-dev/pull/1854) ([dschwoerer](https://github.com/dschwoerer))
- Loosen tolerance for other arches [\#1853](https://github.com/boutproject/BOUT-dev/pull/1853) ([dschwoerer](https://github.com/dschwoerer))
- Bugfix: $MPIRUN should include -np [\#1851](https://github.com/boutproject/BOUT-dev/pull/1851) ([dschwoerer](https://github.com/dschwoerer))
- Add some documentation on setting locales [\#1845](https://github.com/boutproject/BOUT-dev/pull/1845) ([bendudson](https://github.com/bendudson))
- Fix typo in initialisation of rgn\_outer\_x [\#1838](https://github.com/boutproject/BOUT-dev/pull/1838) ([ZedThree](https://github.com/ZedThree))

## [v4.3.0](https://github.com/boutproject/BOUT-dev/tree/v4.3.0) (2019-10-24)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.2.3...v4.3.0)

**Merged pull requests:**

- Micro optimise some common routines for v4.3.0-rc [\#1824](https://github.com/boutproject/BOUT-dev/pull/1824) ([d7919](https://github.com/d7919))
- Automagically checkout mpark.variant submodule [\#1823](https://github.com/boutproject/BOUT-dev/pull/1823) ([ZedThree](https://github.com/ZedThree))
- Deprecate CtoL and LtoC differential operators [\#1822](https://github.com/boutproject/BOUT-dev/pull/1822) ([johnomotani](https://github.com/johnomotani))
- Bugfix add missing include and update configure [\#1819](https://github.com/boutproject/BOUT-dev/pull/1819) ([d7919](https://github.com/d7919))
- Performance fixes: ShiftedMetric and VDDY [\#1816](https://github.com/boutproject/BOUT-dev/pull/1816) ([ZedThree](https://github.com/ZedThree))
- Save all commonly used geometry variables [\#1815](https://github.com/boutproject/BOUT-dev/pull/1815) ([johnomotani](https://github.com/johnomotani))
- Make interp\_to and finite-volume parallel operators return result in the same space as the input [\#1813](https://github.com/boutproject/BOUT-dev/pull/1813) ([johnomotani](https://github.com/johnomotani))
- Ensure parallel\_transform is only read from grid files, not from options [\#1812](https://github.com/boutproject/BOUT-dev/pull/1812) ([johnomotani](https://github.com/johnomotani))
- Bugfixes for writing Vector2D and Vector3D [\#1809](https://github.com/boutproject/BOUT-dev/pull/1809) ([johnomotani](https://github.com/johnomotani))
- Bugfix: result of InvertParCR::solve tagged in wrong y space [\#1806](https://github.com/boutproject/BOUT-dev/pull/1806) ([ZedThree](https://github.com/ZedThree))
- Remove some superfluous location checks in Laplacian [\#1804](https://github.com/boutproject/BOUT-dev/pull/1804) ([ZedThree](https://github.com/ZedThree))
- Fix for Intel enabling -Wnull-dereference despite not accepting it [\#1801](https://github.com/boutproject/BOUT-dev/pull/1801) ([ZedThree](https://github.com/ZedThree))
- Fix assignment instead of comparison in ASSERTs [\#1800](https://github.com/boutproject/BOUT-dev/pull/1800) ([ZedThree](https://github.com/ZedThree))
- Fix y-extrapolation in BoundaryDirichlet::apply\(Field2D&\) [\#1799](https://github.com/boutproject/BOUT-dev/pull/1799) ([johnomotani](https://github.com/johnomotani))
- Fix typo in ternary in InvertableOperator [\#1798](https://github.com/boutproject/BOUT-dev/pull/1798) ([ZedThree](https://github.com/ZedThree))
- Fix in-place Region methods returning new instances [\#1797](https://github.com/boutproject/BOUT-dev/pull/1797) ([ZedThree](https://github.com/ZedThree))
- Make CELL\_LOC strongly typed [\#1796](https://github.com/boutproject/BOUT-dev/pull/1796) ([johnomotani](https://github.com/johnomotani))
- Allow NYPE to be given instead of NXPE in input files  [\#1794](https://github.com/boutproject/BOUT-dev/pull/1794) ([johnomotani](https://github.com/johnomotani))
- Implement boundary conditions for CELL\_ZLOW fields [\#1793](https://github.com/boutproject/BOUT-dev/pull/1793) ([johnomotani](https://github.com/johnomotani))
- Fix initial conditions not being transformed correctly [\#1791](https://github.com/boutproject/BOUT-dev/pull/1791) ([ZedThree](https://github.com/ZedThree))
- Add manual section on xlC compiler [\#1790](https://github.com/boutproject/BOUT-dev/pull/1790) ([bendudson](https://github.com/bendudson))
- Remove checks in Laplace that fail if outloc==CELL\_DEFAULT [\#1788](https://github.com/boutproject/BOUT-dev/pull/1788) ([johnomotani](https://github.com/johnomotani))
- Implement the INVERT\_ZERO\_DC flag in LaplaceCyclic [\#1786](https://github.com/boutproject/BOUT-dev/pull/1786) ([johnomotani](https://github.com/johnomotani))
- Add macro for Scorep instrumentation of a user-defined code region [\#1784](https://github.com/boutproject/BOUT-dev/pull/1784) ([JosephThomasParker](https://github.com/JosephThomasParker))
- Fix some issues in hypnotoad [\#1783](https://github.com/boutproject/BOUT-dev/pull/1783) ([friva000](https://github.com/friva000))
- Remove redundant 'allocate\(\)' calls [\#1782](https://github.com/boutproject/BOUT-dev/pull/1782) ([johnomotani](https://github.com/johnomotani))
- Correct manual - default for 'floats' is true for dump files too [\#1780](https://github.com/boutproject/BOUT-dev/pull/1780) ([johnomotani](https://github.com/johnomotani))
- Support bool variables in file I/O [\#1779](https://github.com/boutproject/BOUT-dev/pull/1779) ([johnomotani](https://github.com/johnomotani))
- Scripts cleanup [\#1778](https://github.com/boutproject/BOUT-dev/pull/1778) ([dschwoerer](https://github.com/dschwoerer))
- File open error messages [\#1777](https://github.com/boutproject/BOUT-dev/pull/1777) ([johnomotani](https://github.com/johnomotani))
- Don't ignore $MPIRUN [\#1776](https://github.com/boutproject/BOUT-dev/pull/1776) ([dschwoerer](https://github.com/dschwoerer))
- Update performance/iterator-offsets example [\#1775](https://github.com/boutproject/BOUT-dev/pull/1775) ([dschwoerer](https://github.com/dschwoerer))
- Bout4to5 script [\#1774](https://github.com/boutproject/BOUT-dev/pull/1774) ([bendudson](https://github.com/bendudson))
- Consistent global indices [\#1770](https://github.com/boutproject/BOUT-dev/pull/1770) ([johnomotani](https://github.com/johnomotani))
- Add processor indices to dump files [\#1769](https://github.com/boutproject/BOUT-dev/pull/1769) ([johnomotani](https://github.com/johnomotani))
- Try GitHub url for SUNDIALS if LLNL url fails [\#1768](https://github.com/boutproject/BOUT-dev/pull/1768) ([ZedThree](https://github.com/ZedThree))
- Fix reading of zShift\_ylow [\#1767](https://github.com/boutproject/BOUT-dev/pull/1767) ([johnomotani](https://github.com/johnomotani))
- Fixes for Python DataFile class [\#1766](https://github.com/boutproject/BOUT-dev/pull/1766) ([johnomotani](https://github.com/johnomotani))
- Fix y-boundary cells of phi in conducting-wall-mode example [\#1765](https://github.com/boutproject/BOUT-dev/pull/1765) ([johnomotani](https://github.com/johnomotani))
- Add mesh options for extrapolate\_{x,y} [\#1760](https://github.com/boutproject/BOUT-dev/pull/1760) ([bendudson](https://github.com/bendudson))
- Deprecate Laplacian::setFlags\(\) [\#1758](https://github.com/boutproject/BOUT-dev/pull/1758) ([johnomotani](https://github.com/johnomotani))
- Fix advection MMS tests [\#1757](https://github.com/boutproject/BOUT-dev/pull/1757) ([ZedThree](https://github.com/ZedThree))
- Rename 'coordinates\_type' gridfile attribute to 'parallel\_transform' [\#1756](https://github.com/boutproject/BOUT-dev/pull/1756) ([ZedThree](https://github.com/ZedThree))
- More clang-tidy fixes [\#1755](https://github.com/boutproject/BOUT-dev/pull/1755) ([ZedThree](https://github.com/ZedThree))
- Add default value to Mesh::get for ints [\#1754](https://github.com/boutproject/BOUT-dev/pull/1754) ([JosephThomasParker](https://github.com/JosephThomasParker))
- Remove FIXME comment from interp\_to [\#1752](https://github.com/boutproject/BOUT-dev/pull/1752) ([johnomotani](https://github.com/johnomotani))
- Build pdf manual [\#1751](https://github.com/boutproject/BOUT-dev/pull/1751) ([johnomotani](https://github.com/johnomotani))
- Bug fix, test and tidy SLEPc solver [\#1749](https://github.com/boutproject/BOUT-dev/pull/1749) ([ZedThree](https://github.com/ZedThree))
- SNB nonlocal heat flux model [\#1748](https://github.com/boutproject/BOUT-dev/pull/1748) ([bendudson](https://github.com/bendudson))
- Pin packages in requirements.txt for Sphinx docs [\#1746](https://github.com/boutproject/BOUT-dev/pull/1746) ([ZedThree](https://github.com/ZedThree))
- Don't mark Coordinates::zShift as const, can't be output [\#1745](https://github.com/boutproject/BOUT-dev/pull/1745) ([ZedThree](https://github.com/ZedThree))
- Laplacian: FFT include dfdz term, plus manual updates [\#1744](https://github.com/boutproject/BOUT-dev/pull/1744) ([johnomotani](https://github.com/johnomotani))
- Fix interpolation of staggered zShift [\#1743](https://github.com/boutproject/BOUT-dev/pull/1743) ([johnomotani](https://github.com/johnomotani))
- Correct calculation of Bxy when interpolating from CELL\_CENTRE [\#1741](https://github.com/boutproject/BOUT-dev/pull/1741) ([johnomotani](https://github.com/johnomotani))
- Only call checkPositive\(g\) for grid cells [\#1739](https://github.com/boutproject/BOUT-dev/pull/1739) ([johnomotani](https://github.com/johnomotani))
- Output ParallelTransform variables [\#1736](https://github.com/boutproject/BOUT-dev/pull/1736) ([johnomotani](https://github.com/johnomotani))
- Fix BoutMesh decomposition on single processor [\#1735](https://github.com/boutproject/BOUT-dev/pull/1735) ([ZedThree](https://github.com/ZedThree))
- Deprecate some unused methods [\#1734](https://github.com/boutproject/BOUT-dev/pull/1734) ([ZedThree](https://github.com/ZedThree))
- make sure values\(\) returns valid pointer [\#1733](https://github.com/boutproject/BOUT-dev/pull/1733) ([dschwoerer](https://github.com/dschwoerer))
- Twistshift for field-aligned variables [\#1732](https://github.com/boutproject/BOUT-dev/pull/1732) ([johnomotani](https://github.com/johnomotani))
- Add bout::utils::is\_Field and variants [\#1730](https://github.com/boutproject/BOUT-dev/pull/1730) ([ZedThree](https://github.com/ZedThree))
- Deprecate Karniadakis solver [\#1727](https://github.com/boutproject/BOUT-dev/pull/1727) ([ZedThree](https://github.com/ZedThree))
- Make MsgStack and BoutException unit tests more flexible [\#1726](https://github.com/boutproject/BOUT-dev/pull/1726) ([ZedThree](https://github.com/ZedThree))
- Bugfix: use region in Coordinates::calcCovariant/calcContravariant [\#1725](https://github.com/boutproject/BOUT-dev/pull/1725) ([ZedThree](https://github.com/ZedThree))
- Hardcode all variables for test-solver; remove input file [\#1724](https://github.com/boutproject/BOUT-dev/pull/1724) ([ZedThree](https://github.com/ZedThree))
- Remove Laplace3D [\#1723](https://github.com/boutproject/BOUT-dev/pull/1723) ([ZedThree](https://github.com/ZedThree))
- Add function\_traits template and replace SUNDIALS int type macros [\#1722](https://github.com/boutproject/BOUT-dev/pull/1722) ([ZedThree](https://github.com/ZedThree))
- fix nc-format [\#1721](https://github.com/boutproject/BOUT-dev/pull/1721) ([dschwoerer](https://github.com/dschwoerer))
- Templated Field functions and deprecate REGION enum arguments [\#1720](https://github.com/boutproject/BOUT-dev/pull/1720) ([johnomotani](https://github.com/johnomotani))
- More robust staggered Jacobian and RGN\_NOCORNERS [\#1719](https://github.com/boutproject/BOUT-dev/pull/1719) ([johnomotani](https://github.com/johnomotani))
- Handle attributes for missing variables [\#1718](https://github.com/boutproject/BOUT-dev/pull/1718) ([bendudson](https://github.com/bendudson))
- Revert "Hypnotoad: 'H' is derivative of integral" [\#1717](https://github.com/boutproject/BOUT-dev/pull/1717) ([johnomotani](https://github.com/johnomotani))
- Remove deprecated invert\_laplace from gyro\_average [\#1716](https://github.com/boutproject/BOUT-dev/pull/1716) ([ZedThree](https://github.com/ZedThree))
- Lots of small clang-tidy fixes [\#1715](https://github.com/boutproject/BOUT-dev/pull/1715) ([ZedThree](https://github.com/ZedThree))
- Tidy up direction-type setters [\#1712](https://github.com/boutproject/BOUT-dev/pull/1712) ([johnomotani](https://github.com/johnomotani))
- Add implementation of Field2D::applyBoundary\(BoutReal time\) [\#1711](https://github.com/boutproject/BOUT-dev/pull/1711) ([ZedThree](https://github.com/ZedThree))
- Fix BoutMesh boundary regions [\#1710](https://github.com/boutproject/BOUT-dev/pull/1710) ([ZedThree](https://github.com/ZedThree))
- Don't run tests that use FFTW if not compiled with it [\#1709](https://github.com/boutproject/BOUT-dev/pull/1709) ([ZedThree](https://github.com/ZedThree))
- Fixes for FV::Div\_a\_Laplace\_perp [\#1707](https://github.com/boutproject/BOUT-dev/pull/1707) ([bendudson](https://github.com/bendudson))
- Set y-direction of FieldPerp results in ParallelTransformIdentity [\#1704](https://github.com/boutproject/BOUT-dev/pull/1704) ([johnomotani](https://github.com/johnomotani))
- Do not calculate parallel slices for field-aligned fields [\#1703](https://github.com/boutproject/BOUT-dev/pull/1703) ([johnomotani](https://github.com/johnomotani))
- Allow default value of Options to be set from another Options object [\#1702](https://github.com/boutproject/BOUT-dev/pull/1702) ([johnomotani](https://github.com/johnomotani))
- Fieldperp I/O [\#1699](https://github.com/boutproject/BOUT-dev/pull/1699) ([johnomotani](https://github.com/johnomotani))
- Set y-direction of results in ParallelTransformIdentity [\#1698](https://github.com/boutproject/BOUT-dev/pull/1698) ([johnomotani](https://github.com/johnomotani))
- Add support for shifting a FieldPerp toFieldAligned/fromFieldAligned [\#1697](https://github.com/boutproject/BOUT-dev/pull/1697) ([johnomotani](https://github.com/johnomotani))
- Experimental CMake support [\#1696](https://github.com/boutproject/BOUT-dev/pull/1696) ([ZedThree](https://github.com/ZedThree))
- Convert Options::isSection\(\) argument to lower case  [\#1695](https://github.com/boutproject/BOUT-dev/pull/1695) ([johnomotani](https://github.com/johnomotani))
- Update required Jinja2 version to avoid CVE-2019-10906 [\#1694](https://github.com/boutproject/BOUT-dev/pull/1694) ([ZedThree](https://github.com/ZedThree))
- Move Gridfile::get implementations for Field3D/Field2D to .cxx [\#1693](https://github.com/boutproject/BOUT-dev/pull/1693) ([johnomotani](https://github.com/johnomotani))
- Warn about random failures in test [\#1692](https://github.com/boutproject/BOUT-dev/pull/1692) ([dschwoerer](https://github.com/dschwoerer))
- Use asynchronous communications in LaplaceMultigrid [\#1691](https://github.com/boutproject/BOUT-dev/pull/1691) ([johnomotani](https://github.com/johnomotani))
- Remove multiple printing of BOUTLOCALE to stderr [\#1689](https://github.com/boutproject/BOUT-dev/pull/1689) ([johnomotani](https://github.com/johnomotani))
- Fix elm pb example [\#1688](https://github.com/boutproject/BOUT-dev/pull/1688) ([bendudson](https://github.com/bendudson))
- Bugfix: bracket operator slowdown [\#1686](https://github.com/boutproject/BOUT-dev/pull/1686) ([johnomotani](https://github.com/johnomotani))
- Fix and reenable [\#1684](https://github.com/boutproject/BOUT-dev/pull/1684) ([dschwoerer](https://github.com/dschwoerer))
- call Finalise in test [\#1683](https://github.com/boutproject/BOUT-dev/pull/1683) ([dschwoerer](https://github.com/dschwoerer))
- Fix comparison of corner boundary cells in test-squash [\#1682](https://github.com/boutproject/BOUT-dev/pull/1682) ([johnomotani](https://github.com/johnomotani))
- Clear Field3D parallel slices in operator= [\#1681](https://github.com/boutproject/BOUT-dev/pull/1681) ([johnomotani](https://github.com/johnomotani))
- Ignore new meta-vars in test-squash [\#1679](https://github.com/boutproject/BOUT-dev/pull/1679) ([dschwoerer](https://github.com/dschwoerer))
- Fix examples [\#1678](https://github.com/boutproject/BOUT-dev/pull/1678) ([dschwoerer](https://github.com/dschwoerer))
- Add .BOUT.pid.\* files to .gitignore [\#1674](https://github.com/boutproject/BOUT-dev/pull/1674) ([johnomotani](https://github.com/johnomotani))
- Runge-Kutta-Legendre stabilised explicit method [\#1673](https://github.com/boutproject/BOUT-dev/pull/1673) ([bendudson](https://github.com/bendudson))
- Unit tests and template-isation of `where` [\#1672](https://github.com/boutproject/BOUT-dev/pull/1672) ([ZedThree](https://github.com/ZedThree))
- Don't try to build documentation [\#1671](https://github.com/boutproject/BOUT-dev/pull/1671) ([dschwoerer](https://github.com/dschwoerer))
- Method for Laplace solvers to say whether they use 3D coefficients [\#1669](https://github.com/boutproject/BOUT-dev/pull/1669) ([johnomotani](https://github.com/johnomotani))
- Fix dereferencing null Coordinates in FieldFactory [\#1667](https://github.com/boutproject/BOUT-dev/pull/1667) ([ZedThree](https://github.com/ZedThree))
- Bugfix: return fields by reference [\#1663](https://github.com/boutproject/BOUT-dev/pull/1663) ([dschwoerer](https://github.com/dschwoerer))
- Allow clean exit in boutcore [\#1662](https://github.com/boutproject/BOUT-dev/pull/1662) ([dschwoerer](https://github.com/dschwoerer))
- Make mixed second-derivative operators more correct [\#1661](https://github.com/boutproject/BOUT-dev/pull/1661) ([johnomotani](https://github.com/johnomotani))
- Unit tests and various small refactorings of Solver [\#1660](https://github.com/boutproject/BOUT-dev/pull/1660) ([ZedThree](https://github.com/ZedThree))
- Under-relaxation for LaplaceNaulin [\#1659](https://github.com/boutproject/BOUT-dev/pull/1659) ([johnomotani](https://github.com/johnomotani))
- Counters for timers, makes them correct with multiple Timer objects [\#1658](https://github.com/boutproject/BOUT-dev/pull/1658) ([johnomotani](https://github.com/johnomotani))
- Generate FieldPerp arithmetic operators with jinja [\#1655](https://github.com/boutproject/BOUT-dev/pull/1655) ([johnomotani](https://github.com/johnomotani))
- LaplaceNaulin solver improvement, and more general coefficients for LaplaceCyclic [\#1654](https://github.com/boutproject/BOUT-dev/pull/1654) ([johnomotani](https://github.com/johnomotani))
- Options type and doc attributes [\#1653](https://github.com/boutproject/BOUT-dev/pull/1653) ([bendudson](https://github.com/bendudson))
- Fix mesh checks in Laplace implementation headers [\#1652](https://github.com/boutproject/BOUT-dev/pull/1652) ([johnomotani](https://github.com/johnomotani))
- Minor refactoring of BoutInitialise, BoutFinalise [\#1651](https://github.com/boutproject/BOUT-dev/pull/1651) ([ZedThree](https://github.com/ZedThree))
- Add name argument to Options::isSection to test for presence of subsection [\#1650](https://github.com/boutproject/BOUT-dev/pull/1650) ([johnomotani](https://github.com/johnomotani))
- Support SUNDIALS 4.1.0 [\#1649](https://github.com/boutproject/BOUT-dev/pull/1649) ([ZedThree](https://github.com/ZedThree))
- Make transforming Field3D inputs from field aligned optional [\#1648](https://github.com/boutproject/BOUT-dev/pull/1648) ([johnomotani](https://github.com/johnomotani))
- Hypnotoad: double precision and  y-boundary guard cells [\#1647](https://github.com/boutproject/BOUT-dev/pull/1647) ([johnomotani](https://github.com/johnomotani))
- Fix y-boundaries of Coordinates fields [\#1646](https://github.com/boutproject/BOUT-dev/pull/1646) ([johnomotani](https://github.com/johnomotani))
- Add order-only dependency on gtest sentinel to unit test objects [\#1643](https://github.com/boutproject/BOUT-dev/pull/1643) ([ZedThree](https://github.com/ZedThree))
- Change variable names for output from staggered Coordinates [\#1639](https://github.com/boutproject/BOUT-dev/pull/1639) ([johnomotani](https://github.com/johnomotani))
- Hypnotoad: enable 'Detailed settings' for nonorthogonal grids [\#1636](https://github.com/boutproject/BOUT-dev/pull/1636) ([johnomotani](https://github.com/johnomotani))
- Make ParallelTransform location-aware [\#1635](https://github.com/boutproject/BOUT-dev/pull/1635) ([johnomotani](https://github.com/johnomotani))
- Replace ENUM\ss_STRING functions with toString overloads [\#1634](https://github.com/boutproject/BOUT-dev/pull/1634) ([ZedThree](https://github.com/ZedThree))
- Last couple of master bugfixes into next [\#1633](https://github.com/boutproject/BOUT-dev/pull/1633) ([ZedThree](https://github.com/ZedThree))
- Write Field directions as attributes in output files [\#1631](https://github.com/boutproject/BOUT-dev/pull/1631) ([johnomotani](https://github.com/johnomotani))
- Some small improvements to unit tests [\#1630](https://github.com/boutproject/BOUT-dev/pull/1630) ([ZedThree](https://github.com/ZedThree))
- Loosen tolerance for CyclicReduce tests [\#1628](https://github.com/boutproject/BOUT-dev/pull/1628) ([ZedThree](https://github.com/ZedThree))
- Add some basic unit tests for CyclicReduce [\#1625](https://github.com/boutproject/BOUT-dev/pull/1625) ([ZedThree](https://github.com/ZedThree))
- Direction tagging and emptyFrom [\#1624](https://github.com/boutproject/BOUT-dev/pull/1624) ([johnomotani](https://github.com/johnomotani))
- Fix spatial advection 2 [\#1623](https://github.com/boutproject/BOUT-dev/pull/1623) ([dschwoerer](https://github.com/dschwoerer))
- set -e [\#1622](https://github.com/boutproject/BOUT-dev/pull/1622) ([dschwoerer](https://github.com/dschwoerer))
- Pin pip packages on Travis [\#1621](https://github.com/boutproject/BOUT-dev/pull/1621) ([ZedThree](https://github.com/ZedThree))
- Fix printf formats in Ncxx4/H5Format::setAttribute\(..., BoutReal\) [\#1620](https://github.com/boutproject/BOUT-dev/pull/1620) ([ZedThree](https://github.com/ZedThree))
- Use std::map::find to avoid double lookup in getCoordinates [\#1618](https://github.com/boutproject/BOUT-dev/pull/1618) ([johnomotani](https://github.com/johnomotani))
- Merge v4.2.2 into next [\#1616](https://github.com/boutproject/BOUT-dev/pull/1616) ([ZedThree](https://github.com/ZedThree))
- Add FDDX\_U2 implementation, plus minor bugfixes [\#1615](https://github.com/boutproject/BOUT-dev/pull/1615) ([johnomotani](https://github.com/johnomotani))
- Unit tests for GridFromOptions [\#1614](https://github.com/boutproject/BOUT-dev/pull/1614) ([ZedThree](https://github.com/ZedThree))
- A few small unit test improvements [\#1613](https://github.com/boutproject/BOUT-dev/pull/1613) ([ZedThree](https://github.com/ZedThree))
- Initial profile tests and tidy [\#1602](https://github.com/boutproject/BOUT-dev/pull/1602) ([ZedThree](https://github.com/ZedThree))
- Some quality of life improvements for unit tests [\#1601](https://github.com/boutproject/BOUT-dev/pull/1601) ([ZedThree](https://github.com/ZedThree))
- FieldFactory and ExpressionParser tidy [\#1597](https://github.com/boutproject/BOUT-dev/pull/1597) ([ZedThree](https://github.com/ZedThree))
- Hypnotoad: more flexible transitions in nonorthogonal grid generation [\#1596](https://github.com/boutproject/BOUT-dev/pull/1596) ([johnomotani](https://github.com/johnomotani))
- Hypnotoad nonorthogonal fixes [\#1593](https://github.com/boutproject/BOUT-dev/pull/1593) ([johnomotani](https://github.com/johnomotani))
- More unit tests for derivatives [\#1592](https://github.com/boutproject/BOUT-dev/pull/1592) ([ZedThree](https://github.com/ZedThree))
- More Field\* tests [\#1591](https://github.com/boutproject/BOUT-dev/pull/1591) ([ZedThree](https://github.com/ZedThree))
- InterpolationFactory tests [\#1590](https://github.com/boutproject/BOUT-dev/pull/1590) ([ZedThree](https://github.com/ZedThree))
- Timer tests and refactor [\#1589](https://github.com/boutproject/BOUT-dev/pull/1589) ([ZedThree](https://github.com/ZedThree))
- Check buffer length [\#1586](https://github.com/boutproject/BOUT-dev/pull/1586) ([dschwoerer](https://github.com/dschwoerer))
- getmpirun default [\#1584](https://github.com/boutproject/BOUT-dev/pull/1584) ([dschwoerer](https://github.com/dschwoerer))
- Spanish translation [\#1579](https://github.com/boutproject/BOUT-dev/pull/1579) ([bendudson](https://github.com/bendudson))
- Make application of INVERT\_SET at outer boundary clearer in cyclic solver [\#1578](https://github.com/boutproject/BOUT-dev/pull/1578) ([johnomotani](https://github.com/johnomotani))
- Use Xenial on Travis [\#1577](https://github.com/boutproject/BOUT-dev/pull/1577) ([ZedThree](https://github.com/ZedThree))
- Tidy derivatives [\#1576](https://github.com/boutproject/BOUT-dev/pull/1576) ([d7919](https://github.com/d7919))
- Hypnotoad: output coordinate system labelling [\#1575](https://github.com/boutproject/BOUT-dev/pull/1575) ([johnomotani](https://github.com/johnomotani))
- Codecov tweaks [\#1571](https://github.com/boutproject/BOUT-dev/pull/1571) ([ZedThree](https://github.com/ZedThree))
- Avoid out-of-range access for invalid regions [\#1570](https://github.com/boutproject/BOUT-dev/pull/1570) ([dschwoerer](https://github.com/dschwoerer))
- Allow Coordinates on staggered grids to be read from grid files [\#1564](https://github.com/boutproject/BOUT-dev/pull/1564) ([johnomotani](https://github.com/johnomotani))
- Enable communications for simulations with no core, only divertor legs [\#1563](https://github.com/boutproject/BOUT-dev/pull/1563) ([johnomotani](https://github.com/johnomotani))
- Hypnotoad: add checkbox to output metrics for orthogonal coordinates [\#1562](https://github.com/boutproject/BOUT-dev/pull/1562) ([johnomotani](https://github.com/johnomotani))
- Hypnotoad: handle case when break of contour is very close to x-point [\#1561](https://github.com/boutproject/BOUT-dev/pull/1561) ([johnomotani](https://github.com/johnomotani))
- Prevent data corruption [\#1558](https://github.com/boutproject/BOUT-dev/pull/1558) ([dschwoerer](https://github.com/dschwoerer))
- Locale de [\#1556](https://github.com/boutproject/BOUT-dev/pull/1556) ([dschwoerer](https://github.com/dschwoerer))
- Fix expr.hxx [\#1555](https://github.com/boutproject/BOUT-dev/pull/1555) ([dschwoerer](https://github.com/dschwoerer))
- Update name of helper function [\#1553](https://github.com/boutproject/BOUT-dev/pull/1553) ([d7919](https://github.com/d7919))
- Remove old examples and change to use new options style [\#1550](https://github.com/boutproject/BOUT-dev/pull/1550) ([d7919](https://github.com/d7919))
- Replace IsField\\*Equal\\* predicates with templated versions [\#1547](https://github.com/boutproject/BOUT-dev/pull/1547) ([ZedThree](https://github.com/ZedThree))
- Fix bug in DST option for cyclic solve [\#1546](https://github.com/boutproject/BOUT-dev/pull/1546) ([bendudson](https://github.com/bendudson))
- More derivative tests [\#1545](https://github.com/boutproject/BOUT-dev/pull/1545) ([d7919](https://github.com/d7919))
- Improve make-script example [\#1542](https://github.com/boutproject/BOUT-dev/pull/1542) ([dschwoerer](https://github.com/dschwoerer))
- Pass by reference in makeField [\#1541](https://github.com/boutproject/BOUT-dev/pull/1541) ([ZedThree](https://github.com/ZedThree))
- Replace MMS/spatial/advection with simpler/more complete test [\#1540](https://github.com/boutproject/BOUT-dev/pull/1540) ([ZedThree](https://github.com/ZedThree))
- Fix time MMS [\#1539](https://github.com/boutproject/BOUT-dev/pull/1539) ([ZedThree](https://github.com/ZedThree))
- Minor improvments for boutcore [\#1536](https://github.com/boutproject/BOUT-dev/pull/1536) ([dschwoerer](https://github.com/dschwoerer))
- Remove setLocation\(\) in Field3D::operator=\(FieldPerp\) [\#1535](https://github.com/boutproject/BOUT-dev/pull/1535) ([johnomotani](https://github.com/johnomotani))
- Derivative unit tests [\#1534](https://github.com/boutproject/BOUT-dev/pull/1534) ([ZedThree](https://github.com/ZedThree))
- Remove checkData from copy constructor and assignment operator in Fields [\#1533](https://github.com/boutproject/BOUT-dev/pull/1533) ([d7919](https://github.com/d7919))
- Merge v4.2.1 release into next [\#1532](https://github.com/boutproject/BOUT-dev/pull/1532) ([ZedThree](https://github.com/ZedThree))
- Write job execution information to dump file [\#1531](https://github.com/boutproject/BOUT-dev/pull/1531) ([JosephThomasParker](https://github.com/JosephThomasParker))
- Use third order B.C. in MMS/advection/weno3 test case. [\#1528](https://github.com/boutproject/BOUT-dev/pull/1528) ([d7919](https://github.com/d7919))
- Documentation for Scorep [\#1525](https://github.com/boutproject/BOUT-dev/pull/1525) ([JosephThomasParker](https://github.com/JosephThomasParker))
- Remove support for scipy/scientific netcdf libraries [\#1524](https://github.com/boutproject/BOUT-dev/pull/1524) ([d7919](https://github.com/d7919))
- Fix typo in petsc installation instructions [\#1523](https://github.com/boutproject/BOUT-dev/pull/1523) ([bshanahan](https://github.com/bshanahan))
- Move googletest into externalpackages [\#1522](https://github.com/boutproject/BOUT-dev/pull/1522) ([d7919](https://github.com/d7919))
- Comment out clang-format options that are not recognised [\#1519](https://github.com/boutproject/BOUT-dev/pull/1519) ([d7919](https://github.com/d7919))
- Fix assert in definition of FFT 2nd derivative [\#1518](https://github.com/boutproject/BOUT-dev/pull/1518) ([d7919](https://github.com/d7919))
- Delp2 test requires fftw [\#1513](https://github.com/boutproject/BOUT-dev/pull/1513) ([dschwoerer](https://github.com/dschwoerer))
- Two stage add coordinates [\#1506](https://github.com/boutproject/BOUT-dev/pull/1506) ([d7919](https://github.com/d7919))
- Show available options in Factory [\#1497](https://github.com/boutproject/BOUT-dev/pull/1497) ([dschwoerer](https://github.com/dschwoerer))
- FieldFactory: Separate parsing, looping stages in create{2,3}D [\#1494](https://github.com/boutproject/BOUT-dev/pull/1494) ([bendudson](https://github.com/bendudson))
- specify python package versions for Travis [\#1493](https://github.com/boutproject/BOUT-dev/pull/1493) ([d7919](https://github.com/d7919))
- Array flexible backing [\#1492](https://github.com/boutproject/BOUT-dev/pull/1492) ([d7919](https://github.com/d7919))
- Add Matrix/Tensor::reallocate; check Arrays are of positive size [\#1491](https://github.com/boutproject/BOUT-dev/pull/1491) ([ZedThree](https://github.com/ZedThree))
- Fix bug in fft Array interface when using odd-length signals [\#1490](https://github.com/boutproject/BOUT-dev/pull/1490) ([ZedThree](https://github.com/ZedThree))
- Add Array::resize [\#1489](https://github.com/boutproject/BOUT-dev/pull/1489) ([ZedThree](https://github.com/ZedThree))
- Move map and function definitions into source file for bout\_types [\#1486](https://github.com/boutproject/BOUT-dev/pull/1486) ([d7919](https://github.com/d7919))
- Testing shiftedmetric [\#1483](https://github.com/boutproject/BOUT-dev/pull/1483) ([ZedThree](https://github.com/ZedThree))
- Fix location of Coordinates\* in tridagCoefs [\#1481](https://github.com/boutproject/BOUT-dev/pull/1481) ([johnomotani](https://github.com/johnomotani))
- Make absence of fftw-wisdom non-fatal in configure [\#1475](https://github.com/boutproject/BOUT-dev/pull/1475) ([d7919](https://github.com/d7919))
- Use namespace for global variables 'mesh' and 'dump' [\#1470](https://github.com/boutproject/BOUT-dev/pull/1470) ([johnomotani](https://github.com/johnomotani))
- Use non-Fourier Delp2 in test-multigrid\_laplace [\#1469](https://github.com/boutproject/BOUT-dev/pull/1469) ([johnomotani](https://github.com/johnomotani))
- Reduce code duplication in interp\_to [\#1467](https://github.com/boutproject/BOUT-dev/pull/1467) ([d7919](https://github.com/d7919))
- Ensure the location is initialised in LaplaceXZ [\#1466](https://github.com/boutproject/BOUT-dev/pull/1466) ([d7919](https://github.com/d7919))
- Make most examples compilable [\#1458](https://github.com/boutproject/BOUT-dev/pull/1458) ([d7919](https://github.com/d7919))
- Deprecate invert\_laplace\(\) free functions [\#1453](https://github.com/boutproject/BOUT-dev/pull/1453) ([johnomotani](https://github.com/johnomotani))
- Remove const from bool return [\#1450](https://github.com/boutproject/BOUT-dev/pull/1450) ([bendudson](https://github.com/bendudson))
- Verbose output [\#1447](https://github.com/boutproject/BOUT-dev/pull/1447) ([ZedThree](https://github.com/ZedThree))
- Pass f\_aligned to standardDerivative in DDY/D2DY2/D4DY4 [\#1446](https://github.com/boutproject/BOUT-dev/pull/1446) ([johnomotani](https://github.com/johnomotani))
- Make free interpolate use the Lagrange4pt class [\#1445](https://github.com/boutproject/BOUT-dev/pull/1445) ([d7919](https://github.com/d7919))
- Add FieldPerp location [\#1441](https://github.com/boutproject/BOUT-dev/pull/1441) ([d7919](https://github.com/d7919))
- Removes explicit request for timezone [\#1440](https://github.com/boutproject/BOUT-dev/pull/1440) ([d7919](https://github.com/d7919))
- Add tool for generic operator inversion [\#1439](https://github.com/boutproject/BOUT-dev/pull/1439) ([d7919](https://github.com/d7919))
- Be more explicit about how many threads to use in some tests. [\#1438](https://github.com/boutproject/BOUT-dev/pull/1438) ([d7919](https://github.com/d7919))
- Non-fourier delp2 [\#1436](https://github.com/boutproject/BOUT-dev/pull/1436) ([d7919](https://github.com/d7919))
- Fix FV::Div\_par\_K\_Grad\_par [\#1434](https://github.com/boutproject/BOUT-dev/pull/1434) ([johnomotani](https://github.com/johnomotani))
- Location checking in ShiftedMetric::shiftZ\(\) [\#1433](https://github.com/boutproject/BOUT-dev/pull/1433) ([johnomotani](https://github.com/johnomotani))
- Add region arguments for toFieldAligned/fromFieldAligned [\#1432](https://github.com/boutproject/BOUT-dev/pull/1432) ([johnomotani](https://github.com/johnomotani))
- Remove result\_fa from interp\_to [\#1427](https://github.com/boutproject/BOUT-dev/pull/1427) ([johnomotani](https://github.com/johnomotani))
- Options use variant type \(towards a DataFile replacement\) [\#1425](https://github.com/boutproject/BOUT-dev/pull/1425) ([bendudson](https://github.com/bendudson))
- Adding toString specialisations [\#1424](https://github.com/boutproject/BOUT-dev/pull/1424) ([bendudson](https://github.com/bendudson))
- Start to introduce zstart and zend [\#1423](https://github.com/boutproject/BOUT-dev/pull/1423) ([d7919](https://github.com/d7919))
- Make FFTW an optional dependency [\#1422](https://github.com/boutproject/BOUT-dev/pull/1422) ([d7919](https://github.com/d7919))
- Warnings tidyup derivative overhaul mesh [\#1420](https://github.com/boutproject/BOUT-dev/pull/1420) ([d7919](https://github.com/d7919))
- Workaround for gcc ICE to do with binding class bound member with [\#1419](https://github.com/boutproject/BOUT-dev/pull/1419) ([d7919](https://github.com/d7919))
- Ensure we install cython for Travis before netcdf4 [\#1417](https://github.com/boutproject/BOUT-dev/pull/1417) ([d7919](https://github.com/d7919))
- Move index derivs out of mesh [\#1416](https://github.com/boutproject/BOUT-dev/pull/1416) ([d7919](https://github.com/d7919))
- Add a couple of sanity tests for ffts [\#1415](https://github.com/boutproject/BOUT-dev/pull/1415) ([ZedThree](https://github.com/ZedThree))
- Pass zShift to ShiftedMetric constructor \(backwards compatible\) [\#1413](https://github.com/boutproject/BOUT-dev/pull/1413) ([ZedThree](https://github.com/ZedThree))
- Split backtrace generation and prettification up [\#1412](https://github.com/boutproject/BOUT-dev/pull/1412) ([ZedThree](https://github.com/ZedThree))
- Add some missing autoconf macros needed to build configure [\#1410](https://github.com/boutproject/BOUT-dev/pull/1410) ([ZedThree](https://github.com/ZedThree))
- Fix MAYBE\_UNUSED for some compilers [\#1409](https://github.com/boutproject/BOUT-dev/pull/1409) ([ZedThree](https://github.com/ZedThree))
- List OpenMP schedule options in configure help [\#1408](https://github.com/boutproject/BOUT-dev/pull/1408) ([JosephThomasParker](https://github.com/JosephThomasParker))
- Remove comm\_group as not used anywhere [\#1406](https://github.com/boutproject/BOUT-dev/pull/1406) ([bendudson](https://github.com/bendudson))
- Remove restart.split python routine [\#1405](https://github.com/boutproject/BOUT-dev/pull/1405) ([bendudson](https://github.com/bendudson))
- Small user manual improvements [\#1404](https://github.com/boutproject/BOUT-dev/pull/1404) ([bendudson](https://github.com/bendudson))
- Remove even more warnings [\#1403](https://github.com/boutproject/BOUT-dev/pull/1403) ([ZedThree](https://github.com/ZedThree))
- "Dumb" constructor for Coordinates and Vector tests [\#1402](https://github.com/boutproject/BOUT-dev/pull/1402) ([ZedThree](https://github.com/ZedThree))
- Bugfix: new\_location check in setLocation would always be false [\#1401](https://github.com/boutproject/BOUT-dev/pull/1401) ([ZedThree](https://github.com/ZedThree))
- Two small improvements to command line options [\#1400](https://github.com/boutproject/BOUT-dev/pull/1400) ([ZedThree](https://github.com/ZedThree))
- More fixes for invparderiv [\#1399](https://github.com/boutproject/BOUT-dev/pull/1399) ([d7919](https://github.com/d7919))
- Add implementation of make\_unique [\#1396](https://github.com/boutproject/BOUT-dev/pull/1396) ([ZedThree](https://github.com/ZedThree))
- Replace deprecated C headers with C++ version [\#1391](https://github.com/boutproject/BOUT-dev/pull/1391) ([ZedThree](https://github.com/ZedThree))
- Replace abs with std abs [\#1390](https://github.com/boutproject/BOUT-dev/pull/1390) ([d7919](https://github.com/d7919))
- Adding simple integrated test to compile all example files [\#1389](https://github.com/boutproject/BOUT-dev/pull/1389) ([d7919](https://github.com/d7919))
- Fix examples so most compile [\#1388](https://github.com/boutproject/BOUT-dev/pull/1388) ([d7919](https://github.com/d7919))
- Use python unittest in runtests [\#1386](https://github.com/boutproject/BOUT-dev/pull/1386) ([ZedThree](https://github.com/ZedThree))
- Field\* constructor tidy [\#1385](https://github.com/boutproject/BOUT-dev/pull/1385) ([ZedThree](https://github.com/ZedThree))
- Overhaul derivatives for vectorisation and user registration [\#1384](https://github.com/boutproject/BOUT-dev/pull/1384) ([d7919](https://github.com/d7919))
- Don't clobber command line short options when reading input file [\#1382](https://github.com/boutproject/BOUT-dev/pull/1382) ([ZedThree](https://github.com/ZedThree))
- Bc docs [\#1381](https://github.com/boutproject/BOUT-dev/pull/1381) ([dschwoerer](https://github.com/dschwoerer))
- Basic Vector support for boutcore [\#1380](https://github.com/boutproject/BOUT-dev/pull/1380) ([dschwoerer](https://github.com/dschwoerer))
- Fix:Escaping in makefile [\#1379](https://github.com/boutproject/BOUT-dev/pull/1379) ([dschwoerer](https://github.com/dschwoerer))
- Add documentation [\#1376](https://github.com/boutproject/BOUT-dev/pull/1376) ([dschwoerer](https://github.com/dschwoerer))
- Remove regeneration test [\#1375](https://github.com/boutproject/BOUT-dev/pull/1375) ([dschwoerer](https://github.com/dschwoerer))
- Print command line options to output\_info [\#1373](https://github.com/boutproject/BOUT-dev/pull/1373) ([johnomotani](https://github.com/johnomotani))
- Remove uses of global 'mesh' from Laplacian solvers [\#1371](https://github.com/boutproject/BOUT-dev/pull/1371) ([johnomotani](https://github.com/johnomotani))
- Set location in LaplaceCyclic::solve\(\) and DC\(\) [\#1367](https://github.com/boutproject/BOUT-dev/pull/1367) ([johnomotani](https://github.com/johnomotani))
- Move the definition of `\_\_thefunc\_\_` and add AUTO\_TRACE [\#1366](https://github.com/boutproject/BOUT-dev/pull/1366) ([d7919](https://github.com/d7919))
- Optimisations to certain vector routines [\#1363](https://github.com/boutproject/BOUT-dev/pull/1363) ([d7919](https://github.com/d7919))
- Clean squashoutput.py [\#1362](https://github.com/boutproject/BOUT-dev/pull/1362) ([dschwoerer](https://github.com/dschwoerer))
- Fix path for locale files [\#1360](https://github.com/boutproject/BOUT-dev/pull/1360) ([dschwoerer](https://github.com/dschwoerer))
- Remove last DataIterator references/uses [\#1358](https://github.com/boutproject/BOUT-dev/pull/1358) ([ZedThree](https://github.com/ZedThree))
- Disable broken tests [\#1356](https://github.com/boutproject/BOUT-dev/pull/1356) ([dschwoerer](https://github.com/dschwoerer))
- Comment out clang-format directives that need clang-format \>= 6 [\#1353](https://github.com/boutproject/BOUT-dev/pull/1353) ([ZedThree](https://github.com/ZedThree))
- Support BoutReal and file-level attributes for netCDF and HDF5 files [\#1350](https://github.com/boutproject/BOUT-dev/pull/1350) ([johnomotani](https://github.com/johnomotani))
- Delete dependency .mk files in clean target [\#1348](https://github.com/boutproject/BOUT-dev/pull/1348) ([bendudson](https://github.com/bendudson))
- Boundary keywords and bugfix [\#1346](https://github.com/boutproject/BOUT-dev/pull/1346) ([bendudson](https://github.com/bendudson))
- Add multiple parallel slices [\#1345](https://github.com/boutproject/BOUT-dev/pull/1345) ([ZedThree](https://github.com/ZedThree))
- Reuse fixture for creating/destroying FakeMesh [\#1344](https://github.com/boutproject/BOUT-dev/pull/1344) ([ZedThree](https://github.com/ZedThree))
- Clang format update [\#1343](https://github.com/boutproject/BOUT-dev/pull/1343) ([ZedThree](https://github.com/ZedThree))
- Fix FV::Div\_Par\_K\_Grad\_Par [\#1341](https://github.com/boutproject/BOUT-dev/pull/1341) ([johnomotani](https://github.com/johnomotani))
- Changing README example to use cross rather than ^ [\#1340](https://github.com/boutproject/BOUT-dev/pull/1340) ([bendudson](https://github.com/bendudson))
- Remove `using std::string` etc from headers [\#1339](https://github.com/boutproject/BOUT-dev/pull/1339) ([ZedThree](https://github.com/ZedThree))
- Boutexception backtrace tidy [\#1338](https://github.com/boutproject/BOUT-dev/pull/1338) ([ZedThree](https://github.com/ZedThree))
- A couple of small bugfixes for Zoidberg [\#1337](https://github.com/boutproject/BOUT-dev/pull/1337) ([ZedThree](https://github.com/ZedThree))
- Internationalisation with gettext [\#1335](https://github.com/boutproject/BOUT-dev/pull/1335) ([bendudson](https://github.com/bendudson))
- Expressions improvements: escape chars and unicode [\#1333](https://github.com/boutproject/BOUT-dev/pull/1333) ([bendudson](https://github.com/bendudson))
- Save run information to settings file [\#1332](https://github.com/boutproject/BOUT-dev/pull/1332) ([bendudson](https://github.com/bendudson))
- Remove more deprecated derivs boundaries [\#1331](https://github.com/boutproject/BOUT-dev/pull/1331) ([d7919](https://github.com/d7919))
- Add unary operator+ to fields [\#1329](https://github.com/boutproject/BOUT-dev/pull/1329) ([bendudson](https://github.com/bendudson))
- Add support for enum class [\#1328](https://github.com/boutproject/BOUT-dev/pull/1328) ([dschwoerer](https://github.com/dschwoerer))
- Remove deprecated routines [\#1326](https://github.com/boutproject/BOUT-dev/pull/1326) ([d7919](https://github.com/d7919))

## [v4.2.3](https://github.com/boutproject/BOUT-dev/tree/v4.2.3) (2019-10-23)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.2.2...v4.2.3)

**Merged pull requests:**

- Add counters to Timers to avoid double-counting sections [\#1817](https://github.com/boutproject/BOUT-dev/pull/1817) ([ZedThree](https://github.com/ZedThree))
- Bugfix: cyclic parallel derivative inversion done in wrong space [\#1807](https://github.com/boutproject/BOUT-dev/pull/1807) ([ZedThree](https://github.com/ZedThree))
- Add instructions for Ubuntu 16.04 [\#1690](https://github.com/boutproject/BOUT-dev/pull/1690) ([dschwoerer](https://github.com/dschwoerer))
- Allow relative paths to be followed when making [\#1670](https://github.com/boutproject/BOUT-dev/pull/1670) ([johnomotani](https://github.com/johnomotani))
- Update examples/staggered\_grid for v4.2 [\#1645](https://github.com/boutproject/BOUT-dev/pull/1645) ([johnomotani](https://github.com/johnomotani))
- Add EXTRA\_LIBS to LIBS when searching for libraries [\#1632](https://github.com/boutproject/BOUT-dev/pull/1632) ([ZedThree](https://github.com/ZedThree))
- Recent fixes/improvements for Travis into master [\#1627](https://github.com/boutproject/BOUT-dev/pull/1627) ([ZedThree](https://github.com/ZedThree))
- Bug in calculation of ShiftAngle \(qloop\) [\#1626](https://github.com/boutproject/BOUT-dev/pull/1626) ([bendudson](https://github.com/bendudson))

## [v4.2.2](https://github.com/boutproject/BOUT-dev/tree/v4.2.2) (2019-02-27)

[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.2.1...v4.2.2)

**Merged pull requests:**

- Fix some clang-tidy warnings [\#1612](https://github.com/boutproject/BOUT-dev/pull/1612) ([ZedThree](https://github.com/ZedThree))
- Check if we need to link against libdl for dladdr [\#1611](https://github.com/boutproject/BOUT-dev/pull/1611) ([ZedThree](https://github.com/ZedThree))
- Fix unclean exit [\#1610](https://github.com/boutproject/BOUT-dev/pull/1610) ([dschwoerer](https://github.com/dschwoerer))
- Fix a couple of small(ish) bugs in FV::Div\_par\_K\_Grad\_par [\#1609](https://github.com/boutproject/BOUT-dev/pull/1609) ([bendudson](https://github.com/bendudson))
- Fix FV::Div\_a\_Laplace\_perp and FV::Div\_par\_K\_Grad\_par [\#1606](https://github.com/boutproject/BOUT-dev/pull/1606) ([bendudson](https://github.com/bendudson))
- Bugfix laplacexz [\#1605](https://github.com/boutproject/BOUT-dev/pull/1605) ([bendudson](https://github.com/bendudson))
- Initialise some mesh variables to sensible defaults [\#1604](https://github.com/boutproject/BOUT-dev/pull/1604) ([ZedThree](https://github.com/ZedThree))
- Fix prototype Div\(v2d, f2d\) in header [\#1603](https://github.com/boutproject/BOUT-dev/pull/1603) ([bendudson](https://github.com/bendudson))
- Hypnotoad version numbering [\#1595](https://github.com/boutproject/BOUT-dev/pull/1595) ([johnomotani](https://github.com/johnomotani))
- Provide formatting string [\#1588](https://github.com/boutproject/BOUT-dev/pull/1588) ([dschwoerer](https://github.com/dschwoerer))
- Fix bug in FCI: missed last point in Z for corner displacements [\#1587](https://github.com/boutproject/BOUT-dev/pull/1587) ([ZedThree](https://github.com/ZedThree))
- use MPIRUN if set [\#1585](https://github.com/boutproject/BOUT-dev/pull/1585) ([dschwoerer](https://github.com/dschwoerer))
- Prevent failures on parallel, clean build [\#1583](https://github.com/boutproject/BOUT-dev/pull/1583) ([dschwoerer](https://github.com/dschwoerer))
- More printf [\#1581](https://github.com/boutproject/BOUT-dev/pull/1581) ([dschwoerer](https://github.com/dschwoerer))
- Provide argument for printf [\#1580](https://github.com/boutproject/BOUT-dev/pull/1580) ([dschwoerer](https://github.com/dschwoerer))
- Ensure Coordinates is a complete type when trying to swap [\#1574](https://github.com/boutproject/BOUT-dev/pull/1574) ([ZedThree](https://github.com/ZedThree))
- Compile with BOUT_FLAGS [\#1573](https://github.com/boutproject/BOUT-dev/pull/1573) ([dschwoerer](https://github.com/dschwoerer))
- Swap coordinates when adding - to master [\#1549](https://github.com/boutproject/BOUT-dev/pull/1549) ([johnomotani](https://github.com/johnomotani))

## [v4.2.1](https://github.com/boutproject/BOUT-dev/tree/v4.2.1) (2019-01-23)

[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.2.0...v4.2.1)

**Merged pull requests:**

- Fix MAYBE_UNUSED for some compilers [\#1520](https://github.com/boutproject/BOUT-dev/pull/1520) ([ZedThree](https://github.com/ZedThree))
- Try to provide some thread safety to msg_stack [\#1517](https://github.com/boutproject/BOUT-dev/pull/1517) ([d7919](https://github.com/d7919))
- Fix listing available derivative methods [\#1515](https://github.com/boutproject/BOUT-dev/pull/1515) ([ZedThree](https://github.com/ZedThree))
- Initialize Coordinates objects in BoutMesh::load() [\#1509](https://github.com/boutproject/BOUT-dev/pull/1509) ([johnomotani](https://github.com/johnomotani))
- Use localmesh for d2x and d2y, and interpolate them to location [\#1496](https://github.com/boutproject/BOUT-dev/pull/1496) ([johnomotani](https://github.com/johnomotani))
- Hypnotoad fixes [\#1487](https://github.com/boutproject/BOUT-dev/pull/1487) ([bendudson](https://github.com/bendudson))
- Silence remaining warnings on master [\#1485](https://github.com/boutproject/BOUT-dev/pull/1485) ([ZedThree](https://github.com/ZedThree))
- Documentation for making releases [\#1482](https://github.com/boutproject/BOUT-dev/pull/1482) ([ZedThree](https://github.com/ZedThree))
- Silence gcc warning about unrecognised option Wno-cast-function-type [\#1480](https://github.com/boutproject/BOUT-dev/pull/1480) ([ZedThree](https://github.com/ZedThree))
- Fix bugs in boututils.calculus.deriv2D [\#1479](https://github.com/boutproject/BOUT-dev/pull/1479) ([bendudson](https://github.com/bendudson))
- Fix failure of collect() with integer slice argument [\#1421](https://github.com/boutproject/BOUT-dev/pull/1421) ([johnomotani](https://github.com/johnomotani))
- Fix setCoefs in InvertPar [\#1398](https://github.com/boutproject/BOUT-dev/pull/1398) ([arkabokshi](https://github.com/arkabokshi))
- Support BoutOutputs caching option in boutcore \*.fromBoutOutputs [\#1397](https://github.com/boutproject/BOUT-dev/pull/1397) ([johnomotani](https://github.com/johnomotani))
- Hypnotoad: fix unstable integration method used to calculate zShift  [\#1387](https://github.com/boutproject/BOUT-dev/pull/1387) ([johnomotani](https://github.com/johnomotani))
- Check for nullptr in NcFormat::get/setAttribute [\#1374](https://github.com/boutproject/BOUT-dev/pull/1374) ([johnomotani](https://github.com/johnomotani))
- Set location in LaplaceCyclic::solve() and DC() [\#1368](https://github.com/boutproject/BOUT-dev/pull/1368) ([johnomotani](https://github.com/johnomotani))
- Changing README example to use cross rather than ^ [\#1357](https://github.com/boutproject/BOUT-dev/pull/1357) ([dschwoerer](https://github.com/dschwoerer))

## [v4.2.0](https://github.com/boutproject/BOUT-dev/tree/v4.2.0) (2018-10-16)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v1.0...v4.2.0)

**Merged pull requests:**

- Check TwistShift==true in ShiftedMetric with no changes to Mesh [\#1323](https://github.com/boutproject/BOUT-dev/pull/1323) ([johnomotani](https://github.com/johnomotani))
- Derivatives more tidyup [\#1318](https://github.com/boutproject/BOUT-dev/pull/1318) ([johnomotani](https://github.com/johnomotani))
- Use std::map::emplace to avoid naming complicated type with insert [\#1317](https://github.com/boutproject/BOUT-dev/pull/1317) ([ZedThree](https://github.com/ZedThree))
- Provide `getRegion` method on Fields [\#1316](https://github.com/boutproject/BOUT-dev/pull/1316) ([d7919](https://github.com/d7919))
- Throw error messages for non-python collect routines [\#1312](https://github.com/boutproject/BOUT-dev/pull/1312) ([ZedThree](https://github.com/ZedThree))
- Rename Mesh::coordinates -\> Mesh::getCoordinates; deprecate old name [\#1310](https://github.com/boutproject/BOUT-dev/pull/1310) ([ZedThree](https://github.com/ZedThree))
- Vecops consistent cell default add more checking on location [\#1308](https://github.com/boutproject/BOUT-dev/pull/1308) ([d7919](https://github.com/d7919))
- Include caveats on OpenMP parallelisation in documentation [\#1307](https://github.com/boutproject/BOUT-dev/pull/1307) ([ZedThree](https://github.com/ZedThree))
- Bugfixes from shiftedmetric-update [\#1306](https://github.com/boutproject/BOUT-dev/pull/1306) ([johnomotani](https://github.com/johnomotani))
- Squash test [\#1303](https://github.com/boutproject/BOUT-dev/pull/1303) ([dschwoerer](https://github.com/dschwoerer))
- Derivatives bugfixes [\#1302](https://github.com/boutproject/BOUT-dev/pull/1302) ([johnomotani](https://github.com/johnomotani))
-  Set 'non\_uniform' to true by default [\#1301](https://github.com/boutproject/BOUT-dev/pull/1301) ([johnomotani](https://github.com/johnomotani))
- Stagger derivatives fixes [\#1297](https://github.com/boutproject/BOUT-dev/pull/1297) ([dschwoerer](https://github.com/dschwoerer))
- Documentation for marconi [\#1296](https://github.com/boutproject/BOUT-dev/pull/1296) ([dschwoerer](https://github.com/dschwoerer))
- Use checkData instead of ASSERT\(finite\(\)\) in test-petsc-laplace [\#1295](https://github.com/boutproject/BOUT-dev/pull/1295) ([ZedThree](https://github.com/ZedThree))
- Use input field/vector location for CELL\_DEFAULT in vecops [\#1293](https://github.com/boutproject/BOUT-dev/pull/1293) ([ZedThree](https://github.com/ZedThree))
- Options with empty strings [\#1292](https://github.com/boutproject/BOUT-dev/pull/1292) ([bendudson](https://github.com/bendudson))
- Change Solver::add to take std::string [\#1291](https://github.com/boutproject/BOUT-dev/pull/1291) ([bendudson](https://github.com/bendudson))
- Add back "user" as a synonym for "shell" PETSc PCTYPE [\#1289](https://github.com/boutproject/BOUT-dev/pull/1289) ([ZedThree](https://github.com/ZedThree))
- Add MACRO\_FOR\_EACH for variadic macros [\#1285](https://github.com/boutproject/BOUT-dev/pull/1285) ([bendudson](https://github.com/bendudson))
- More consistent `CELL\_DEFAULT` handling [\#1284](https://github.com/boutproject/BOUT-dev/pull/1284) ([d7919](https://github.com/d7919))
- Remove unused local variable [\#1282](https://github.com/boutproject/BOUT-dev/pull/1282) ([ZedThree](https://github.com/ZedThree))
- Add fromBoutOutputs method to boutcore.Field3D [\#1281](https://github.com/boutproject/BOUT-dev/pull/1281) ([johnomotani](https://github.com/johnomotani))
- Bugfix for linking boutcore when $ldflags is empty [\#1280](https://github.com/boutproject/BOUT-dev/pull/1280) ([johnomotani](https://github.com/johnomotani))
- Add location checking for generated field ops involving Field2Ds [\#1278](https://github.com/boutproject/BOUT-dev/pull/1278) ([d7919](https://github.com/d7919))
- Pour some sugar on Options [\#1277](https://github.com/boutproject/BOUT-dev/pull/1277) ([bendudson](https://github.com/bendudson))
- Adding OMP parallelisation for loops in rkgeneric solver [\#1272](https://github.com/boutproject/BOUT-dev/pull/1272) ([d7919](https://github.com/d7919))
- Tidyup coordinates field fix [\#1271](https://github.com/boutproject/BOUT-dev/pull/1271) ([d7919](https://github.com/d7919))
- Simplifying interchange instability test [\#1270](https://github.com/boutproject/BOUT-dev/pull/1270) ([bendudson](https://github.com/bendudson))
- Don't overwrite local mesh with global one [\#1269](https://github.com/boutproject/BOUT-dev/pull/1269) ([d7919](https://github.com/d7919))
- Add checks in case Mesh::source is nullptr and try to do sensible things [\#1268](https://github.com/boutproject/BOUT-dev/pull/1268) ([d7919](https://github.com/d7919))
- Field{2,3}D::applyBoundary\(string,string\) throw [\#1265](https://github.com/boutproject/BOUT-dev/pull/1265) ([bendudson](https://github.com/bendudson))
- hypnotoad: make dpsi in PF region continuous at separatrix [\#1264](https://github.com/boutproject/BOUT-dev/pull/1264) ([johnomotani](https://github.com/johnomotani))
- Less confusing error message [\#1262](https://github.com/boutproject/BOUT-dev/pull/1262) ([dschwoerer](https://github.com/dschwoerer))
- Support for old install [\#1261](https://github.com/boutproject/BOUT-dev/pull/1261) ([dschwoerer](https://github.com/dschwoerer))
- Fix return type [\#1260](https://github.com/boutproject/BOUT-dev/pull/1260) ([dschwoerer](https://github.com/dschwoerer))
- Deprecate Field::getName/setName [\#1257](https://github.com/boutproject/BOUT-dev/pull/1257) ([bendudson](https://github.com/bendudson))
- Fix warnings with default configure [\#1256](https://github.com/boutproject/BOUT-dev/pull/1256) ([ZedThree](https://github.com/ZedThree))
- Morecommands [\#1255](https://github.com/boutproject/BOUT-dev/pull/1255) ([dschwoerer](https://github.com/dschwoerer))
- Cyclic Laplace solve\(Field3D\) [\#1253](https://github.com/boutproject/BOUT-dev/pull/1253) ([bendudson](https://github.com/bendudson))
- Field2D and Coordinates for boutcore [\#1251](https://github.com/boutproject/BOUT-dev/pull/1251) ([johnomotani](https://github.com/johnomotani))
- Respect 'enabled' option in Datafile::add [\#1250](https://github.com/boutproject/BOUT-dev/pull/1250) ([johnomotani](https://github.com/johnomotani))
- More omp cyclic laplace [\#1249](https://github.com/boutproject/BOUT-dev/pull/1249) ([d7919](https://github.com/d7919))
- Fix for h5py bug [\#1248](https://github.com/boutproject/BOUT-dev/pull/1248) ([dschwoerer](https://github.com/dschwoerer))
- Add -Wall -Wextra to default configure [\#1246](https://github.com/boutproject/BOUT-dev/pull/1246) ([ZedThree](https://github.com/ZedThree))
- Monitor frequency fix [\#1244](https://github.com/boutproject/BOUT-dev/pull/1244) ([johnomotani](https://github.com/johnomotani))
- DataFile return self from \_\_enter\_\_ [\#1243](https://github.com/boutproject/BOUT-dev/pull/1243) ([johnomotani](https://github.com/johnomotani))
- Reduce memory usage of squashoutput [\#1241](https://github.com/boutproject/BOUT-dev/pull/1241) ([dschwoerer](https://github.com/dschwoerer))
- Faster arakawa with bout for [\#1239](https://github.com/boutproject/BOUT-dev/pull/1239) ([d7919](https://github.com/d7919))
- More consistent/stringent pre/postconditions on Field\* functions [\#1238](https://github.com/boutproject/BOUT-dev/pull/1238) ([ZedThree](https://github.com/ZedThree))
- Check int arguments to \*ind in collect [\#1235](https://github.com/boutproject/BOUT-dev/pull/1235) ([johnomotani](https://github.com/johnomotani))
- Make pow\(Field3D, FieldPerp\) return FieldPerp [\#1234](https://github.com/boutproject/BOUT-dev/pull/1234) ([ZedThree](https://github.com/ZedThree))
- Fix includes for region.hxx [\#1232](https://github.com/boutproject/BOUT-dev/pull/1232) ([ZedThree](https://github.com/ZedThree))
- Fix constructors for BoundaryRegion classes [\#1231](https://github.com/boutproject/BOUT-dev/pull/1231) ([ZedThree](https://github.com/ZedThree))
- isSet returns false if set via default [\#1227](https://github.com/boutproject/BOUT-dev/pull/1227) ([dschwoerer](https://github.com/dschwoerer))
- Fix interpolation boundaries [\#1226](https://github.com/boutproject/BOUT-dev/pull/1226) ([dschwoerer](https://github.com/dschwoerer))
- Summarise test-include test in the end [\#1225](https://github.com/boutproject/BOUT-dev/pull/1225) ([dschwoerer](https://github.com/dschwoerer))
- Improve comments for Mesh::?GLOBAL [\#1224](https://github.com/boutproject/BOUT-dev/pull/1224) ([dschwoerer](https://github.com/dschwoerer))
- Add 'Laplace\(\)' operator in boutcore [\#1223](https://github.com/boutproject/BOUT-dev/pull/1223) ([johnomotani](https://github.com/johnomotani))
- Add ind perp to region support [\#1222](https://github.com/boutproject/BOUT-dev/pull/1222) ([d7919](https://github.com/d7919))
- Squashoutput [\#1220](https://github.com/boutproject/BOUT-dev/pull/1220) ([dschwoerer](https://github.com/dschwoerer))
- Collect: Fix if a list containing zero, one or three elements [\#1219](https://github.com/boutproject/BOUT-dev/pull/1219) ([dschwoerer](https://github.com/dschwoerer))
- Expose the setCoef\* methods of Laplacian in boutcore [\#1216](https://github.com/boutproject/BOUT-dev/pull/1216) ([johnomotani](https://github.com/johnomotani))
- Check for None explicitly in collect [\#1215](https://github.com/boutproject/BOUT-dev/pull/1215) ([johnomotani](https://github.com/johnomotani))
- Template SpecificInd to allow strong typedef like Ind2D and Ind3D [\#1214](https://github.com/boutproject/BOUT-dev/pull/1214) ([d7919](https://github.com/d7919))
- Matrix tensor size type [\#1212](https://github.com/boutproject/BOUT-dev/pull/1212) ([d7919](https://github.com/d7919))
- Add offsetting to Region and Ind2D/Ind3D [\#1211](https://github.com/boutproject/BOUT-dev/pull/1211) ([ZedThree](https://github.com/ZedThree))
- Towards stencil deprecation [\#1210](https://github.com/boutproject/BOUT-dev/pull/1210) ([d7919](https://github.com/d7919))
- New region block loop macro [\#1209](https://github.com/boutproject/BOUT-dev/pull/1209) ([ZedThree](https://github.com/ZedThree))
- Stencil small tweak to aid vectorisation [\#1208](https://github.com/boutproject/BOUT-dev/pull/1208) ([d7919](https://github.com/d7919))
- Manual instructions on Docker image [\#1207](https://github.com/boutproject/BOUT-dev/pull/1207) ([bendudson](https://github.com/bendudson))
- Improved VDDX\_U2\_stag [\#1205](https://github.com/boutproject/BOUT-dev/pull/1205) ([johnomotani](https://github.com/johnomotani))
- Add SUNDIALS\_EXTRA\_LIBS linker flag [\#1204](https://github.com/boutproject/BOUT-dev/pull/1204) ([bendudson](https://github.com/bendudson))
- Extend Ubuntu installation instructions [\#1203](https://github.com/boutproject/BOUT-dev/pull/1203) ([dschwoerer](https://github.com/dschwoerer))
- Make Monitor::timestep settable [\#1202](https://github.com/boutproject/BOUT-dev/pull/1202) ([johnomotani](https://github.com/johnomotani))
- Search for expressions as whole words when evaluating options [\#1201](https://github.com/boutproject/BOUT-dev/pull/1201) ([johnomotani](https://github.com/johnomotani))
- Set coordinates location [\#1200](https://github.com/boutproject/BOUT-dev/pull/1200) ([johnomotani](https://github.com/johnomotani))
- Don't use global mesh in BoundaryRegion [\#1199](https://github.com/boutproject/BOUT-dev/pull/1199) ([johnomotani](https://github.com/johnomotani))
- Coordinates location [\#1198](https://github.com/boutproject/BOUT-dev/pull/1198) ([johnomotani](https://github.com/johnomotani))
- Cython linking [\#1197](https://github.com/boutproject/BOUT-dev/pull/1197) ([dschwoerer](https://github.com/dschwoerer))
- Speedup travis by removing jobs [\#1196](https://github.com/boutproject/BOUT-dev/pull/1196) ([d7919](https://github.com/d7919))
- Write attributes to file only once [\#1195](https://github.com/boutproject/BOUT-dev/pull/1195) ([johnomotani](https://github.com/johnomotani))
- Block region describe [\#1194](https://github.com/boutproject/BOUT-dev/pull/1194) ([d7919](https://github.com/d7919))
- Attributes for scalars [\#1193](https://github.com/boutproject/BOUT-dev/pull/1193) ([johnomotani](https://github.com/johnomotani))
- MMS fixes [\#1190](https://github.com/boutproject/BOUT-dev/pull/1190) ([dschwoerer](https://github.com/dschwoerer))
- Escape variable names for expression parsing in BoutOptions/BoutOptionsFile [\#1188](https://github.com/boutproject/BOUT-dev/pull/1188) ([johnomotani](https://github.com/johnomotani))
- Fix check for post\_processing\_function in bout\_runners [\#1185](https://github.com/boutproject/BOUT-dev/pull/1185) ([ZedThree](https://github.com/ZedThree))
- Manual operator typo [\#1184](https://github.com/boutproject/BOUT-dev/pull/1184) ([ZedThree](https://github.com/ZedThree))
- Change 'auto i' to 'const auto &i' in for loops [\#1182](https://github.com/boutproject/BOUT-dev/pull/1182) ([johnomotani](https://github.com/johnomotani))
- Expose applyBoundary to boutcore [\#1180](https://github.com/boutproject/BOUT-dev/pull/1180) ([dschwoerer](https://github.com/dschwoerer))
- Fix documentation [\#1172](https://github.com/boutproject/BOUT-dev/pull/1172) ([dschwoerer](https://github.com/dschwoerer))
- Various modernise fixes [\#1171](https://github.com/boutproject/BOUT-dev/pull/1171) ([ZedThree](https://github.com/ZedThree))
- Codacy tweaks [\#1169](https://github.com/boutproject/BOUT-dev/pull/1169) ([d7919](https://github.com/d7919))
- Add support for multiple Options [\#1168](https://github.com/boutproject/BOUT-dev/pull/1168) ([dschwoerer](https://github.com/dschwoerer))
- Avoid throwing a copy of existing exception [\#1167](https://github.com/boutproject/BOUT-dev/pull/1167) ([d7919](https://github.com/d7919))
- Rethrow exceptions without copying [\#1165](https://github.com/boutproject/BOUT-dev/pull/1165) ([d7919](https://github.com/d7919))
- Replace shared\_ptr\<?\>\(new ?\(\)\) with make\_shared [\#1164](https://github.com/boutproject/BOUT-dev/pull/1164) ([d7919](https://github.com/d7919))
- Fix various unused warnings [\#1159](https://github.com/boutproject/BOUT-dev/pull/1159) ([ZedThree](https://github.com/ZedThree))
- Modernise MsgStack [\#1156](https://github.com/boutproject/BOUT-dev/pull/1156) ([ZedThree](https://github.com/ZedThree))
- More unit tests fields [\#1155](https://github.com/boutproject/BOUT-dev/pull/1155) ([d7919](https://github.com/d7919))
- More unit tests include files [\#1154](https://github.com/boutproject/BOUT-dev/pull/1154) ([d7919](https://github.com/d7919))
- More robust tests for Array, plus C++11 idioms [\#1153](https://github.com/boutproject/BOUT-dev/pull/1153) ([ZedThree](https://github.com/ZedThree))
- More unit tests expressionparser [\#1151](https://github.com/boutproject/BOUT-dev/pull/1151) ([d7919](https://github.com/d7919))
- More unit tests msg stack [\#1150](https://github.com/boutproject/BOUT-dev/pull/1150) ([d7919](https://github.com/d7919))
- More unit tests for optionsreader [\#1148](https://github.com/boutproject/BOUT-dev/pull/1148) ([d7919](https://github.com/d7919))
- Slepc configure update [\#1145](https://github.com/boutproject/BOUT-dev/pull/1145) ([d7919](https://github.com/d7919))
- Use Array\<BoutReal\> in imex-bdf2 [\#1144](https://github.com/boutproject/BOUT-dev/pull/1144) ([ZedThree](https://github.com/ZedThree))
- Fix some sign comparison warnings [\#1143](https://github.com/boutproject/BOUT-dev/pull/1143) ([ZedThree](https://github.com/ZedThree))
- Remove some unused variables [\#1142](https://github.com/boutproject/BOUT-dev/pull/1142) ([ZedThree](https://github.com/ZedThree))
- Fix memory leak in laplacexy [\#1140](https://github.com/boutproject/BOUT-dev/pull/1140) ([ZedThree](https://github.com/ZedThree))
- Restore coordinate documentation [\#1139](https://github.com/boutproject/BOUT-dev/pull/1139) ([ZedThree](https://github.com/ZedThree))
- Allows rkgeneric to reset for use with SLEPc [\#1138](https://github.com/boutproject/BOUT-dev/pull/1138) ([d7919](https://github.com/d7919))
- Fix showdata error when plotting 0. [\#1137](https://github.com/boutproject/BOUT-dev/pull/1137) ([johnomotani](https://github.com/johnomotani))
- The simple version does not work. [\#1135](https://github.com/boutproject/BOUT-dev/pull/1135) ([dschwoerer](https://github.com/dschwoerer))
- Extend support for 1D simulation [\#1130](https://github.com/boutproject/BOUT-dev/pull/1130) ([dschwoerer](https://github.com/dschwoerer))
- Silence Options unit test [\#1129](https://github.com/boutproject/BOUT-dev/pull/1129) ([ZedThree](https://github.com/ZedThree))
- Use nullptr everywhere possible in library [\#1128](https://github.com/boutproject/BOUT-dev/pull/1128) ([ZedThree](https://github.com/ZedThree))
- Add implementation of 'Naulin' Laplacian solver [\#1127](https://github.com/boutproject/BOUT-dev/pull/1127) ([johnomotani](https://github.com/johnomotani))
- Use character overload of string::find\_first/last\_of [\#1125](https://github.com/boutproject/BOUT-dev/pull/1125) ([ZedThree](https://github.com/ZedThree))
- Set result location in Delp2 from incoming field [\#1124](https://github.com/boutproject/BOUT-dev/pull/1124) ([AdamD94](https://github.com/AdamD94))
- Bugfixes for non-zero Neumann boundary conditions in tridagMatrix [\#1122](https://github.com/boutproject/BOUT-dev/pull/1122) ([johnomotani](https://github.com/johnomotani))
- clang-tidy: avoid copies [\#1121](https://github.com/boutproject/BOUT-dev/pull/1121) ([ZedThree](https://github.com/ZedThree))
- Fix deprecated warning in vecops Div [\#1120](https://github.com/boutproject/BOUT-dev/pull/1120) ([ZedThree](https://github.com/ZedThree))
- Don't set/delete MMS\_err for Vectors [\#1118](https://github.com/boutproject/BOUT-dev/pull/1118) ([ZedThree](https://github.com/ZedThree))
- Add monotonic Hermite spline interpolator [\#1116](https://github.com/boutproject/BOUT-dev/pull/1116) ([bendudson](https://github.com/bendudson))
- Fix bug in FCI area integration [\#1115](https://github.com/boutproject/BOUT-dev/pull/1115) ([bendudson](https://github.com/bendudson))
- Guard against double-frees of PETSc objects [\#1112](https://github.com/boutproject/BOUT-dev/pull/1112) ([ZedThree](https://github.com/ZedThree))
- Fix wrong function signature in ArkodeSolver [\#1111](https://github.com/boutproject/BOUT-dev/pull/1111) ([ZedThree](https://github.com/ZedThree))
- pol\_slice tidy and simplify [\#1110](https://github.com/boutproject/BOUT-dev/pull/1110) ([ZedThree](https://github.com/ZedThree))
- Simplify some bout\_type \<-\> dimensions tuple handling [\#1109](https://github.com/boutproject/BOUT-dev/pull/1109) ([ZedThree](https://github.com/ZedThree))
- Monkey patch old versions of scipy.io.netcdf [\#1108](https://github.com/boutproject/BOUT-dev/pull/1108) ([ZedThree](https://github.com/ZedThree))
- Add write method to BoutOptionsFile and update showdata [\#1107](https://github.com/boutproject/BOUT-dev/pull/1107) ([johnomotani](https://github.com/johnomotani))
- Additions to Python tools [\#1106](https://github.com/boutproject/BOUT-dev/pull/1106) ([johnomotani](https://github.com/johnomotani))
- More SI constants [\#1105](https://github.com/boutproject/BOUT-dev/pull/1105) ([dschwoerer](https://github.com/dschwoerer))
- Add option for setting the window title in showdata [\#1104](https://github.com/boutproject/BOUT-dev/pull/1104) ([johnomotani](https://github.com/johnomotani))
- Python DataFile 64-bit offsets [\#1103](https://github.com/boutproject/BOUT-dev/pull/1103) ([bendudson](https://github.com/bendudson))
- Python numpy [\#1102](https://github.com/boutproject/BOUT-dev/pull/1102) ([dschwoerer](https://github.com/dschwoerer))
- Take parameter by const-reference in SQ [\#1101](https://github.com/boutproject/BOUT-dev/pull/1101) ([ZedThree](https://github.com/ZedThree))
- Fix some memory leaks in multigrid [\#1100](https://github.com/boutproject/BOUT-dev/pull/1100) ([ZedThree](https://github.com/ZedThree))
- Zoidberg large grids [\#1099](https://github.com/boutproject/BOUT-dev/pull/1099) ([bendudson](https://github.com/bendudson))
- Monitor tidy [\#1098](https://github.com/boutproject/BOUT-dev/pull/1098) ([ZedThree](https://github.com/ZedThree))
- fix D2DXDY: include x boundary [\#1097](https://github.com/boutproject/BOUT-dev/pull/1097) ([dschwoerer](https://github.com/dschwoerer))
- Sub Libs most likely depend on BOUT++ [\#1096](https://github.com/boutproject/BOUT-dev/pull/1096) ([dschwoerer](https://github.com/dschwoerer))
- Check field location in solver [\#1095](https://github.com/boutproject/BOUT-dev/pull/1095) ([dschwoerer](https://github.com/dschwoerer))
- fix isMultiple [\#1094](https://github.com/boutproject/BOUT-dev/pull/1094) ([dschwoerer](https://github.com/dschwoerer))
- ExpressionParser throw ParseException rather than returning null [\#1091](https://github.com/boutproject/BOUT-dev/pull/1091) ([bendudson](https://github.com/bendudson))
- Fix typo in collect [\#1089](https://github.com/boutproject/BOUT-dev/pull/1089) ([johnomotani](https://github.com/johnomotani))
- Fix copy constructor bug [\#1088](https://github.com/boutproject/BOUT-dev/pull/1088) ([d7919](https://github.com/d7919))
- Evaluate expressions from input files in BoutOptions/BoutOptionsFile [\#1087](https://github.com/boutproject/BOUT-dev/pull/1087) ([johnomotani](https://github.com/johnomotani))
- Fix exit status of quiet script [\#1086](https://github.com/boutproject/BOUT-dev/pull/1086) ([dschwoerer](https://github.com/dschwoerer))
- Remove MPICH from Travis build [\#1084](https://github.com/boutproject/BOUT-dev/pull/1084) ([ZedThree](https://github.com/ZedThree))
- rhs counters are reset by Solver [\#1083](https://github.com/boutproject/BOUT-dev/pull/1083) ([dschwoerer](https://github.com/dschwoerer))
- Improve scripts in bin [\#1082](https://github.com/boutproject/BOUT-dev/pull/1082) ([dschwoerer](https://github.com/dschwoerer))
- FCI divergence operators [\#1081](https://github.com/boutproject/BOUT-dev/pull/1081) ([bendudson](https://github.com/bendudson))
- Fix various 'import' related issues in python [\#1080](https://github.com/boutproject/BOUT-dev/pull/1080) ([ZedThree](https://github.com/ZedThree))
- Allow number of x-boundary points to change in FFT Laplace solvers [\#1078](https://github.com/boutproject/BOUT-dev/pull/1078) ([johnomotani](https://github.com/johnomotani))
- Fix order of arguments in call to tridagMatrix in LaplaceSPT [\#1077](https://github.com/boutproject/BOUT-dev/pull/1077) ([johnomotani](https://github.com/johnomotani))
- Fix zoidberg with ny=1 [\#1075](https://github.com/boutproject/BOUT-dev/pull/1075) ([bendudson](https://github.com/bendudson))
- Fixes pol\_slice by adding `np.` in appropriate places [\#1074](https://github.com/boutproject/BOUT-dev/pull/1074) ([d7919](https://github.com/d7919))
- Python numpydocs [\#1073](https://github.com/boutproject/BOUT-dev/pull/1073) ([ZedThree](https://github.com/ZedThree))
- Bring back progress spinner and ETA estimate [\#1072](https://github.com/boutproject/BOUT-dev/pull/1072) ([ZedThree](https://github.com/ZedThree))
- Remove our own error messages on ImportError [\#1070](https://github.com/boutproject/BOUT-dev/pull/1070) ([ZedThree](https://github.com/ZedThree))
- Remove BoutComm::cleanup\(\) call from exception catch in BoutInitialise\(\) [\#1069](https://github.com/boutproject/BOUT-dev/pull/1069) ([johnomotani](https://github.com/johnomotani))
- Boutoptionsfile update [\#1066](https://github.com/boutproject/BOUT-dev/pull/1066) ([johnomotani](https://github.com/johnomotani))
- Ny interp pol slice [\#1063](https://github.com/boutproject/BOUT-dev/pull/1063) ([d7919](https://github.com/d7919))
- Workarounds to get boutcore Cython module to work with OpenMPI [\#1059](https://github.com/boutproject/BOUT-dev/pull/1059) ([johnomotani](https://github.com/johnomotani))
- Add readme for boutcore tests [\#1058](https://github.com/boutproject/BOUT-dev/pull/1058) ([dschwoerer](https://github.com/dschwoerer))
- Bugfix for BoutOutputs when not caching open DataFiles [\#1057](https://github.com/boutproject/BOUT-dev/pull/1057) ([johnomotani](https://github.com/johnomotani))
- Bracket mms [\#1055](https://github.com/boutproject/BOUT-dev/pull/1055) ([dschwoerer](https://github.com/dschwoerer))
- Make unit tests less verbose [\#1052](https://github.com/boutproject/BOUT-dev/pull/1052) ([dschwoerer](https://github.com/dschwoerer))
- Add missing fromFieldAligned\(\) in interp\_to\(\) [\#1051](https://github.com/boutproject/BOUT-dev/pull/1051) ([johnomotani](https://github.com/johnomotani))
- Cleanup PETSc interface [\#1050](https://github.com/boutproject/BOUT-dev/pull/1050) ([ZedThree](https://github.com/ZedThree))
- Fix missing braces in interp\_to [\#1046](https://github.com/boutproject/BOUT-dev/pull/1046) ([johnomotani](https://github.com/johnomotani))
- Enable formatting of single numbers [\#1045](https://github.com/boutproject/BOUT-dev/pull/1045) ([dschwoerer](https://github.com/dschwoerer))
- Disable pnetcdf configure by default [\#1044](https://github.com/boutproject/BOUT-dev/pull/1044) ([bendudson](https://github.com/bendudson))
- Save field cell location attributes [\#1042](https://github.com/boutproject/BOUT-dev/pull/1042) ([bendudson](https://github.com/bendudson))
- Deprecate ^ operator as cross product [\#1041](https://github.com/boutproject/BOUT-dev/pull/1041) ([dschwoerer](https://github.com/dschwoerer))
- D2dy2 bugfix test2 [\#1040](https://github.com/boutproject/BOUT-dev/pull/1040) ([dschwoerer](https://github.com/dschwoerer))
- Expose forceset [\#1038](https://github.com/boutproject/BOUT-dev/pull/1038) ([dschwoerer](https://github.com/dschwoerer))
- Fix compiling for petsc 3.9 [\#1035](https://github.com/boutproject/BOUT-dev/pull/1035) ([dschwoerer](https://github.com/dschwoerer))
- Simlify and extend Function lookup [\#1034](https://github.com/boutproject/BOUT-dev/pull/1034) ([dschwoerer](https://github.com/dschwoerer))
- Add installation instruction for fedora [\#1033](https://github.com/boutproject/BOUT-dev/pull/1033) ([dschwoerer](https://github.com/dschwoerer))
- Make Solvers discoverable [\#1032](https://github.com/boutproject/BOUT-dev/pull/1032) ([ZedThree](https://github.com/ZedThree))
- Remove header file changes tracking [\#1031](https://github.com/boutproject/BOUT-dev/pull/1031) ([dschwoerer](https://github.com/dschwoerer))
- netCDF-cxx library needed for Ubuntu [\#1030](https://github.com/boutproject/BOUT-dev/pull/1030) ([jenuis](https://github.com/jenuis))
- Use POSIX-compliant syntax for file redirects [\#1028](https://github.com/boutproject/BOUT-dev/pull/1028) ([johnomotani](https://github.com/johnomotani))
- jyseps checking update [\#1027](https://github.com/boutproject/BOUT-dev/pull/1027) ([johnomotani](https://github.com/johnomotani))
- Increase the precision of stored BoutReals in Options [\#1026](https://github.com/boutproject/BOUT-dev/pull/1026) ([ZedThree](https://github.com/ZedThree))
- jyseps\* checking [\#1025](https://github.com/boutproject/BOUT-dev/pull/1025) ([johnomotani](https://github.com/johnomotani))
- Fix elm-pb case with compressional effects [\#1023](https://github.com/boutproject/BOUT-dev/pull/1023) ([bendudson](https://github.com/bendudson))
- Throw if options is changed [\#1021](https://github.com/boutproject/BOUT-dev/pull/1021) ([dschwoerer](https://github.com/dschwoerer))
- Cleanup calculus.py [\#1020](https://github.com/boutproject/BOUT-dev/pull/1020) ([dschwoerer](https://github.com/dschwoerer))
- Even more manual improvements [\#1019](https://github.com/boutproject/BOUT-dev/pull/1019) ([ZedThree](https://github.com/ZedThree))
- Print names first in tests [\#1016](https://github.com/boutproject/BOUT-dev/pull/1016) ([dschwoerer](https://github.com/dschwoerer))
- += is not supported by dash [\#1015](https://github.com/boutproject/BOUT-dev/pull/1015) ([dschwoerer](https://github.com/dschwoerer))
- Warn if object files remain after cleaning [\#1014](https://github.com/boutproject/BOUT-dev/pull/1014) ([dschwoerer](https://github.com/dschwoerer))
- Add explanaiton for test and disable by default [\#1012](https://github.com/boutproject/BOUT-dev/pull/1012) ([dschwoerer](https://github.com/dschwoerer))
- Remove test-ballooning [\#1005](https://github.com/boutproject/BOUT-dev/pull/1005) ([dschwoerer](https://github.com/dschwoerer))
- Make sure DataIterator.zp\(\) is not used with negative numbers [\#1002](https://github.com/boutproject/BOUT-dev/pull/1002) ([dschwoerer](https://github.com/dschwoerer))
- Avoid exception if no implementation found [\#1000](https://github.com/boutproject/BOUT-dev/pull/1000) ([dschwoerer](https://github.com/dschwoerer))
- Redistribute dmp files [\#996](https://github.com/boutproject/BOUT-dev/pull/996) ([johnomotani](https://github.com/johnomotani))
- Fix multigrid openmp collapse loops [\#995](https://github.com/boutproject/BOUT-dev/pull/995) ([JosephThomasParker](https://github.com/JosephThomasParker))
- Check result location in derivatives [\#994](https://github.com/boutproject/BOUT-dev/pull/994) ([johnomotani](https://github.com/johnomotani))
- Enable configuring for fedoras installed PETSc [\#993](https://github.com/boutproject/BOUT-dev/pull/993) ([dschwoerer](https://github.com/dschwoerer))
- Fix test-petsc\_laplace\_MAST-grid [\#992](https://github.com/boutproject/BOUT-dev/pull/992) ([dschwoerer](https://github.com/dschwoerer))
- Fix test-fieldgroupComm [\#991](https://github.com/boutproject/BOUT-dev/pull/991) ([dschwoerer](https://github.com/dschwoerer))
- Fix hdf5 test [\#990](https://github.com/boutproject/BOUT-dev/pull/990) ([dschwoerer](https://github.com/dschwoerer))
- Slow tests [\#989](https://github.com/boutproject/BOUT-dev/pull/989) ([dschwoerer](https://github.com/dschwoerer))
- Prevent issues with parallel documentation build [\#982](https://github.com/boutproject/BOUT-dev/pull/982) ([dschwoerer](https://github.com/dschwoerer))
- Improve manual [\#981](https://github.com/boutproject/BOUT-dev/pull/981) ([bendudson](https://github.com/bendudson))
- Basic version of test requirement scripts [\#980](https://github.com/boutproject/BOUT-dev/pull/980) ([bendudson](https://github.com/bendudson))
- Prevent shadowing [\#978](https://github.com/boutproject/BOUT-dev/pull/978) ([dschwoerer](https://github.com/dschwoerer))
- Suppress multigrid diagnostic output [\#977](https://github.com/boutproject/BOUT-dev/pull/977) ([johnomotani](https://github.com/johnomotani))
- Include fixes [\#976](https://github.com/boutproject/BOUT-dev/pull/976) ([dschwoerer](https://github.com/dschwoerer))
- Prefer passing nullptr [\#975](https://github.com/boutproject/BOUT-dev/pull/975) ([dschwoerer](https://github.com/dschwoerer))
- Indent make messages more consistently [\#974](https://github.com/boutproject/BOUT-dev/pull/974) ([dschwoerer](https://github.com/dschwoerer))
- Update documentation of integer expressions [\#973](https://github.com/boutproject/BOUT-dev/pull/973) ([bendudson](https://github.com/bendudson))
- Rangeiterator to region in Solver [\#972](https://github.com/boutproject/BOUT-dev/pull/972) ([bendudson](https://github.com/bendudson))
- Fix test-dataiterator [\#971](https://github.com/boutproject/BOUT-dev/pull/971) ([dschwoerer](https://github.com/dschwoerer))
- Prevent issues with parallel clean builds [\#970](https://github.com/boutproject/BOUT-dev/pull/970) ([dschwoerer](https://github.com/dschwoerer))
- OpenMP cyclic-reduce solver; add ensureUnique to Matrix,Tensor [\#969](https://github.com/boutproject/BOUT-dev/pull/969) ([bendudson](https://github.com/bendudson))
- Add DataFile shiftInput option [\#968](https://github.com/boutproject/BOUT-dev/pull/968) ([bendudson](https://github.com/bendudson))
- Documentation - local build [\#967](https://github.com/boutproject/BOUT-dev/pull/967) ([dschwoerer](https://github.com/dschwoerer))
- Backtrace fixes [\#966](https://github.com/boutproject/BOUT-dev/pull/966) ([dschwoerer](https://github.com/dschwoerer))
- Correcting documentation [\#965](https://github.com/boutproject/BOUT-dev/pull/965) ([dschwoerer](https://github.com/dschwoerer))
- Fix assignment in assert [\#964](https://github.com/boutproject/BOUT-dev/pull/964) ([ZedThree](https://github.com/ZedThree))
- Exception by ref test [\#963](https://github.com/boutproject/BOUT-dev/pull/963) ([dschwoerer](https://github.com/dschwoerer))
- Fix order of HDF5 flags [\#962](https://github.com/boutproject/BOUT-dev/pull/962) ([ZedThree](https://github.com/ZedThree))
- Ensure nullptr checks come before dereferences [\#960](https://github.com/boutproject/BOUT-dev/pull/960) ([ZedThree](https://github.com/ZedThree))
- Fix reorder warning in DataIterator ctor [\#959](https://github.com/boutproject/BOUT-dev/pull/959) ([ZedThree](https://github.com/ZedThree))
- Catch all exceptions by reference [\#958](https://github.com/boutproject/BOUT-dev/pull/958) ([ZedThree](https://github.com/ZedThree))
- Cleanup makefiles [\#955](https://github.com/boutproject/BOUT-dev/pull/955) ([dschwoerer](https://github.com/dschwoerer))
- Configure faster [\#954](https://github.com/boutproject/BOUT-dev/pull/954) ([dschwoerer](https://github.com/dschwoerer))
- Track Headerfile changes for rebuild [\#953](https://github.com/boutproject/BOUT-dev/pull/953) ([dschwoerer](https://github.com/dschwoerer))
- Extend differencing type checking slightly to be more rigorous in checking [\#948](https://github.com/boutproject/BOUT-dev/pull/948) ([d7919](https://github.com/d7919))
- Various configure fixes and improvements [\#944](https://github.com/boutproject/BOUT-dev/pull/944) ([ZedThree](https://github.com/ZedThree))
- Don't ignore CELL\_LOC [\#942](https://github.com/boutproject/BOUT-dev/pull/942) ([dschwoerer](https://github.com/dschwoerer))
- Interp to fixes [\#940](https://github.com/boutproject/BOUT-dev/pull/940) ([dschwoerer](https://github.com/dschwoerer))
- Add override to `region` in Fields [\#939](https://github.com/boutproject/BOUT-dev/pull/939) ([d7919](https://github.com/d7919))
- Tweak travis script [\#938](https://github.com/boutproject/BOUT-dev/pull/938) ([dschwoerer](https://github.com/dschwoerer))
- Speed up Travis and refactor config [\#936](https://github.com/boutproject/BOUT-dev/pull/936) ([d7919](https://github.com/d7919))
- Remove copy on write from matrix/tensor [\#935](https://github.com/boutproject/BOUT-dev/pull/935) ([d7919](https://github.com/d7919))
- Fieldops region 2d-3d special treatment [\#934](https://github.com/boutproject/BOUT-dev/pull/934) ([d7919](https://github.com/d7919))
- Update field2d.cxx [\#929](https://github.com/boutproject/BOUT-dev/pull/929) ([d7919](https://github.com/d7919))
- Allow runtime control of maximum size of contiguous block to use in Region [\#927](https://github.com/boutproject/BOUT-dev/pull/927) ([d7919](https://github.com/d7919))
- Add performance/arithmetic\_3d2d case [\#926](https://github.com/boutproject/BOUT-dev/pull/926) ([d7919](https://github.com/d7919))
- More region arguments [\#920](https://github.com/boutproject/BOUT-dev/pull/920) ([johnomotani](https://github.com/johnomotani))
- More unit tests [\#918](https://github.com/boutproject/BOUT-dev/pull/918) ([d7919](https://github.com/d7919))
- Remove deprecated code [\#917](https://github.com/boutproject/BOUT-dev/pull/917) ([d7919](https://github.com/d7919))
- Extend field perp [\#916](https://github.com/boutproject/BOUT-dev/pull/916) ([d7919](https://github.com/d7919))
- Use web service for tracking unit test coverage [\#915](https://github.com/boutproject/BOUT-dev/pull/915) ([ZedThree](https://github.com/ZedThree))
- Fix use of old `restarting` in slepc solver [\#911](https://github.com/boutproject/BOUT-dev/pull/911) ([ZedThree](https://github.com/ZedThree))
- Update region.hxx [\#910](https://github.com/boutproject/BOUT-dev/pull/910) ([d7919](https://github.com/d7919))
- Block region iterator field ops [\#908](https://github.com/boutproject/BOUT-dev/pull/908) ([d7919](https://github.com/d7919))
- Build API documentation on Readthedocs [\#907](https://github.com/boutproject/BOUT-dev/pull/907) ([ZedThree](https://github.com/ZedThree))
- Clean comments on removed files [\#906](https://github.com/boutproject/BOUT-dev/pull/906) ([dschwoerer](https://github.com/dschwoerer))
- Multigrid bugfixes and test [\#903](https://github.com/boutproject/BOUT-dev/pull/903) ([johnomotani](https://github.com/johnomotani))
- Replace new with array [\#902](https://github.com/boutproject/BOUT-dev/pull/902) ([d7919](https://github.com/d7919))
- Remove matrix remainder [\#901](https://github.com/boutproject/BOUT-dev/pull/901) ([d7919](https://github.com/d7919))
- Replace matrix with Matrix in various cyclic inversions [\#900](https://github.com/boutproject/BOUT-dev/pull/900) ([d7919](https://github.com/d7919))
- Fixes issue in cyclic and adds comments [\#899](https://github.com/boutproject/BOUT-dev/pull/899) ([bendudson](https://github.com/bendudson))
- Add ASSERT3 checks to Array indexing to check bounds [\#896](https://github.com/boutproject/BOUT-dev/pull/896) ([d7919](https://github.com/d7919))
- Ensure Matrix/Tensor data block unique before modification [\#894](https://github.com/boutproject/BOUT-dev/pull/894) ([d7919](https://github.com/d7919))
- Replace matrix with Matrix in serial\_tri [\#891](https://github.com/boutproject/BOUT-dev/pull/891) ([d7919](https://github.com/d7919))
- Manual build [\#890](https://github.com/boutproject/BOUT-dev/pull/890) ([dschwoerer](https://github.com/dschwoerer))
- Avoid potentially slow locate [\#889](https://github.com/boutproject/BOUT-dev/pull/889) ([dschwoerer](https://github.com/dschwoerer))
- Fix some minor warnings [\#887](https://github.com/boutproject/BOUT-dev/pull/887) ([ZedThree](https://github.com/ZedThree))
- Add OpenMP dataiterator test to unit tests [\#886](https://github.com/boutproject/BOUT-dev/pull/886) ([dschwoerer](https://github.com/dschwoerer))
- More region arguments [\#885](https://github.com/boutproject/BOUT-dev/pull/885) ([johnomotani](https://github.com/johnomotani))
- Remove lapack replacement code [\#884](https://github.com/boutproject/BOUT-dev/pull/884) ([bendudson](https://github.com/bendudson))
- Replace gaussj with direct invert 3x3 [\#883](https://github.com/boutproject/BOUT-dev/pull/883) ([d7919](https://github.com/d7919))
- Download googletest on `make build-check` [\#882](https://github.com/boutproject/BOUT-dev/pull/882) ([dschwoerer](https://github.com/dschwoerer))
- Exclude guard cells when checking finite values in field functions [\#881](https://github.com/boutproject/BOUT-dev/pull/881) ([johnomotani](https://github.com/johnomotani))
- Report if Lapack is available in this build [\#880](https://github.com/boutproject/BOUT-dev/pull/880) ([d7919](https://github.com/d7919))
- Finish Fieldgroup tests [\#879](https://github.com/boutproject/BOUT-dev/pull/879) ([ZedThree](https://github.com/ZedThree))
- Better matrices/tensors [\#878](https://github.com/boutproject/BOUT-dev/pull/878) ([d7919](https://github.com/d7919))
- Has openmp [\#877](https://github.com/boutproject/BOUT-dev/pull/877) ([dschwoerer](https://github.com/dschwoerer))
- Extend Region class [\#875](https://github.com/boutproject/BOUT-dev/pull/875) ([d7919](https://github.com/d7919))
- Fix two potential bugs: out-of-bounds access and use-after-scope [\#872](https://github.com/boutproject/BOUT-dev/pull/872) ([ZedThree](https://github.com/ZedThree))
- Invalidate guards [\#871](https://github.com/boutproject/BOUT-dev/pull/871) ([d7919](https://github.com/d7919))
- Change LaplaceXZ-PETSc to Dirichlet boundary conditions by default. [\#868](https://github.com/boutproject/BOUT-dev/pull/868) ([bshanahan](https://github.com/bshanahan))
- Bug fix for build without checks [\#867](https://github.com/boutproject/BOUT-dev/pull/867) ([d7919](https://github.com/d7919))
- Fixes for 2D interpolation \(for FCI\) [\#866](https://github.com/boutproject/BOUT-dev/pull/866) ([ZedThree](https://github.com/ZedThree))
- Allow checkData to take a region [\#863](https://github.com/boutproject/BOUT-dev/pull/863) ([d7919](https://github.com/d7919))
- Create decent stacktrace with PIE code [\#862](https://github.com/boutproject/BOUT-dev/pull/862) ([dschwoerer](https://github.com/dschwoerer))
- Pylib dimensions [\#861](https://github.com/boutproject/BOUT-dev/pull/861) ([dschwoerer](https://github.com/dschwoerer))
- Improve subdir target [\#860](https://github.com/boutproject/BOUT-dev/pull/860) ([dschwoerer](https://github.com/dschwoerer))
- Configure options should be preferred in manual [\#859](https://github.com/boutproject/BOUT-dev/pull/859) ([dschwoerer](https://github.com/dschwoerer))
- Replace one more mesh with localmesh [\#858](https://github.com/boutproject/BOUT-dev/pull/858) ([dschwoerer](https://github.com/dschwoerer))
- Remove unused variables/lambda from FCI [\#856](https://github.com/boutproject/BOUT-dev/pull/856) ([ZedThree](https://github.com/ZedThree))
- Remove PETSc type string comparisons [\#855](https://github.com/boutproject/BOUT-dev/pull/855) ([bendudson](https://github.com/bendudson))
- Fix local build of manual PDF [\#854](https://github.com/boutproject/BOUT-dev/pull/854) ([ZedThree](https://github.com/ZedThree))
- Make function match signature in ncxx4 [\#853](https://github.com/boutproject/BOUT-dev/pull/853) ([dschwoerer](https://github.com/dschwoerer))
- Localmesh fixes [\#851](https://github.com/boutproject/BOUT-dev/pull/851) ([dschwoerer](https://github.com/dschwoerer))
- Improve build of autogenerated text files [\#848](https://github.com/boutproject/BOUT-dev/pull/848) ([dschwoerer](https://github.com/dschwoerer))
- Fix missing overrides [\#847](https://github.com/boutproject/BOUT-dev/pull/847) ([d7919](https://github.com/d7919))
- Fix prefix operator in RangeIterator header [\#845](https://github.com/boutproject/BOUT-dev/pull/845) ([d7919](https://github.com/d7919))
- small cleanup [\#843](https://github.com/boutproject/BOUT-dev/pull/843) ([dschwoerer](https://github.com/dschwoerer))
- make performance/arithmetic more reliable [\#842](https://github.com/boutproject/BOUT-dev/pull/842) ([dschwoerer](https://github.com/dschwoerer))
- Block region iterating [\#841](https://github.com/boutproject/BOUT-dev/pull/841) ([d7919](https://github.com/d7919))
- More region [\#839](https://github.com/boutproject/BOUT-dev/pull/839) ([dschwoerer](https://github.com/dschwoerer))
- increase constants accuracy [\#838](https://github.com/boutproject/BOUT-dev/pull/838) ([dschwoerer](https://github.com/dschwoerer))
- Update constants.hxx [\#836](https://github.com/boutproject/BOUT-dev/pull/836) ([d7919](https://github.com/d7919))
- Performance iterator update [\#835](https://github.com/boutproject/BOUT-dev/pull/835) ([d7919](https://github.com/d7919))
- Update array.hxx [\#832](https://github.com/boutproject/BOUT-dev/pull/832) ([d7919](https://github.com/d7919))
- Avoid macro name clash in bout++.cxx [\#831](https://github.com/boutproject/BOUT-dev/pull/831) ([d7919](https://github.com/d7919))
- Allow specification of number of OMP threads in job launcher [\#830](https://github.com/boutproject/BOUT-dev/pull/830) ([d7919](https://github.com/d7919))
- Petsc3.7 compatibility [\#828](https://github.com/boutproject/BOUT-dev/pull/828) ([johnomotani](https://github.com/johnomotani))
- fix sign error in FDDX\_U1 [\#827](https://github.com/boutproject/BOUT-dev/pull/827) ([dschwoerer](https://github.com/dschwoerer))
- ignore vectorization reports and temporary files [\#826](https://github.com/boutproject/BOUT-dev/pull/826) ([dschwoerer](https://github.com/dschwoerer))
- prevent some issues with -Ofast [\#825](https://github.com/boutproject/BOUT-dev/pull/825) ([dschwoerer](https://github.com/dschwoerer))
- Dataiterator improvements [\#824](https://github.com/boutproject/BOUT-dev/pull/824) ([dschwoerer](https://github.com/dschwoerer))
- Python tools minor upgrades [\#822](https://github.com/boutproject/BOUT-dev/pull/822) ([johnomotani](https://github.com/johnomotani))
- Change default for include\_yguards in Laplace inversion to false [\#821](https://github.com/boutproject/BOUT-dev/pull/821) ([johnomotani](https://github.com/johnomotani))
- Remove shifted grids from test-interchange-instability [\#819](https://github.com/boutproject/BOUT-dev/pull/819) ([ZedThree](https://github.com/ZedThree))
- Use Jinja2 to generate code for Field\* arithmetic operators [\#818](https://github.com/boutproject/BOUT-dev/pull/818) ([ZedThree](https://github.com/ZedThree))
- Update Travis miniconda setup for speed. [\#817](https://github.com/boutproject/BOUT-dev/pull/817) ([d7919](https://github.com/d7919))
- Allow no openmp for pvode [\#816](https://github.com/boutproject/BOUT-dev/pull/816) ([d7919](https://github.com/d7919))
- Unify derivative function signatures [\#815](https://github.com/boutproject/BOUT-dev/pull/815) ([dschwoerer](https://github.com/dschwoerer))
- remove exit calls [\#813](https://github.com/boutproject/BOUT-dev/pull/813) ([dschwoerer](https://github.com/dschwoerer))
- Improve makefile: [\#812](https://github.com/boutproject/BOUT-dev/pull/812) ([dschwoerer](https://github.com/dschwoerer))
- Add overload for checkData\(BoutReal\) [\#809](https://github.com/boutproject/BOUT-dev/pull/809) ([ZedThree](https://github.com/ZedThree))
- Consistently return fields from index derivs functions [\#808](https://github.com/boutproject/BOUT-dev/pull/808) ([ZedThree](https://github.com/ZedThree))
- Set location of fields only if StaggerGrids is enabled [\#807](https://github.com/boutproject/BOUT-dev/pull/807) ([ZedThree](https://github.com/ZedThree))
- make sure units test link against lib pthread [\#806](https://github.com/boutproject/BOUT-dev/pull/806) ([dschwoerer](https://github.com/dschwoerer))
- Next remove bindex [\#804](https://github.com/boutproject/BOUT-dev/pull/804) ([JosephThomasParker](https://github.com/JosephThomasParker))
- Fix BoundaryRegion link [\#803](https://github.com/boutproject/BOUT-dev/pull/803) ([d7919](https://github.com/d7919))
- Remove old configuration files for specific machines [\#802](https://github.com/boutproject/BOUT-dev/pull/802) ([d7919](https://github.com/d7919))
- Minor documentation fixes [\#800](https://github.com/boutproject/BOUT-dev/pull/800) ([d7919](https://github.com/d7919))
- Travis update gcc6 to gcc7 [\#797](https://github.com/boutproject/BOUT-dev/pull/797) ([d7919](https://github.com/d7919))
- Update makefile to put back removed @ [\#796](https://github.com/boutproject/BOUT-dev/pull/796) ([d7919](https://github.com/d7919))
- Bug Fix : Add one level of indirection to stringify [\#795](https://github.com/boutproject/BOUT-dev/pull/795) ([d7919](https://github.com/d7919))
- NPES bugfix [\#794](https://github.com/boutproject/BOUT-dev/pull/794) ([loeiten](https://github.com/loeiten))
- Lots of documentation fixes [\#793](https://github.com/boutproject/BOUT-dev/pull/793) ([ZedThree](https://github.com/ZedThree))
- Next remove bindex [\#792](https://github.com/boutproject/BOUT-dev/pull/792) ([johnomotani](https://github.com/johnomotani))
- Use specialised output object for warnings/errors/info [\#791](https://github.com/boutproject/BOUT-dev/pull/791) ([ZedThree](https://github.com/ZedThree))
- use python3 rather then default python [\#790](https://github.com/boutproject/BOUT-dev/pull/790) ([dschwoerer](https://github.com/dschwoerer))
- assert lhs and rhs are on the same location in pow [\#788](https://github.com/boutproject/BOUT-dev/pull/788) ([dschwoerer](https://github.com/dschwoerer))
- set and check location in CtoL and LtoC routines [\#787](https://github.com/boutproject/BOUT-dev/pull/787) ([dschwoerer](https://github.com/dschwoerer))
- merge ./test\_suite and be more verbose to prevent timeouts [\#786](https://github.com/boutproject/BOUT-dev/pull/786) ([dschwoerer](https://github.com/dschwoerer))
- Tests verbose on fail [\#785](https://github.com/boutproject/BOUT-dev/pull/785) ([dschwoerer](https://github.com/dschwoerer))
- Zoidberg generates grids for tokamaks [\#782](https://github.com/boutproject/BOUT-dev/pull/782) ([bendudson](https://github.com/bendudson))
- Lazy backtrace [\#781](https://github.com/boutproject/BOUT-dev/pull/781) ([dschwoerer](https://github.com/dschwoerer))
- allow to build tests with make build-check [\#780](https://github.com/boutproject/BOUT-dev/pull/780) ([dschwoerer](https://github.com/dschwoerer))
- add interface to mesh to ask whether it is possible to transform. [\#779](https://github.com/boutproject/BOUT-dev/pull/779) ([dschwoerer](https://github.com/dschwoerer))
- .so support [\#778](https://github.com/boutproject/BOUT-dev/pull/778) ([dschwoerer](https://github.com/dschwoerer))
- Default to not building with scorep [\#777](https://github.com/boutproject/BOUT-dev/pull/777) ([ZedThree](https://github.com/ZedThree))
- Some small tests for Field2D/3D [\#776](https://github.com/boutproject/BOUT-dev/pull/776) ([ZedThree](https://github.com/ZedThree))
- Report the value of BOUT\_FLAGS used to compile. [\#774](https://github.com/boutproject/BOUT-dev/pull/774) ([d7919](https://github.com/d7919))
- Array with shared ptrs [\#773](https://github.com/boutproject/BOUT-dev/pull/773) ([d7919](https://github.com/d7919))
- Remove unused mesh routines [\#772](https://github.com/boutproject/BOUT-dev/pull/772) ([d7919](https://github.com/d7919))
- Adding support for attributes \(NetCDF only\) [\#770](https://github.com/boutproject/BOUT-dev/pull/770) ([bendudson](https://github.com/bendudson))
- Fix off by one error in FFT based DDZ loop [\#769](https://github.com/boutproject/BOUT-dev/pull/769) ([d7919](https://github.com/d7919))
- Optimise omp fftw  [\#767](https://github.com/boutproject/BOUT-dev/pull/767) ([d7919](https://github.com/d7919))
- make sure time derivative are at proper location [\#766](https://github.com/boutproject/BOUT-dev/pull/766) ([dschwoerer](https://github.com/dschwoerer))
- Finite volume methods [\#760](https://github.com/boutproject/BOUT-dev/pull/760) ([bendudson](https://github.com/bendudson))
- Make Field2/3D arthimetic operators return non-const value [\#756](https://github.com/boutproject/BOUT-dev/pull/756) ([ZedThree](https://github.com/ZedThree))
- Fix bug in infinite recursion in configure when netcdf not found [\#754](https://github.com/boutproject/BOUT-dev/pull/754) ([ZedThree](https://github.com/ZedThree))
- disable plotting in test-fci-slab [\#753](https://github.com/boutproject/BOUT-dev/pull/753) ([dschwoerer](https://github.com/dschwoerer))
- Global mesh [\#752](https://github.com/boutproject/BOUT-dev/pull/752) ([dschwoerer](https://github.com/dschwoerer))
- Adding -l,--log command-line argument [\#751](https://github.com/boutproject/BOUT-dev/pull/751) ([bendudson](https://github.com/bendudson))
- Adding restart.addvar routine for Python [\#750](https://github.com/boutproject/BOUT-dev/pull/750) ([bendudson](https://github.com/bendudson))
- Nonuniform single option [\#740](https://github.com/boutproject/BOUT-dev/pull/740) ([bendudson](https://github.com/bendudson))
- Delete boundary regions in test\_vector?d when tearing down test [\#738](https://github.com/boutproject/BOUT-dev/pull/738) ([ZedThree](https://github.com/ZedThree))
- Removing genZMode from initial\_profiles.cxx [\#735](https://github.com/boutproject/BOUT-dev/pull/735) ([bendudson](https://github.com/bendudson))
- allow collect to suceed if not all writes to the files have finished [\#732](https://github.com/boutproject/BOUT-dev/pull/732) ([dschwoerer](https://github.com/dschwoerer))
- Avoid unknown omp pragma warnings [\#726](https://github.com/boutproject/BOUT-dev/pull/726) ([d7919](https://github.com/d7919))
- Update showdata [\#725](https://github.com/boutproject/BOUT-dev/pull/725) ([AdamD94](https://github.com/AdamD94))
- FFT derivs for staggered meshes seem to be broken for Z [\#723](https://github.com/boutproject/BOUT-dev/pull/723) ([dschwoerer](https://github.com/dschwoerer))
- Adding Vector applyboundary\(string\) [\#716](https://github.com/boutproject/BOUT-dev/pull/716) ([bendudson](https://github.com/bendudson))
- Cython [\#641](https://github.com/boutproject/BOUT-dev/pull/641) ([dschwoerer](https://github.com/dschwoerer))

## [v4.1.2](https://github.com/boutproject/BOUT-dev/tree/v4.1.2) (2017-12-01)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.1.1...v4.1.2)

**Fixed bugs:**

- ./configure deadlock [\#744](https://github.com/boutproject/BOUT-dev/issues/744)
- Typo in unit test makefile? [\#730](https://github.com/boutproject/BOUT-dev/issues/730)
- Laplacian Serial\_tri incorrect operation [\#727](https://github.com/boutproject/BOUT-dev/issues/727)
- memory leak in pylib/boututils/showdata [\#231](https://github.com/boutproject/BOUT-dev/issues/231)
- Fix minor typo in unit test makefile [\#731](https://github.com/boutproject/BOUT-dev/pull/731) ([d7919](https://github.com/d7919))

**Closed issues:**

- Test fci-slab [\#748](https://github.com/boutproject/BOUT-dev/issues/748)
- BOUT.log is hardcoded [\#745](https://github.com/boutproject/BOUT-dev/issues/745)
- FFT for DDZ hard coded parameters [\#647](https://github.com/boutproject/BOUT-dev/issues/647)
- genZMode no longer used? [\#645](https://github.com/boutproject/BOUT-dev/issues/645)
- Vector applyBoundary [\#584](https://github.com/boutproject/BOUT-dev/issues/584)

**Merged pull requests:**

- Bug fix bout runners [\#758](https://github.com/boutproject/BOUT-dev/pull/758) ([loeiten](https://github.com/loeiten))
- Fix bug in infinite recursion in configure when netcdf not found [\#754](https://github.com/boutproject/BOUT-dev/pull/754) ([ZedThree](https://github.com/ZedThree))
- disable plotting in test-fci-slab [\#753](https://github.com/boutproject/BOUT-dev/pull/753) ([dschwoerer](https://github.com/dschwoerer))
- Fixing bug in calculation of non-uniform correction [\#739](https://github.com/boutproject/BOUT-dev/pull/739) ([bendudson](https://github.com/bendudson))
- Laplacexy examples fix [\#733](https://github.com/boutproject/BOUT-dev/pull/733) ([bendudson](https://github.com/bendudson))
- Small fixes for serial\_tri Laplace solver [\#729](https://github.com/boutproject/BOUT-dev/pull/729) ([bendudson](https://github.com/bendudson))
- Adding missing \_\_setitem\_\_ and keys\(\) functions [\#728](https://github.com/boutproject/BOUT-dev/pull/728) ([bendudson](https://github.com/bendudson))
- Manual fix [\#721](https://github.com/boutproject/BOUT-dev/pull/721) ([dschwoerer](https://github.com/dschwoerer))

## [v4.1.1](https://github.com/boutproject/BOUT-dev/tree/v4.1.1) (2017-10-18)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.1.0...v4.1.1)

**Fixed bugs:**

- Generalise the "boundaries" section of Delp2 for Field3D [\#708](https://github.com/boutproject/BOUT-dev/pull/708) ([d7919](https://github.com/d7919))
- Cleanup array :: cleanup all at end of sim [\#706](https://github.com/boutproject/BOUT-dev/pull/706) ([d7919](https://github.com/d7919))
- Ensure VarStr entries are initialised in all cases [\#705](https://github.com/boutproject/BOUT-dev/pull/705) ([d7919](https://github.com/d7919))
- Initialise `covar` for all `VarStr` instances [\#704](https://github.com/boutproject/BOUT-dev/pull/704) ([d7919](https://github.com/d7919))
- Removing Field3D move constructor [\#699](https://github.com/boutproject/BOUT-dev/pull/699) ([bendudson](https://github.com/bendudson))
- Field3D default move constructor leading to segfaults [\#698](https://github.com/boutproject/BOUT-dev/issues/698)
- Unit test seg fault \(`Output::cleanup`\) -- order dependent [\#693](https://github.com/boutproject/BOUT-dev/issues/693)
- test-fci-slab fix: Don't show plot by default [\#692](https://github.com/boutproject/BOUT-dev/pull/692) ([d7919](https://github.com/d7919))

**Closed issues:**

- Integrated tests don't all compile and not all used [\#701](https://github.com/boutproject/BOUT-dev/issues/701)
- PYTHONPATH in tests [\#695](https://github.com/boutproject/BOUT-dev/issues/695)
- Dynamic casts in `ConditionalOutput` [\#691](https://github.com/boutproject/BOUT-dev/issues/691)
- Segfault when increasing verbosity  [\#690](https://github.com/boutproject/BOUT-dev/issues/690)
- v4.1 release candidate [\#640](https://github.com/boutproject/BOUT-dev/issues/640)
- -DCHECK changes memory layout [\#594](https://github.com/boutproject/BOUT-dev/issues/594)
- nx and ny constant for different processors [\#560](https://github.com/boutproject/BOUT-dev/issues/560)
- release notes [\#504](https://github.com/boutproject/BOUT-dev/issues/504)
- y initial conditions always at CELL\_YLOW [\#484](https://github.com/boutproject/BOUT-dev/issues/484)
- Free boundaries [\#429](https://github.com/boutproject/BOUT-dev/issues/429)
- Adding TRACE and BoutException to monitors [\#355](https://github.com/boutproject/BOUT-dev/issues/355)
- indexDDZ \(staggered\) [\#335](https://github.com/boutproject/BOUT-dev/issues/335)
- Reducing compiler warnings [\#322](https://github.com/boutproject/BOUT-dev/issues/322)
- Derivatives: free boundary - Issues if MXG not 2 [\#250](https://github.com/boutproject/BOUT-dev/issues/250)

**Merged pull requests:**

- Fix broken links, code blocks and tables in documentation [\#722](https://github.com/boutproject/BOUT-dev/pull/722) ([ZedThree](https://github.com/ZedThree))
- Small bug fixes for Options/OptionsReader and their tests [\#718](https://github.com/boutproject/BOUT-dev/pull/718) ([ZedThree](https://github.com/ZedThree))
- Update user manual: --enable-checks is the configure option for checking [\#717](https://github.com/boutproject/BOUT-dev/pull/717) ([JosephThomasParker](https://github.com/JosephThomasParker))
- Make sure link flags apply correctly to unit tests [\#715](https://github.com/boutproject/BOUT-dev/pull/715) ([ZedThree](https://github.com/ZedThree))
- throw exception if staggererd deriv in z direction [\#714](https://github.com/boutproject/BOUT-dev/pull/714) ([dschwoerer](https://github.com/dschwoerer))
- Set PYTHONPATH for tests [\#713](https://github.com/boutproject/BOUT-dev/pull/713) ([ZedThree](https://github.com/ZedThree))
- A few small fixes and tests for Output/ConditionalOutput [\#712](https://github.com/boutproject/BOUT-dev/pull/712) ([ZedThree](https://github.com/ZedThree))
- Output message if NetCDF4 support is enabled [\#711](https://github.com/boutproject/BOUT-dev/pull/711) ([ZedThree](https://github.com/ZedThree))
- Make bout\_test\_main.o depend on source file [\#710](https://github.com/boutproject/BOUT-dev/pull/710) ([ZedThree](https://github.com/ZedThree))
- Make shiftedmetric use const refs when possible [\#703](https://github.com/boutproject/BOUT-dev/pull/703) ([d7919](https://github.com/d7919))
- Some fixes to the integrated tests [\#702](https://github.com/boutproject/BOUT-dev/pull/702) ([bendudson](https://github.com/bendudson))
- Add an option "ddz:fft\_filter" to control filtering in DDZ [\#700](https://github.com/boutproject/BOUT-dev/pull/700) ([bendudson](https://github.com/bendudson))
- Multigrid solver memory leak bugfix [\#696](https://github.com/boutproject/BOUT-dev/pull/696) ([johnomotani](https://github.com/johnomotani))
- Bugfix: Checkout googletest if not available [\#694](https://github.com/boutproject/BOUT-dev/pull/694) ([bendudson](https://github.com/bendudson))

## [v4.1.0](https://github.com/boutproject/BOUT-dev/tree/v4.1.0) (2017-09-20)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.0.1...v4.1.0)

**Fixed bugs:**

- Boundary non-staggered dirichlet with Field3D [\#651](https://github.com/boutproject/BOUT-dev/issues/651)
- Ensure `doneComms` always defined in `field\_data` [\#618](https://github.com/boutproject/BOUT-dev/pull/618) ([d7919](https://github.com/d7919))
- Consistency of CHECK usage [\#569](https://github.com/boutproject/BOUT-dev/issues/569)
- Making PhysicsModel's destructor virtual [\#552](https://github.com/boutproject/BOUT-dev/pull/552) ([bendudson](https://github.com/bendudson))
- Various test fails [\#551](https://github.com/boutproject/BOUT-dev/issues/551)
- Error message is not informative when specifying a non existing directory on command line -d  [\#526](https://github.com/boutproject/BOUT-dev/issues/526)
- Communication of vectors gives segfault in BOUT++ 4 [\#522](https://github.com/boutproject/BOUT-dev/issues/522)
- Getters for BoutMesh nx and ny now return ints [\#497](https://github.com/boutproject/BOUT-dev/pull/497) ([JensMadsen](https://github.com/JensMadsen))
- Rebuild incomplete [\#453](https://github.com/boutproject/BOUT-dev/issues/453)
- BoutMesh ignores non-available differentiation-options [\#419](https://github.com/boutproject/BOUT-dev/issues/419)
- Calculating Christoffel symbols crashes if MYG=0 [\#376](https://github.com/boutproject/BOUT-dev/issues/376)
- D2DX2\_C4\_stag is only 2nd order [\#352](https://github.com/boutproject/BOUT-dev/issues/352)
- DataIterator::offset\(\) [\#278](https://github.com/boutproject/BOUT-dev/issues/278)
- No dmp files when appending [\#199](https://github.com/boutproject/BOUT-dev/issues/199)

**Closed issues:**

- v4.0.1 [\#676](https://github.com/boutproject/BOUT-dev/issues/676)
- Bugfixes available - but not in 4.1.0 [\#675](https://github.com/boutproject/BOUT-dev/issues/675)
- LaplaceXZcyclic::setCoefs is ambiguous [\#663](https://github.com/boutproject/BOUT-dev/issues/663)
- Use of floats in Coordinates::gaussj [\#656](https://github.com/boutproject/BOUT-dev/issues/656)
- Unused source files [\#653](https://github.com/boutproject/BOUT-dev/issues/653)
- Extra boundary files [\#646](https://github.com/boutproject/BOUT-dev/issues/646)
- Building Manual [\#639](https://github.com/boutproject/BOUT-dev/issues/639)
- Options:set\(\) [\#620](https://github.com/boutproject/BOUT-dev/issues/620)
- get/set?array in Field/Field2D [\#610](https://github.com/boutproject/BOUT-dev/issues/610)
- BOUT.log files too noisy [\#608](https://github.com/boutproject/BOUT-dev/issues/608)
- Derivatives - why global mesh? [\#596](https://github.com/boutproject/BOUT-dev/issues/596)
- Laplacian maxmode limits [\#589](https://github.com/boutproject/BOUT-dev/issues/589)
- Separating examples and tests [\#588](https://github.com/boutproject/BOUT-dev/issues/588)
- Trying to avoiding branch misprediction [\#583](https://github.com/boutproject/BOUT-dev/issues/583)
- ASSERT0 in "per element" functions [\#580](https://github.com/boutproject/BOUT-dev/issues/580)
- Collect on Marconi-Fusion [\#579](https://github.com/boutproject/BOUT-dev/issues/579)
- Expanding the capability of `TRACE` [\#573](https://github.com/boutproject/BOUT-dev/issues/573)
- python2 compatible? [\#547](https://github.com/boutproject/BOUT-dev/issues/547)
- FieldGroup adding const fields [\#540](https://github.com/boutproject/BOUT-dev/issues/540)
- nype is not written to log [\#539](https://github.com/boutproject/BOUT-dev/issues/539)
- Parallel transforms are not documented [\#503](https://github.com/boutproject/BOUT-dev/issues/503)
- getters for nx, ny and nz [\#498](https://github.com/boutproject/BOUT-dev/issues/498)
- MYG and MXG not read from gridfile [\#493](https://github.com/boutproject/BOUT-dev/issues/493)
- Restart files should include MXSUB such that boutdata.collect can read them [\#483](https://github.com/boutproject/BOUT-dev/issues/483)
- Should mergeYupYdown check for ydown\_field too? [\#474](https://github.com/boutproject/BOUT-dev/issues/474)
- Increase verbosity of option reader [\#451](https://github.com/boutproject/BOUT-dev/issues/451)
- User defined flush frequency [\#449](https://github.com/boutproject/BOUT-dev/issues/449)
- Restart should be moved from the solvers [\#439](https://github.com/boutproject/BOUT-dev/issues/439)
- RangeIterator created by mesh-\>iterateBndryLowerY\(\) return wrong indices when nxpe!=0 [\#435](https://github.com/boutproject/BOUT-dev/issues/435)
- laplacexz should exit when g13 \neq 0 [\#425](https://github.com/boutproject/BOUT-dev/issues/425)
- Mesh::getXcomm\(\) [\#416](https://github.com/boutproject/BOUT-dev/issues/416)
- Deprecate functions [\#405](https://github.com/boutproject/BOUT-dev/issues/405)
- v4.0.0-RC branch takes forever to compile [\#382](https://github.com/boutproject/BOUT-dev/issues/382)
- Datafile copy constructor [\#367](https://github.com/boutproject/BOUT-dev/issues/367)
- getName/setName only available for -DTRACK [\#362](https://github.com/boutproject/BOUT-dev/issues/362)
- Monitors rewrite [\#346](https://github.com/boutproject/BOUT-dev/issues/346)
- Compilation of BOUT++ on ARCHER and batch jobs [\#282](https://github.com/boutproject/BOUT-dev/issues/282)
- ShiftInitial compatibility in next [\#266](https://github.com/boutproject/BOUT-dev/issues/266)
- MXG and MYG saved to the restart files [\#212](https://github.com/boutproject/BOUT-dev/issues/212)
- Check that the manuals are building [\#159](https://github.com/boutproject/BOUT-dev/issues/159)
- Testcases [\#152](https://github.com/boutproject/BOUT-dev/issues/152)

**Merged pull requests:**

- Release 4.1 [\#688](https://github.com/boutproject/BOUT-dev/pull/688) ([ZedThree](https://github.com/ZedThree))
- Update version to 4.0.1 [\#687](https://github.com/boutproject/BOUT-dev/pull/687) ([dschwoerer](https://github.com/dschwoerer))
- showdata call cla\(\) for contour plots [\#686](https://github.com/boutproject/BOUT-dev/pull/686) ([bendudson](https://github.com/bendudson))
- rename runtest that are not tests [\#685](https://github.com/boutproject/BOUT-dev/pull/685) ([dschwoerer](https://github.com/dschwoerer))
- Fix for BOUT\_ADDPATH\_CHECK\_LIB and BOUT\_ADDPATH\_CHECK\_HEADER [\#682](https://github.com/boutproject/BOUT-dev/pull/682) ([bendudson](https://github.com/bendudson))
- Fci slab poloidal grids [\#681](https://github.com/boutproject/BOUT-dev/pull/681) ([bshanahan](https://github.com/bshanahan))
- Quick patch to try to ensure only one processor [\#680](https://github.com/boutproject/BOUT-dev/pull/680) ([d7919](https://github.com/d7919))
- Removing files associated with old style unit tests [\#679](https://github.com/boutproject/BOUT-dev/pull/679) ([d7919](https://github.com/d7919))
- Remove unused options from configure [\#678](https://github.com/boutproject/BOUT-dev/pull/678) ([d7919](https://github.com/d7919))
- Throw in petsc solver if following invalid path. [\#677](https://github.com/boutproject/BOUT-dev/pull/677) ([d7919](https://github.com/d7919))
- Documentation [\#674](https://github.com/boutproject/BOUT-dev/pull/674) ([bendudson](https://github.com/bendudson))
- Convert old-style casts to static\_cast [\#673](https://github.com/boutproject/BOUT-dev/pull/673) ([ZedThree](https://github.com/ZedThree))
- Remove header files associated with files removed earlier [\#672](https://github.com/boutproject/BOUT-dev/pull/672) ([d7919](https://github.com/d7919))
- Remove lots of commented-out code [\#671](https://github.com/boutproject/BOUT-dev/pull/671) ([ZedThree](https://github.com/ZedThree))
- Remove unused files associated with mesh impls [\#670](https://github.com/boutproject/BOUT-dev/pull/670) ([d7919](https://github.com/d7919))
- Add inline to prototypes where inline on implementation [\#669](https://github.com/boutproject/BOUT-dev/pull/669) ([d7919](https://github.com/d7919))
- Travis include externals [\#667](https://github.com/boutproject/BOUT-dev/pull/667) ([d7919](https://github.com/d7919))
- Travis testing gcc6 [\#666](https://github.com/boutproject/BOUT-dev/pull/666) ([d7919](https://github.com/d7919))
- Update petsc-3.4.cxx [\#665](https://github.com/boutproject/BOUT-dev/pull/665) ([d7919](https://github.com/d7919))
- V4.1 Intel warnings/remarks fixes [\#664](https://github.com/boutproject/BOUT-dev/pull/664) ([ZedThree](https://github.com/ZedThree))
- Travis tweak parallel build [\#659](https://github.com/boutproject/BOUT-dev/pull/659) ([d7919](https://github.com/d7919))
- make install and uninstall targets [\#658](https://github.com/boutproject/BOUT-dev/pull/658) ([bendudson](https://github.com/bendudson))
- Remove unused files [\#654](https://github.com/boutproject/BOUT-dev/pull/654) ([d7919](https://github.com/d7919))
- Remove unused boundary files and small bug fix in Dirichlet non-staggered [\#652](https://github.com/boutproject/BOUT-dev/pull/652) ([d7919](https://github.com/d7919))
- Making integrated test suite quiet by default [\#650](https://github.com/boutproject/BOUT-dev/pull/650) ([bendudson](https://github.com/bendudson))
- Delete free boundary in diffs [\#649](https://github.com/boutproject/BOUT-dev/pull/649) ([d7919](https://github.com/d7919))
- Fix various warnings in v4.1-RC [\#643](https://github.com/boutproject/BOUT-dev/pull/643) ([ZedThree](https://github.com/ZedThree))
- Remove deprecated get/setdata from fields [\#642](https://github.com/boutproject/BOUT-dev/pull/642) ([ZedThree](https://github.com/ZedThree))
- Overhaul testing framework [\#637](https://github.com/boutproject/BOUT-dev/pull/637) ([ZedThree](https://github.com/ZedThree))
- Reinstate newline accidentally removed in \#615 [\#636](https://github.com/boutproject/BOUT-dev/pull/636) ([d7919](https://github.com/d7919))
- SUNDIALS shared libraries [\#635](https://github.com/boutproject/BOUT-dev/pull/635) ([bendudson](https://github.com/bendudson))
- Operators with dataiterator arg [\#634](https://github.com/boutproject/BOUT-dev/pull/634) ([bendudson](https://github.com/bendudson))
- Replacing old stencils with DataIterator loops in index\_derivs [\#633](https://github.com/boutproject/BOUT-dev/pull/633) ([bendudson](https://github.com/bendudson))
- Memory tidy [\#631](https://github.com/boutproject/BOUT-dev/pull/631) ([bendudson](https://github.com/bendudson))
- Add color to output [\#630](https://github.com/boutproject/BOUT-dev/pull/630) ([bendudson](https://github.com/bendudson))
- Dschwoerer verbosity [\#629](https://github.com/boutproject/BOUT-dev/pull/629) ([bendudson](https://github.com/bendudson))
- Lapd drift example [\#628](https://github.com/boutproject/BOUT-dev/pull/628) ([bendudson](https://github.com/bendudson))
- Fixes mapping of profiles in gridgen [\#627](https://github.com/boutproject/BOUT-dev/pull/627) ([bendudson](https://github.com/bendudson))
- Zoidberg poloidal grids [\#626](https://github.com/boutproject/BOUT-dev/pull/626) ([bendudson](https://github.com/bendudson))
- Optimise pack\_data/unpack\_data [\#622](https://github.com/boutproject/BOUT-dev/pull/622) ([d7919](https://github.com/d7919))
- Options::cleanCache\(\) [\#621](https://github.com/boutproject/BOUT-dev/pull/621) ([dschwoerer](https://github.com/dschwoerer))
- Tidying BoutException [\#619](https://github.com/boutproject/BOUT-dev/pull/619) ([bendudson](https://github.com/bendudson))
- Adding symmetric keyword to griddata.gridcontourf [\#617](https://github.com/boutproject/BOUT-dev/pull/617) ([bendudson](https://github.com/bendudson))
- Options logging [\#615](https://github.com/boutproject/BOUT-dev/pull/615) ([bendudson](https://github.com/bendudson))
- Deprecate get set xyz array [\#614](https://github.com/boutproject/BOUT-dev/pull/614) ([d7919](https://github.com/d7919))
- Delete more of the variables allocated with new and related [\#613](https://github.com/boutproject/BOUT-dev/pull/613) ([d7919](https://github.com/d7919))
- Field3d shift fix and const auto loops, Field2D/3D consistency [\#609](https://github.com/boutproject/BOUT-dev/pull/609) ([d7919](https://github.com/d7919))
- Make finite\(Field2D\), finite\(Field3D\) behave identically [\#607](https://github.com/boutproject/BOUT-dev/pull/607) ([ZedThree](https://github.com/ZedThree))
- Warnings squash [\#606](https://github.com/boutproject/BOUT-dev/pull/606) ([bendudson](https://github.com/bendudson))
- Scorep wrapper [\#605](https://github.com/boutproject/BOUT-dev/pull/605) ([d7919](https://github.com/d7919))
- make sure input file is not overwritten [\#601](https://github.com/boutproject/BOUT-dev/pull/601) ([dschwoerer](https://github.com/dschwoerer))
- getName always available [\#599](https://github.com/boutproject/BOUT-dev/pull/599) ([dschwoerer](https://github.com/dschwoerer))
- add fieldmesh and make derivatives default to fieldmesh [\#598](https://github.com/boutproject/BOUT-dev/pull/598) ([dschwoerer](https://github.com/dschwoerer))
- fix typos in bout-config [\#595](https://github.com/boutproject/BOUT-dev/pull/595) ([dschwoerer](https://github.com/dschwoerer))
- Laplacian maxmode fix [\#592](https://github.com/boutproject/BOUT-dev/pull/592) ([d7919](https://github.com/d7919))
- Replacing modulus operation with ternary [\#591](https://github.com/boutproject/BOUT-dev/pull/591) ([d7919](https://github.com/d7919))
- Small optimisations for rfft/irfft [\#590](https://github.com/boutproject/BOUT-dev/pull/590) ([d7919](https://github.com/d7919))
- Small typo fix in Zoidberg [\#586](https://github.com/boutproject/BOUT-dev/pull/586) ([bshanahan](https://github.com/bshanahan))
- Improve arakawa performance [\#585](https://github.com/boutproject/BOUT-dev/pull/585) ([d7919](https://github.com/d7919))
- fix typo [\#582](https://github.com/boutproject/BOUT-dev/pull/582) ([dschwoerer](https://github.com/dschwoerer))
- allow to disable some checks [\#581](https://github.com/boutproject/BOUT-dev/pull/581) ([dschwoerer](https://github.com/dschwoerer))
- Fix typo in griddata.gridcontourf plotting routine [\#578](https://github.com/boutproject/BOUT-dev/pull/578) ([bendudson](https://github.com/bendudson))
- Replacing all `\#ifdef CHECK` lines with `\#if CHECK \> 0` [\#577](https://github.com/boutproject/BOUT-dev/pull/577) ([d7919](https://github.com/d7919))
- Updating documentation referring to TRACE/msg\_stack [\#576](https://github.com/boutproject/BOUT-dev/pull/576) ([d7919](https://github.com/d7919))
- Replace msg\_stack with TRACE everywhere [\#575](https://github.com/boutproject/BOUT-dev/pull/575) ([d7919](https://github.com/d7919))
- Let trace do formatting [\#574](https://github.com/boutproject/BOUT-dev/pull/574) ([d7919](https://github.com/d7919))
- Test subdir new [\#570](https://github.com/boutproject/BOUT-dev/pull/570) ([dschwoerer](https://github.com/dschwoerer))
- Next feature user defined flush freq [\#568](https://github.com/boutproject/BOUT-dev/pull/568) ([d7919](https://github.com/d7919))
- Adding build-aux to PVODE for make on \*BSD [\#567](https://github.com/boutproject/BOUT-dev/pull/567) ([bendudson](https://github.com/bendudson))
- Freebsd compile fixes [\#565](https://github.com/boutproject/BOUT-dev/pull/565) ([bendudson](https://github.com/bendudson))
- Adding example of 1D advection with boundaries [\#564](https://github.com/boutproject/BOUT-dev/pull/564) ([bendudson](https://github.com/bendudson))
- Modify the IDL\_PATH suggested by configure [\#562](https://github.com/boutproject/BOUT-dev/pull/562) ([bendudson](https://github.com/bendudson))
- Changing mesh:symmetricGlobalY to true by default [\#561](https://github.com/boutproject/BOUT-dev/pull/561) ([bendudson](https://github.com/bendudson))
- print NXPE/NYPE and localNX more clearly [\#559](https://github.com/boutproject/BOUT-dev/pull/559) ([dschwoerer](https://github.com/dschwoerer))
- rename examples [\#558](https://github.com/boutproject/BOUT-dev/pull/558) ([dschwoerer](https://github.com/dschwoerer))
- FieldGroup catch incorrect types at compile time [\#557](https://github.com/boutproject/BOUT-dev/pull/557) ([bendudson](https://github.com/bendudson))
- Next merge [\#556](https://github.com/boutproject/BOUT-dev/pull/556) ([dschwoerer](https://github.com/dschwoerer))
- Making ExpressionParser::LexInfo chars signed [\#553](https://github.com/boutproject/BOUT-dev/pull/553) ([bendudson](https://github.com/bendudson))
- add documentation for bout.m4 [\#549](https://github.com/boutproject/BOUT-dev/pull/549) ([dschwoerer](https://github.com/dschwoerer))
- cleanup of tools/pylib [\#548](https://github.com/boutproject/BOUT-dev/pull/548) ([dschwoerer](https://github.com/dschwoerer))
- Fixes to examples  [\#545](https://github.com/boutproject/BOUT-dev/pull/545) ([bendudson](https://github.com/bendudson))
- Remove deprecated warnings from core library [\#537](https://github.com/boutproject/BOUT-dev/pull/537) ([bendudson](https://github.com/bendudson))
- Test subdir [\#536](https://github.com/boutproject/BOUT-dev/pull/536) ([dschwoerer](https://github.com/dschwoerer))
- Move restart logic from Solver to PhysicsModel [\#535](https://github.com/boutproject/BOUT-dev/pull/535) ([bendudson](https://github.com/bendudson))
- Target check [\#532](https://github.com/boutproject/BOUT-dev/pull/532) ([dschwoerer](https://github.com/dschwoerer))
- make build faster [\#531](https://github.com/boutproject/BOUT-dev/pull/531) ([dschwoerer](https://github.com/dschwoerer))
- Hypnotoad: Improving handling of boundaries and X-points [\#530](https://github.com/boutproject/BOUT-dev/pull/530) ([bendudson](https://github.com/bendudson))
- fix issue with makedir [\#529](https://github.com/boutproject/BOUT-dev/pull/529) ([dschwoerer](https://github.com/dschwoerer))
- cleanup test\_suite [\#528](https://github.com/boutproject/BOUT-dev/pull/528) ([dschwoerer](https://github.com/dschwoerer))
- check data\_dir exists [\#527](https://github.com/boutproject/BOUT-dev/pull/527) ([dschwoerer](https://github.com/dschwoerer))
- Adding documentation to manual [\#525](https://github.com/boutproject/BOUT-dev/pull/525) ([bendudson](https://github.com/bendudson))
- add basic test for vector communication [\#524](https://github.com/boutproject/BOUT-dev/pull/524) ([dschwoerer](https://github.com/dschwoerer))
- Supplements to bout\_3to4.py [\#519](https://github.com/boutproject/BOUT-dev/pull/519) ([loeiten](https://github.com/loeiten))
- Important bugfix: Read dz from input [\#517](https://github.com/boutproject/BOUT-dev/pull/517) ([bendudson](https://github.com/bendudson))
- optionparser: only print source if not used [\#515](https://github.com/boutproject/BOUT-dev/pull/515) ([dschwoerer](https://github.com/dschwoerer))
- fix for datafile [\#514](https://github.com/boutproject/BOUT-dev/pull/514) ([dschwoerer](https://github.com/dschwoerer))
- Added checks for small g13 in LaplaceXZ [\#513](https://github.com/boutproject/BOUT-dev/pull/513) ([bendudson](https://github.com/bendudson))
- Output settings to file [\#512](https://github.com/boutproject/BOUT-dev/pull/512) ([bendudson](https://github.com/bendudson))
- Consolidating compressible gas examples  [\#511](https://github.com/boutproject/BOUT-dev/pull/511) ([bendudson](https://github.com/bendudson))
- Allow wider stencil in parallel direction if yup/ydown is not used [\#510](https://github.com/boutproject/BOUT-dev/pull/510) ([dschwoerer](https://github.com/dschwoerer))
- Solver adds Mesh variables to restart files [\#508](https://github.com/boutproject/BOUT-dev/pull/508) ([bendudson](https://github.com/bendudson))
- Changes to PetscOptions in PETSc 3.7 [\#507](https://github.com/boutproject/BOUT-dev/pull/507) ([bendudson](https://github.com/bendudson))
- Simplify boutmain.hxx for legacy physics models [\#506](https://github.com/boutproject/BOUT-dev/pull/506) ([bendudson](https://github.com/bendudson))
- Adding boltzman constant to constants.hxx [\#505](https://github.com/boutproject/BOUT-dev/pull/505) ([JensMadsen](https://github.com/JensMadsen))
- delete filename in destructor [\#501](https://github.com/boutproject/BOUT-dev/pull/501) ([dschwoerer](https://github.com/dschwoerer))
- Removing IS\_MYPROC [\#500](https://github.com/boutproject/BOUT-dev/pull/500) ([loeiten](https://github.com/loeiten))
- Petsc slepsc bug fixes [\#495](https://github.com/boutproject/BOUT-dev/pull/495) ([loeiten](https://github.com/loeiten))
- MXG and MYG read from grid files [\#494](https://github.com/boutproject/BOUT-dev/pull/494) ([bendudson](https://github.com/bendudson))
- Next examples tidy [\#491](https://github.com/boutproject/BOUT-dev/pull/491) ([bendudson](https://github.com/bendudson))
- Added an option to python gridcontourf [\#490](https://github.com/boutproject/BOUT-dev/pull/490) ([bendudson](https://github.com/bendudson))
- remove using namespace std; [\#489](https://github.com/boutproject/BOUT-dev/pull/489) ([dschwoerer](https://github.com/dschwoerer))
- use unique\_ptr for dataformat in datafile [\#487](https://github.com/boutproject/BOUT-dev/pull/487) ([dschwoerer](https://github.com/dschwoerer))
- Inner outer mesh iterators [\#486](https://github.com/boutproject/BOUT-dev/pull/486) ([dschwoerer](https://github.com/dschwoerer))
- Allow no bndry [\#485](https://github.com/boutproject/BOUT-dev/pull/485) ([dschwoerer](https://github.com/dschwoerer))
- throw if diffmethod is unknown [\#481](https://github.com/boutproject/BOUT-dev/pull/481) ([dschwoerer](https://github.com/dschwoerer))
- MergeYupYdown\(\) also checks status of ydown [\#480](https://github.com/boutproject/BOUT-dev/pull/480) ([bshanahan](https://github.com/bshanahan))
- Support of reading Field2D from gridfiles which have values at ghost points [\#479](https://github.com/boutproject/BOUT-dev/pull/479) ([JensMadsen](https://github.com/JensMadsen))
- Adding error recovery to IMEX-BDF2 [\#476](https://github.com/boutproject/BOUT-dev/pull/476) ([bendudson](https://github.com/bendudson))
- Travis matrix \(new\) [\#473](https://github.com/boutproject/BOUT-dev/pull/473) ([dschwoerer](https://github.com/dschwoerer))
- fix return value of operator= [\#472](https://github.com/boutproject/BOUT-dev/pull/472) ([dschwoerer](https://github.com/dschwoerer))
- Catch BoutExceptions as references [\#470](https://github.com/boutproject/BOUT-dev/pull/470) ([ZedThree](https://github.com/ZedThree))
- Fix rare double free with BoutException [\#469](https://github.com/boutproject/BOUT-dev/pull/469) ([ZedThree](https://github.com/ZedThree))
- Alt fix for use with intel compilers without openmp. \(more const\) [\#468](https://github.com/boutproject/BOUT-dev/pull/468) ([dschwoerer](https://github.com/dschwoerer))
- Bug fix py boutdata [\#467](https://github.com/boutproject/BOUT-dev/pull/467) ([ZedThree](https://github.com/ZedThree))
- Bug fixes and improvements for Zoidberg [\#465](https://github.com/boutproject/BOUT-dev/pull/465) ([ZedThree](https://github.com/ZedThree))
- More gridinfo output [\#460](https://github.com/boutproject/BOUT-dev/pull/460) ([JensMadsen](https://github.com/JensMadsen))
- clean datafile from mem leaks [\#456](https://github.com/boutproject/BOUT-dev/pull/456) ([dschwoerer](https://github.com/dschwoerer))
- ensure target is rebuild if libbout++.a changes [\#454](https://github.com/boutproject/BOUT-dev/pull/454) ([dschwoerer](https://github.com/dschwoerer))
- Next multi timestep monitor [\#364](https://github.com/boutproject/BOUT-dev/pull/364) ([dschwoerer](https://github.com/dschwoerer))
- signal based user requested exit [\#343](https://github.com/boutproject/BOUT-dev/pull/343) ([dschwoerer](https://github.com/dschwoerer))
- User requested exit [\#321](https://github.com/boutproject/BOUT-dev/pull/321) ([d7919](https://github.com/d7919))
- A "Z-folder" testing the D2DZ2 operator was added to examples/MMS/diffusion2.  [\#314](https://github.com/boutproject/BOUT-dev/pull/314) ([JensMadsen](https://github.com/JensMadsen))

## [v4.0.1](https://github.com/boutproject/BOUT-dev/tree/v4.0.1) (2017-09-02)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v4.0.0...v4.0.1)

**Fixed bugs:**

- Make sure to use c++ compiler with extern c declarations in configure [\#684](https://github.com/boutproject/BOUT-dev/pull/684) ([dschwoerer](https://github.com/dschwoerer))
- elm-pb option nogradparj is used without initialisation [\#571](https://github.com/boutproject/BOUT-dev/pull/571) ([bendudson](https://github.com/bendudson))
- small pyGridGen fixes [\#566](https://github.com/boutproject/BOUT-dev/pull/566) ([HarukiST](https://github.com/HarukiST))
- fix test-initial to allow more precise calculation [\#555](https://github.com/boutproject/BOUT-dev/pull/555) ([dschwoerer](https://github.com/dschwoerer))
- fix drift-instability for python3 [\#554](https://github.com/boutproject/BOUT-dev/pull/554) ([dschwoerer](https://github.com/dschwoerer))
- Add support for installing bout [\#550](https://github.com/boutproject/BOUT-dev/pull/550) ([dschwoerer](https://github.com/dschwoerer))
- Cherry picked fixes to master [\#546](https://github.com/boutproject/BOUT-dev/pull/546) ([ZedThree](https://github.com/ZedThree))
- Bugfix: FieldGroup handles Vectors [\#533](https://github.com/boutproject/BOUT-dev/pull/533) ([dschwoerer](https://github.com/dschwoerer))
- Changed ng@ to LocalN@ in the sphinx documentation [\#523](https://github.com/boutproject/BOUT-dev/pull/523) ([loeiten](https://github.com/loeiten))
- Bugfix bout\_runners [\#521](https://github.com/boutproject/BOUT-dev/pull/521) ([loeiten](https://github.com/loeiten))
- Important bugfix: Read dz from input [\#518](https://github.com/boutproject/BOUT-dev/pull/518) ([bendudson](https://github.com/bendudson))
- Bout runners fix immutable and documentation [\#516](https://github.com/boutproject/BOUT-dev/pull/516) ([loeiten](https://github.com/loeiten))
- 2nd derivative staggered diffoperator is only 2nd order [\#482](https://github.com/boutproject/BOUT-dev/pull/482) ([dschwoerer](https://github.com/dschwoerer))
- reorder licenses, so github shows the license correctly [\#475](https://github.com/boutproject/BOUT-dev/pull/475) ([dschwoerer](https://github.com/dschwoerer))
- Fix small typo in make.config.in [\#471](https://github.com/boutproject/BOUT-dev/pull/471) ([d7919](https://github.com/d7919))
- Bug fix for python BoutData [\#464](https://github.com/boutproject/BOUT-dev/pull/464) ([bendudson](https://github.com/bendudson))


## [v4.0.0](https://github.com/boutproject/BOUT-dev/tree/v4.0.0) (2017-02-03)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v3.1...v4.0.0)

**Fixed bugs:**

- `applyBoundary` on Fields with background set [\#430](https://github.com/boutproject/BOUT-dev/issues/430)
- Covariant metric tensor is calculated from contravariant metric tensor even if g\_ij is given in gridfile [\#386](https://github.com/boutproject/BOUT-dev/issues/386)
- test-initial ignores boundaries [\#360](https://github.com/boutproject/BOUT-dev/issues/360)
- Building next with PETSc [\#356](https://github.com/boutproject/BOUT-dev/issues/356)
- Vector3D DDZ not calculated correctly [\#123](https://github.com/boutproject/BOUT-dev/issues/123)
- Bug fix for genRand in Mixmode field generator [\#399](https://github.com/boutproject/BOUT-dev/pull/399) ([d7919](https://github.com/d7919))

**Closed issues:**

- test-invpar has high tolerance [\#422](https://github.com/boutproject/BOUT-dev/issues/422)
- How to pass BoutReal [\#402](https://github.com/boutproject/BOUT-dev/issues/402)
- Inital conditions test [\#400](https://github.com/boutproject/BOUT-dev/issues/400)
- Merge Policy [\#395](https://github.com/boutproject/BOUT-dev/issues/395)
- Version for BOUT++ 4.0 [\#383](https://github.com/boutproject/BOUT-dev/issues/383)
- Metric tensor components \(g\_13\) in b0xGrad\_dot\_Grad [\#377](https://github.com/boutproject/BOUT-dev/issues/377)
- PVODE fails to build in next [\#369](https://github.com/boutproject/BOUT-dev/issues/369)
- Enable -DCHECK to get trace doesn't work [\#353](https://github.com/boutproject/BOUT-dev/issues/353)
- Replace all instances of MsgStackItem with TRACE macro [\#350](https://github.com/boutproject/BOUT-dev/issues/350)
- Remove PDB file format [\#349](https://github.com/boutproject/BOUT-dev/issues/349)
- Deprecate FieldXX::{get,set}Data [\#348](https://github.com/boutproject/BOUT-dev/issues/348)
- FieldPerp doesn't have it's own mesh [\#347](https://github.com/boutproject/BOUT-dev/issues/347)
- Final call for PRs for BOUT++ 4.0-RC [\#344](https://github.com/boutproject/BOUT-dev/issues/344)
- double free or corruption [\#342](https://github.com/boutproject/BOUT-dev/issues/342)
- Boundaries: check sufficient points available [\#305](https://github.com/boutproject/BOUT-dev/issues/305)
- field::applyBoundary [\#300](https://github.com/boutproject/BOUT-dev/issues/300)
- test-initial should be rewritten [\#297](https://github.com/boutproject/BOUT-dev/issues/297)
- Boundary modifiers don't pass on time \(master and next\) [\#294](https://github.com/boutproject/BOUT-dev/issues/294)
- vsprintf should be replaced by vsnprintf [\#286](https://github.com/boutproject/BOUT-dev/issues/286)
- Delete the dirichlet and neuman boundary operators [\#256](https://github.com/boutproject/BOUT-dev/issues/256)
- test-gyro fails with gcc 6.1 [\#236](https://github.com/boutproject/BOUT-dev/issues/236)
- commandline options not recognized should halt program execution [\#233](https://github.com/boutproject/BOUT-dev/issues/233)
- inconsistency in apply{X,Y,Z}diff [\#170](https://github.com/boutproject/BOUT-dev/issues/170)
- Initial conditions test case [\#110](https://github.com/boutproject/BOUT-dev/issues/110)
- Memleak in dump.writeVAR\(\) [\#45](https://github.com/boutproject/BOUT-dev/issues/45)
- output:floats default value [\#34](https://github.com/boutproject/BOUT-dev/issues/34)
- NetCDF file format support [\#26](https://github.com/boutproject/BOUT-dev/issues/26)

**Merged pull requests:**

- Update next to v4.0.0 [\#462](https://github.com/boutproject/BOUT-dev/pull/462) ([ZedThree](https://github.com/ZedThree))
- Release v4.0.0 [\#461](https://github.com/boutproject/BOUT-dev/pull/461) ([ZedThree](https://github.com/ZedThree))
- fix the dataiterator z-offset for abitrary offsets [\#457](https://github.com/boutproject/BOUT-dev/pull/457) ([dschwoerer](https://github.com/dschwoerer))
- exit if the first call to the monitor fails [\#455](https://github.com/boutproject/BOUT-dev/pull/455) ([dschwoerer](https://github.com/dschwoerer))
- Sphinx/readthedocs documentation [\#450](https://github.com/boutproject/BOUT-dev/pull/450) ([ZedThree](https://github.com/ZedThree))
- Deprecate background [\#448](https://github.com/boutproject/BOUT-dev/pull/448) ([ZedThree](https://github.com/ZedThree))
- Y derivatives transform toFieldAligned if no yup/down [\#447](https://github.com/boutproject/BOUT-dev/pull/447) ([bendudson](https://github.com/bendudson))
- Deprecate writeVar [\#446](https://github.com/boutproject/BOUT-dev/pull/446) ([ZedThree](https://github.com/ZedThree))
- Fixes python restart.resizeY to handle Field2D, scalars \(v4\) [\#445](https://github.com/boutproject/BOUT-dev/pull/445) ([bendudson](https://github.com/bendudson))
- Remove abandoned diagnos class [\#442](https://github.com/boutproject/BOUT-dev/pull/442) ([ZedThree](https://github.com/ZedThree))
- V4 manual updates [\#441](https://github.com/boutproject/BOUT-dev/pull/441) ([ZedThree](https://github.com/ZedThree))
- Boutdata/restart fix new nz [\#440](https://github.com/boutproject/BOUT-dev/pull/440) ([JensMadsen](https://github.com/JensMadsen))
- Cache the value of localN [\#438](https://github.com/boutproject/BOUT-dev/pull/438) ([bendudson](https://github.com/bendudson))
- Added more diagnostics to CVODE [\#433](https://github.com/boutproject/BOUT-dev/pull/433) ([bendudson](https://github.com/bendudson))
- Small fix for configure NetCDF [\#432](https://github.com/boutproject/BOUT-dev/pull/432) ([bendudson](https://github.com/bendudson))
- Stop setting the corner of fields to zero during applyBoundary [\#431](https://github.com/boutproject/BOUT-dev/pull/431) ([ZedThree](https://github.com/ZedThree))
- Doxygen comments [\#428](https://github.com/boutproject/BOUT-dev/pull/428) ([bendudson](https://github.com/bendudson))
- Dschwoerer issue 402 [\#427](https://github.com/boutproject/BOUT-dev/pull/427) ([bendudson](https://github.com/bendudson))
- Lovely lovely documentations [\#423](https://github.com/boutproject/BOUT-dev/pull/423) ([ZedThree](https://github.com/ZedThree))
- remove quilt mesh [\#421](https://github.com/boutproject/BOUT-dev/pull/421) ([dschwoerer](https://github.com/dschwoerer))
- Doxygen comments [\#418](https://github.com/boutproject/BOUT-dev/pull/418) ([bendudson](https://github.com/bendudson))
- Remove unsupported quiltmesh implementation [\#417](https://github.com/boutproject/BOUT-dev/pull/417) ([ZedThree](https://github.com/ZedThree))
- Fix several warnings in v4 [\#415](https://github.com/boutproject/BOUT-dev/pull/415) ([ZedThree](https://github.com/ZedThree))
- Fix for multigrid: wrap \#include omp.h in \#ifdef \_OPENMP [\#414](https://github.com/boutproject/BOUT-dev/pull/414) ([ZedThree](https://github.com/ZedThree))
- Short laplace3d dc fix [\#413](https://github.com/boutproject/BOUT-dev/pull/413) ([bshanahan](https://github.com/bshanahan))
- add test-minmax to test suite [\#410](https://github.com/boutproject/BOUT-dev/pull/410) ([dschwoerer](https://github.com/dschwoerer))
- use matching flags for ar [\#408](https://github.com/boutproject/BOUT-dev/pull/408) ([dschwoerer](https://github.com/dschwoerer))
- make test-initial more strict [\#407](https://github.com/boutproject/BOUT-dev/pull/407) ([dschwoerer](https://github.com/dschwoerer))
- set default output format to double [\#404](https://github.com/boutproject/BOUT-dev/pull/404) ([dschwoerer](https://github.com/dschwoerer))
- Changing rmatrix and cmatrix to matrix\<\> [\#403](https://github.com/boutproject/BOUT-dev/pull/403) ([bendudson](https://github.com/bendudson))
- Documentation and some tidying [\#398](https://github.com/boutproject/BOUT-dev/pull/398) ([bendudson](https://github.com/bendudson))
- Bug in Div\_par fixed. Missing second argument in Grad\_par 'metric' w… [\#397](https://github.com/boutproject/BOUT-dev/pull/397) ([JensMadsen](https://github.com/JensMadsen))
- More Doxygen documentation [\#391](https://github.com/boutproject/BOUT-dev/pull/391) ([bendudson](https://github.com/bendudson))
- Doxygen documentation additions [\#388](https://github.com/boutproject/BOUT-dev/pull/388) ([bendudson](https://github.com/bendudson))
- Doxygened documentation from a previous commit  [\#387](https://github.com/boutproject/BOUT-dev/pull/387) ([loeiten](https://github.com/loeiten))
- Added Div\_Par\(f, metric\) to mms.py. Calculates the parallel divergence. [\#381](https://github.com/boutproject/BOUT-dev/pull/381) ([JensMadsen](https://github.com/JensMadsen))
- fixing test staggered grid [\#379](https://github.com/boutproject/BOUT-dev/pull/379) ([dschwoerer](https://github.com/dschwoerer))
- small improvement for collect [\#373](https://github.com/boutproject/BOUT-dev/pull/373) ([dschwoerer](https://github.com/dschwoerer))
- use msg trace only if available [\#368](https://github.com/boutproject/BOUT-dev/pull/368) ([dschwoerer](https://github.com/dschwoerer))
- Next fix vsnprintf [\#365](https://github.com/boutproject/BOUT-dev/pull/365) ([dschwoerer](https://github.com/dschwoerer))
- Zoidberg - python grid generator for FCI [\#361](https://github.com/boutproject/BOUT-dev/pull/361) ([ZedThree](https://github.com/ZedThree))
- utils for next [\#359](https://github.com/boutproject/BOUT-dev/pull/359) ([dschwoerer](https://github.com/dschwoerer))
- Various fixes and improvements to configure [\#358](https://github.com/boutproject/BOUT-dev/pull/358) ([ZedThree](https://github.com/ZedThree))
- Add 0D ints as vars not attrs [\#357](https://github.com/boutproject/BOUT-dev/pull/357) ([ZedThree](https://github.com/ZedThree))
- Remove support for PDB files [\#354](https://github.com/boutproject/BOUT-dev/pull/354) ([ZedThree](https://github.com/ZedThree))
- Rewrite test-initial [\#345](https://github.com/boutproject/BOUT-dev/pull/345) ([ZedThree](https://github.com/ZedThree))
- More warning fixes [\#341](https://github.com/boutproject/BOUT-dev/pull/341) ([ZedThree](https://github.com/ZedThree))
- Potential bug fix: Ensure result location set [\#327](https://github.com/boutproject/BOUT-dev/pull/327) ([d7919](https://github.com/d7919))
- Fix ddz of vector [\#316](https://github.com/boutproject/BOUT-dev/pull/316) ([loeiten](https://github.com/loeiten))
- include -fno-inline in debug mode [\#272](https://github.com/boutproject/BOUT-dev/pull/272) ([dschwoerer](https://github.com/dschwoerer))
- Make sure people notice this bug ... [\#253](https://github.com/boutproject/BOUT-dev/pull/253) ([dschwoerer](https://github.com/dschwoerer))
- Fast non-OpenMP DataIterator [\#186](https://github.com/boutproject/BOUT-dev/pull/186) ([dschwoerer](https://github.com/dschwoerer))

## [v3.1](https://github.com/boutproject/BOUT-dev/tree/v3.1) (2016-10-28)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v3.0...v3.1)

**Fixed bugs:**

- Debugging broken after commit 2ba639c99460a9f7272da0959cdcfa948bd65ded [\#176](https://github.com/boutproject/BOUT-dev/issues/176)
- Segmentation fault since 3a0c34be01c94303beb6c403a93e60581a8e3aeb [\#138](https://github.com/boutproject/BOUT-dev/issues/138)
- ./configure can no longer find libfftw3.a [\#103](https://github.com/boutproject/BOUT-dev/issues/103)

**Closed issues:**

- VDDX\_stag broken [\#324](https://github.com/boutproject/BOUT-dev/issues/324)
- Cannot make install on ubuntu 16.04 [\#308](https://github.com/boutproject/BOUT-dev/issues/308)
- mask.hxx:73 - missing return statement \(next\) [\#299](https://github.com/boutproject/BOUT-dev/issues/299)
- Datafile grow [\#287](https://github.com/boutproject/BOUT-dev/issues/287)
- Failure to open output file is ignored [\#285](https://github.com/boutproject/BOUT-dev/issues/285)
- next is broken with -DCHECK=3 [\#268](https://github.com/boutproject/BOUT-dev/issues/268)
- Error in user\_manual. no field twistshift [\#258](https://github.com/boutproject/BOUT-dev/issues/258)
- OpenMPI does not exit reliably if BOUT crashes [\#255](https://github.com/boutproject/BOUT-dev/issues/255)
- All:scale not passed to evolved variables in next [\#242](https://github.com/boutproject/BOUT-dev/issues/242)
- Max/Min returning different values with next compared to master. [\#241](https://github.com/boutproject/BOUT-dev/issues/241)
- Globalny set in boutmesh defaults to ny + 4  [\#230](https://github.com/boutproject/BOUT-dev/issues/230)
- Field3D and Vector3D \(probably field2D as well\) do not allocate memory when variables defined [\#220](https://github.com/boutproject/BOUT-dev/issues/220)
- BOUT version number [\#192](https://github.com/boutproject/BOUT-dev/issues/192)
- Evaluation of nonlinear brackets [\#179](https://github.com/boutproject/BOUT-dev/issues/179)
- Bug in applyYStencil? [\#155](https://github.com/boutproject/BOUT-dev/issues/155)
- copy of unintialised field fails at run time [\#145](https://github.com/boutproject/BOUT-dev/issues/145)
- Travis says test is successfull, even if it fails [\#141](https://github.com/boutproject/BOUT-dev/issues/141)
- zeroComponent\(int\) and getData\(int\) [\#136](https://github.com/boutproject/BOUT-dev/issues/136)
- error on flags: INVERT\_AC\_IN\_GRAD & INVERT\_AC\_OUT\_GRAD [\#134](https://github.com/boutproject/BOUT-dev/issues/134)
- Repeated references in FieldGroup leads to incorrect behaviour when TwistShift=True [\#129](https://github.com/boutproject/BOUT-dev/issues/129)
- Tagged releases [\#122](https://github.com/boutproject/BOUT-dev/issues/122)
- PETSc version [\#119](https://github.com/boutproject/BOUT-dev/issues/119)
- Remove mesh-\>zlength [\#114](https://github.com/boutproject/BOUT-dev/issues/114)
- Grid generation from geqdsk with NaNs [\#113](https://github.com/boutproject/BOUT-dev/issues/113)
- FieldGenerators error: ‘BoutException’ was not declared in this scope [\#108](https://github.com/boutproject/BOUT-dev/issues/108)
- FCI generate.py should be generalised [\#101](https://github.com/boutproject/BOUT-dev/issues/101)
- "Missing MXSUB variable" error for conduction NetCDF file [\#100](https://github.com/boutproject/BOUT-dev/issues/100)
- Brackets operator \[3D,2D\] /= -\[2D,3D\] [\#94](https://github.com/boutproject/BOUT-dev/issues/94)
- MMS-ing auxiliary variables using RK4 solver [\#84](https://github.com/boutproject/BOUT-dev/issues/84)
- Arithmetic support for all variables in BOUT.inp [\#72](https://github.com/boutproject/BOUT-dev/issues/72)
- Clean up \_\_init\_\_.py [\#68](https://github.com/boutproject/BOUT-dev/issues/68)
- CVODE number of preconditioner calls [\#61](https://github.com/boutproject/BOUT-dev/issues/61)
- Differing nrhs with changing processor count [\#48](https://github.com/boutproject/BOUT-dev/issues/48)
- Minor: setLocation twice in spt inversion [\#41](https://github.com/boutproject/BOUT-dev/issues/41)
- ^ exponentation operator in Field3d not working [\#33](https://github.com/boutproject/BOUT-dev/issues/33)
- Exit code if boundary assignment is not succesfull [\#29](https://github.com/boutproject/BOUT-dev/issues/29)
- function evaluation in "global" part of BOUT.inp [\#28](https://github.com/boutproject/BOUT-dev/issues/28)
- Remove ngz-1 [\#19](https://github.com/boutproject/BOUT-dev/issues/19)
- complex number class [\#17](https://github.com/boutproject/BOUT-dev/issues/17)
- Restart file error message [\#16](https://github.com/boutproject/BOUT-dev/issues/16)

**Merged pull requests:**

- Add macro to silence unused-parameter warning [\#337](https://github.com/boutproject/BOUT-dev/pull/337) ([ZedThree](https://github.com/ZedThree))
- Use miniconda to install python packages in Travis [\#336](https://github.com/boutproject/BOUT-dev/pull/336) ([ZedThree](https://github.com/ZedThree))
- Optimise next shift z [\#334](https://github.com/boutproject/BOUT-dev/pull/334) ([d7919](https://github.com/d7919))
- Fix bug in bilinear interpolation [\#333](https://github.com/boutproject/BOUT-dev/pull/333) ([ZedThree](https://github.com/ZedThree))
- improve boutexception [\#332](https://github.com/boutproject/BOUT-dev/pull/332) ([dschwoerer](https://github.com/dschwoerer))
- Ensure shiftOutput is set to an initial value [\#331](https://github.com/boutproject/BOUT-dev/pull/331) ([d7919](https://github.com/d7919))
- Warnings fix merged [\#330](https://github.com/boutproject/BOUT-dev/pull/330) ([d7919](https://github.com/d7919))
- Ensure physics model attached monitor can report state [\#328](https://github.com/boutproject/BOUT-dev/pull/328) ([d7919](https://github.com/d7919))
- Check points for boundary [\#323](https://github.com/boutproject/BOUT-dev/pull/323) ([d7919](https://github.com/d7919))
- FormatFactory throws exception if format not recognised [\#320](https://github.com/boutproject/BOUT-dev/pull/320) ([bendudson](https://github.com/bendudson))
- Small fix to mask.hxx [\#318](https://github.com/boutproject/BOUT-dev/pull/318) ([bendudson](https://github.com/bendudson))
- Bugfix in collect: don't use f.read [\#317](https://github.com/boutproject/BOUT-dev/pull/317) ([ZedThree](https://github.com/ZedThree))
- Small bugfix bout\_runners+improved doc of examples [\#315](https://github.com/boutproject/BOUT-dev/pull/315) ([loeiten](https://github.com/loeiten))
- Updated the user manual field initialisation [\#313](https://github.com/boutproject/BOUT-dev/pull/313) ([bendudson](https://github.com/bendudson))
- Added checks when reading netcdf files [\#310](https://github.com/boutproject/BOUT-dev/pull/310) ([bendudson](https://github.com/bendudson))
- Ensure a new line after exception [\#307](https://github.com/boutproject/BOUT-dev/pull/307) ([dschwoerer](https://github.com/dschwoerer))
- Ensure a new line after exception [\#306](https://github.com/boutproject/BOUT-dev/pull/306) ([d7919](https://github.com/d7919))
- Modifying VDDX operators in index\_derivs [\#303](https://github.com/boutproject/BOUT-dev/pull/303) ([bendudson](https://github.com/bendudson))
- Next gbs mmstest add comms and fix MYG [\#302](https://github.com/boutproject/BOUT-dev/pull/302) ([d7919](https://github.com/d7919))
- Passing time through boundary modifiers [\#301](https://github.com/boutproject/BOUT-dev/pull/301) ([d7919](https://github.com/d7919))
- Fixing tokamak mms test [\#298](https://github.com/boutproject/BOUT-dev/pull/298) ([d7919](https://github.com/d7919))
- Changing yup\(\) and ydown\(\) to nullptr [\#296](https://github.com/boutproject/BOUT-dev/pull/296) ([bendudson](https://github.com/bendudson))
- datafile: replace returns with throw, if neccessary [\#295](https://github.com/boutproject/BOUT-dev/pull/295) ([dschwoerer](https://github.com/dschwoerer))
- Replace vsprintf with vsnprintf [\#291](https://github.com/boutproject/BOUT-dev/pull/291) ([bendudson](https://github.com/bendudson))
- Adding two new boundary modifiers [\#290](https://github.com/boutproject/BOUT-dev/pull/290) ([d7919](https://github.com/d7919))
- replace int in datafile`s add to bool [\#289](https://github.com/boutproject/BOUT-dev/pull/289) ([dschwoerer](https://github.com/dschwoerer))
- Ignore boundaries when checking data is finite. [\#288](https://github.com/boutproject/BOUT-dev/pull/288) ([d7919](https://github.com/d7919))
- Elm pb fixes [\#284](https://github.com/boutproject/BOUT-dev/pull/284) ([d7919](https://github.com/d7919))
- Filter and lowpass fix [\#283](https://github.com/boutproject/BOUT-dev/pull/283) ([d7919](https://github.com/d7919))
- missing y-derivative in coordinates.tex section B.5.1 line 5	modified:   coordinates.tex [\#281](https://github.com/boutproject/BOUT-dev/pull/281) ([JensMadsen](https://github.com/JensMadsen))
- Hard coded MXG in MMS gridfile generator made flexible	modified:   mms.py [\#280](https://github.com/boutproject/BOUT-dev/pull/280) ([JensMadsen](https://github.com/JensMadsen))
- Removing hanging bracket [\#276](https://github.com/boutproject/BOUT-dev/pull/276) ([d7919](https://github.com/d7919))
- Next shift output [\#275](https://github.com/boutproject/BOUT-dev/pull/275) ([d7919](https://github.com/d7919))
- Next example fixes [\#273](https://github.com/boutproject/BOUT-dev/pull/273) ([ZedThree](https://github.com/ZedThree))
- Next fix check3 [\#271](https://github.com/boutproject/BOUT-dev/pull/271) ([dschwoerer](https://github.com/dschwoerer))
- Backtrace for next [\#270](https://github.com/boutproject/BOUT-dev/pull/270) ([dschwoerer](https://github.com/dschwoerer))
- Add tool to help with updating files from v3 to v4 [\#269](https://github.com/boutproject/BOUT-dev/pull/269) ([ZedThree](https://github.com/ZedThree))
- Bug fix for IMEX-BDF2 scheme for PETSc \< 3.4 [\#267](https://github.com/boutproject/BOUT-dev/pull/267) ([ZedThree](https://github.com/ZedThree))
- Fix numpy FutureWarning about comparison to None in pylib [\#264](https://github.com/boutproject/BOUT-dev/pull/264) ([ZedThree](https://github.com/ZedThree))
- Added implementation of D2DXDY [\#263](https://github.com/boutproject/BOUT-dev/pull/263) ([bendudson](https://github.com/bendudson))
- Added Include library example in:   make\_subdir/fuu/fuu.cxx [\#261](https://github.com/boutproject/BOUT-dev/pull/261) ([JensMadsen](https://github.com/JensMadsen))
- 	Fixed erroneous reference to "twistshift\[nx\]" in section 11 usermanual. [\#260](https://github.com/boutproject/BOUT-dev/pull/260) ([JensMadsen](https://github.com/JensMadsen))
- Call MPI\_Abort if physics\_init returns non-zero exit code. [\#257](https://github.com/boutproject/BOUT-dev/pull/257) ([dschwoerer](https://github.com/dschwoerer))
- New test [\#254](https://github.com/boutproject/BOUT-dev/pull/254) ([dschwoerer](https://github.com/dschwoerer))
- fixing field.hxx [\#249](https://github.com/boutproject/BOUT-dev/pull/249) ([dschwoerer](https://github.com/dschwoerer))
- allocate time deriv in field2d if it is not allocated [\#248](https://github.com/boutproject/BOUT-dev/pull/248) ([dschwoerer](https://github.com/dschwoerer))
- Fixing min behaviour in field2d [\#247](https://github.com/boutproject/BOUT-dev/pull/247) ([d7919](https://github.com/d7919))
- in case scale or function is not available for field, fallback to all… [\#246](https://github.com/boutproject/BOUT-dev/pull/246) ([dschwoerer](https://github.com/dschwoerer))
- ignoring extra point in z so dataiterator test doesn't fail [\#245](https://github.com/boutproject/BOUT-dev/pull/245) ([dschwoerer](https://github.com/dschwoerer))
- Adding missing newline to message [\#244](https://github.com/boutproject/BOUT-dev/pull/244) ([d7919](https://github.com/d7919))
- fixing min max behaviour in field2d [\#243](https://github.com/boutproject/BOUT-dev/pull/243) ([dschwoerer](https://github.com/dschwoerer))
- Update make.config.in to support subdirs [\#240](https://github.com/boutproject/BOUT-dev/pull/240) ([dschwoerer](https://github.com/dschwoerer))
- Fixing the DALF3 example [\#238](https://github.com/boutproject/BOUT-dev/pull/238) ([bendudson](https://github.com/bendudson))
- Fix for Laplacian inversion when IncIntShear=true [\#237](https://github.com/boutproject/BOUT-dev/pull/237) ([bendudson](https://github.com/bendudson))
- Bout runners chaining [\#234](https://github.com/boutproject/BOUT-dev/pull/234) ([loeiten](https://github.com/loeiten))
- Add 0D ints as variables instead of attributes [\#219](https://github.com/boutproject/BOUT-dev/pull/219) ([ZedThree](https://github.com/ZedThree))
- BoutMesh throws error if ShiftAngle not found [\#216](https://github.com/boutproject/BOUT-dev/pull/216) ([bendudson](https://github.com/bendudson))
- Changing non\_uniform to default true [\#210](https://github.com/boutproject/BOUT-dev/pull/210) ([bendudson](https://github.com/bendudson))
- Updated version of multigrid solver. [\#209](https://github.com/boutproject/BOUT-dev/pull/209) ([JosephThomasParker](https://github.com/JosephThomasParker))
- Improved Arakawa bracket evaluation  [\#205](https://github.com/boutproject/BOUT-dev/pull/205) ([JosephThomasParker](https://github.com/JosephThomasParker))
- Added neumann\_o4 to boundaries [\#203](https://github.com/boutproject/BOUT-dev/pull/203) ([loeiten](https://github.com/loeiten))
- Bugfix of configure [\#202](https://github.com/boutproject/BOUT-dev/pull/202) ([loeiten](https://github.com/loeiten))
- Adding bout-sonnet script [\#201](https://github.com/boutproject/BOUT-dev/pull/201) ([bendudson](https://github.com/bendudson))
- Adding boutdata.data classes [\#200](https://github.com/boutproject/BOUT-dev/pull/200) ([bendudson](https://github.com/bendudson))
- DataFile throws exception for missing fields [\#197](https://github.com/boutproject/BOUT-dev/pull/197) ([bendudson](https://github.com/bendudson))
- Renamed ngx,ngy,ngz to LocalN\* [\#194](https://github.com/boutproject/BOUT-dev/pull/194) ([bendudson](https://github.com/bendudson))
- check git revision at compile time [\#193](https://github.com/boutproject/BOUT-dev/pull/193) ([dschwoerer](https://github.com/dschwoerer))
- fix field2d [\#191](https://github.com/boutproject/BOUT-dev/pull/191) ([dschwoerer](https://github.com/dschwoerer))
- add FieldPerp::operator\(int,int\) [\#188](https://github.com/boutproject/BOUT-dev/pull/188) ([dschwoerer](https://github.com/dschwoerer))
- Fix array.cxx [\#187](https://github.com/boutproject/BOUT-dev/pull/187) ([dschwoerer](https://github.com/dschwoerer))
- fix typo in configure.ac [\#184](https://github.com/boutproject/BOUT-dev/pull/184) ([dschwoerer](https://github.com/dschwoerer))
- Updating Field2D [\#183](https://github.com/boutproject/BOUT-dev/pull/183) ([bendudson](https://github.com/bendudson))
- Fix fiedperp [\#181](https://github.com/boutproject/BOUT-dev/pull/181) ([dschwoerer](https://github.com/dschwoerer))
- Multigrid solver [\#178](https://github.com/boutproject/BOUT-dev/pull/178) ([JosephThomasParker](https://github.com/JosephThomasParker))
- OpenMP [\#177](https://github.com/boutproject/BOUT-dev/pull/177) ([dschwoerer](https://github.com/dschwoerer))
- Adding boundary conditions to LaplaceXY cyclic [\#174](https://github.com/boutproject/BOUT-dev/pull/174) ([bendudson](https://github.com/bendudson))
- D2DZ2 update [\#173](https://github.com/boutproject/BOUT-dev/pull/173) ([loeiten](https://github.com/loeiten))
- make travis output more verbose if configure fails [\#172](https://github.com/boutproject/BOUT-dev/pull/172) ([dschwoerer](https://github.com/dschwoerer))
- adding MPI flags for travis [\#171](https://github.com/boutproject/BOUT-dev/pull/171) ([dschwoerer](https://github.com/dschwoerer))
- PETSc 3.6 [\#168](https://github.com/boutproject/BOUT-dev/pull/168) ([bendudson](https://github.com/bendudson))
- D Schwoerer's configure improvements [\#166](https://github.com/boutproject/BOUT-dev/pull/166) ([bendudson](https://github.com/bendudson))
- Changing the way bracket \[2d,3d\] handels not implemented methods. [\#165](https://github.com/boutproject/BOUT-dev/pull/165) ([dschwoerer](https://github.com/dschwoerer))
- Improved reading of contravariant metrics [\#164](https://github.com/boutproject/BOUT-dev/pull/164) ([loeiten](https://github.com/loeiten))
- Coloring [\#160](https://github.com/boutproject/BOUT-dev/pull/160) ([bendudson](https://github.com/bendudson))
- Boundary condition laplace xz [\#158](https://github.com/boutproject/BOUT-dev/pull/158) ([loeiten](https://github.com/loeiten))
- Removing unused ioSupport functions [\#156](https://github.com/boutproject/BOUT-dev/pull/156) ([bendudson](https://github.com/bendudson))
- fix sign error [\#154](https://github.com/boutproject/BOUT-dev/pull/154) ([dschwoerer](https://github.com/dschwoerer))
- Added PETSC\_VERSION\_GE macro [\#153](https://github.com/boutproject/BOUT-dev/pull/153) ([bendudson](https://github.com/bendudson))
- Manual update [\#151](https://github.com/boutproject/BOUT-dev/pull/151) ([loeiten](https://github.com/loeiten))
- fixed/extended some tests [\#150](https://github.com/boutproject/BOUT-dev/pull/150) ([dschwoerer](https://github.com/dschwoerer))
- Configure optimize [\#144](https://github.com/boutproject/BOUT-dev/pull/144) ([dschwoerer](https://github.com/dschwoerer))
- added sys.exit\(1\) to test\_suite, that failed test are detected by travis [\#142](https://github.com/boutproject/BOUT-dev/pull/142) ([dschwoerer](https://github.com/dschwoerer))
- typo in field2d.cxx [\#137](https://github.com/boutproject/BOUT-dev/pull/137) ([dschwoerer](https://github.com/dschwoerer))
- fixed missing track in copy constructor [\#135](https://github.com/boutproject/BOUT-dev/pull/135) ([dschwoerer](https://github.com/dschwoerer))
- Gridgen fixes [\#131](https://github.com/boutproject/BOUT-dev/pull/131) ([bendudson](https://github.com/bendudson))
- Unique field group [\#130](https://github.com/boutproject/BOUT-dev/pull/130) ([d7919](https://github.com/d7919))
- Fix of conduction example [\#128](https://github.com/boutproject/BOUT-dev/pull/128) ([loeiten](https://github.com/loeiten))
- added strict flag for collect function [\#127](https://github.com/boutproject/BOUT-dev/pull/127) ([dschwoerer](https://github.com/dschwoerer))
- throw exception if given boundray is not found [\#126](https://github.com/boutproject/BOUT-dev/pull/126) ([dschwoerer](https://github.com/dschwoerer))
- Imex solver updates [\#120](https://github.com/boutproject/BOUT-dev/pull/120) ([bendudson](https://github.com/bendudson))
- Changed mesh-\>zlength to a function [\#118](https://github.com/boutproject/BOUT-dev/pull/118) ([bendudson](https://github.com/bendudson))
- Added the erf function and a hat function to the FieldFactory class [\#117](https://github.com/boutproject/BOUT-dev/pull/117) ([loeiten](https://github.com/loeiten))
- Added possibility to read covariant metric tensor from gridfile [\#116](https://github.com/boutproject/BOUT-dev/pull/116) ([loeiten](https://github.com/loeiten))
- Laplacian solvers [\#115](https://github.com/boutproject/BOUT-dev/pull/115) ([bendudson](https://github.com/bendudson))
- Clean up init [\#112](https://github.com/boutproject/BOUT-dev/pull/112) ([loeiten](https://github.com/loeiten))
- Arithmetic support for all options [\#107](https://github.com/boutproject/BOUT-dev/pull/107) ([bendudson](https://github.com/bendudson))
- Adding calls to run\_rhs\(\) to RK4, Euler and RK3-SSP solvers [\#105](https://github.com/boutproject/BOUT-dev/pull/105) ([bendudson](https://github.com/bendudson))
- Don't use missing CollectError [\#99](https://github.com/boutproject/BOUT-dev/pull/99) ([erikgrinaker](https://github.com/erikgrinaker))
- Small clean-up [\#98](https://github.com/boutproject/BOUT-dev/pull/98) ([loeiten](https://github.com/loeiten))
- Added staggered 3rd order WENO scheme [\#31](https://github.com/boutproject/BOUT-dev/pull/31) ([nick-walkden](https://github.com/nick-walkden))

## [v3.0](https://github.com/boutproject/BOUT-dev/tree/v3.0) (2015-09-17)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v2.1...v3.0)

**Fixed bugs:**

- collect when 'variable not found' broken [\#77](https://github.com/boutproject/BOUT-dev/issues/77)
- "with" broken in the new datafile.py [\#76](https://github.com/boutproject/BOUT-dev/issues/76)
- Some options in certain sections cannot be changed from the command [\#36](https://github.com/boutproject/BOUT-dev/issues/36)

**Closed issues:**

- libhdf5 link failure on OS X [\#95](https://github.com/boutproject/BOUT-dev/issues/95)
- Problems with building PETSc as described in user\_manual [\#90](https://github.com/boutproject/BOUT-dev/issues/90)
- configure file present [\#83](https://github.com/boutproject/BOUT-dev/issues/83)
- Possible bug in call to tridagMatrix in serial\_tri and cycl\_laplace [\#71](https://github.com/boutproject/BOUT-dev/issues/71)
- Arithmetic in input file when variable is specified on command line [\#62](https://github.com/boutproject/BOUT-dev/issues/62)
- Boundaries not properly set when using a function as a boundary argument in BOUT.inp [\#54](https://github.com/boutproject/BOUT-dev/issues/54)
- Laplacian Flags invert\_set, invert\_rhs implementation [\#52](https://github.com/boutproject/BOUT-dev/issues/52)
- ffmpeg\_path specified in showdata.py [\#47](https://github.com/boutproject/BOUT-dev/issues/47)
- Obsolete files? [\#44](https://github.com/boutproject/BOUT-dev/issues/44)
- Mesh::get fails if field is unallocated [\#43](https://github.com/boutproject/BOUT-dev/issues/43)
- BoutInitialise failure [\#39](https://github.com/boutproject/BOUT-dev/issues/39)
- Obsolete communicator in reference.pdf [\#32](https://github.com/boutproject/BOUT-dev/issues/32)
- HDF5 file support [\#27](https://github.com/boutproject/BOUT-dev/issues/27)
- Z domain size in input file, and non-FFT 3D fields [\#22](https://github.com/boutproject/BOUT-dev/issues/22)

**Merged pull requests:**

- Commenting laplacian [\#97](https://github.com/boutproject/BOUT-dev/pull/97) ([loeiten](https://github.com/loeiten))
- Fix for libhdf path [\#96](https://github.com/boutproject/BOUT-dev/pull/96) ([dschwoerer](https://github.com/dschwoerer))
- Remove stray .svn/ directories [\#93](https://github.com/boutproject/BOUT-dev/pull/93) ([erikgrinaker](https://github.com/erikgrinaker))
- Clean up and improve .gitignore [\#92](https://github.com/boutproject/BOUT-dev/pull/92) ([erikgrinaker](https://github.com/erikgrinaker))
- Travis CI [\#86](https://github.com/boutproject/BOUT-dev/pull/86) ([ZedThree](https://github.com/ZedThree))
- configure searches for libraries in lib64 and lib directories [\#85](https://github.com/boutproject/BOUT-dev/pull/85) ([dschwoerer](https://github.com/dschwoerer))
- DataFile raises exception not return None [\#82](https://github.com/boutproject/BOUT-dev/pull/82) ([bendudson](https://github.com/bendudson))
- README updates [\#81](https://github.com/boutproject/BOUT-dev/pull/81) ([peternaylor](https://github.com/peternaylor))
- Basic vagrant config [\#80](https://github.com/boutproject/BOUT-dev/pull/80) ([kevinpetersavage](https://github.com/kevinpetersavage))
- Manual [\#79](https://github.com/boutproject/BOUT-dev/pull/79) ([loeiten](https://github.com/loeiten))
- Fixed tridagMatrix calls [\#78](https://github.com/boutproject/BOUT-dev/pull/78) ([loeiten](https://github.com/loeiten))
- Bout runners [\#75](https://github.com/boutproject/BOUT-dev/pull/75) ([loeiten](https://github.com/loeiten))
- IMEX-BDF2 and SNES time solvers [\#74](https://github.com/boutproject/BOUT-dev/pull/74) ([bendudson](https://github.com/bendudson))
- Adding HDF5 support [\#73](https://github.com/boutproject/BOUT-dev/pull/73) ([bendudson](https://github.com/bendudson))
- Added comments in the laplace solvers [\#70](https://github.com/boutproject/BOUT-dev/pull/70) ([loeiten](https://github.com/loeiten))
- Help message fix [\#69](https://github.com/boutproject/BOUT-dev/pull/69) ([d7919](https://github.com/d7919))
- Python3 compatible [\#65](https://github.com/boutproject/BOUT-dev/pull/65) ([loeiten](https://github.com/loeiten))
- Add staggered field support to initial\_profile [\#63](https://github.com/boutproject/BOUT-dev/pull/63) ([johnomotani](https://github.com/johnomotani))
- Topology manual update [\#59](https://github.com/boutproject/BOUT-dev/pull/59) ([nick-walkden](https://github.com/nick-walkden))
- Enable C1 and C2 coefficients in Laplacian solvers [\#57](https://github.com/boutproject/BOUT-dev/pull/57) ([johnomotani](https://github.com/johnomotani))
- Redistribute restarts [\#55](https://github.com/boutproject/BOUT-dev/pull/55) ([johnomotani](https://github.com/johnomotani))
- Laplace invert set fix [\#53](https://github.com/boutproject/BOUT-dev/pull/53) ([johnomotani](https://github.com/johnomotani))
- Implementation of ARKode solver [\#51](https://github.com/boutproject/BOUT-dev/pull/51) ([nick-walkden](https://github.com/nick-walkden))
- Output initial state when restarting [\#49](https://github.com/boutproject/BOUT-dev/pull/49) ([johnomotani](https://github.com/johnomotani))
- Help message [\#38](https://github.com/boutproject/BOUT-dev/pull/38) ([ZedThree](https://github.com/ZedThree))
- Fixed optimizer flag for debugging [\#30](https://github.com/boutproject/BOUT-dev/pull/30) ([loeiten](https://github.com/loeiten))
- Updated version of python tools [\#23](https://github.com/boutproject/BOUT-dev/pull/23) ([brey](https://github.com/brey))

## [v2.1](https://github.com/boutproject/BOUT-dev/tree/v2.1) (2014-09-10)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v2.0...v2.1)

**Merged pull requests:**

- Bad behaviour fix for FieldGroup operator overload [\#11](https://github.com/boutproject/BOUT-dev/pull/11) ([d7919](https://github.com/d7919))
- Adding + and += operators to FieldGroup class to allow FieldGroups to be... [\#10](https://github.com/boutproject/BOUT-dev/pull/10) ([d7919](https://github.com/d7919))
- Introduce the python post processing routines and some scripts for analysis in elm-pb folder [\#9](https://github.com/boutproject/BOUT-dev/pull/9) ([brey](https://github.com/brey))
- Update import\_data\_netcdf.m [\#8](https://github.com/boutproject/BOUT-dev/pull/8) ([sanatkrtiwari86](https://github.com/sanatkrtiwari86))
- Inner radial bndry [\#7](https://github.com/boutproject/BOUT-dev/pull/7) ([lukeeasy](https://github.com/lukeeasy))
- Python modules for BOUT++ pre-processing [\#4](https://github.com/boutproject/BOUT-dev/pull/4) ([brey](https://github.com/brey))
- Timestep monitor [\#3](https://github.com/boutproject/BOUT-dev/pull/3) ([bendudson](https://github.com/bendudson))
- Improved python showdata routine to allow animation of multiple plots si... [\#2](https://github.com/boutproject/BOUT-dev/pull/2) ([lukeeasy](https://github.com/lukeeasy))

## [v2.0](https://github.com/boutproject/BOUT-dev/tree/v2.0) (2013-09-23)
[Full Changelog](https://github.com/boutproject/BOUT-dev/compare/v1.0...v2.0)

## [v1.0](https://github.com/boutproject/BOUT-dev/tree/v1.0) (2011-08-26)


\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
