# This file is automatically generated. DO NOT EDIT!
# fmt: off

from __future__ import annotations

import copy
import json
from typing import Any, Literal, TypedDict, overload

import paho.mqtt.client as mqtt
from loguru import logger

from .payloads import (
    AvrPcmSetBaseColorPayload,
    _AvrPcmSetBaseColorCallable,
    AvrPcmSetTempColorPayload,
    _AvrPcmSetTempColorCallable,
    AvrPcmFireLaserPayload,
    _AvrPcmFireLaserCallable,
    AvrPcmSetLaserOnPayload,
    _AvrPcmSetLaserOnCallable,
    AvrPcmSetLaserOffPayload,
    _AvrPcmSetLaserOffCallable,
    AvrPcmSetServoOpenClosePayload,
    _AvrPcmSetServoOpenCloseCallable,
    AvrPcmSetServoMinPayload,
    _AvrPcmSetServoMinCallable,
    AvrPcmSetServoMaxPayload,
    _AvrPcmSetServoMaxCallable,
    AvrPcmSetServoPctPayload,
    _AvrPcmSetServoPctCallable,
    AvrPcmSetServoAbsPayload,
    _AvrPcmSetServoAbsCallable,
    AvrFcmHilGpsStatsPayload,
    _AvrFcmHilGpsStatsCallable,
    AvrFcmEventsPayload,
    _AvrFcmEventsCallable,
    AvrFcmBatteryPayload,
    _AvrFcmBatteryCallable,
    AvrFcmStatusPayload,
    _AvrFcmStatusCallable,
    AvrFcmLocationLocalPayload,
    _AvrFcmLocationLocalCallable,
    AvrFcmLocationGlobalPayload,
    _AvrFcmLocationGlobalCallable,
    AvrFcmLocationHomePayload,
    _AvrFcmLocationHomeCallable,
    AvrFcmAttitudeEulerPayload,
    _AvrFcmAttitudeEulerCallable,
    AvrFcmVelocityPayload,
    _AvrFcmVelocityCallable,
    AvrFcmGpsInfoPayload,
    _AvrFcmGpsInfoCallable,
    AvrFusionPositionNedPayload,
    _AvrFusionPositionNedCallable,
    AvrFusionVelocityNedPayload,
    _AvrFusionVelocityNedCallable,
    AvrFusionGeoPayload,
    _AvrFusionGeoCallable,
    AvrFusionGroundspeedPayload,
    _AvrFusionGroundspeedCallable,
    AvrFusionCoursePayload,
    _AvrFusionCourseCallable,
    AvrFusionClimbratePayload,
    _AvrFusionClimbrateCallable,
    AvrFusionAttitudeQuatPayload,
    _AvrFusionAttitudeQuatCallable,
    AvrFusionAttitudeEulerPayload,
    _AvrFusionAttitudeEulerCallable,
    AvrFusionAttitudeHeadingPayload,
    _AvrFusionAttitudeHeadingCallable,
    AvrFusionHilGpsPayload,
    _AvrFusionHilGpsCallable,
    AvrVioResyncPayload,
    _AvrVioResyncCallable,
    AvrVioPositionNedPayload,
    _AvrVioPositionNedCallable,
    AvrVioVelocityNedPayload,
    _AvrVioVelocityNedCallable,
    AvrVioOrientationEulPayload,
    _AvrVioOrientationEulCallable,
    AvrVioOrientationQuatPayload,
    _AvrVioOrientationQuatCallable,
    AvrVioHeadingPayload,
    _AvrVioHeadingCallable,
    AvrVioConfidencePayload,
    _AvrVioConfidenceCallable,
    AvrApriltagsSelectedPayload,
    _AvrApriltagsSelectedCallable,
    AvrApriltagsRawPayload,
    _AvrApriltagsRawCallable,
    AvrApriltagsVisiblePayload,
    _AvrApriltagsVisibleCallable,
    AvrApriltagsFpsPayload,
    _AvrApriltagsFpsCallable,
    AvrThermalReadingPayload,
    _AvrThermalReadingCallable,
    AvrStatusLightPcmPayload,
    _AvrStatusLightPcmCallable,
    AvrStatusLightVioPayload,
    _AvrStatusLightVioCallable,
    AvrStatusLightApriltagsPayload,
    _AvrStatusLightApriltagsCallable,
    AvrStatusLightFcmPayload,
    _AvrStatusLightFcmCallable,
    AvrStatusLightThermalPayload,
    _AvrStatusLightThermalCallable,
    AvrAutonomousEnablePayload,
    _AvrAutonomousEnableCallable,
    AvrAutonomousBuildingDropPayload,
    _AvrAutonomousBuildingDropCallable,
)
from ..utils.decorators import try_except


# create typed dict of topics associated with callbacks
_MQTTTopicCallable = TypedDict(
    "_MQTTTopicCallable",
    {
        "avr/pcm/set_base_color": _AvrPcmSetBaseColorCallable,
        "avr/pcm/set_temp_color": _AvrPcmSetTempColorCallable,
        "avr/pcm/fire_laser": _AvrPcmFireLaserCallable,
        "avr/pcm/set_laser_on": _AvrPcmSetLaserOnCallable,
        "avr/pcm/set_laser_off": _AvrPcmSetLaserOffCallable,
        "avr/pcm/set_servo_open_close": _AvrPcmSetServoOpenCloseCallable,
        "avr/pcm/set_servo_min": _AvrPcmSetServoMinCallable,
        "avr/pcm/set_servo_max": _AvrPcmSetServoMaxCallable,
        "avr/pcm/set_servo_pct": _AvrPcmSetServoPctCallable,
        "avr/pcm/set_servo_abs": _AvrPcmSetServoAbsCallable,
        "avr/fcm/hil_gps_stats": _AvrFcmHilGpsStatsCallable,
        "avr/fcm/events": _AvrFcmEventsCallable,
        "avr/fcm/battery": _AvrFcmBatteryCallable,
        "avr/fcm/status": _AvrFcmStatusCallable,
        "avr/fcm/location/local": _AvrFcmLocationLocalCallable,
        "avr/fcm/location/global": _AvrFcmLocationGlobalCallable,
        "avr/fcm/location/home": _AvrFcmLocationHomeCallable,
        "avr/fcm/attitude/euler": _AvrFcmAttitudeEulerCallable,
        "avr/fcm/velocity": _AvrFcmVelocityCallable,
        "avr/fcm/gps_info": _AvrFcmGpsInfoCallable,
        "avr/fusion/position/ned": _AvrFusionPositionNedCallable,
        "avr/fusion/velocity/ned": _AvrFusionVelocityNedCallable,
        "avr/fusion/geo": _AvrFusionGeoCallable,
        "avr/fusion/groundspeed": _AvrFusionGroundspeedCallable,
        "avr/fusion/course": _AvrFusionCourseCallable,
        "avr/fusion/climbrate": _AvrFusionClimbrateCallable,
        "avr/fusion/attitude/quat": _AvrFusionAttitudeQuatCallable,
        "avr/fusion/attitude/euler": _AvrFusionAttitudeEulerCallable,
        "avr/fusion/attitude/heading": _AvrFusionAttitudeHeadingCallable,
        "avr/fusion/hil_gps": _AvrFusionHilGpsCallable,
        "avr/vio/resync": _AvrVioResyncCallable,
        "avr/vio/position/ned": _AvrVioPositionNedCallable,
        "avr/vio/velocity/ned": _AvrVioVelocityNedCallable,
        "avr/vio/orientation/eul": _AvrVioOrientationEulCallable,
        "avr/vio/orientation/quat": _AvrVioOrientationQuatCallable,
        "avr/vio/heading": _AvrVioHeadingCallable,
        "avr/vio/confidence": _AvrVioConfidenceCallable,
        "avr/apriltags/selected": _AvrApriltagsSelectedCallable,
        "avr/apriltags/raw": _AvrApriltagsRawCallable,
        "avr/apriltags/visible": _AvrApriltagsVisibleCallable,
        "avr/apriltags/fps": _AvrApriltagsFpsCallable,
        "avr/thermal/reading": _AvrThermalReadingCallable,
        "avr/status/light/pcm": _AvrStatusLightPcmCallable,
        "avr/status/light/vio": _AvrStatusLightVioCallable,
        "avr/status/light/apriltags": _AvrStatusLightApriltagsCallable,
        "avr/status/light/fcm": _AvrStatusLightFcmCallable,
        "avr/status/light/thermal": _AvrStatusLightThermalCallable,
        "avr/autonomous/enable": _AvrAutonomousEnableCallable,
        "avr/autonomous/building/drop": _AvrAutonomousBuildingDropCallable,
    },
    total=False
)

# create typed dict of topics associated with payloads
_MQTTTopicPayload = TypedDict(
    "_MQTTTopicPayload",
    {
        "avr/pcm/set_base_color": AvrPcmSetBaseColorPayload,
        "avr/pcm/set_temp_color": AvrPcmSetTempColorPayload,
        "avr/pcm/fire_laser": AvrPcmFireLaserPayload,
        "avr/pcm/set_laser_on": AvrPcmSetLaserOnPayload,
        "avr/pcm/set_laser_off": AvrPcmSetLaserOffPayload,
        "avr/pcm/set_servo_open_close": AvrPcmSetServoOpenClosePayload,
        "avr/pcm/set_servo_min": AvrPcmSetServoMinPayload,
        "avr/pcm/set_servo_max": AvrPcmSetServoMaxPayload,
        "avr/pcm/set_servo_pct": AvrPcmSetServoPctPayload,
        "avr/pcm/set_servo_abs": AvrPcmSetServoAbsPayload,
        "avr/fcm/hil_gps_stats": AvrFcmHilGpsStatsPayload,
        "avr/fcm/events": AvrFcmEventsPayload,
        "avr/fcm/battery": AvrFcmBatteryPayload,
        "avr/fcm/status": AvrFcmStatusPayload,
        "avr/fcm/location/local": AvrFcmLocationLocalPayload,
        "avr/fcm/location/global": AvrFcmLocationGlobalPayload,
        "avr/fcm/location/home": AvrFcmLocationHomePayload,
        "avr/fcm/attitude/euler": AvrFcmAttitudeEulerPayload,
        "avr/fcm/velocity": AvrFcmVelocityPayload,
        "avr/fcm/gps_info": AvrFcmGpsInfoPayload,
        "avr/fusion/position/ned": AvrFusionPositionNedPayload,
        "avr/fusion/velocity/ned": AvrFusionVelocityNedPayload,
        "avr/fusion/geo": AvrFusionGeoPayload,
        "avr/fusion/groundspeed": AvrFusionGroundspeedPayload,
        "avr/fusion/course": AvrFusionCoursePayload,
        "avr/fusion/climbrate": AvrFusionClimbratePayload,
        "avr/fusion/attitude/quat": AvrFusionAttitudeQuatPayload,
        "avr/fusion/attitude/euler": AvrFusionAttitudeEulerPayload,
        "avr/fusion/attitude/heading": AvrFusionAttitudeHeadingPayload,
        "avr/fusion/hil_gps": AvrFusionHilGpsPayload,
        "avr/vio/resync": AvrVioResyncPayload,
        "avr/vio/position/ned": AvrVioPositionNedPayload,
        "avr/vio/velocity/ned": AvrVioVelocityNedPayload,
        "avr/vio/orientation/eul": AvrVioOrientationEulPayload,
        "avr/vio/orientation/quat": AvrVioOrientationQuatPayload,
        "avr/vio/heading": AvrVioHeadingPayload,
        "avr/vio/confidence": AvrVioConfidencePayload,
        "avr/apriltags/selected": AvrApriltagsSelectedPayload,
        "avr/apriltags/raw": AvrApriltagsRawPayload,
        "avr/apriltags/visible": AvrApriltagsVisiblePayload,
        "avr/apriltags/fps": AvrApriltagsFpsPayload,
        "avr/thermal/reading": AvrThermalReadingPayload,
        "avr/status/light/pcm": AvrStatusLightPcmPayload,
        "avr/status/light/vio": AvrStatusLightVioPayload,
        "avr/status/light/apriltags": AvrStatusLightApriltagsPayload,
        "avr/status/light/fcm": AvrStatusLightFcmPayload,
        "avr/status/light/thermal": AvrStatusLightThermalPayload,
        "avr/autonomous/enable": AvrAutonomousEnablePayload,
        "avr/autonomous/building/drop": AvrAutonomousBuildingDropPayload,
    },
    total=False
)


class MQTTModule:
    """
    Generic MQTT Module class that should be inherited by other modules.
    The `topic_map` attribute should be a dictionary of topics to functions
    that will be called with a payload.
    """

    def __init__(self):
        # these should be not be changed
        self.mqtt_host = "mqtt"
        self.mqtt_port = 18830

        # create the MQTT client
        self._mqtt_client = mqtt.Client(protocol=mqtt.MQTTv311)

        # set up the on connect and on message handlers
        self._mqtt_client.on_connect = self.on_connect
        self._mqtt_client.on_message = self.on_message

        # dictionary of MQTT topics to callback functions
        # this is intended to be overwritten by the child class
        self.topic_map: _MQTTTopicCallable = {}

        # maintain a cache of the last message sent on a topic by this module
        self.message_cache: _MQTTTopicPayload = {}

    def run(self) -> None:
        """
        Class entrypoint. Connects to the MQTT broker and starts the MQTT loop
        in a blocking manner.
        """
        # connect the MQTT client
        self._mqtt_client.connect(host=self.mqtt_host, port=self.mqtt_port, keepalive=60)
        # run forever
        self._mqtt_client.loop_forever()

    def run_non_blocking(self) -> None:
        """
        Class entrypoint. Connects to the MQTT broker and starts the MQTT loop
        in a non-blocking manner.
        """
        # connect the MQTT client
        self._mqtt_client.connect(host=self.mqtt_host, port=self.mqtt_port, keepalive=60)
        # run in background
        self._mqtt_client.loop_start()

    @try_except()
    def on_message(self, client: mqtt.Client, userdata: Any, msg: mqtt.MQTTMessage) -> None:
        """
        On message callback, dispatches the message to the appropriate function.
        """
        # logger.debug(f"Recieved {msg.topic}: {msg.payload}")
        if msg.topic in self.topic_map:
            # we talk JSON, no exceptions
            payload = json.loads(msg.payload)
            self.topic_map[msg.topic](payload)

    def on_connect(self, client: mqtt.Client, userdata: Any, flags: dict, rc: int) -> None:
        """
        On connection callback. Subscribes to MQTT topics in the topic map.
        """
        logger.debug(f"Connected with result {rc}")

        for topic in self.topic_map.keys():
            client.subscribe(topic)
            logger.success(f"Subscribed to: {topic}")

    @overload
    def send_message(self, topic: Literal["avr/pcm/set_base_color"], payload: AvrPcmSetBaseColorPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/pcm/set_temp_color"], payload: AvrPcmSetTempColorPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/pcm/fire_laser"], payload: AvrPcmFireLaserPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/pcm/set_laser_on"], payload: AvrPcmSetLaserOnPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/pcm/set_laser_off"], payload: AvrPcmSetLaserOffPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/pcm/set_servo_open_close"], payload: AvrPcmSetServoOpenClosePayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/pcm/set_servo_min"], payload: AvrPcmSetServoMinPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/pcm/set_servo_max"], payload: AvrPcmSetServoMaxPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/pcm/set_servo_pct"], payload: AvrPcmSetServoPctPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/pcm/set_servo_abs"], payload: AvrPcmSetServoAbsPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fcm/hil_gps_stats"], payload: AvrFcmHilGpsStatsPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fcm/events"], payload: AvrFcmEventsPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fcm/battery"], payload: AvrFcmBatteryPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fcm/status"], payload: AvrFcmStatusPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fcm/location/local"], payload: AvrFcmLocationLocalPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fcm/location/global"], payload: AvrFcmLocationGlobalPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fcm/location/home"], payload: AvrFcmLocationHomePayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fcm/attitude/euler"], payload: AvrFcmAttitudeEulerPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fcm/velocity"], payload: AvrFcmVelocityPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fcm/gps_info"], payload: AvrFcmGpsInfoPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fusion/position/ned"], payload: AvrFusionPositionNedPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fusion/velocity/ned"], payload: AvrFusionVelocityNedPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fusion/geo"], payload: AvrFusionGeoPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fusion/groundspeed"], payload: AvrFusionGroundspeedPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fusion/course"], payload: AvrFusionCoursePayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fusion/climbrate"], payload: AvrFusionClimbratePayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fusion/attitude/quat"], payload: AvrFusionAttitudeQuatPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fusion/attitude/euler"], payload: AvrFusionAttitudeEulerPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fusion/attitude/heading"], payload: AvrFusionAttitudeHeadingPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/fusion/hil_gps"], payload: AvrFusionHilGpsPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/vio/resync"], payload: AvrVioResyncPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/vio/position/ned"], payload: AvrVioPositionNedPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/vio/velocity/ned"], payload: AvrVioVelocityNedPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/vio/orientation/eul"], payload: AvrVioOrientationEulPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/vio/orientation/quat"], payload: AvrVioOrientationQuatPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/vio/heading"], payload: AvrVioHeadingPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/vio/confidence"], payload: AvrVioConfidencePayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/apriltags/selected"], payload: AvrApriltagsSelectedPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/apriltags/raw"], payload: AvrApriltagsRawPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/apriltags/visible"], payload: AvrApriltagsVisiblePayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/apriltags/fps"], payload: AvrApriltagsFpsPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/thermal/reading"], payload: AvrThermalReadingPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/status/light/pcm"], payload: AvrStatusLightPcmPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/status/light/vio"], payload: AvrStatusLightVioPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/status/light/apriltags"], payload: AvrStatusLightApriltagsPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/status/light/fcm"], payload: AvrStatusLightFcmPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/status/light/thermal"], payload: AvrStatusLightThermalPayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/autonomous/enable"], payload: AvrAutonomousEnablePayload) -> None: ...

    @overload
    def send_message(self, topic: Literal["avr/autonomous/building/drop"], payload: AvrAutonomousBuildingDropPayload) -> None: ...

    def send_message(self, topic, payload) -> None:
        """
        Sends a message to the MQTT broker.
        """
        # logger.debug(f"Sending message to {topic}: {payload}")
        self._mqtt_client.publish(topic, json.dumps(payload))
        self.message_cache[topic] = copy.deepcopy(payload)
