# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class PipelineStep(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'batch': 'PipelineBatch',
        'inputs': 'list[str]',
        'inputs_join_type': 'JoinType',
        'join_window_ms': 'int',
        'name': 'str',
        'tensor_map': 'dict(str, str)',
        'triggers': 'list[str]',
        'triggers_join_type': 'JoinType'
    }

    attribute_map = {
        'batch': 'batch',
        'inputs': 'inputs',
        'inputs_join_type': 'inputsJoinType',
        'join_window_ms': 'joinWindowMs',
        'name': 'name',
        'tensor_map': 'tensorMap',
        'triggers': 'triggers',
        'triggers_join_type': 'triggersJoinType'
    }

    def __init__(self, batch=None, inputs=None, inputs_join_type=None, join_window_ms=None, name=None, tensor_map=None, triggers=None, triggers_join_type=None):  # noqa: E501
        """PipelineStep - a model defined in Swagger"""  # noqa: E501

        self._batch = None
        self._inputs = None
        self._inputs_join_type = None
        self._join_window_ms = None
        self._name = None
        self._tensor_map = None
        self._triggers = None
        self._triggers_join_type = None
        self.discriminator = None

        if batch is not None:
            self.batch = batch
        if inputs is not None:
            self.inputs = inputs
        if inputs_join_type is not None:
            self.inputs_join_type = inputs_join_type
        if join_window_ms is not None:
            self.join_window_ms = join_window_ms
        if name is not None:
            self.name = name
        if tensor_map is not None:
            self.tensor_map = tensor_map
        if triggers is not None:
            self.triggers = triggers
        if triggers_join_type is not None:
            self.triggers_join_type = triggers_join_type

    @property
    def batch(self):
        """Gets the batch of this PipelineStep.  # noqa: E501


        :return: The batch of this PipelineStep.  # noqa: E501
        :rtype: PipelineBatch
        """
        return self._batch

    @batch.setter
    def batch(self, batch):
        """Sets the batch of this PipelineStep.


        :param batch: The batch of this PipelineStep.  # noqa: E501
        :type: PipelineBatch
        """

        self._batch = batch

    @property
    def inputs(self):
        """Gets the inputs of this PipelineStep.  # noqa: E501

        Previous step to receive data from  # noqa: E501

        :return: The inputs of this PipelineStep.  # noqa: E501
        :rtype: list[str]
        """
        return self._inputs

    @inputs.setter
    def inputs(self, inputs):
        """Sets the inputs of this PipelineStep.

        Previous step to receive data from  # noqa: E501

        :param inputs: The inputs of this PipelineStep.  # noqa: E501
        :type: list[str]
        """

        self._inputs = inputs

    @property
    def inputs_join_type(self):
        """Gets the inputs_join_type of this PipelineStep.  # noqa: E501


        :return: The inputs_join_type of this PipelineStep.  # noqa: E501
        :rtype: JoinType
        """
        return self._inputs_join_type

    @inputs_join_type.setter
    def inputs_join_type(self, inputs_join_type):
        """Sets the inputs_join_type of this PipelineStep.


        :param inputs_join_type: The inputs_join_type of this PipelineStep.  # noqa: E501
        :type: JoinType
        """

        self._inputs_join_type = inputs_join_type

    @property
    def join_window_ms(self):
        """Gets the join_window_ms of this PipelineStep.  # noqa: E501

        msecs to wait for messages from multiple inputs to arrive before joining the inputs  # noqa: E501

        :return: The join_window_ms of this PipelineStep.  # noqa: E501
        :rtype: int
        """
        return self._join_window_ms

    @join_window_ms.setter
    def join_window_ms(self, join_window_ms):
        """Sets the join_window_ms of this PipelineStep.

        msecs to wait for messages from multiple inputs to arrive before joining the inputs  # noqa: E501

        :param join_window_ms: The join_window_ms of this PipelineStep.  # noqa: E501
        :type: int
        """

        self._join_window_ms = join_window_ms

    @property
    def name(self):
        """Gets the name of this PipelineStep.  # noqa: E501

        Name of the step  # noqa: E501

        :return: The name of this PipelineStep.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PipelineStep.

        Name of the step  # noqa: E501

        :param name: The name of this PipelineStep.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def tensor_map(self):
        """Gets the tensor_map of this PipelineStep.  # noqa: E501

        Map of tensor name conversions to use e.g. output1 -> input1  # noqa: E501

        :return: The tensor_map of this PipelineStep.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._tensor_map

    @tensor_map.setter
    def tensor_map(self, tensor_map):
        """Sets the tensor_map of this PipelineStep.

        Map of tensor name conversions to use e.g. output1 -> input1  # noqa: E501

        :param tensor_map: The tensor_map of this PipelineStep.  # noqa: E501
        :type: dict(str, str)
        """

        self._tensor_map = tensor_map

    @property
    def triggers(self):
        """Gets the triggers of this PipelineStep.  # noqa: E501

        Triggers required to activate step  # noqa: E501

        :return: The triggers of this PipelineStep.  # noqa: E501
        :rtype: list[str]
        """
        return self._triggers

    @triggers.setter
    def triggers(self, triggers):
        """Sets the triggers of this PipelineStep.

        Triggers required to activate step  # noqa: E501

        :param triggers: The triggers of this PipelineStep.  # noqa: E501
        :type: list[str]
        """

        self._triggers = triggers

    @property
    def triggers_join_type(self):
        """Gets the triggers_join_type of this PipelineStep.  # noqa: E501


        :return: The triggers_join_type of this PipelineStep.  # noqa: E501
        :rtype: JoinType
        """
        return self._triggers_join_type

    @triggers_join_type.setter
    def triggers_join_type(self, triggers_join_type):
        """Sets the triggers_join_type of this PipelineStep.


        :param triggers_join_type: The triggers_join_type of this PipelineStep.  # noqa: E501
        :type: JoinType
        """

        self._triggers_join_type = triggers_join_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PipelineStep, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PipelineStep):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
