# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ModelSpec(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'artifact_version': 'int',
        'dedicated': 'bool',
        'explainer': 'ExplainerSpec',
        'logger': 'LoggingSpec',
        'max_replicas': 'int',
        'memory': 'Quantity',
        'min_replicas': 'int',
        'model_type': 'str',
        'parameters': 'list[ParameterSpec]',
        'preloaded': 'bool',
        'replicas': 'int',
        'requirements': 'list[str]',
        'schema_uri': 'str',
        'secret_name': 'str',
        'server': 'str',
        'storage_uri': 'str'
    }

    attribute_map = {
        'artifact_version': 'artifactVersion',
        'dedicated': 'dedicated',
        'explainer': 'explainer',
        'logger': 'logger',
        'max_replicas': 'maxReplicas',
        'memory': 'memory',
        'min_replicas': 'minReplicas',
        'model_type': 'modelType',
        'parameters': 'parameters',
        'preloaded': 'preloaded',
        'replicas': 'replicas',
        'requirements': 'requirements',
        'schema_uri': 'schemaUri',
        'secret_name': 'secretName',
        'server': 'server',
        'storage_uri': 'storageUri'
    }

    def __init__(self, artifact_version=None, dedicated=None, explainer=None, logger=None, max_replicas=None, memory=None, min_replicas=None, model_type=None, parameters=None, preloaded=None, replicas=None, requirements=None, schema_uri=None, secret_name=None, server=None, storage_uri=None):  # noqa: E501
        """ModelSpec - a model defined in Swagger"""  # noqa: E501

        self._artifact_version = None
        self._dedicated = None
        self._explainer = None
        self._logger = None
        self._max_replicas = None
        self._memory = None
        self._min_replicas = None
        self._model_type = None
        self._parameters = None
        self._preloaded = None
        self._replicas = None
        self._requirements = None
        self._schema_uri = None
        self._secret_name = None
        self._server = None
        self._storage_uri = None
        self.discriminator = None

        if artifact_version is not None:
            self.artifact_version = artifact_version
        if dedicated is not None:
            self.dedicated = dedicated
        if explainer is not None:
            self.explainer = explainer
        if logger is not None:
            self.logger = logger
        if max_replicas is not None:
            self.max_replicas = max_replicas
        if memory is not None:
            self.memory = memory
        if min_replicas is not None:
            self.min_replicas = min_replicas
        if model_type is not None:
            self.model_type = model_type
        if parameters is not None:
            self.parameters = parameters
        if preloaded is not None:
            self.preloaded = preloaded
        if replicas is not None:
            self.replicas = replicas
        if requirements is not None:
            self.requirements = requirements
        if schema_uri is not None:
            self.schema_uri = schema_uri
        if secret_name is not None:
            self.secret_name = secret_name
        if server is not None:
            self.server = server
        if storage_uri is not None:
            self.storage_uri = storage_uri

    @property
    def artifact_version(self):
        """Gets the artifact_version of this ModelSpec.  # noqa: E501

        Artifact Version A v2 version folder to select from storage bucket +optional  # noqa: E501

        :return: The artifact_version of this ModelSpec.  # noqa: E501
        :rtype: int
        """
        return self._artifact_version

    @artifact_version.setter
    def artifact_version(self, artifact_version):
        """Sets the artifact_version of this ModelSpec.

        Artifact Version A v2 version folder to select from storage bucket +optional  # noqa: E501

        :param artifact_version: The artifact_version of this ModelSpec.  # noqa: E501
        :type: int
        """

        self._artifact_version = artifact_version

    @property
    def dedicated(self):
        """Gets the dedicated of this ModelSpec.  # noqa: E501

        Dedicated server exclusive to this model Default false  # noqa: E501

        :return: The dedicated of this ModelSpec.  # noqa: E501
        :rtype: bool
        """
        return self._dedicated

    @dedicated.setter
    def dedicated(self, dedicated):
        """Sets the dedicated of this ModelSpec.

        Dedicated server exclusive to this model Default false  # noqa: E501

        :param dedicated: The dedicated of this ModelSpec.  # noqa: E501
        :type: bool
        """

        self._dedicated = dedicated

    @property
    def explainer(self):
        """Gets the explainer of this ModelSpec.  # noqa: E501


        :return: The explainer of this ModelSpec.  # noqa: E501
        :rtype: ExplainerSpec
        """
        return self._explainer

    @explainer.setter
    def explainer(self, explainer):
        """Sets the explainer of this ModelSpec.


        :param explainer: The explainer of this ModelSpec.  # noqa: E501
        :type: ExplainerSpec
        """

        self._explainer = explainer

    @property
    def logger(self):
        """Gets the logger of this ModelSpec.  # noqa: E501


        :return: The logger of this ModelSpec.  # noqa: E501
        :rtype: LoggingSpec
        """
        return self._logger

    @logger.setter
    def logger(self, logger):
        """Sets the logger of this ModelSpec.


        :param logger: The logger of this ModelSpec.  # noqa: E501
        :type: LoggingSpec
        """

        self._logger = logger

    @property
    def max_replicas(self):
        """Gets the max_replicas of this ModelSpec.  # noqa: E501

        Max number of replicas - default equal to replicas  # noqa: E501

        :return: The max_replicas of this ModelSpec.  # noqa: E501
        :rtype: int
        """
        return self._max_replicas

    @max_replicas.setter
    def max_replicas(self, max_replicas):
        """Sets the max_replicas of this ModelSpec.

        Max number of replicas - default equal to replicas  # noqa: E501

        :param max_replicas: The max_replicas of this ModelSpec.  # noqa: E501
        :type: int
        """

        self._max_replicas = max_replicas

    @property
    def memory(self):
        """Gets the memory of this ModelSpec.  # noqa: E501


        :return: The memory of this ModelSpec.  # noqa: E501
        :rtype: Quantity
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """Sets the memory of this ModelSpec.


        :param memory: The memory of this ModelSpec.  # noqa: E501
        :type: Quantity
        """

        self._memory = memory

    @property
    def min_replicas(self):
        """Gets the min_replicas of this ModelSpec.  # noqa: E501

        Min number of replicas - default equal to replicas  # noqa: E501

        :return: The min_replicas of this ModelSpec.  # noqa: E501
        :rtype: int
        """
        return self._min_replicas

    @min_replicas.setter
    def min_replicas(self, min_replicas):
        """Sets the min_replicas of this ModelSpec.

        Min number of replicas - default equal to replicas  # noqa: E501

        :param min_replicas: The min_replicas of this ModelSpec.  # noqa: E501
        :type: int
        """

        self._min_replicas = min_replicas

    @property
    def model_type(self):
        """Gets the model_type of this ModelSpec.  # noqa: E501

        Model type +optional  # noqa: E501

        :return: The model_type of this ModelSpec.  # noqa: E501
        :rtype: str
        """
        return self._model_type

    @model_type.setter
    def model_type(self, model_type):
        """Sets the model_type of this ModelSpec.

        Model type +optional  # noqa: E501

        :param model_type: The model_type of this ModelSpec.  # noqa: E501
        :type: str
        """

        self._model_type = model_type

    @property
    def parameters(self):
        """Gets the parameters of this ModelSpec.  # noqa: E501

        Parameters to load with model  # noqa: E501

        :return: The parameters of this ModelSpec.  # noqa: E501
        :rtype: list[ParameterSpec]
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """Sets the parameters of this ModelSpec.

        Parameters to load with model  # noqa: E501

        :param parameters: The parameters of this ModelSpec.  # noqa: E501
        :type: list[ParameterSpec]
        """

        self._parameters = parameters

    @property
    def preloaded(self):
        """Gets the preloaded of this ModelSpec.  # noqa: E501

        Model already loaded on a server. Don't schedule. Default false  # noqa: E501

        :return: The preloaded of this ModelSpec.  # noqa: E501
        :rtype: bool
        """
        return self._preloaded

    @preloaded.setter
    def preloaded(self, preloaded):
        """Sets the preloaded of this ModelSpec.

        Model already loaded on a server. Don't schedule. Default false  # noqa: E501

        :param preloaded: The preloaded of this ModelSpec.  # noqa: E501
        :type: bool
        """

        self._preloaded = preloaded

    @property
    def replicas(self):
        """Gets the replicas of this ModelSpec.  # noqa: E501

        Number of replicas - default 1  # noqa: E501

        :return: The replicas of this ModelSpec.  # noqa: E501
        :rtype: int
        """
        return self._replicas

    @replicas.setter
    def replicas(self, replicas):
        """Sets the replicas of this ModelSpec.

        Number of replicas - default 1  # noqa: E501

        :param replicas: The replicas of this ModelSpec.  # noqa: E501
        :type: int
        """

        self._replicas = replicas

    @property
    def requirements(self):
        """Gets the requirements of this ModelSpec.  # noqa: E501

        List of extra requirements for this model to be loaded on a compatible server  # noqa: E501

        :return: The requirements of this ModelSpec.  # noqa: E501
        :rtype: list[str]
        """
        return self._requirements

    @requirements.setter
    def requirements(self, requirements):
        """Sets the requirements of this ModelSpec.

        List of extra requirements for this model to be loaded on a compatible server  # noqa: E501

        :param requirements: The requirements of this ModelSpec.  # noqa: E501
        :type: list[str]
        """

        self._requirements = requirements

    @property
    def schema_uri(self):
        """Gets the schema_uri of this ModelSpec.  # noqa: E501

        Schema URI +optional  # noqa: E501

        :return: The schema_uri of this ModelSpec.  # noqa: E501
        :rtype: str
        """
        return self._schema_uri

    @schema_uri.setter
    def schema_uri(self, schema_uri):
        """Sets the schema_uri of this ModelSpec.

        Schema URI +optional  # noqa: E501

        :param schema_uri: The schema_uri of this ModelSpec.  # noqa: E501
        :type: str
        """

        self._schema_uri = schema_uri

    @property
    def secret_name(self):
        """Gets the secret_name of this ModelSpec.  # noqa: E501

        Secret name +optional  # noqa: E501

        :return: The secret_name of this ModelSpec.  # noqa: E501
        :rtype: str
        """
        return self._secret_name

    @secret_name.setter
    def secret_name(self, secret_name):
        """Sets the secret_name of this ModelSpec.

        Secret name +optional  # noqa: E501

        :param secret_name: The secret_name of this ModelSpec.  # noqa: E501
        :type: str
        """

        self._secret_name = secret_name

    @property
    def server(self):
        """Gets the server of this ModelSpec.  # noqa: E501

        Name of the Server to deploy this artifact +optional  # noqa: E501

        :return: The server of this ModelSpec.  # noqa: E501
        :rtype: str
        """
        return self._server

    @server.setter
    def server(self, server):
        """Sets the server of this ModelSpec.

        Name of the Server to deploy this artifact +optional  # noqa: E501

        :param server: The server of this ModelSpec.  # noqa: E501
        :type: str
        """

        self._server = server

    @property
    def storage_uri(self):
        """Gets the storage_uri of this ModelSpec.  # noqa: E501

        Storage URI for the model repository  # noqa: E501

        :return: The storage_uri of this ModelSpec.  # noqa: E501
        :rtype: str
        """
        return self._storage_uri

    @storage_uri.setter
    def storage_uri(self, storage_uri):
        """Sets the storage_uri of this ModelSpec.

        Storage URI for the model repository  # noqa: E501

        :param storage_uri: The storage_uri of this ModelSpec.  # noqa: E501
        :type: str
        """

        self._storage_uri = storage_uri

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ModelSpec, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ModelSpec):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
