# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from seldon_deploy_sdk.api_client import ApiClient


class PipelinesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_pipeline(self, namespace, mldeployment, **kwargs):  # noqa: E501
        """create_pipeline  # noqa: E501

        Create a Seldon Pipeline  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pipeline(namespace, mldeployment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param Pipeline mldeployment: Seldon Pipeline (required)
        :param str action: Action
        :param str message: Message
        :return: SeldonPipeline
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_pipeline_with_http_info(namespace, mldeployment, **kwargs)  # noqa: E501
        else:
            (data) = self.create_pipeline_with_http_info(namespace, mldeployment, **kwargs)  # noqa: E501
            return data

    def create_pipeline_with_http_info(self, namespace, mldeployment, **kwargs):  # noqa: E501
        """create_pipeline  # noqa: E501

        Create a Seldon Pipeline  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pipeline_with_http_info(namespace, mldeployment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param Pipeline mldeployment: Seldon Pipeline (required)
        :param str action: Action
        :param str message: Message
        :return: SeldonPipeline
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'mldeployment', 'action', 'message']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_pipeline" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_pipeline`")  # noqa: E501
        # verify the required parameter 'mldeployment' is set
        if ('mldeployment' not in params or
                params['mldeployment'] is None):
            raise ValueError("Missing the required parameter `mldeployment` when calling `create_pipeline`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'action' in params:
            query_params.append(('action', params['action']))  # noqa: E501
        if 'message' in params:
            query_params.append(('message', params['message']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'mldeployment' in params:
            body_params = params['mldeployment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SeldonPipeline',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_pipeline_explainer(self, name, namespace, model, **kwargs):  # noqa: E501
        """create_pipeline_explainer  # noqa: E501

        Read the specified Seldon Pipeline Explainer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pipeline_explainer(name, namespace, model, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param Model model: Seldon Model (required)
        :param str action: Action
        :param str message: Message
        :return: SeldonModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_pipeline_explainer_with_http_info(name, namespace, model, **kwargs)  # noqa: E501
        else:
            (data) = self.create_pipeline_explainer_with_http_info(name, namespace, model, **kwargs)  # noqa: E501
            return data

    def create_pipeline_explainer_with_http_info(self, name, namespace, model, **kwargs):  # noqa: E501
        """create_pipeline_explainer  # noqa: E501

        Read the specified Seldon Pipeline Explainer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pipeline_explainer_with_http_info(name, namespace, model, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param Model model: Seldon Model (required)
        :param str action: Action
        :param str message: Message
        :return: SeldonModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'model', 'action', 'message']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_pipeline_explainer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_pipeline_explainer`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_pipeline_explainer`")  # noqa: E501
        # verify the required parameter 'model' is set
        if ('model' not in params or
                params['model'] is None):
            raise ValueError("Missing the required parameter `model` when calling `create_pipeline_explainer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'action' in params:
            query_params.append(('action', params['action']))  # noqa: E501
        if 'message' in params:
            query_params.append(('message', params['message']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model' in params:
            body_params = params['model']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines/{name}/explainer', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SeldonModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_pipeline(self, name, namespace, **kwargs):  # noqa: E501
        """delete_pipeline  # noqa: E501

        Delete the specified Seldon Pipeline  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pipeline(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param str action: Action
        :param str message: Message
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_pipeline_with_http_info(name, namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_pipeline_with_http_info(name, namespace, **kwargs)  # noqa: E501
            return data

    def delete_pipeline_with_http_info(self, name, namespace, **kwargs):  # noqa: E501
        """delete_pipeline  # noqa: E501

        Delete the specified Seldon Pipeline  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pipeline_with_http_info(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param str action: Action
        :param str message: Message
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'action', 'message']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_pipeline" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_pipeline`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_pipeline`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'action' in params:
            query_params.append(('action', params['action']))  # noqa: E501
        if 'message' in params:
            query_params.append(('message', params['message']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_pipeline_explainer(self, name, namespace, **kwargs):  # noqa: E501
        """delete_pipeline_explainer  # noqa: E501

        Read the specified Seldon Pipeline Explainer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pipeline_explainer(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param str action: Action
        :param str message: Message
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_pipeline_explainer_with_http_info(name, namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_pipeline_explainer_with_http_info(name, namespace, **kwargs)  # noqa: E501
            return data

    def delete_pipeline_explainer_with_http_info(self, name, namespace, **kwargs):  # noqa: E501
        """delete_pipeline_explainer  # noqa: E501

        Read the specified Seldon Pipeline Explainer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pipeline_explainer_with_http_info(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param str action: Action
        :param str message: Message
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'action', 'message']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_pipeline_explainer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_pipeline_explainer`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_pipeline_explainer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'action' in params:
            query_params.append(('action', params['action']))  # noqa: E501
        if 'message' in params:
            query_params.append(('message', params['message']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines/{name}/explainer', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_pipeline_models(self, name, namespace, **kwargs):  # noqa: E501
        """list_pipeline_models  # noqa: E501

        List objects of kind Seldon Models within a Pipeline  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_pipeline_models(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: SeldonModelList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_pipeline_models_with_http_info(name, namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.list_pipeline_models_with_http_info(name, namespace, **kwargs)  # noqa: E501
            return data

    def list_pipeline_models_with_http_info(self, name, namespace, **kwargs):  # noqa: E501
        """list_pipeline_models  # noqa: E501

        List objects of kind Seldon Models within a Pipeline  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_pipeline_models_with_http_info(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: SeldonModelList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_pipeline_models" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `list_pipeline_models`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_pipeline_models`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines/{name}/models', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SeldonModelList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_pipelines(self, namespace, **kwargs):  # noqa: E501
        """list_pipelines  # noqa: E501

        list objects of kind Seldon Pipelines  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_pipelines(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: SeldonPipelineList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_pipelines_with_http_info(namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.list_pipelines_with_http_info(namespace, **kwargs)  # noqa: E501
            return data

    def list_pipelines_with_http_info(self, namespace, **kwargs):  # noqa: E501
        """list_pipelines  # noqa: E501

        list objects of kind Seldon Pipelines  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_pipelines_with_http_info(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: SeldonPipelineList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_pipelines" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_pipelines`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SeldonPipelineList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read_pipeline(self, name, namespace, **kwargs):  # noqa: E501
        """read_pipeline  # noqa: E501

        Read the specified Seldon Pipeline  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_pipeline(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: SeldonPipeline
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.read_pipeline_with_http_info(name, namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.read_pipeline_with_http_info(name, namespace, **kwargs)  # noqa: E501
            return data

    def read_pipeline_with_http_info(self, name, namespace, **kwargs):  # noqa: E501
        """read_pipeline  # noqa: E501

        Read the specified Seldon Pipeline  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_pipeline_with_http_info(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: SeldonPipeline
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_pipeline" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_pipeline`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_pipeline`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SeldonPipeline',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read_pipeline_explainer(self, name, namespace, **kwargs):  # noqa: E501
        """read_pipeline_explainer  # noqa: E501

        Read the specified Seldon Pipeline Explainer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_pipeline_explainer(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: SeldonModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.read_pipeline_explainer_with_http_info(name, namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.read_pipeline_explainer_with_http_info(name, namespace, **kwargs)  # noqa: E501
            return data

    def read_pipeline_explainer_with_http_info(self, name, namespace, **kwargs):  # noqa: E501
        """read_pipeline_explainer  # noqa: E501

        Read the specified Seldon Pipeline Explainer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_pipeline_explainer_with_http_info(name, namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :return: SeldonModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_pipeline_explainer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_pipeline_explainer`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_pipeline_explainer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines/{name}/explainer', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SeldonModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_pipeline(self, name, namespace, mldeployment, **kwargs):  # noqa: E501
        """update_pipeline  # noqa: E501

        Update the specified Seldon Pipeline  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_pipeline(name, namespace, mldeployment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param Pipeline mldeployment: Seldon Pipeline (required)
        :param str action: Action
        :param str message: Message
        :return: SeldonPipeline
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_pipeline_with_http_info(name, namespace, mldeployment, **kwargs)  # noqa: E501
        else:
            (data) = self.update_pipeline_with_http_info(name, namespace, mldeployment, **kwargs)  # noqa: E501
            return data

    def update_pipeline_with_http_info(self, name, namespace, mldeployment, **kwargs):  # noqa: E501
        """update_pipeline  # noqa: E501

        Update the specified Seldon Pipeline  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_pipeline_with_http_info(name, namespace, mldeployment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name identifies a resource (required)
        :param str namespace: Namespace provides a logical grouping of resources (required)
        :param Pipeline mldeployment: Seldon Pipeline (required)
        :param str action: Action
        :param str message: Message
        :return: SeldonPipeline
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'mldeployment', 'action', 'message']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_pipeline" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `update_pipeline`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `update_pipeline`")  # noqa: E501
        # verify the required parameter 'mldeployment' is set
        if ('mldeployment' not in params or
                params['mldeployment'] is None):
            raise ValueError("Missing the required parameter `mldeployment` when calling `update_pipeline`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'action' in params:
            query_params.append(('action', params['action']))  # noqa: E501
        if 'message' in params:
            query_params.append(('message', params['message']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'mldeployment' in params:
            body_params = params['mldeployment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/namespaces/{namespace}/pipelines/{name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SeldonPipeline',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
